/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.levelscraft7.rustlingspots.config.ConfigIO;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;

public final class RustlingSpotsFamilySpawnConfig {
    public static Families FAMILIES = Families.defaults();
    private static final Path PATH = ConfigIO.configPath("rustlingspots/rustlingspots-families.json");

    private RustlingSpotsFamilySpawnConfig() {
    }

    public static void load() {
        FAMILIES = ConfigIO.loadOrCreate(PATH, Families.defaults(), Families.class);
        for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
            RustlingSpotsFamilySpawnConfig.FAMILIES.familyRates.putIfAbsent(family.name(), RustlingSpotsFamilySpawnConfig.defaultRateFor(family));
        }
    }

    private static double defaultRateFor(RustlingSpotFamily family) {
        return family == RustlingSpotFamily.FLYING ? 0.2 : 1.0;
    }

    public static final class Families {
        public Map<String, Double> familyRates = new HashMap<String, Double>();

        public static Families defaults() {
            Families f = new Families();
            for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
                f.familyRates.put(family.name(), RustlingSpotsFamilySpawnConfig.defaultRateFor(family));
            }
            return f;
        }

        public double spawnRate(RustlingSpotFamily family) {
            Double v = this.familyRates.get(family.name());
            if (v == null) {
                return RustlingSpotsFamilySpawnConfig.defaultRateFor(family);
            }
            return Math.max(0.0, Math.min(1.0, v));
        }
    }
}

