/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigIO {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ConfigIO() {
    }

    static Path configPath(String relative) {
        return FabricLoader.getInstance().getConfigDir().resolve(relative);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T loadOrCreate(Path path, T defaults, Class<T> type) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                ConfigIO.save(path, defaults);
                return defaults;
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Object loaded = GSON.fromJson((Reader)reader, type);
                if (loaded == null) {
                    ConfigIO.save(path, defaults);
                    T t = defaults;
                    return t;
                }
                Object object = loaded;
                return (T)object;
            }
        }
        catch (Exception e) {
            try {
                ConfigIO.save(path, defaults);
                return defaults;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return defaults;
        }
    }

    static void save(Path path, Object value) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(value, (Appendable)writer);
        }
    }
}

