/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client.particle;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_707;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class RustlingBurstParticle
extends class_4003 {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustlingBurstParticle.class);
    private static final ConcurrentMap<String, Boolean> LOGGED_SPRITE_FAILURES = new ConcurrentHashMap<String, Boolean>();
    private final class_4002 sprites;
    private final Style style;
    private final boolean hasSprites;
    private boolean spriteReady;
    private final String debugId;

    protected RustlingBurstParticle(class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_4002 sprites, Style style, String debugId) {
        super(level, x, y, z, velocityX, velocityY, velocityZ);
        boolean needsMotion;
        this.sprites = sprites;
        this.style = style;
        this.hasSprites = sprites != null;
        this.debugId = debugId;
        this.field_28786 = style.friction();
        this.field_3844 = style.gravity();
        this.field_3862 = true;
        boolean bl = needsMotion = Math.abs(velocityX) < 1.0E-4 && Math.abs(velocityY) < 1.0E-4 && Math.abs(velocityZ) < 1.0E-4;
        if (needsMotion) {
            this.field_3852 = (this.field_3840.method_43058() - 0.5) * 0.08;
            this.field_3850 = (this.field_3840.method_43058() - 0.5) * 0.08;
            this.field_3869 = 0.06 + this.field_3840.method_43058() * 0.04;
        } else {
            this.field_3852 *= 0.65;
            this.field_3869 *= 0.8;
            this.field_3850 *= 0.65;
        }
        float jitter = (float)((double)style.scaleJitter() * (level.field_9229.method_43058() - 0.5));
        this.field_17867 *= style.scaleMultiplier() + jitter;
        this.field_3847 = style.minLifetime() + level.field_9229.method_43048(style.maxLifetime() - style.minLifetime() + 1);
        this.field_3841 = 0.0f;
        this.field_3839 = this.field_3857 = level.field_9229.method_43057() * ((float)Math.PI * 2);
        this.spriteReady = this.ensureSpriteBound();
    }

    public static class_707<class_2400> provider(class_4002 sprites, Style style, String debugId) {
        return (type, level, x, y, z, dx, dy, dz) -> new RustlingBurstParticle(level, x, y, z, dx, dy, dz, sprites, style, debugId);
    }

    public void method_3070() {
        float progress;
        super.method_3070();
        if (!this.spriteReady) {
            this.spriteReady = this.ensureSpriteBound();
        }
        this.field_3841 = (progress = (float)this.field_3866 / (float)this.field_3847) < 0.25f ? class_3532.method_15363((float)(progress / 0.25f), (float)0.0f, (float)1.0f) : (progress > 0.75f ? class_3532.method_15363((float)(1.0f - (progress - 0.75f) / 0.25f), (float)0.0f, (float)1.0f) : 1.0f);
        this.field_3869 += (double)this.style.riseAcceleration();
    }

    private boolean ensureSpriteBound() {
        if (!this.hasSprites) {
            this.logSpriteIssue("sprite set handle is null");
            this.method_3085();
            return false;
        }
        try {
            this.method_18141(this.sprites.method_18139(this.field_3840));
        }
        catch (Exception e) {
            this.logSpriteIssue("setSprite threw: " + e.getMessage());
        }
        if (this.field_17886 == null) {
            this.logSpriteIssue("sprite set returned null sprite");
            this.method_3085();
            return false;
        }
        class_2960 spriteName = this.field_17886.method_45851().method_45816();
        if (class_1047.method_4539().equals((Object)spriteName)) {
            this.logSpriteIssue("sprite resolved to missing texture atlas sprite");
            this.method_3085();
            return false;
        }
        if (!this.spriteReady) {
            // empty if block
        }
        return true;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    private void logSpriteIssue(String reason) {
        if (this.debugId == null) {
            return;
        }
        LOGGED_SPRITE_FAILURES.computeIfAbsent(this.debugId, key -> {
            LOGGER.warn("Rustling Spots: {} has no usable sprite set ({}). The particle will be discarded.", key, (Object)reason);
            return true;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public record Style(float scaleMultiplier, float scaleJitter, int minLifetime, int maxLifetime, float friction, float gravity, float riseAcceleration) {
    }
}

