/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.levelscraft7.rustlingspots.client.RustlingParticleProviderRegistrar;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.levelscraft7.rustlingspots.config.RustlingSpotsClientConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotRemovePacket;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class RustlingSpotsFabricClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"rustlingspots");

    public void onInitializeClient() {
        RustlingSpotsClientConfig.load();
        RustlingSpotClientHandler.bootstrap();
        RustlingSpotsFabricClient.registerParticleFactories();
        RustlingSpotsFabricClient.registerClientReceivers();
        RustlingSpotsFabricClient.registerParticleTextureValidator();
    }

    private static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(RustlingSpotSpawnPacket.TYPE, (payload, context) -> context.client().execute(() -> RustlingSpotClientHandler.handleSpawn(payload)));
        ClientPlayNetworking.registerGlobalReceiver(RustlingSpotRemovePacket.TYPE, (payload, context) -> context.client().execute(() -> RustlingSpotClientHandler.handleRemove(payload)));
    }

    private static void registerParticleFactories() {
        ParticleFactoryRegistry registry = ParticleFactoryRegistry.getInstance();
        RustlingParticleProviderRegistrar.register(registry);
    }

    private static void registerParticleTextureValidator() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final List<class_2960> expected = RustlingParticleTypes.particleTextures();

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"rustlingspots", (String)"particle_texture_validator");
            }

            public void method_14491(class_3300 resourceManager) {
                if (!RustlingSpotsServerConfig.GENERAL.loggingEnabled()) {
                    return;
                }
                LOGGER.info("Rustling Spots: validating particle textures ({} expected entries)", (Object)this.expected.size());
                for (class_2960 texture : this.expected) {
                    class_2960 textureFile = texture.method_45136("textures/particle/" + texture.method_12832() + ".png");
                    Optional resource = resourceManager.method_14486(textureFile);
                    if (resource.isPresent()) {
                        LOGGER.info("Rustling Spots: texture found -> {} (pack: {})", (Object)texture, (Object)((class_3298)resource.get()).method_14480());
                        continue;
                    }
                    String filename = texture.method_12832().substring(texture.method_12832().lastIndexOf(47) + 1);
                    LOGGER.warn("Rustling Spots: texture missing -> {} (resolved path: {}). Expected under assets/{}/textures/particle/{}.png including optional top-level /resources override.", new Object[]{texture, textureFile, "rustlingspots", filename});
                }
            }
        });
    }
}

