/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.levelscraft7.rustlingspots.config.RustlingSpotsClientConfig;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class RustlingSpotRenderer {
    private static final class_2960 SHADOW_TEXTURE = class_2960.method_60655((String)"rustlingspots", (String)"textures/rs_ombres.png");

    private RustlingSpotRenderer() {
    }

    public static void render(WorldRenderContext context) {
        class_638 level = context.world();
        if (level == null) {
            return;
        }
        class_4184 camera = context.camera();
        if (camera == null) {
            return;
        }
        double baseOpacity = RustlingSpotsClientConfig.VISUALS.shadowOpacity();
        if (baseOpacity <= 0.0) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        if (matrices == null) {
            return;
        }
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW_TEXTURE);
        class_4588 vc = context.consumers().getBuffer(class_1921.method_23580((class_2960)SHADOW_TEXTURE));
        Matrix4f mat = matrices.method_23760().method_23761();
        double camX = camera.method_19326().field_1352;
        double camY = camera.method_19326().field_1351;
        double camZ = camera.method_19326().field_1350;
        float halfSize = 0.6f;
        float yOffset = 0.02f;
        for (RustlingSpotClientHandler.ClientSpot spot : RustlingSpotClientHandler.activeSpots()) {
            double opacity;
            class_2338 p = spot.renderPos();
            RustlingSpotFamily family = spot.renderFamily();
            double d = opacity = family == RustlingSpotFamily.WATER ? RustlingSpotsClientConfig.VISUALS.waterShadowOpacity() : baseOpacity;
            if (opacity <= 0.0) continue;
            float a = (float)Math.min(1.0, Math.max(0.0, opacity));
            float x = (float)((double)p.method_10263() + 0.5 - camX);
            float y = (float)((double)((float)p.method_10264() + yOffset) - camY);
            float z = (float)((double)p.method_10260() + 0.5 - camZ);
            int light = class_765.method_23687((int)15, (int)15);
            int overlay = class_4608.field_21444;
            vc.method_22918(mat, x - halfSize, y, z - halfSize).method_22915(0.0f, 0.0f, 0.0f, a).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
            vc.method_22918(mat, x - halfSize, y, z + halfSize).method_22915(0.0f, 0.0f, 0.0f, a).method_22913(0.0f, 1.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
            vc.method_22918(mat, x + halfSize, y, z + halfSize).method_22915(0.0f, 0.0f, 0.0f, a).method_22913(1.0f, 1.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
            vc.method_22918(mat, x + halfSize, y, z - halfSize).method_22915(0.0f, 0.0f, 0.0f, a).method_22913(1.0f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        }
    }
}

