/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.levelscraft7.rustlingspots.client.RustlingAmbientSound;
import net.levelscraft7.rustlingspots.client.RustlingParticles;
import net.levelscraft7.rustlingspots.client.RustlingSpotRenderer;
import net.levelscraft7.rustlingspots.config.RustlingSpotsClientConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotRemovePacket;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public final class RustlingSpotClientHandler {
    private static final Map<UUID, ClientSpot> ACTIVE = new HashMap<UUID, ClientSpot>();
    private static class_5321<class_1937> currentDimension;

    private RustlingSpotClientHandler() {
    }

    public static void bootstrap() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> RustlingSpotClientHandler.onClientTick());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> RustlingSpotRenderer.render(context));
        RustlingSpotsClientConfig.load();
    }

    public static Iterable<ClientSpot> activeSpots() {
        return ACTIVE.values();
    }

    public static void handleSpawn(RustlingSpotSpawnPacket packet) {
        ACTIVE.put(packet.id(), new ClientSpot(packet.id(), packet.pos(), packet.family(), packet.ambientVariant()));
    }

    public static void handleRemove(RustlingSpotRemovePacket packet) {
        RustlingSpotClientHandler.handleRemove(packet.id());
    }

    public static void handleRemove(UUID id) {
        ClientSpot spot = ACTIVE.remove(id);
        if (spot != null) {
            spot.stop();
        }
    }

    private static void onClientTick() {
        class_5321 dimension;
        class_310 mc = class_310.method_1551();
        class_5321 class_53212 = dimension = mc.field_1687 != null ? mc.field_1687.method_27983() : null;
        if (mc.field_1687 == null || !Objects.equals(currentDimension, dimension)) {
            currentDimension = dimension;
            ACTIVE.values().forEach(ClientSpot::stop);
            ACTIVE.clear();
            return;
        }
        for (ClientSpot spot : ACTIVE.values()) {
            spot.tick(mc);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static final class ClientSpot {
        private final UUID id;
        private final class_2338 pos;
        private final RustlingSpotFamily family;
        private final int ambientVariant;
        private RustlingAmbientSound ambient;

        class_2338 renderPos() {
            return this.pos;
        }

        RustlingSpotFamily renderFamily() {
            return this.family;
        }

        ClientSpot(UUID id, class_2338 pos, RustlingSpotFamily family, int ambientVariant) {
            this.id = id;
            this.pos = pos;
            this.family = family;
            this.ambientVariant = ambientVariant;
        }

        void tick(class_310 mc) {
            double dz;
            double dy;
            double dx;
            double distance;
            if (mc.field_1687 == null || mc.field_1724 == null) {
                this.stop();
                return;
            }
            long time = mc.field_1687.method_8510();
            if (time % 10L == 0L) {
                RustlingParticles.spawn(this.family, this.pos);
            }
            if ((distance = Math.sqrt((dx = mc.field_1724.method_23317() - ((double)this.pos.method_10263() + 0.5)) * dx + (dy = mc.field_1724.method_23318() - ((double)this.pos.method_10264() + 0.5)) * dy + (dz = mc.field_1724.method_23321() - ((double)this.pos.method_10260() + 0.5)) * dz)) <= 10.0) {
                if (this.ambient == null) {
                    class_3414 sound = RustlingSoundEvents.ambientVariant(this.ambientVariant);
                    float initialVolume = RustlingAmbientSound.calculateVolume(distance);
                    this.ambient = new RustlingAmbientSound(this.id, this.pos, sound, initialVolume);
                    mc.method_1483().method_4873((class_1113)this.ambient);
                }
            } else if (this.ambient != null) {
                this.ambient.requestStop();
                this.ambient = null;
            }
        }

        void stop() {
            if (this.ambient != null) {
                this.ambient.requestStop();
                this.ambient = null;
            }
        }
    }
}

