/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class RustlingParticles {
    private RustlingParticles() {
    }

    public static void spawn(RustlingSpotFamily family, class_2338 pos) {
        double radius;
        double angle;
        int i;
        double visualTop;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_5819 random = level.method_8409();
        double collisionTop = level.method_8320(pos).method_26220((class_1922)level, pos).method_1105(class_2350.class_2351.field_11052);
        double topHeight = Math.max(collisionTop, visualTop = level.method_8320(pos).method_26218((class_1922)level, pos).method_1105(class_2350.class_2351.field_11052));
        if (topHeight < 0.01) {
            topHeight = 1.0;
        }
        class_243 topCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + topHeight + 0.02, (double)pos.method_10260() + 0.5);
        class_243 spotCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.02, (double)pos.method_10260() + 0.5);
        if (family == RustlingSpotFamily.GRASS || family == RustlingSpotFamily.LEAVES || family == RustlingSpotFamily.WATER || family == RustlingSpotFamily.SAND || family == RustlingSpotFamily.SNOW || family == RustlingSpotFamily.NETHERFLAMME || family == RustlingSpotFamily.SOULFLAME || family == RustlingSpotFamily.FLYING || family == RustlingSpotFamily.CAVE) {
            class_2400 primary = switch (family) {
                case RustlingSpotFamily.GRASS -> RustlingParticleTypes.GRASS_BURST;
                case RustlingSpotFamily.LEAVES -> RustlingParticleTypes.LEAVES_BURST;
                case RustlingSpotFamily.WATER -> RustlingParticleTypes.WATER_BURST;
                case RustlingSpotFamily.CAVE -> RustlingParticleTypes.CAVE_BURST;
                case RustlingSpotFamily.SAND -> RustlingParticleTypes.SAND_BURST;
                case RustlingSpotFamily.SNOW -> RustlingParticleTypes.SNOW_BURST;
                case RustlingSpotFamily.NETHERFLAMME -> RustlingParticleTypes.NETHERFLAMME_BURST;
                case RustlingSpotFamily.SOULFLAME -> RustlingParticleTypes.SOULFLAME_BURST;
                case RustlingSpotFamily.FLYING -> RustlingParticleTypes.FLYING_BURST;
                default -> throw new IllegalStateException("Unexpected family: " + String.valueOf((Object)family));
            };
            LeafyBurstProfile leafyProfile = new LeafyBurstProfile((class_2394)primary, 22, 28, 10, 15, 0.4f, 0.6f, 0.12f, 0.06f, 0.035f, 0.018f, 0.12f, 0.05f);
            RustlingParticles.emitLeafyBurst(level, random, spotCenter, leafyProfile);
            return;
        }
        switch (family) {
            default: {
                throw new MatchException(null, null);
            }
            case GRASS: {
                throw new IllegalStateException("handled above");
            }
            case LEAVES: {
                throw new IllegalStateException("handled above");
            }
            case WATER: {
                throw new IllegalStateException("handled above");
            }
            case CAVE: {
                throw new IllegalStateException("handled above");
            }
            case SAND: {
                throw new IllegalStateException("handled above");
            }
            case SNOW: {
                throw new IllegalStateException("handled above");
            }
            case NETHERFLAMME: {
                throw new IllegalStateException("handled above");
            }
            case SOULFLAME: {
                throw new IllegalStateException("handled above");
            }
            case FLYING: 
        }
        BurstProfile profile = new BurstProfile((class_2394)RustlingParticleTypes.FLYING_BURST, 26, 0.28f, 0.48f, 0.09f, 0.014f, (class_2394)class_2398.field_11204);
        if (family == RustlingSpotFamily.FLYING) {
            RustlingParticles.emitFlyingBurst(level, random, topCenter, profile);
            return;
        }
        for (i = 0; i < profile.count; ++i) {
            angle = random.method_43058() * Math.PI * 2.0;
            radius = class_3532.method_16436((double)random.method_43058(), (double)profile.radiusMin, (double)profile.radiusMax);
            double offsetY = random.method_43058() * 0.08;
            double x = topCenter.field_1352 + Math.cos(angle) * radius;
            double z = topCenter.field_1350 + Math.sin(angle) * radius;
            double y = topCenter.field_1351 + offsetY;
            double outward = 0.01 + random.method_43058() * 0.01;
            double velX = Math.cos(angle) * outward * 0.8 + (random.method_43058() - 0.5) * 0.012;
            double velZ = Math.sin(angle) * outward * 0.8 + (random.method_43058() - 0.5) * 0.012;
            double velY = (double)profile.upwardBase + random.method_43058() * (double)profile.upwardJitter + 0.01;
            level.method_8406(profile.primary, x, y, z, velX, velY, velZ);
        }
        for (i = 0; i < 20; ++i) {
            angle = random.method_43058() * Math.PI * 2.0;
            radius = class_3532.method_16436((double)random.method_43058(), (double)(profile.radiusMin * 0.6f), (double)(profile.radiusMax * 0.65f));
            double x = topCenter.field_1352 + Math.cos(angle) * radius;
            double z = topCenter.field_1350 + Math.sin(angle) * radius;
            double velY = (double)profile.upwardBase * 0.25;
            level.method_8406(profile.accent, x, topCenter.field_1351 + 0.02, z, 0.0, velY, 0.0);
        }
    }

    private static void emitLeafyBurst(class_638 level, class_5819 random, class_243 center, LeafyBurstProfile profile) {
        int firstCount = profile.phaseOneMin + random.method_43048(profile.phaseOneMax - profile.phaseOneMin + 1);
        int secondCount = profile.phaseTwoMin + random.method_43048(profile.phaseTwoMax - profile.phaseTwoMin + 1);
        RustlingParticles.emitLeafyBurstPhase(level, random, center, profile, firstCount);
        RustlingParticles.emitLeafyBurstPhase(level, random, center, profile, secondCount);
    }

    private static void emitLeafyBurstPhase(class_638 level, class_5819 random, class_243 center, LeafyBurstProfile profile, int count) {
        for (int i = 0; i < count; ++i) {
            double angle = random.method_43058() * Math.PI * 2.0;
            double radius = class_3532.method_16436((double)random.method_43058(), (double)profile.radiusMin, (double)profile.radiusMax);
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            double y = center.field_1351 + (double)profile.yOffsetBase + random.method_43058() * (double)profile.yOffsetJitter;
            double outward = (double)profile.horizontalBase + random.method_43058() * (double)profile.horizontalJitter;
            double velX = Math.cos(angle) * outward + (random.method_43058() - 0.5) * 0.01;
            double velZ = Math.sin(angle) * outward + (random.method_43058() - 0.5) * 0.01;
            double velY = (double)profile.upwardBase + random.method_43058() * (double)profile.upwardJitter;
            level.method_8406(profile.primary, x, y, z, velX, velY, velZ);
        }
    }

    private static void emitFlyingBurst(class_638 level, class_5819 random, class_243 center, BurstProfile profile) {
        double radius;
        double angle;
        int i;
        for (i = 0; i < profile.count; ++i) {
            angle = random.method_43058() * Math.PI * 2.0;
            radius = class_3532.method_16436((double)random.method_43058(), (double)(profile.radiusMin * 0.5f), (double)(profile.radiusMax * 0.75f));
            double columnHeight = random.method_43058() * 0.9;
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            double y = center.field_1351 + columnHeight * 0.6;
            double baseSwirl = 0.03 + random.method_43058() * 0.02;
            double swirlX = -Math.sin(angle) * baseSwirl;
            double swirlZ = Math.cos(angle) * baseSwirl;
            double velY = (double)profile.upwardBase * 0.7 + random.method_43058() * ((double)profile.upwardJitter * 0.5);
            level.method_8406(profile.primary, x, y, z, swirlX, velY, swirlZ);
        }
        for (i = 0; i < 14; ++i) {
            angle = random.method_43058() * Math.PI * 2.0;
            radius = class_3532.method_16436((double)random.method_43058(), (double)(profile.radiusMin * 0.4f), (double)(profile.radiusMax * 0.6f));
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            double velY = (double)profile.upwardBase * 0.2;
            level.method_8406(profile.accent, x, center.field_1351 + 0.02, z, 0.0, velY, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record LeafyBurstProfile(class_2394 primary, int phaseOneMin, int phaseOneMax, int phaseTwoMin, int phaseTwoMax, float radiusMin, float radiusMax, float upwardBase, float upwardJitter, float horizontalBase, float horizontalJitter, float yOffsetBase, float yOffsetJitter) {
    }

    @Environment(value=EnvType.CLIENT)
    private record BurstProfile(class_2394 primary, int count, float radiusMin, float radiusMax, float upwardBase, float upwardJitter, class_2394 accent) {
    }
}

