/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.levelscraft7.rustlingspots.config.RustlingSpotsFamilySpawnConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsSoundConfig;
import net.levelscraft7.rustlingspots.network.RustlingSpotsNetwork;
import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.LootPoolService;
import net.levelscraft7.rustlingspots.spot.PokemonPoolService;
import net.levelscraft7.rustlingspots.spot.RustlingSpotCommands;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamilyConfigService;
import net.levelscraft7.rustlingspots.spot.SpotSpawner;
import net.levelscraft7.rustlingspots.spot.SpotTicker;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustlingSpotsFabricMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rustlingspots");

    public void onInitialize() {
        RustlingSpotsServerConfig.load();
        RustlingSpotsFamilySpawnConfig.load();
        RustlingSpotsPokemonConfig.load();
        RustlingSpotsSoundConfig.load();
        RustlingSpotFamilyConfigService.ensureDefaultsExist();
        LootPoolService.ensureDefaultsExist();
        PokemonPoolService.ensureDefaultsExist();
        RustlingSoundEvents.register();
        RustlingParticleTypes.register();
        RustlingSpotsNetwork.register();
        SpotSpawner spawner = new SpotSpawner();
        SpotTicker ticker = new SpotTicker();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            spawner.onServerTick(server);
            ticker.onServerTick(server);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> RustlingSpotCommands.register((CommandDispatcher<class_2168>)dispatcher));
    }
}

