/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.boxlink.platform;

import com.emperdog.boxlink.BoxLinkCommon;
import com.emperdog.boxlink.platform.AccessoriesCompat;
import com.emperdog.boxlink.platform.services.BoxLinkConfig;
import com.emperdog.boxlink.platform.services.IAccessoryModHelper;
import com.emperdog.boxlink.platform.services.IPlatformHelper;
import java.util.ServiceLoader;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IAccessoryModHelper ACCESSORY_MOD;
    public static final BoxLinkConfig CONFIG;

    public static <T> T load(Class<T> clazz, UnaryOperator<Stream<ServiceLoader.Provider<T>>> intercept) {
        Object loadedService = ((ServiceLoader.Provider)((Stream)intercept.apply(ServiceLoader.load(clazz).stream())).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()))).get();
        BoxLinkCommon.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return (T)loadedService;
    }

    public static <T> T load(Class<T> clazz) {
        return Services.load(clazz, UnaryOperator.identity());
    }

    static {
        CONFIG = Services.load(BoxLinkConfig.class);
        ACCESSORY_MOD = Services.load(IAccessoryModHelper.class, loader -> loader.filter(helper -> AccessoriesCompat.MOD_LOADED == helper.get() instanceof AccessoriesCompat));
    }
}

