/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.noise;

import com.yungnickyoung.minecraft.yungscavebiomes.world.NoiseSamplerBiomeHolder;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_3532;
import net.minecraft.class_4540;
import net.minecraft.class_4543;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class MarbleCavesInterpolationSlideDensityFunction
implements class_6910 {
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final int SEARCH_RADIUS_INT = class_3532.method_15384((double)(SQRT3 * 4.0));
    public static final int BLOCK_XYZ_OFFSET = 2;
    private static final int FIDDLE_HASH_BIT_START = 24;
    private static final int FIDDLE_HASH_BIT_COUNT = 10;
    private static final int FIDDLE_HASH_BIT_SHIFTED = 1024;
    private static final int FIDDLE_HASH_BIT_MASK = 1023;
    private static final double FIDDLE_MAGNITUDE = 1.0;
    private final NoiseSamplerBiomeHolder holder;
    private final long biomeZoomSeed;

    public MarbleCavesInterpolationSlideDensityFunction(NoiseSamplerBiomeHolder holder) {
        this.holder = holder;
        this.biomeZoomSeed = class_4543.method_27984((long)holder.getWorldSeed());
    }

    public double method_40464(class_6910.class_6912 context) {
        class_1966 source = this.holder.getBiomeSource();
        class_2378<class_1959> biomes = this.holder.getBiomeRegistry();
        if (source != null && biomes != null) {
            int offsetX = context.comp_371() - 2;
            int offsetY = context.comp_372() - 2;
            int offsetZ = context.comp_373() - 2;
            int xStart = offsetX - SEARCH_RADIUS_INT >> 2;
            int yStart = offsetY - SEARCH_RADIUS_INT >> 2;
            int zStart = offsetZ - SEARCH_RADIUS_INT >> 2;
            int xEnd = offsetX + SEARCH_RADIUS_INT >> 2;
            int yEnd = offsetY + SEARCH_RADIUS_INT >> 2;
            int zEnd = offsetZ + SEARCH_RADIUS_INT >> 2;
            int xCount = xEnd - xStart + 1;
            int yCount = yEnd - yStart + 1;
            int zCount = zEnd - zStart + 1;
            double xDelta = (double)(offsetX - (xStart << 2)) * 0.25;
            double yDelta = (double)(offsetY - (yStart << 2)) * 0.25;
            double zDelta = (double)(offsetZ - (zStart << 2)) * 0.25;
            double totalWeight = 0.0;
            double marbleWeight = 0.0;
            int cz = 0;
            int cy = 0;
            int cx = 0;
            while (true) {
                double fiddledDistanceSquared;
                if ((fiddledDistanceSquared = MarbleCavesInterpolationSlideDensityFunction.getFiddledDistance(this.biomeZoomSeed, cx + xStart, cy + yStart, cz + zStart, xDelta - (double)cx, yDelta - (double)cy, zDelta - (double)cz)) < 3.0) {
                    double falloff = 3.0 - fiddledDistanceSquared;
                    falloff *= falloff * falloff;
                    class_6880 biomeHolderHere = source.method_38109(cx + xStart, cy + yStart, cz + zStart, this.holder.getClimateSampler());
                    totalWeight += falloff;
                    if (this.shouldSolidifyForMarbleCaves((class_6880<class_1959>)biomeHolderHere, cy + yStart)) {
                        marbleWeight += falloff;
                    }
                }
                if (++cz < zCount) continue;
                cz = 0;
                if (++cy < yCount) continue;
                cy = 0;
                if (++cx >= xCount) break;
            }
            return marbleWeight / totalWeight;
        }
        return 0.0;
    }

    private boolean shouldSolidifyForMarbleCaves(class_6880<class_1959> biome, int quartY) {
        return quartY <= 0;
    }

    private static double getFiddledDistance(long seed, int quartX, int quartY, int quartZ, double dx, double dy, double dz) {
        long hash = class_4540.method_22372((long)seed, (long)quartX);
        hash = class_4540.method_22372((long)hash, (long)quartY);
        hash = class_4540.method_22372((long)hash, (long)quartZ);
        hash = class_4540.method_22372((long)hash, (long)quartX);
        hash = class_4540.method_22372((long)hash, (long)quartY);
        hash = class_4540.method_22372((long)hash, (long)quartZ);
        double jz = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        hash = class_4540.method_22372((long)hash, (long)seed);
        double jy = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        hash = class_4540.method_22372((long)hash, (long)seed);
        double jx = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        return class_3532.method_33723((double)(dz + jz)) + class_3532.method_33723((double)(dy + jy)) + class_3532.method_33723((double)(dx + jx));
    }

    private static double getFiddle(long hash) {
        long hashBits = hash >> 24 & 0x3FFL;
        return (double)hashBits * 9.765625E-4 - 0.5;
    }

    public void method_40470(double[] doubles, class_6910.class_6911 contextProvider) {
        contextProvider.method_40478(doubles, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new MarbleCavesInterpolationSlideDensityFunction(this.holder));
    }

    public double comp_377() {
        return 0.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public class_7243<? extends class_6910> method_41062() {
        return null;
    }
}

