/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util;

import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import java.util.function.Consumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5689;
import net.minecraft.class_5691;

public class DripstoneIceUtils {
    public static double getDripstoneHeight(double radialDistance, double radius, double scale, double bluntness) {
        if (radialDistance < bluntness) {
            radialDistance = bluntness;
        }
        double h = 0.384;
        double i = radialDistance / radius * h;
        double j = 0.75 * Math.pow(i, 1.3333333333333333);
        double k = Math.pow(i, 0.6666666666666666);
        double l = 0.3333333333333333 * Math.log(i);
        double m = scale * (j - k - l);
        m = Math.max(m, 0.0);
        return m / h * radius;
    }

    public static boolean isCircleMostlyEmbeddedInStone(class_5281 worldGenLevel, class_2338 blockPos, int radius) {
        if (DripstoneIceUtils.isEmptyOrWaterOrLava((class_1936)worldGenLevel, blockPos)) {
            return false;
        }
        float f = 6.0f;
        float increment = 6.0f / (float)radius;
        for (float theta = 0.0f; theta < (float)Math.PI * 2; theta += increment) {
            int dz;
            int dx = (int)(class_3532.method_15362((float)theta) * (float)radius);
            if (!DripstoneIceUtils.isEmptyOrWaterOrLava((class_1936)worldGenLevel, blockPos.method_10069(dx, 0, dz = (int)(class_3532.method_15374((float)theta) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(class_1936 levelAccessor, class_2338 blockPos) {
        return levelAccessor.method_16358(blockPos, class_4970.class_4971::method_26215);
    }

    public static boolean isEmptyOrWater(class_1936 levelAccessor, class_2338 blockPos) {
        return levelAccessor.method_16358(blockPos, DripstoneIceUtils::isEmptyOrWater);
    }

    public static boolean isEmptyOrWaterOrLava(class_1936 levelAccessor, class_2338 blockPos) {
        return levelAccessor.method_16358(blockPos, DripstoneIceUtils::isEmptyOrWaterOrLava);
    }

    public static void buildBaseToTipColumn(class_2350 direction, int i, boolean bl, Consumer<class_2680> consumer) {
        if (i >= 3) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, class_5691.field_28068));
            for (int j = 0; j < i - 3; ++j) {
                consumer.accept(DripstoneIceUtils.createIcicle(direction, class_5691.field_28067));
            }
        }
        if (i >= 2) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, class_5691.field_28066));
        }
        if (i >= 1) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, bl ? class_5691.field_28064 : class_5691.field_28065));
        }
    }

    public static void growIcicle(class_1936 levelAccessor, class_2338 blockPos, class_2350 direction, int i, boolean bl) {
        if (DripstoneIceUtils.isIcicleBase(levelAccessor.method_8320(blockPos.method_10093(direction.method_10153())))) {
            class_2338.class_2339 mutable = blockPos.method_25503();
            DripstoneIceUtils.buildBaseToTipColumn(direction, i, bl, blockState -> {
                levelAccessor.method_8652((class_2338)mutable, blockState, 2);
                mutable.method_10098(direction);
            });
        }
    }

    public static boolean placePackedIceIfPossible(class_1936 levelAccessor, class_2338 blockPos) {
        class_2680 blockState = levelAccessor.method_8320(blockPos);
        if (blockState.method_26164(class_3481.field_28089)) {
            levelAccessor.method_8652(blockPos, class_2246.field_10225.method_9564(), 2);
            return true;
        }
        return false;
    }

    private static class_2680 createIcicle(class_2350 direction, class_5691 dripstoneThickness) {
        return (class_2680)((class_2248)BlockModule.ICICLE.get()).method_9564().method_11657((class_2769)class_5689.field_28051, (Comparable)dripstoneThickness);
    }

    public static boolean isDripstoneBaseOrLava(class_2680 blockState) {
        return DripstoneIceUtils.isIcicleBase(blockState) || blockState.method_27852(class_2246.field_10164);
    }

    public static boolean isIcicleBase(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10225) || blockState.method_26164(class_3481.field_28089);
    }

    public static boolean isEmptyOrWater(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_27852(class_2246.field_10382);
    }

    public static boolean isEmptyOrWaterOrLava(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_27852(class_2246.field_10382) || blockState.method_27852(class_2246.field_10164);
    }
}

