/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.LargeIceDripstoneConfiguration;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;

public class LargeIceDripstoneFeature
extends class_3031<LargeIceDripstoneConfiguration> {
    public LargeIceDripstoneFeature(Codec<LargeIceDripstoneConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<LargeIceDripstoneConfiguration> featurePlaceContext) {
        Object t;
        class_5281 worldGenLevel = featurePlaceContext.method_33652();
        class_2338 origin = featurePlaceContext.method_33655();
        class_4076 originSectionPos = class_4076.method_18682((class_2338)origin);
        LargeIceDripstoneConfiguration config = (LargeIceDripstoneConfiguration)featurePlaceContext.method_33656();
        class_5819 random = featurePlaceContext.method_33654();
        if (!DripstoneIceUtils.isEmptyOrWater((class_1936)worldGenLevel, origin)) {
            return false;
        }
        Optional optionalColumn = class_5721.method_32982((class_3746)worldGenLevel, (class_2338)origin, (int)config.floorToCeilingSearchRange, class_5726::method_33014, class_5726::method_33387);
        if (optionalColumn.isEmpty() || !((t = optionalColumn.get()) instanceof class_5721.class_5723)) {
            return false;
        }
        class_5721.class_5723 range = (class_5721.class_5723)t;
        if (range.method_32992() < 4) {
            return false;
        }
        int maxColumnRadius = (int)((float)range.method_32992() * config.maxColumnRadiusToCaveHeightRatio);
        maxColumnRadius = class_3532.method_15340((int)maxColumnRadius, (int)config.columnRadius.method_35009(), (int)config.columnRadius.method_35011());
        int columnRadius = class_3532.method_32751((class_5819)random, (int)config.columnRadius.method_35009(), (int)maxColumnRadius);
        LargeIceDripstone stalactite = LargeIceDripstoneFeature.makeIceDripstone(origin.method_33096(range.method_32990() - 1), false, random, columnRadius, config.stalactiteBluntness, config.heightScale);
        LargeIceDripstone stalagmite = LargeIceDripstoneFeature.makeIceDripstone(origin.method_33096(range.method_32991() + 1), true, random, columnRadius, config.stalagmiteBluntness, config.heightScale);
        WindOffsetter windOffsetter = stalactite.isSuitableForWind(config) && stalagmite.isSuitableForWind(config) ? new WindOffsetter(origin.method_10264(), random, config.windSpeed, config.angle) : WindOffsetter.noWind();
        boolean canSpawnStalactite = stalactite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        boolean canspawnStalagmite = stalagmite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        if (canSpawnStalactite) {
            stalactite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        if (canspawnStalagmite) {
            stalagmite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        return true;
    }

    private static LargeIceDripstone makeIceDripstone(class_2338 blockPos, boolean isPointingUp, class_5819 random, int radius, class_5863 bluntnessProvider, class_5863 scaleProvider) {
        return new LargeIceDripstone(blockPos, isPointingUp, radius, bluntnessProvider.method_33920(random), scaleProvider.method_33920(random));
    }

    private void placeDebugMarkers(class_5281 worldGenLevel, class_2338 blockPos, class_5721.class_5723 range, WindOffsetter windOffsetter) {
        worldGenLevel.method_8652(windOffsetter.offset(blockPos.method_33096(range.method_32990() - 1)), class_2246.field_10201.method_9564(), 2);
        worldGenLevel.method_8652(windOffsetter.offset(blockPos.method_33096(range.method_32991() + 1)), class_2246.field_10205.method_9564(), 2);
        class_2338.class_2339 mutableBlockPos = blockPos.method_33096(range.method_32991() + 2).method_25503();
        while (mutableBlockPos.method_10264() < range.method_32990() - 1) {
            class_2338 blockPos2 = windOffsetter.offset((class_2338)mutableBlockPos);
            if (DripstoneIceUtils.isEmptyOrWater((class_1936)worldGenLevel, blockPos2) || worldGenLevel.method_8320(blockPos2).method_27852(class_2246.field_28049)) {
                worldGenLevel.method_8652(blockPos2, class_2246.field_10042.method_9564(), 2);
            }
            mutableBlockPos.method_10098(class_2350.field_11036);
        }
    }

    static final class LargeIceDripstone {
        private class_2338 root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeIceDripstone(class_2338 root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.method_10264() : this.root.method_10264() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.method_10264() : this.root.method_10264() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(class_5281 worldGenLevel, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                class_2338.class_2339 mutable = this.root.method_25503();
                for (int i = 0; i < Math.min(10, this.getHeight()); ++i) {
                    if (worldGenLevel.method_8320((class_2338)mutable).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (DripstoneIceUtils.isCircleMostlyEmbeddedInStone(worldGenLevel, windOffsetter.offset((class_2338)mutable), this.radius)) {
                        this.root = mutable;
                        return true;
                    }
                    mutable.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radialDistance) {
            return (int)DripstoneIceUtils.getDripstoneHeight(radialDistance, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(class_5281 worldGenLevel, class_5819 random, WindOffsetter windOffsetter, float rareIceChance, class_4076 originSectionPos) {
            boolean hasRareIce;
            boolean bl = hasRareIce = random.method_43057() < rareIceChance;
            if (this.getHeightAtRadius(0.0f) < 6) {
                hasRareIce = false;
            }
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                block1: for (int dz = -this.radius; dz <= this.radius; ++dz) {
                    int heightAtCurrPos;
                    float distToCenter = class_3532.method_15355((float)(dx * dx + dz * dz));
                    if (!(distToCenter <= (float)this.radius) || (heightAtCurrPos = this.getHeightAtRadius(distToCenter)) <= 0) continue;
                    if (random.method_43058() < 0.2) {
                        heightAtCurrPos = (int)((float)heightAtCurrPos * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 mutable = this.root.method_10069(dx, 0, dz).method_25503();
                    boolean placed = false;
                    int surfaceHeight = this.pointingUp ? worldGenLevel.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260()) : Integer.MAX_VALUE;
                    for (int dy = 0; dy < heightAtCurrPos && mutable.method_10264() < surfaceHeight; ++dy) {
                        class_2338 blockPos = windOffsetter.offset((class_2338)mutable);
                        if (DripstoneIceUtils.isEmptyOrWaterOrLava((class_1936)worldGenLevel, blockPos)) {
                            placed = true;
                            class_2248 block = class_2246.field_10225;
                            if (hasRareIce) {
                                double progress = (double)dy / (double)heightAtCurrPos;
                                if (dx == 0 && dz == 0 && dy == (int)((double)heightAtCurrPos / 2.2)) {
                                    block = (class_2248)BlockModule.RARE_ICE.get();
                                } else if (progress > 0.3 + random.method_43058() * 0.04) {
                                    block = class_2246.field_10295;
                                }
                            }
                            if (this.isBlockInPlacementRange(originSectionPos, blockPos)) {
                                worldGenLevel.method_8652(blockPos, block.method_9564(), 2);
                            }
                        } else if (placed && worldGenLevel.method_8320(blockPos).method_26164(class_3481.field_25806)) continue block1;
                        mutable.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        private boolean isSuitableForWind(LargeIceDripstoneConfiguration largeDripstoneConfiguration) {
            return this.radius >= largeDripstoneConfiguration.minRadiusForWind && this.bluntness >= (double)largeDripstoneConfiguration.minBluntnessForWind;
        }

        private boolean isBlockInPlacementRange(class_4076 originSectionPos, class_2338 blockPos) {
            class_4076 blockSectionPos = class_4076.method_18682((class_2338)blockPos);
            return class_3532.method_15382((int)(originSectionPos.method_18674() - blockSectionPos.method_18674())) <= 1 && class_3532.method_15382((int)(originSectionPos.method_18687() - blockSectionPos.method_18687())) <= 1;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final class_243 windSpeed;

        WindOffsetter(int originY, class_5819 random, class_5863 windSpeedProvider, class_5863 angleProvider) {
            this.originY = originY;
            float speedAmp = windSpeedProvider.method_33920(random);
            float radAngle = angleProvider.method_33920(random);
            this.windSpeed = new class_243((double)(class_3532.method_15362((float)radAngle) * speedAmp), 0.0, (double)(class_3532.method_15374((float)radAngle) * speedAmp));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        class_2338 offset(class_2338 blockPos) {
            if (this.windSpeed == null) {
                return blockPos;
            }
            int dy = this.originY - blockPos.method_10264();
            class_243 vec3 = this.windSpeed.method_1021((double)dy);
            return blockPos.method_10069((int)vec3.field_1352, 0, (int)vec3.field_1350);
        }
    }
}

