/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.services;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterItem;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DecoratedPotPatternsModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.network.payload.IcicleShatterS2CPayload;
import com.yungnickyoung.minecraft.yungscavebiomes.network.payload.SandstormSyncS2CPayload;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import com.yungnickyoung.minecraft.yungscavebiomes.services.IPlatformHelper;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9766;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public void sendIcicleProjectileShatterS2CPacket(class_3218 level, class_243 pos) {
        IcicleShatterS2CPayload payload = new IcicleShatterS2CPayload(pos.method_10216(), pos.method_10214(), pos.method_10215());
        PlayerLookup.tracking((class_3218)level, (class_2338)class_2338.method_49638((class_2374)pos)).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
    }

    @Override
    public void syncSandstormDataToClients(SandstormServerData sandstormServerData) {
        SandstormSyncS2CPayload payload = new SandstormSyncS2CPayload(sandstormServerData.isSandstormActive(), sandstormServerData.getCurrSandstormTicks(), sandstormServerData.getSeed(), sandstormServerData.getTotalSandstormDurationTicks());
        PlayerLookup.world((class_3218)sandstormServerData.getServerLevel()).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
    }

    @Override
    public void syncSandstormDataToPlayer(SandstormServerData sandstormServerData, class_3222 serverPlayer) {
        SandstormSyncS2CPayload payload = new SandstormSyncS2CPayload(sandstormServerData.isSandstormActive(), sandstormServerData.getCurrSandstormTicks(), sandstormServerData.getSeed(), sandstormServerData.getTotalSandstormDurationTicks());
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)payload);
    }

    @Override
    public Supplier<class_1792> getIceCubeSpawnEggItem() {
        return () -> new class_1826((class_1299)EntityTypeModule.ICE_CUBE.get(), 10798332, 15002876, new class_1792.class_1793());
    }

    @Override
    public Supplier<class_1792> getSandSnapperSpawnEggItem() {
        return () -> new class_1826((class_1299)EntityTypeModule.SAND_SNAPPER.get(), 12223791, 13610069, new class_1792.class_1793());
    }

    @Override
    public class_2248 getPottedPricklyPeachCactusBlock() {
        return new class_2362((class_2248)BlockModule.PRICKLY_PEACH_CACTUS.get(), class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971));
    }

    @Override
    public class_5321<class_9766> registerDecoratedPotPattern(String name, AutoRegisterItem potterySherdItem) {
        class_2960 resourceLocation = YungsCaveBiomesCommon.id(name);
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_42941, (class_2960)resourceLocation);
        class_2378.method_39197((class_2378)class_7923.field_42940, (class_5321)resourceKey, (Object)new class_9766(resourceLocation));
        DecoratedPotPatternsModule.ALL_PATTERNS.add((class_5321<class_9766>)resourceKey);
        DecoratedPotPatternsModule.RESOUCE_KEY_BY_ITEM.put((class_1792)potterySherdItem.get(), (class_5321<class_9766>)resourceKey);
        return resourceKey;
    }
}

