/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper;

import com.yungnickyoung.minecraft.yungscavebiomes.block.PricklyPeachCactusBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.BuryLootGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EatPeachGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EatPricklyPeachCactusGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EmergeGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.GiftLootGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.RunFromPlayerGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.SnapperStrollGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.SnapperTemptGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.SoundModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SandSnapperEntity
extends class_1314
implements GeoEntity {
    public static final byte HEART_PARTICLES_EVENT = 7;
    public static final byte BURY_LOOT_PARTICLES_EVENT_SAND = 8;
    public static final byte BURY_LOOT_PARTICLES_EVENT_ANCIENT_SAND = 9;
    public static final byte BURY_LOOT_PARTICLES_EVENT_GRAVEL = 10;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation EMERGE_PLAYER = RawAnimation.begin().thenPlay("look").thenPlay("look_loop");
    private final RawAnimation EMERGE = RawAnimation.begin().thenPlay("look_turn_head");
    private final RawAnimation DIVE = RawAnimation.begin().thenPlay("diveback");
    private final RawAnimation SWIM = RawAnimation.begin().thenPlay("swim");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation DIG_DOWN = RawAnimation.begin().thenPlay("dig_down");
    private final RawAnimation DIG_UP = RawAnimation.begin().thenPlay("dig_up");
    private final RawAnimation EAT = RawAnimation.begin().thenPlay("eat");
    private static final class_2940<Boolean> SUBMERGED = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LOOKING_AT_PLAYER = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> EMERGING = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIVING = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIGGING_DOWN = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIGGING_UP = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FORCE_SPAWN_DIG_PARTICLES = class_2945.method_12791(SandSnapperEntity.class, (class_2941)class_2943.field_13323);
    private boolean submergedHolder;
    private boolean lookingAtPlayerHolder;
    private boolean emergingHolder;
    private boolean divingHolder;
    private boolean diggingDownHolder;
    private boolean diggingUpHolder;
    private boolean eatingHolder;
    private boolean forceSpawnDigParticlesHolder;
    private int divingTimer;
    private static final int DIVING_LENGTH = 15;
    private int digUpTimer;
    private static final int DIG_UP_LENGTH = 34;
    private int digDownTimer;
    private static final int DIG_DOWN_LENGTH = 37;
    public class_1799 carryingItem = class_1799.field_8037;
    private int aboveGroundTimer;
    private static final int MIN_TICKS_ABOVE_GROUND = 100;
    private boolean submergeLocked = false;
    public int friendlyTimer;
    private static final int FRIENDLY_TIMER_LENGTH = 3600;
    private int invalidSubmergeTimer;
    private static final int MAX_INVALID_SUBMERGE_TICKS = 10;
    public int cactusEatCooldownTimer;
    public static final int CACTUS_EAT_COOLDOWN = 6000;
    public static final int CACTUS_EAT_INTERRUPTED_COOLDOWN = 200;
    public int recentlyFedTimer;
    public static final int RECENTLY_FED_COOLDOWN = 1200;
    private int panicSoundCooldownTimer;
    private static final int PANIC_SOUND_COOLDOWN = 60;
    public boolean searchingForGift;

    public SandSnapperEntity(class_1299<SandSnapperEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        class_1799 itemStack = this.carryingItem;
        if (!itemStack.method_7960()) {
            tag.method_10566("carryingItemStack", itemStack.method_57358((class_7225.class_7874)this.method_56673()));
        }
        tag.method_10569("friendlyTimer", this.friendlyTimer);
        tag.method_10569("recentlyFedTimer", this.recentlyFedTimer);
        tag.method_10556("searchingForGift", this.searchingForGift);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("carryingItemStack")) {
            class_2487 carryingItemTag = tag.method_10562("carryingItemStack");
            this.carryingItem = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)carryingItemTag);
        }
        this.friendlyTimer = tag.method_10550("friendlyTimer");
        this.recentlyFedTimer = tag.method_10550("recentlyFedTimer");
        this.searchingForGift = tag.method_10577("searchingForGift");
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(EMERGING, (Object)false);
        builder.method_56912(DIVING, (Object)false);
        builder.method_56912(SUBMERGED, (Object)false);
        builder.method_56912(LOOKING_AT_PLAYER, (Object)false);
        builder.method_56912(DIGGING_DOWN, (Object)false);
        builder.method_56912(DIGGING_UP, (Object)false);
        builder.method_56912(EATING, (Object)false);
        builder.method_56912(FORCE_SPAWN_DIG_PARTICLES, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BuryLootGoal(this, 2, 1, 120));
        this.field_6201.method_6277(1, (class_1352)new GiftLootGoal(this, 2, 1, 120));
        this.field_6201.method_6277(2, (class_1352)new SnapperTemptGoal(this, 1.0, 2.5f, 10.0f));
        this.field_6201.method_6277(3, (class_1352)new EatPeachGoal(this, 16.0f, 4.0f, 1.0f, 1.5f));
        this.field_6201.method_6277(4, (class_1352)new RunFromPlayerGoal(this, 8.0f, 1.25, 2.0));
        this.field_6201.method_6277(5, (class_1352)new SnapperStrollGoal(this, 1.0, 1.25));
        this.field_6201.method_6277(6, (class_1352)new EatPricklyPeachCactusGoal(this, 6, 1, 4.0f, 2.0f));
        this.field_6201.method_6277(6, (class_1352)new EmergeGoal(this, 8.0f, 2.0f, 32.0f, 100));
    }

    @NotNull
    public class_4048 method_55694(@NotNull class_4050 pose) {
        if (this.isEmerging() || this.isDiving() || this.isDiggingUp() || this.isDiggingDown()) {
            return class_4048.method_18385((float)0.4f, (float)0.7f);
        }
        if (this.isSubmerged()) {
            return class_4048.method_18385((float)0.01f, (float)0.01f);
        }
        return super.method_55694(pose);
    }

    public void method_5674(@NotNull class_2940<?> dataAccessor) {
        super.method_5674(dataAccessor);
        if (dataAccessor.equals(EMERGING)) {
            AnimationController controller;
            if (this.method_37908().field_9236 && (controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.method_5628()).getAnimationControllers().get("generalController")) != null) {
                controller.forceAnimationReset();
            }
            this.emergingHolder = (Boolean)this.field_6011.method_12789(EMERGING);
            this.method_18382();
        } else if (dataAccessor.equals(DIVING)) {
            this.divingHolder = (Boolean)this.field_6011.method_12789(DIVING);
            if (this.isDiving()) {
                this.divingTimer = 15;
            }
            this.method_18382();
        } else if (dataAccessor.equals(SUBMERGED)) {
            this.submergedHolder = (Boolean)this.field_6011.method_12789(SUBMERGED);
            this.method_18382();
        } else if (dataAccessor.equals(LOOKING_AT_PLAYER)) {
            this.lookingAtPlayerHolder = (Boolean)this.field_6011.method_12789(LOOKING_AT_PLAYER);
        } else if (dataAccessor.equals(DIGGING_UP)) {
            this.diggingUpHolder = (Boolean)this.field_6011.method_12789(DIGGING_UP);
            if (this.isDiggingUp()) {
                this.digUpTimer = 34;
            }
            this.method_18382();
        } else if (dataAccessor.equals(DIGGING_DOWN)) {
            this.diggingDownHolder = (Boolean)this.field_6011.method_12789(DIGGING_DOWN);
            if (this.isDiggingDown()) {
                this.digDownTimer = 37;
            }
            this.method_18382();
        } else if (dataAccessor.equals(EATING)) {
            this.eatingHolder = (Boolean)this.field_6011.method_12789(EATING);
        } else if (dataAccessor.equals(FORCE_SPAWN_DIG_PARTICLES)) {
            this.forceSpawnDigParticlesHolder = (Boolean)this.field_6011.method_12789(FORCE_SPAWN_DIG_PARTICLES);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.aboveGroundTimer > 0) {
                --this.aboveGroundTimer;
            }
            if (this.panicSoundCooldownTimer > 0) {
                --this.panicSoundCooldownTimer;
            }
            if (this.friendlyTimer > 0) {
                --this.friendlyTimer;
            }
            if (this.cactusEatCooldownTimer > 0) {
                --this.cactusEatCooldownTimer;
            }
            if (this.recentlyFedTimer > 0) {
                --this.recentlyFedTimer;
            }
            if (this.canMove()) {
                if (!this.isSubmerged() && this.canSubmerge(false)) {
                    this.setSubmerged(true);
                    this.invalidSubmergeTimer = 0;
                } else if (this.isSubmerged() && !this.canSubmerge(false)) {
                    ++this.invalidSubmergeTimer;
                    if (this.invalidSubmergeTimer > 10) {
                        this.setSubmerged(false);
                        this.invalidSubmergeTimer = 0;
                    }
                }
            }
            if (this.isDiving()) {
                if (this.divingTimer > 0) {
                    --this.divingTimer;
                } else {
                    this.setDiving(false);
                    this.divingTimer = 0;
                }
            }
            if (this.isDiggingDown()) {
                if (this.digDownTimer > 0) {
                    --this.digDownTimer;
                } else {
                    this.setDiggingDown(false);
                    this.digDownTimer = 0;
                    this.field_6011.method_12778(SUBMERGED, (Object)true);
                    this.submergedHolder = true;
                    this.method_18382();
                }
            }
            if (this.isDiggingUp()) {
                if (this.digUpTimer > 0) {
                    --this.digUpTimer;
                } else {
                    this.setDiggingUp(false);
                    this.digUpTimer = 0;
                    this.field_6011.method_12778(SUBMERGED, (Object)false);
                    this.submergedHolder = false;
                    this.method_18382();
                }
            }
        }
    }

    public boolean canMove() {
        return !this.isDiving() && !this.isDiggingUp() && !this.isDiggingDown() && !this.isEmerging() && !this.isEating();
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.isSubmerged() || this.isDiggingDown() || this.isDiggingUp() || this.isDiving() || this.searchingForGift || !this.carryingItem.method_7960()) {
            return class_1269.field_5814;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574((class_1792)ItemModule.PRICKLY_PEACH_ITEM.get()) && this.recentlyFedTimer <= 0) {
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.method_32876((class_6880)class_5712.field_28725);
            this.onEat();
            this.friendlyTimer = 3600;
            this.searchingForGift = true;
            this.recentlyFedTimer = 1200;
            return class_1269.field_5812;
        }
        if (!itemStack.method_7960() && !itemStack.method_31574((class_1792)ItemModule.PRICKLY_PEACH_ITEM.get())) {
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
            this.carryingItem = itemStack.method_46651(1);
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.method_32876((class_6880)class_5712.field_28725);
            float pitch = class_3532.method_32750((class_5819)this.field_5974, (float)0.9f, (float)1.2f);
            this.method_5783((class_3414)SoundModule.SAND_SNAPPER_HAPPY.get(), 1.0f, pitch);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void onEat() {
        this.method_6025(4.0f);
        this.method_37908().method_8421((class_1297)this, (byte)7);
        float pitch = class_3532.method_32750((class_5819)this.field_5974, (float)0.9f, (float)1.2f);
        this.method_5783((class_3414)SoundModule.SAND_SNAPPER_HAPPY.get(), 1.0f, pitch);
    }

    protected void spawnHeartParticles() {
        for (int i = 0; i < 7; ++i) {
            double xSpeed = this.field_5974.method_43059() * 0.02;
            double ySpeed = this.field_5974.method_43059() * 0.02;
            double zSpeed = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), xSpeed, ySpeed, zSpeed);
        }
    }

    protected void spawnLootBuryParticles(class_2680 blockState) {
        class_2388 particleOption = new class_2388(class_2398.field_11217, blockState);
        for (int i = 0; i < 7; ++i) {
            double xSpeed = this.field_5974.method_43059() * 0.02;
            double ySpeed = this.field_5974.method_43059() * 0.02;
            double zSpeed = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleOption, this.method_23322(1.0), this.method_23319() + 1.5, this.method_23325(1.0), xSpeed, ySpeed, zSpeed);
        }
    }

    public void method_5711(byte eventId) {
        if (eventId == 7) {
            this.spawnHeartParticles();
        } else if (eventId == 8) {
            this.spawnLootBuryParticles(class_2246.field_10102.method_9564());
        } else if (eventId == 9) {
            this.spawnLootBuryParticles(((class_2248)BlockModule.ANCIENT_SAND.get()).method_9564());
        } else if (eventId == 10) {
            this.spawnLootBuryParticles(class_2246.field_10255.method_9564());
        } else {
            super.method_5711(eventId);
        }
    }

    public boolean method_30949(@NotNull class_1297 entity) {
        return !this.isSubmerged() && super.method_30949(entity);
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isSubmerged();
    }

    public void method_5697(@NotNull class_1297 entity) {
        if (!this.isSubmerged()) {
            super.method_5697(entity);
        }
    }

    public boolean method_5655() {
        return this.isSubmerged() || super.method_5655();
    }

    public boolean method_5679(@NotNull class_1282 source) {
        if (this.isSubmerged() && !source.method_48789(class_8103.field_42242) && !source.method_5530()) {
            return true;
        }
        if (source.method_49708(class_8111.field_42344)) {
            return true;
        }
        return super.method_5679(source);
    }

    public float method_6144(class_2338 movePos, class_4538 level) {
        return level.method_8320(movePos.method_10074()).method_26164(BlockModule.SAND_SNAPPER_BLOCKS) ? 10.0f : 0.0f;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.canMove()) {
            this.method_5942().method_6340();
        }
        class_243 movement = this.method_18798();
        if (this.method_37908().method_8608() && this.isSubmerged() && (movement.method_37267() > (double)0.01f || this.forceSpawnDigParticlesHolder)) {
            float width = this.method_18377(this.method_18376()).comp_2185() * 0.8f;
            Vector3d particlePos = new Vector3d(this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)width, this.method_23318() + 0.1, this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)width);
            Vector3d particleSpeed = new Vector3d(movement.field_1352 * -4.0, 1.5, movement.field_1350 * -4.0);
            this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, this.method_25936()), particlePos.x, particlePos.y, particlePos.z, particleSpeed.x, particleSpeed.y, particleSpeed.z);
        }
    }

    public boolean method_5757() {
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void method_6099(class_3218 serverLevel, class_1282 damageSource, boolean $$2) {
        super.method_6099(serverLevel, damageSource, $$2);
        this.method_5775(this.carryingItem);
    }

    public boolean method_17326() {
        return super.method_17326() || !this.carryingItem.method_7960();
    }

    public boolean isOnCactusEatCooldown() {
        return this.cactusEatCooldownTimer > 0;
    }

    public void eatCactus(class_2338 cactusPos) {
        class_2338 cactusBlockPos = new class_2338((class_2382)cactusPos);
        class_2680 state = this.method_37908().method_8320(cactusBlockPos);
        if (state.method_27852((class_2248)BlockModule.PRICKLY_PEACH_CACTUS.get()) && ((Boolean)state.method_11654((class_2769)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
            this.method_37908().method_8652(cactusBlockPos, (class_2680)((class_2680)state.method_11657((class_2769)PricklyPeachCactusBlock.FRUIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PricklyPeachCactusBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
            this.onEat();
        }
    }

    public void setSubmerged(boolean isSubmerged) {
        boolean prevValue = this.submergedHolder;
        this.field_6011.method_12778(SUBMERGED, (Object)isSubmerged);
        int n = this.aboveGroundTimer = isSubmerged ? 0 : 100;
        if (isSubmerged && !prevValue) {
            this.setDiggingDown(true);
        } else if (!isSubmerged && prevValue) {
            this.setDiggingUp(true);
        }
        this.method_18382();
    }

    public boolean canSubmerge(boolean ignoreTimer) {
        if (!ignoreTimer && this.aboveGroundTimer > 0) {
            return false;
        }
        if (!this.canMove()) {
            return false;
        }
        if (this.isSubmergeLocked()) {
            return false;
        }
        return this.canSubmergeAt(this.method_23312());
    }

    public boolean canSubmergeAt(class_2338 blockPos) {
        class_2680 blockStateOn = this.method_37908().method_8320(blockPos);
        class_2680 blockStateBelow = this.method_37908().method_8320(blockPos.method_10074());
        return blockStateOn.method_26164(BlockModule.SAND_SNAPPER_BLOCKS) || blockStateOn.method_27852(class_2246.field_10124) && blockStateBelow.method_26164(BlockModule.SAND_SNAPPER_BLOCKS);
    }

    public void setSubmergeLocked(boolean locked) {
        this.submergeLocked = locked;
    }

    public boolean isSubmergeLocked() {
        return this.submergeLocked;
    }

    public void setEmerging(boolean isEmerging) {
        this.field_6011.method_12778(EMERGING, (Object)isEmerging);
        this.emergingHolder = isEmerging;
        this.field_6011.method_12778(SUBMERGED, (Object)(!isEmerging ? 1 : 0));
        this.submergedHolder = !isEmerging;
    }

    public boolean isEmerging() {
        return this.emergingHolder;
    }

    public void setDiving(boolean isDiving) {
        this.field_6011.method_12778(DIVING, (Object)isDiving);
        this.divingHolder = isDiving;
    }

    public boolean isDiving() {
        return this.divingHolder;
    }

    public boolean isSubmerged() {
        return this.submergedHolder;
    }

    public void setDiggingUp(boolean diggingUp) {
        this.field_6011.method_12778(DIGGING_UP, (Object)diggingUp);
        this.diggingUpHolder = diggingUp;
    }

    public boolean isDiggingUp() {
        return this.diggingUpHolder;
    }

    public void setDiggingDown(boolean diggingDown) {
        this.field_6011.method_12778(DIGGING_DOWN, (Object)diggingDown);
        this.diggingDownHolder = diggingDown;
    }

    public boolean isDiggingDown() {
        return this.diggingDownHolder;
    }

    public boolean isLookingAtPlayer() {
        return this.lookingAtPlayerHolder;
    }

    public void setLookingAtPlayer(boolean isLookingAtPlayer) {
        this.field_6011.method_12778(LOOKING_AT_PLAYER, (Object)isLookingAtPlayer);
        this.lookingAtPlayerHolder = isLookingAtPlayer;
    }

    public boolean isEating() {
        return this.eatingHolder;
    }

    public void setEating(boolean isEating) {
        this.field_6011.method_12778(EATING, (Object)isEating);
        this.eatingHolder = isEating;
    }

    public void setForceSpawnDigParticles(boolean forceSpawnDigParticles) {
        this.field_6011.method_12778(FORCE_SPAWN_DIG_PARTICLES, (Object)forceSpawnDigParticles);
        this.forceSpawnDigParticlesHolder = forceSpawnDigParticles;
    }

    public boolean isForceSpawnDigParticles() {
        return this.forceSpawnDigParticlesHolder;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 $$0) {
        return (class_3414)SoundModule.SAND_SNAPPER_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)SoundModule.SAND_SNAPPER_DEATH.get();
    }

    public void tryPlayPanicSound() {
        if (this.panicSoundCooldownTimer > 0) {
            return;
        }
        float pitch = class_3532.method_32750((class_5819)this.method_59922(), (float)1.0f, (float)1.2f);
        this.method_5783((class_3414)SoundModule.SAND_SNAPPER_PANIC.get(), 1.0f, pitch);
        this.panicSoundCooldownTimer = 60;
    }

    private <E extends GeoAnimatable> PlayState generalPredicate(AnimationState<E> event) {
        if (this.isEmerging()) {
            if (this.isLookingAtPlayer()) {
                event.getController().setAnimation(this.EMERGE_PLAYER);
            } else {
                event.getController().setAnimation(this.EMERGE);
            }
            return PlayState.CONTINUE;
        }
        if (this.isEating()) {
            event.getController().setAnimation(this.EAT);
            return PlayState.CONTINUE;
        }
        if (this.isDiving()) {
            event.getController().setAnimation(this.DIVE);
            return PlayState.CONTINUE;
        }
        if (this.isDiggingDown()) {
            event.getController().setAnimation(this.DIG_DOWN);
            return PlayState.CONTINUE;
        }
        if (this.isDiggingUp()) {
            event.getController().setAnimation(this.DIG_UP);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.isSubmerged()) {
                event.getController().setAnimation(this.SWIM);
            } else {
                event.getController().setAnimation(this.WALK);
            }
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected void method_5712(class_2338 pos, class_2680 stateOn) {
        if (this.isSubmerged()) {
            return;
        }
        super.method_5712(pos, stateOn);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "generalController", 0, this::generalPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

