/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block.entity;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8170;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public class SuspiciousAncientSandBlockEntity
extends class_2586 {
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private class_2350 hitDirection;
    @Nullable
    private class_5321<class_52> lootTable;
    private long lootTableSeed;

    public SuspiciousAncientSandBlockEntity(class_2338 $$0, class_2680 $$1) {
        super((class_2591)EntityTypeModule.SUSPICIOUS_ANCIENT_SAND.get(), $$0, $$1);
    }

    public boolean brush(long $$0, class_1657 $$1, class_2350 $$2) {
        if (this.hitDirection == null) {
            this.hitDirection = $$2;
        }
        this.brushCountResetsAtTick = $$0 + 40L;
        if ($$0 >= this.coolDownEndsAtTick && this.field_11863 instanceof class_3218) {
            this.coolDownEndsAtTick = $$0 + 10L;
            this.unpackLootTable($$1);
            int $$3 = this.getCompletionState();
            if (++this.brushCount >= 10) {
                this.brushingCompleted($$1);
                return true;
            }
            this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 40);
            int $$4 = this.getCompletionState();
            if ($$3 != $$4) {
                class_2680 $$5 = this.method_11010();
                class_2680 $$6 = (class_2680)$$5.method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf($$4));
                this.field_11863.method_8652(this.method_11016(), $$6, 3);
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(class_1657 $$0) {
        if (this.lootTable != null && this.field_11863 != null && !this.field_11863.method_8608() && this.field_11863.method_8503() != null) {
            class_52 $$1 = this.field_11863.method_8503().method_58576().method_58295(this.lootTable);
            if ($$0 instanceof class_3222) {
                class_3222 $$2 = (class_3222)$$0;
                class_174.field_24479.method_27993($$2, this.lootTable);
            }
            class_8567 $$3 = new class_8567.class_8568((class_3218)this.field_11863).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51871($$0.method_7292()).method_51874(class_181.field_1226, (Object)$$0).method_51875(class_173.field_1179);
            ObjectArrayList $$4 = $$1.method_51879($$3, this.lootTableSeed);
            this.item = switch ($$4.size()) {
                case 0 -> class_1799.field_8037;
                case 1 -> (class_1799)$$4.getFirst();
                default -> {
                    YungsCaveBiomesCommon.LOGGER.warn("Expected max 1 loot from loot table {} got {}", this.lootTable, (Object)$$4.size());
                    yield (class_1799)$$4.getFirst();
                }
            };
            this.lootTable = null;
            this.method_5431();
        }
    }

    private void brushingCompleted(class_1657 $$0) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            class_2248 $$4;
            this.dropContent($$0);
            class_2680 $$1 = this.method_11010();
            this.field_11863.method_20290(3008, this.method_11016(), class_2248.method_9507((class_2680)$$1));
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof class_8170) {
                class_8170 $$3 = (class_8170)class_22482;
                $$4 = $$3.method_49810();
            } else {
                $$4 = class_2246.field_10124;
            }
            this.field_11863.method_8652(this.field_11867, $$4.method_9564(), 3);
        }
    }

    private void dropContent(class_1657 $$0) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            this.unpackLootTable($$0);
            if (!this.item.method_7960()) {
                double $$1 = class_1299.field_6052.method_17685();
                double $$2 = 1.0 - $$1;
                double $$3 = $$1 / 2.0;
                class_2350 $$4 = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
                class_2338 $$5 = this.field_11867.method_10079($$4, 1);
                double $$6 = (double)$$5.method_10263() + 0.5 * $$2 + $$3;
                double $$7 = (double)$$5.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
                double $$8 = (double)$$5.method_10260() + 0.5 * $$2 + $$3;
                class_1542 $$9 = new class_1542(this.field_11863, $$6, $$7, $$8, this.item.method_7971(this.field_11863.field_9229.method_43048(21) + 10));
                $$9.method_18799(class_243.field_1353);
                this.field_11863.method_8649((class_1297)$$9);
                this.item = class_1799.field_8037;
            }
        }
    }

    public void checkReset() {
        if (this.field_11863 != null) {
            if (this.brushCount != 0 && this.field_11863.method_8510() >= this.brushCountResetsAtTick) {
                int $$0 = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int $$1 = this.getCompletionState();
                if ($$0 != $$1) {
                    this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf($$1)), 3);
                }
                int $$2 = 4;
                this.brushCountResetsAtTick = this.field_11863.method_8510() + 4L;
            }
            if (this.brushCount == 0) {
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), (int)(this.brushCountResetsAtTick - this.field_11863.method_8510()));
            }
        }
    }

    private boolean tryLoadLootTable(class_2487 tag) {
        if (tag.method_10573(LOOT_TABLE_TAG, 8)) {
            this.lootTable = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)tag.method_10558(LOOT_TABLE_TAG)));
            this.lootTableSeed = tag.method_10537(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(class_2487 $$0) {
        if (this.lootTable == null) {
            return false;
        }
        $$0.method_10582(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            $$0.method_10544(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    @NotNull
    public class_2487 method_16887(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 $$0) {
        class_2487 $$1 = super.method_16887($$0);
        if (this.hitDirection != null) {
            $$1.method_10569(HIT_DIRECTION_TAG, this.hitDirection.ordinal());
        }
        if (!this.item.method_7960()) {
            $$1.method_10566(ITEM_TAG, this.item.method_57358($$0));
        }
        return $$1;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(@NotNull class_2487 $$0, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 $$1) {
        super.method_11014($$0, $$1);
        this.item = !this.tryLoadLootTable($$0) && $$0.method_10545(ITEM_TAG) ? class_1799.method_57360((class_7225.class_7874)$$1, (class_2520)$$0.method_10562(ITEM_TAG)).orElse(class_1799.field_8037) : class_1799.field_8037;
        if ($$0.method_10545(HIT_DIRECTION_TAG)) {
            this.hitDirection = class_2350.values()[$$0.method_10550(HIT_DIRECTION_TAG)];
        }
    }

    protected void method_11007(@NotNull class_2487 $$0, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 $$1) {
        super.method_11007($$0, $$1);
        if (!this.trySaveLootTable($$0) && !this.item.method_7960()) {
            $$0.method_10566(ITEM_TAG, this.item.method_57358($$1));
        }
    }

    public void setLootTable(class_5321<class_52> $$0, long $$1) {
        this.lootTable = $$0;
        this.lootTableSeed = $$1;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public class_2350 getHitDirection() {
        return this.hitDirection;
    }

    public class_1799 getItem() {
        return this.item;
    }

    public void setItem(class_1799 itemStack) {
        this.item = itemStack;
    }
}

