/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.AbstractCauldronBlockAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DamageTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IcicleBlock
extends class_2248
implements class_5688,
class_3737 {
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 TIP_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public IcicleBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{THICKNESS, WATERLOGGED});
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return IcicleBlock.isValidPosition(levelReader, blockPos);
    }

    public class_2680 method_9559(class_2680 currState, class_2350 neighborDirection, class_2680 neighborBlockState, class_1936 levelAccessor, class_2338 currPos, class_2338 neighborPos) {
        if (((Boolean)currState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(currPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        if (neighborDirection != class_2350.field_11036 && neighborDirection != class_2350.field_11033) {
            return currState;
        }
        if (levelAccessor.method_8397().method_8674(currPos, (Object)this)) {
            return currState;
        }
        if (neighborDirection == class_2350.field_11036 && !this.method_9558(currState, (class_4538)levelAccessor, currPos)) {
            levelAccessor.method_39279(currPos, (class_2248)this, 2);
            return currState;
        }
        class_5691 thickness = IcicleBlock.calculateIcicleThickness((class_4538)levelAccessor, currPos);
        return (class_2680)currState.method_11657(THICKNESS, (Comparable)thickness);
    }

    public void method_19286(class_1937 level, @NotNull class_2680 blockState, class_3965 blockHitResult, @NotNull class_1676 projectile) {
        class_2338 blockPos = blockHitResult.method_17777();
        if (!level.field_9236 && projectile.method_36971(level, blockPos) && projectile instanceof class_1665 && projectile.method_18798().method_1033() > 0.4) {
            level.method_22352(blockPos, true);
        }
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        IcicleBlock.spawnFallingIcicle(blockState, serverLevel, blockPos);
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        IcicleBlock.maybeFillCauldron(blockState, serverLevel, blockPos, random.method_43057());
        if (random.method_43057() < 0.011377778f && IcicleBlock.isTop(blockState, (class_4538)serverLevel, blockPos)) {
            IcicleBlock.tryToGrowIcicle(blockState, serverLevel, blockPos);
        }
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 random) {
        if (!IcicleBlock.canDrip(blockState)) {
            return;
        }
        float chance = random.method_43057();
        if (chance > 0.12f) {
            return;
        }
        IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(fluid -> chance < 0.02f || IcicleBlock.canFillCauldron(fluid)).ifPresent(fluid -> IcicleBlock.spawnDripParticle(level, blockPos, blockState, fluid));
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_1937 levelAccessor = blockPlaceContext.method_8045();
        if (!IcicleBlock.isValidPosition((class_4538)levelAccessor, blockPlaceContext.method_8037())) {
            return null;
        }
        boolean isWaterlogged = levelAccessor.method_8316(blockPlaceContext.method_8037()).method_15772() == class_3612.field_15910;
        class_5691 thickness = IcicleBlock.calculateIcicleThickness((class_4538)levelAccessor, blockPlaceContext.method_8037());
        if (thickness == null) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_5691 thickness = (class_5691)blockState.method_11654(THICKNESS);
        class_265 voxelShape = switch (thickness) {
            case class_5691.field_28068 -> BASE_SHAPE;
            case class_5691.field_28067 -> MIDDLE_SHAPE;
            case class_5691.field_28066 -> FRUSTUM_SHAPE;
            default -> TIP_SHAPE;
        };
        class_243 vec3 = blockState.method_26226(blockGetter, blockPos);
        return voxelShape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public boolean method_37403(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return false;
    }

    public float method_32913() {
        return 0.125f;
    }

    public void method_10129(class_1937 level, class_2338 blockPos, class_1540 fallingBlockEntity) {
        if (!fallingBlockEntity.method_5701() && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            Services.PLATFORM.sendIcicleProjectileShatterS2CPacket(serverLevel, class_243.method_24953((class_2382)blockPos));
            fallingBlockEntity.method_5783(class_3417.field_15081, 1.0f, 1.2f / (new Random().nextFloat() * 0.2f + 0.9f));
        }
    }

    @NotNull
    public class_1282 method_32898(@NotNull class_1297 entity) {
        return DamageTypeModule.of(entity.method_37908().method_30349(), DamageTypeModule.FALLING_ICICLE);
    }

    @NotNull
    public class_3610 method_9545(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    @Nullable
    private static class_2338 findTip(class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, int searchDistance) {
        if (IcicleBlock.isTip(blockState)) {
            return blockPos;
        }
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, class_2350.field_11033, state -> state.method_27852((class_2248)BlockModule.ICICLE.get()), IcicleBlock::isTip, searchDistance).orElse(null);
    }

    @Nullable
    private static class_2338 findRoot(class_1936 levelAccessor, class_2338 blockPos) {
        Predicate<class_2680> matchingPredicate = state -> state.method_27852((class_2248)BlockModule.ICICLE.get());
        Predicate<class_2680> stoppingPredicate = state -> !state.method_27852((class_2248)BlockModule.ICICLE.get());
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, class_2350.field_11036, matchingPredicate, stoppingPredicate, 11).orElse(null);
    }

    private static boolean isValidPosition(class_4538 levelReader, class_2338 blockPos) {
        class_2338 posAbove = blockPos.method_10093(class_2350.field_11036);
        class_2680 blockStateAbove = levelReader.method_8320(posAbove);
        return blockStateAbove.method_26206((class_1922)levelReader, posAbove, class_2350.field_11033) || blockStateAbove.method_27852((class_2248)BlockModule.ICICLE.get());
    }

    private static boolean isTip(class_2680 blockState) {
        if (!blockState.method_27852((class_2248)BlockModule.ICICLE.get())) {
            return false;
        }
        class_5691 thickness = (class_5691)blockState.method_11654(THICKNESS);
        return thickness == class_5691.field_28065;
    }

    private static boolean isTop(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return blockState.method_27852((class_2248)BlockModule.ICICLE.get()) && !levelReader.method_8320(blockPos.method_10084()).method_27852((class_2248)BlockModule.ICICLE.get());
    }

    private static Optional<class_2338> findBlockVertical(class_1936 levelAccessor, class_2338 startPos, class_2350 searchDirection, Predicate<class_2680> predicate, Predicate<class_2680> stoppingPredicate, int searchDistance) {
        class_2338.class_2339 mutable = startPos.method_25503();
        for (int i = 1; i < searchDistance; ++i) {
            mutable.method_10098(searchDirection);
            class_2680 blockState = levelAccessor.method_8320((class_2338)mutable);
            if (stoppingPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (predicate.test(blockState) && !levelAccessor.method_31601(mutable.method_10264())) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static class_5691 calculateIcicleThickness(class_4538 levelReader, class_2338 blockPos) {
        class_2680 blockBelow = levelReader.method_8320(blockPos.method_10093(class_2350.field_11033));
        class_2680 blockAbove = levelReader.method_8320(blockPos.method_10093(class_2350.field_11036));
        if (!blockBelow.method_27852((class_2248)BlockModule.ICICLE.get())) {
            return class_5691.field_28065;
        }
        if (blockBelow.method_11654(THICKNESS) == class_5691.field_28065) {
            return class_5691.field_28066;
        }
        if (!blockAbove.method_27852((class_2248)BlockModule.ICICLE.get())) {
            return class_5691.field_28068;
        }
        return class_5691.field_28067;
    }

    private static void spawnFallingIcicle(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos) {
        class_2338.class_2339 mutable = blockPos.method_25503();
        class_2680 blockState2 = blockState;
        while (blockState2.method_27852((class_2248)BlockModule.ICICLE.get())) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)serverLevel, (class_2338)mutable, (class_2680)blockState2);
            if (IcicleBlock.isTip(blockState2)) {
                int icicleSize = Math.max(1 + blockPos.method_10264() - mutable.method_10264(), 6);
                float damagePerBlock = 0.5f * (float)icicleSize;
                fallingBlockEntity.method_6965(damagePerBlock, 10);
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            blockState2 = serverLevel.method_8320((class_2338)mutable);
        }
    }

    private static void tryToGrowIcicle(class_2680 rootIcicleBlock, class_3218 serverLevel, class_2338 rootIcicleBlockPos) {
        if (!IcicleBlock.canGrow(serverLevel.method_8320(rootIcicleBlockPos.method_10086(1)), serverLevel.method_8320(rootIcicleBlockPos.method_10086(2)))) {
            return;
        }
        class_2338 tipPos = IcicleBlock.findTip(rootIcicleBlock, (class_1936)serverLevel, rootIcicleBlockPos, 6);
        if (tipPos == null || !IcicleBlock.isTip(serverLevel.method_8320(tipPos))) {
            return;
        }
        if (IcicleBlock.doesTipHaveRoomToGrow(serverLevel, tipPos)) {
            IcicleBlock.growIcicle(serverLevel, tipPos);
        }
    }

    private static boolean canGrow(class_2680 blockState, class_2680 blockStateAbove) {
        return blockState.method_26164(class_3481.field_15467) && blockStateAbove.method_27852(class_2246.field_10382) && blockStateAbove.method_26227().method_15771();
    }

    private static boolean doesTipHaveRoomToGrow(class_3218 serverLevel, class_2338 tipPos) {
        class_2338 belowTipPos = tipPos.method_10093(class_2350.field_11033);
        class_2680 belowTipBlock = serverLevel.method_8320(belowTipPos);
        if (!belowTipBlock.method_26227().method_15769()) {
            return false;
        }
        return belowTipBlock.method_26215();
    }

    private static void growIcicle(class_3218 serverLevel, class_2338 tipPos) {
        class_2338 belowTipBlock = tipPos.method_10074();
        IcicleBlock.createIcicle((class_1936)serverLevel, belowTipBlock, class_5691.field_28065);
    }

    private static void createIcicle(class_1936 levelAccessor, class_2338 blockPos, class_5691 thickness) {
        class_2680 blockState = (class_2680)((class_2680)((class_2248)BlockModule.ICICLE.get()).method_9564().method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910));
        levelAccessor.method_8652(blockPos, blockState, 3);
    }

    @Nullable
    public static class_2338 findIcicleTipAboveCauldron(class_1937 level, class_2338 blockPos) {
        return IcicleBlock.findBlockVertical((class_1936)level, blockPos, class_2350.field_11036, class_4970.class_4971::method_26215, IcicleBlock::canDrip, 11).orElse(null);
    }

    private static boolean canDrip(class_2680 blockState) {
        return blockState.method_26204() == BlockModule.ICICLE.get() && blockState.method_11654(THICKNESS) == class_5691.field_28065 && (Boolean)blockState.method_11654((class_2769)WATERLOGGED) == false;
    }

    private static Optional<class_3611> getFluidAboveIcicle(class_1937 level, class_2338 blockPos) {
        class_2338 rootPos = IcicleBlock.findRoot((class_1936)level, blockPos);
        if (rootPos == null) {
            return Optional.empty();
        }
        return Optional.of(level.method_8316(rootPos.method_10084()).method_15772());
    }

    private static boolean canFillCauldron(class_3611 fluid) {
        return fluid == class_3612.field_15910;
    }

    private static void spawnDripParticle(class_1937 level, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        class_243 vec3 = blockState.method_26226((class_1922)level, blockPos);
        double d = 0.0625;
        double x = (double)blockPos.method_10263() + 0.5 + vec3.field_1352;
        double y = (double)((float)(blockPos.method_10264() + 1) - 0.6875f) - d;
        double z = (double)blockPos.method_10260() + 0.5 + vec3.field_1350;
        level.method_8406((class_2394)class_2398.field_28078, x, y, z, 0.0, 0.0, 0.0);
    }

    public static class_3611 getCauldronFillFluidType(class_1937 level, class_2338 blockPos) {
        return IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(IcicleBlock::canFillCauldron).orElse(null);
    }

    private static void maybeFillCauldron(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, float f) {
        if (f > 0.17578125f) {
            return;
        }
        if (!IcicleBlock.isTop(blockState, (class_4538)serverLevel, blockPos)) {
            return;
        }
        class_3611 fluid = IcicleBlock.getCauldronFillFluidType((class_1937)serverLevel, blockPos);
        if (fluid != class_3612.field_15910) {
            return;
        }
        float dripChance = 0.17578125f;
        if (f >= dripChance) {
            return;
        }
        class_2338 tipPos = IcicleBlock.findTip(blockState, (class_1936)serverLevel, blockPos, 11);
        if (tipPos == null) {
            return;
        }
        Predicate<class_2680> isValidCauldron = state -> state.method_26204() instanceof class_2275 && ((AbstractCauldronBlockAccessor)state.method_26204()).callCanReceiveStalactiteDrip(fluid);
        class_2338 cauldronPos = IcicleBlock.findBlockVertical((class_1936)serverLevel, tipPos, class_2350.field_11033, class_4970.class_4971::method_26215, isValidCauldron, 11).orElse(null);
        if (cauldronPos == null) {
            return;
        }
        int yDist = tipPos.method_10264() - cauldronPos.method_10264();
        int timeUntilCauldronTick = 50 + yDist;
        class_2680 cauldronBlockState = serverLevel.method_8320(cauldronPos);
        serverLevel.method_39279(cauldronPos, cauldronBlockState.method_26204(), timeUntilCauldronTick);
    }
}

