/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_7118;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IceSheetBlock
extends class_5778
implements class_3737 {
    public static final MapCodec<IceSheetBlock> CODEC = IceSheetBlock.method_54094(IceSheetBlock::new);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 GLOWING = class_2741.field_12548;
    public static final class_2758 GROWTH_DISTANCE = class_2741.field_12497;
    private final class_7118 spreader = new class_7118((class_5778)this);

    public IceSheetBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)GROWTH_DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends class_5778> method_53969() {
        return CODEC;
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        if (random.method_43057() < 0.25f && serverLevel.method_8314(class_1944.field_9282, blockPos) > 12 - blockState.method_26193((class_1922)serverLevel, blockPos)) {
            serverLevel.method_8650(blockPos, false);
        }
        if (random.method_43057() < 0.05f) {
            this.spreadFromRandomFaceWithinBlock(blockState, serverLevel, blockPos, random);
            if ((Integer)blockState.method_11654((class_2769)GROWTH_DISTANCE) > 0) {
                this.spreadFromRandomFaceTowardRandomDirection(blockState, serverLevel, blockPos, random);
            }
        }
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 random) {
        if (level.method_8314(class_1944.field_9282, blockPos) <= 12 - blockState.method_26193((class_1922)level, blockPos) || random.method_43057() < 0.2f) {
            // empty if block
        }
    }

    public class_2680 method_9559(class_2680 thisState, class_2350 directionToNeighbor, class_2680 neighborState, class_1936 levelAccessor, class_2338 thisPos, class_2338 neighborPos) {
        if (((Boolean)thisState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(thisPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        return super.method_9559(thisState, directionToNeighbor, neighborState, levelAccessor, thisPos, neighborPos);
    }

    public class_2680 method_33362(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 neighborDirection) {
        class_2680 updatedState;
        if (!this.method_33369(neighborDirection)) {
            return null;
        }
        class_2338 neighborPos = blockPos.method_10093(neighborDirection);
        if (blockState.method_27852((class_2248)this)) {
            updatedState = blockState;
        } else {
            class_2680 class_26802 = updatedState = blockState.method_26227().method_33659((class_3611)class_3612.field_15910) ? (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : this.method_9564();
        }
        if (IceSheetBlock.method_33358((class_1922)blockGetter, (class_2350)neighborDirection, (class_2338)neighborPos, (class_2680)blockGetter.method_8320(neighborPos))) {
            updatedState = (class_2680)updatedState.method_11657((class_2769)IceSheetBlock.method_33374((class_2350)neighborDirection), (Comparable)Boolean.valueOf(true));
            class_2680 adjacentBlock = blockGetter.method_8320(neighborPos);
            if (adjacentBlock.method_26164(BlockModule.CREEPING_ICE_GLOWS_ON)) {
                updatedState = (class_2680)updatedState.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(true));
            }
        } else {
            updatedState = null;
        }
        return updatedState;
    }

    @NotNull
    public class_7118 method_41432() {
        return this.spreader;
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 neighborBlock, class_2338 neighborPos, boolean bl) {
        if (level.field_9236) {
            return;
        }
        for (Map.Entry entry : class_2429.field_11329.entrySet()) {
            class_2338 adjacentPos;
            class_2680 adjacentBlock;
            class_2350 direction = (class_2350)entry.getKey();
            class_2746 property = (class_2746)entry.getValue();
            if (!((Boolean)blockState.method_11654((class_2769)property)).booleanValue() || !(adjacentBlock = level.method_8320(adjacentPos = blockPos.method_10093(direction))).method_26164(BlockModule.CREEPING_ICE_GLOWS_ON)) continue;
            if (!((Boolean)blockState.method_11654((class_2769)GLOWING)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
            }
            return;
        }
        if (((Boolean)blockState.method_11654((class_2769)GLOWING)).booleanValue()) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public class_3610 method_9545(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{GLOWING, WATERLOGGED, GROWTH_DISTANCE});
    }

    public boolean spreadFromRandomFaceWithinBlock(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        List possibleSourceDirections = Lists.newArrayList((Object[])field_28421).stream().filter(direction -> IceSheetBlock.method_33366((class_2680)blockState, (class_2350)direction)).collect(Collectors.toList());
        Collections.shuffle(possibleSourceDirections);
        for (class_2350 possibleSourceDirection : possibleSourceDirections) {
            List possibleTargetDirections = Lists.newArrayList((Object[])field_28421).stream().filter(direction -> direction.method_10166() != possibleSourceDirection.method_10166() && (Boolean)blockState.method_11654((class_2769)IceSheetBlock.method_33374((class_2350)direction)) == false).collect(Collectors.toList());
            Collections.shuffle(possibleTargetDirections);
            for (class_2350 targetDirection : possibleTargetDirections) {
                class_2338 neighborPos;
                if (!IceSheetBlock.method_33358((class_1922)serverLevel, (class_2350)targetDirection, (class_2338)(neighborPos = blockPos.method_10093(targetDirection)), (class_2680)serverLevel.method_8320(neighborPos))) continue;
                class_2680 updatedState = (class_2680)blockState.method_11657((class_2769)IceSheetBlock.method_33374((class_2350)targetDirection), (Comparable)Boolean.valueOf(true));
                class_2680 adjacentBlock = serverLevel.method_8320(neighborPos);
                if (adjacentBlock.method_26164(BlockModule.CREEPING_ICE_GLOWS_ON)) {
                    updatedState = (class_2680)updatedState.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(true));
                }
                serverLevel.method_8652(blockPos, updatedState, 2);
                return true;
            }
        }
        return false;
    }

    public boolean spreadFromRandomFaceTowardRandomDirection(class_2680 spreadOriginBlockState, class_3218 serverLevel, class_2338 spreadOriginBlockPos, class_5819 random) {
        ArrayList directions = Lists.newArrayList((Object[])field_28421);
        Collections.shuffle(directions);
        return directions.stream().filter(direction -> IceSheetBlock.method_33366((class_2680)spreadOriginBlockState, (class_2350)direction)).anyMatch(direction -> this.spreadFromFaceTowardRandomDirection(spreadOriginBlockState, (class_1936)serverLevel, spreadOriginBlockPos, (class_2350)direction, random, false));
    }

    public boolean spreadFromFaceTowardRandomDirection(class_2680 spreadOriginBlockState, class_1936 levelAccessor, class_2338 spreadOriginBlockPos, class_2350 faceDirection, class_5819 random, boolean bl) {
        List<class_2350> list = Arrays.asList(field_28421);
        Collections.shuffle(list, new Random(random.method_43055()));
        return list.stream().anyMatch(targetDirection -> this.spreadFromFaceTowardDirection(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, (class_2350)targetDirection, bl));
    }

    public boolean spreadFromFaceTowardDirection(class_2680 spreadOriginBlockState, class_1936 levelAccessor, class_2338 spreadOriginBlockPos, class_2350 faceDirection, class_2350 targetDirection, boolean bl) {
        Optional<Pair<class_2338, class_2350>> optional = this.getSpreadFromFaceTowardDirection(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, targetDirection);
        if (optional.isPresent()) {
            Pair<class_2338, class_2350> pair = optional.get();
            return this.spreadToFace(levelAccessor, (class_2338)pair.getFirst(), (class_2350)pair.getSecond(), bl, spreadOriginBlockState);
        }
        return false;
    }

    private Optional<Pair<class_2338, class_2350>> getSpreadFromFaceTowardDirection(class_2680 spreadOriginBlockState, class_1936 levelAccessor, class_2338 spreadOriginBlockPos, class_2350 faceDirection, class_2350 targetDirection) {
        if (targetDirection.method_10166() != faceDirection.method_10166() && IceSheetBlock.method_33366((class_2680)spreadOriginBlockState, (class_2350)faceDirection) && !IceSheetBlock.method_33366((class_2680)spreadOriginBlockState, (class_2350)targetDirection)) {
            class_2350 direction3;
            if (this.canSpreadToFace(levelAccessor, spreadOriginBlockPos, targetDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)spreadOriginBlockPos, (Object)targetDirection));
            }
            class_2338 blockPos2 = spreadOriginBlockPos.method_10093(targetDirection);
            if (this.canSpreadToFace(levelAccessor, blockPos2, faceDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)blockPos2, (Object)faceDirection));
            }
            class_2338 blockPos3 = blockPos2.method_10093(faceDirection);
            return this.canSpreadToFace(levelAccessor, blockPos3, direction3 = targetDirection.method_10153(), spreadOriginBlockState) ? Optional.of(Pair.of((Object)blockPos3, (Object)direction3)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(class_1936 levelAccessor, class_2338 blockPos, class_2350 direction, class_2680 spreadOriginBlockState) {
        class_2680 blockState = levelAccessor.method_8320(blockPos);
        if (!this.canSpreadInto(levelAccessor, blockState, blockPos, spreadOriginBlockState)) {
            return false;
        }
        class_2680 blockState2 = this.method_33362(blockState, (class_1922)levelAccessor, blockPos, direction);
        return blockState2 != null;
    }

    private boolean spreadToFace(class_1936 levelAccessor, class_2338 blockPos, class_2350 direction, boolean bl, class_2680 spreadOriginBlockState) {
        if (!spreadOriginBlockState.method_28498((class_2769)GROWTH_DISTANCE)) {
            return false;
        }
        class_2680 oldBlockState = levelAccessor.method_8320(blockPos);
        class_2680 newBlockState = this.method_33362(oldBlockState, (class_1922)levelAccessor, blockPos, direction);
        if (newBlockState != null) {
            newBlockState = (class_2680)newBlockState.method_11657((class_2769)GROWTH_DISTANCE, (Comparable)Integer.valueOf((Integer)spreadOriginBlockState.method_11654((class_2769)GROWTH_DISTANCE) - 1));
            if (bl) {
                levelAccessor.method_22350(blockPos).method_12039(blockPos);
            }
            return levelAccessor.method_8652(blockPos, newBlockState, 2);
        }
        return false;
    }

    private boolean canSpreadInto(class_1936 levelAccessor, class_2680 blockState, class_2338 blockPos, class_2680 spreadOriginBlockState) {
        return (blockState.method_26215() || blockState.method_27852((class_2248)this) && (Integer)blockState.method_11654((class_2769)GROWTH_DISTANCE) < (Integer)spreadOriginBlockState.method_11654((class_2769)GROWTH_DISTANCE) || blockState.method_27852(class_2246.field_10382) && blockState.method_26227().method_15771()) && levelAccessor.method_8314(class_1944.field_9282, blockPos) <= 12 - blockState.method_26193((class_1922)levelAccessor, blockPos);
    }
}

