/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.network;

import com.minimons.Minimons;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.block.entity.PokemonAnimation;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class MinimonNetworking {
    public static final class_2960 SET_ANIMATION_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_animation");
    public static final class_2960 SET_AUTO_ROTATE_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_auto_rotate");
    public static final class_2960 SET_SCALE_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_scale");
    public static final class_2960 CLEAR_COLOR_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"clear_color");
    public static final class_2960 SET_HIDE_BLOCK_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_hide_block");
    public static final class_2960 SET_AUTO_REPEAT_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_auto_repeat");
    public static final class_2960 SET_AUTO_REPEAT_MS_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"set_auto_repeat_ms");
    public static final class_2960 CLEAR_MODEL_ID = class_2960.method_60655((String)"cobblemon_minimons", (String)"clear_model");

    public static void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(SetAnimationPayload.TYPE, SetAnimationPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetAutoRotatePayload.TYPE, SetAutoRotatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetScalePayload.TYPE, SetScalePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClearColorPayload.TYPE, ClearColorPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetHideBlockPayload.TYPE, SetHideBlockPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetAutoRepeatPayload.TYPE, SetAutoRepeatPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetAutoRepeatMsPayload.TYPE, SetAutoRepeatMsPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClearModelPayload.TYPE, ClearModelPayload.CODEC);
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(SetAnimationPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            String animationName = payload.animationName();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    PokemonAnimation animation = PokemonAnimation.fromName(animationName);
                    displayBlock.setAnimation(animation);
                    Minimons.LOGGER.debug("Set animation to {} for display at {}", (Object)animationName, (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetAutoRotatePayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            boolean autoRotate = payload.autoRotate();
            float rotation = payload.rotation();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!autoRotate) {
                        displayBlock.setRotation(rotation);
                    }
                    displayBlock.setAutoRotate(autoRotate);
                    Minimons.LOGGER.debug("Set auto-rotate to {} (rotation: {}) for display at {}", new Object[]{autoRotate, Float.valueOf(rotation), pos});
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetScalePayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            float scale = payload.scale();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    float clampedScale = Math.max(0.05f, Math.min(1.0f, scale));
                    displayBlock.setScale(clampedScale);
                    Minimons.LOGGER.debug("Set scale to {} for display at {}", (Object)Float.valueOf(clampedScale), (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ClearColorPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    displayBlock.setDisplayColor(null);
                    class_2680 state = player.method_37908().method_8320(pos);
                    if (state.method_28498((class_2769)MinimonDisplayBlock.COLOR)) {
                        player.method_37908().method_8652(pos, (class_2680)state.method_11657((class_2769)MinimonDisplayBlock.COLOR, (Comparable)Integer.valueOf(0)), 3);
                    }
                    Minimons.LOGGER.debug("Cleared color for display at {}", (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetHideBlockPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            boolean hide = payload.hide();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!displayBlock.isOwner((class_1657)player)) {
                        return;
                    }
                    displayBlock.setHideBlock(hide);
                    class_2680 state = player.method_37908().method_8320(pos);
                    if (state.method_28498((class_2769)MinimonDisplayBlock.HIDDEN)) {
                        player.method_37908().method_8652(pos, (class_2680)state.method_11657((class_2769)MinimonDisplayBlock.HIDDEN, (Comparable)Boolean.valueOf(hide)), 3);
                    }
                    Minimons.LOGGER.debug("Set hide-block={} for display at {}", (Object)hide, (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetAutoRepeatPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            boolean repeat = payload.repeat();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!displayBlock.isOwner((class_1657)player)) {
                        return;
                    }
                    displayBlock.setAutoRepeat(repeat);
                    Minimons.LOGGER.debug("Set auto-repeat={} for display at {}", (Object)repeat, (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetAutoRepeatMsPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            int ms = payload.ms();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!displayBlock.isOwner((class_1657)player)) {
                        return;
                    }
                    int clamped = Math.max(100, Math.min(20000, ms));
                    displayBlock.setAutoRepeatMs(clamped);
                    Minimons.LOGGER.debug("Set auto-repeat-ms={} for display at {}", (Object)clamped, (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ClearModelPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!displayBlock.isOwner((class_1657)player)) {
                        return;
                    }
                    displayBlock.setMinimonData(null);
                    Minimons.LOGGER.debug("Cleared model for display at {}", (Object)pos);
                }
            });
        });
    }

    public record SetAnimationPayload(class_2338 pos, String animationName) implements class_8710
    {
        public static final class_8710.class_9154<SetAnimationPayload> TYPE = new class_8710.class_9154(SET_ANIMATION_ID);
        public static final class_9139<class_2540, SetAnimationPayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_10814(payload.animationName);
        }, buf -> new SetAnimationPayload(buf.method_10811(), buf.method_19772()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetAutoRotatePayload(class_2338 pos, boolean autoRotate, float rotation) implements class_8710
    {
        public static final class_8710.class_9154<SetAutoRotatePayload> TYPE = new class_8710.class_9154(SET_AUTO_ROTATE_ID);
        public static final class_9139<class_2540, SetAutoRotatePayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52964(payload.autoRotate);
            buf.method_52941(payload.rotation);
        }, buf -> new SetAutoRotatePayload(buf.method_10811(), buf.readBoolean(), buf.readFloat()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetScalePayload(class_2338 pos, float scale) implements class_8710
    {
        public static final class_8710.class_9154<SetScalePayload> TYPE = new class_8710.class_9154(SET_SCALE_ID);
        public static final class_9139<class_2540, SetScalePayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52941(payload.scale);
        }, buf -> new SetScalePayload(buf.method_10811(), buf.readFloat()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ClearColorPayload(class_2338 pos) implements class_8710
    {
        public static final class_8710.class_9154<ClearColorPayload> TYPE = new class_8710.class_9154(CLEAR_COLOR_ID);
        public static final class_9139<class_2540, ClearColorPayload> CODEC = class_9139.method_56437((buf, payload) -> buf.method_10807(payload.pos), buf -> new ClearColorPayload(buf.method_10811()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetHideBlockPayload(class_2338 pos, boolean hide) implements class_8710
    {
        public static final class_8710.class_9154<SetHideBlockPayload> TYPE = new class_8710.class_9154(SET_HIDE_BLOCK_ID);
        public static final class_9139<class_2540, SetHideBlockPayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52964(payload.hide);
        }, buf -> new SetHideBlockPayload(buf.method_10811(), buf.readBoolean()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetAutoRepeatPayload(class_2338 pos, boolean repeat) implements class_8710
    {
        public static final class_8710.class_9154<SetAutoRepeatPayload> TYPE = new class_8710.class_9154(SET_AUTO_REPEAT_ID);
        public static final class_9139<class_2540, SetAutoRepeatPayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52964(payload.repeat);
        }, buf -> new SetAutoRepeatPayload(buf.method_10811(), buf.readBoolean()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetAutoRepeatMsPayload(class_2338 pos, int ms) implements class_8710
    {
        public static final class_8710.class_9154<SetAutoRepeatMsPayload> TYPE = new class_8710.class_9154(SET_AUTO_REPEAT_MS_ID);
        public static final class_9139<class_2540, SetAutoRepeatMsPayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_53002(payload.ms);
        }, buf -> new SetAutoRepeatMsPayload(buf.method_10811(), buf.readInt()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ClearModelPayload(class_2338 pos) implements class_8710
    {
        public static final class_8710.class_9154<ClearModelPayload> TYPE = new class_8710.class_9154(CLEAR_MODEL_ID);
        public static final class_9139<class_2540, ClearModelPayload> CODEC = class_9139.method_56437((buf, payload) -> buf.method_10807(payload.pos), buf -> new ClearModelPayload(buf.method_10811()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

