/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.client.screen;

import com.minimons.Minimons;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.block.entity.PokemonAnimation;
import com.minimons.client.network.MinimonClientNetworking;
import com.minimons.client.screen.MinimonsStyledButton;
import com.minimons.data.MinimonData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_898;

@Environment(value=EnvType.CLIENT)
public class MinimonDisplayScreen
extends class_437 {
    private static final int PANEL_BG = MinimonDisplayScreen.color(25, 22, 22, 255);
    private static final int HEADER_BG = MinimonDisplayScreen.color(35, 28, 28, 255);
    private static final int SECTION_BG = MinimonDisplayScreen.color(30, 25, 25, 255);
    private static final int BORDER_COLOR = MinimonDisplayScreen.color(60, 35, 35, 255);
    private static final int BORDER_HIGHLIGHT = MinimonDisplayScreen.color(90, 50, 50, 255);
    private static final int ACCENT_COLOR = MinimonDisplayScreen.color(200, 60, 60, 255);
    private static final int ACCENT_SECONDARY = MinimonDisplayScreen.color(255, 180, 80, 255);
    private static final int TEXT_PRIMARY = MinimonDisplayScreen.color(240, 235, 235, 255);
    private static final int TEXT_SECONDARY = MinimonDisplayScreen.color(180, 160, 160, 255);
    private static final int TEXT_DIM = MinimonDisplayScreen.color(140, 120, 120, 255);
    private static final int PREVIEW_BG = MinimonDisplayScreen.color(18, 15, 15, 255);
    private final MinimonDisplayBlockEntity blockEntity;
    private final class_2338 blockPos;
    private PokemonAnimation selectedAnimation;
    private float currentScale;
    private boolean autoRotate;
    private class_342 autoRepeatMsBox;
    private class_1297 previewEntity;
    private float previewRotation = 0.0f;
    private float facingRotation = 0.0f;
    private boolean previewDragging = false;
    private double lastMouseX;
    private long lastPreviewTickTime = 0L;
    private static final long PREVIEW_TICK_INTERVAL_MS = 50L;
    private long lastNamedAnimationTime = 0L;
    private static final long NAMED_ANIMATION_REPEAT_MS = 1500L;
    private static final float MIN_SCALE = 0.05f;
    private static final float MAX_SCALE = 1.0f;
    private static final float SCALE_STEP = 0.05f;
    private static final int PANEL_WIDTH = 400;
    private static final int PANEL_HEIGHT = 275;
    private static final int CONTROLS_WIDTH = 245;
    private static final int PREVIEW_WIDTH = 135;
    private int panelX;
    private int panelY;
    private class_4185 scaleLabelButton;
    private class_4185 autoRotateButton;
    private static Class<?> pokemonEntityClass = null;
    private static Class<?> pokemonClass = null;
    private static Class<?> speciesClass = null;
    private static Object pokemonSpeciesRegistry = null;
    private static boolean reflectionInitialized = false;
    private boolean previewInBattleState = false;
    private long screenOpenTime = 0L;
    private static final long TOOLTIP_DELAY_MS = 300L;

    private static int color(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public MinimonDisplayScreen(MinimonDisplayBlockEntity blockEntity) {
        super((class_2561)class_2561.method_43471((String)"screen.minimons.display"));
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.method_11016();
        this.selectedAnimation = blockEntity.getCurrentAnimation();
        this.currentScale = blockEntity.getScale();
        this.autoRotate = blockEntity.isAutoRotating();
        this.previewRotation = blockEntity.getRotation();
        class_2350 facing = (class_2350)blockEntity.method_11010().method_11654((class_2769)MinimonDisplayBlock.FACING);
        this.facingRotation = switch (facing) {
            case class_2350.field_11043 -> 0.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
            default -> 0.0f;
        };
        MinimonDisplayScreen.initializeReflection();
        this.createPreviewEntity();
    }

    private static void initializeReflection() {
        if (reflectionInitialized) {
            return;
        }
        reflectionInitialized = true;
        try {
            pokemonEntityClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            pokemonClass = Class.forName("com.cobblemon.mod.common.pokemon.Pokemon");
            speciesClass = Class.forName("com.cobblemon.mod.common.pokemon.Species");
            Class<?> pokemonSpeciesClass = Class.forName("com.cobblemon.mod.common.api.pokemon.PokemonSpecies");
            Field instanceField = pokemonSpeciesClass.getField("INSTANCE");
            pokemonSpeciesRegistry = instanceField.get(null);
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to initialize reflection for preview: {}", (Object)e.getMessage());
        }
    }

    private void createPreviewEntity() {
        MinimonData data = this.blockEntity.getMinimonData();
        if (data == null || !data.isValid() || pokemonEntityClass == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        try {
            block29: {
                Set<String> aspects;
                Object pokemon;
                block28: {
                    String formName;
                    class_2960 speciesLoc;
                    String speciesId = data.getSpeciesId();
                    if (speciesId.contains(":")) {
                        String[] parts = speciesId.split(":");
                        speciesLoc = class_2960.method_60655((String)parts[0], (String)parts[1]);
                    } else {
                        speciesLoc = class_2960.method_60655((String)"cobblemon", (String)speciesId);
                    }
                    Method getByIdentifier = pokemonSpeciesRegistry.getClass().getMethod("getByIdentifier", class_2960.class);
                    Object species = getByIdentifier.invoke(pokemonSpeciesRegistry, speciesLoc);
                    if (species == null) {
                        return;
                    }
                    Constructor<?> pokemonConstructor = pokemonClass.getConstructor(new Class[0]);
                    pokemon = pokemonConstructor.newInstance(new Object[0]);
                    Method setSpecies = pokemonClass.getMethod("setSpecies", speciesClass);
                    setSpecies.invoke(pokemon, species);
                    if (data.isShiny()) {
                        try {
                            Method setShiny = pokemonClass.getMethod("setShiny", Boolean.TYPE);
                            setShiny.invoke(pokemon, true);
                        }
                        catch (Exception setShiny) {
                            // empty catch block
                        }
                    }
                    if ((formName = data.getFormName()) != null && !formName.isEmpty()) {
                        try {
                            Method getForm = species.getClass().getMethod("getForm", String.class);
                            Object form = getForm.invoke(species, formName);
                            if (form == null) break block28;
                            Method[] methodArray = pokemonClass.getMethods();
                            int n = methodArray.length;
                            for (int i = 0; i < n; ++i) {
                                Method m = methodArray[i];
                                if (!m.getName().equals("setForm") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(form.getClass())) continue;
                                m.invoke(pokemon, form);
                                break;
                            }
                        }
                        catch (Exception getForm) {
                            // empty catch block
                        }
                    }
                }
                if ((aspects = data.getAspects()) != null && !aspects.isEmpty()) {
                    try {
                        Method setForcedAspects = pokemonClass.getMethod("setForcedAspects", Set.class);
                        setForcedAspects.invoke(pokemon, aspects);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method setAspects = pokemonClass.getMethod("setAspects", Set.class);
                            setAspects.invoke(pokemon, aspects);
                        }
                        catch (Exception setAspects) {
                            // empty catch block
                        }
                    }
                }
                Object pokemonEntityType = null;
                try {
                    Class<?> cobblemonEntitiesClass = Class.forName("com.cobblemon.mod.common.CobblemonEntities");
                    Field pokemonTypeField = cobblemonEntitiesClass.getField("POKEMON");
                    pokemonEntityType = pokemonTypeField.get(null);
                }
                catch (Exception e) {
                    return;
                }
                if (pokemonEntityType != null) {
                    for (Constructor<?> c : pokemonEntityClass.getConstructors()) {
                        Class<?>[] params = c.getParameterTypes();
                        if (params.length != 3 || !params[0].isAssignableFrom(level.getClass()) || !params[1].isAssignableFrom(pokemon.getClass())) continue;
                        this.previewEntity = (class_1297)c.newInstance(level, pokemon, pokemonEntityType);
                        break;
                    }
                }
                if (this.previewEntity == null) {
                    return;
                }
                this.previewEntity.method_5814(0.0, 0.0, 0.0);
                if (aspects != null && !aspects.isEmpty()) {
                    try {
                        Object entityData;
                        Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                        Field companionInstance = this.previewEntity.getClass().getField("Companion");
                        Object companion = companionInstance.get(null);
                        Method getAspectsAccessor = companionClass.getMethod("getASPECTS", new Class[0]);
                        Object aspectsAccessor = getAspectsAccessor.invoke(companion, new Object[0]);
                        if (aspectsAccessor == null || (entityData = this.findEntityData(this.previewEntity)) == null) break block29;
                        for (Method m : entityData.getClass().getMethods()) {
                            Class<?> param0Type;
                            if (m.getParameterCount() != 2 || !(param0Type = m.getParameterTypes()[0]).isAssignableFrom(aspectsAccessor.getClass())) continue;
                            m.invoke(entityData, aspectsAccessor, aspects);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.updatePreviewPose();
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to create preview entity: {}", (Object)e.getMessage());
        }
    }

    private Object findEntityData(class_1297 entity) {
        for (Class<?> currentClass = entity.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field f : currentClass.getDeclaredFields()) {
                String typeName = f.getType().getName();
                if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                f.setAccessible(true);
                try {
                    return f.get(entity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void updatePreviewPose() {
        if (this.previewEntity == null) {
            return;
        }
        try {
            switch (this.selectedAnimation.getAnimationType()) {
                case POSE: {
                    if (this.previewInBattleState) {
                        this.setPreviewBattleState(false);
                        this.previewInBattleState = false;
                    }
                    this.updatePreviewPoseType(this.selectedAnimation.getPoseTypeName());
                    break;
                }
                case BATTLE: {
                    this.setPreviewBattleState(true);
                    this.previewInBattleState = true;
                    this.updatePreviewPoseType(this.selectedAnimation.getPoseTypeName());
                    break;
                }
                case NAMED: {
                    this.triggerPreviewNamedAnimation(this.selectedAnimation.getPoseTypeName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPreviewBattleState(boolean battling) {
        try {
            for (Method m : this.previewEntity.getClass().getMethods()) {
                String name = m.getName();
                if (!name.equals("setBattleId") && !name.equals("setBattling") || m.getParameterCount() != 1) continue;
                Class<?> paramType = m.getParameterTypes()[0];
                if (paramType == Boolean.TYPE) {
                    m.invoke((Object)this.previewEntity, battling);
                    return;
                }
                if (!paramType.getName().contains("UUID") && !paramType.getName().contains("Optional")) continue;
                if (paramType.getName().contains("Optional")) {
                    Class<?> optionalClass = Class.forName("java.util.Optional");
                    Object optValue = battling ? optionalClass.getMethod("of", Object.class).invoke(null, UUID.randomUUID()) : optionalClass.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
                    m.invoke((Object)this.previewEntity, optValue);
                    return;
                }
                UUID uuid = battling ? UUID.randomUUID() : null;
                m.invoke((Object)this.previewEntity, uuid);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void triggerPreviewNamedAnimation(String animationName) {
        try {
            Method getDelegateMethod = null;
            for (Method m : this.previewEntity.getClass().getMethods()) {
                if (!m.getName().equals("getDelegate") || m.getParameterCount() != 0) continue;
                getDelegateMethod = m;
                break;
            }
            if (getDelegateMethod == null) {
                return;
            }
            Object delegate = getDelegateMethod.invoke((Object)this.previewEntity, new Object[0]);
            if (delegate == null) {
                return;
            }
            for (Method m : delegate.getClass().getMethods()) {
                if (!m.getName().equals("addFirstAnimation") || m.getParameterCount() != 1) continue;
                HashSet<String> animSet = new HashSet<String>();
                animSet.add(animationName);
                m.invoke(delegate, animSet);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePreviewPoseType(String poseTypeName) {
        block6: {
            try {
                Object entityData;
                try {
                    Method setEnablePoseTypeRecalculation = this.previewEntity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                    setEnablePoseTypeRecalculation.invoke((Object)this.previewEntity, false);
                }
                catch (Exception setEnablePoseTypeRecalculation) {
                    // empty catch block
                }
                Class<?> poseTypeClass = Class.forName("com.cobblemon.mod.common.entity.PoseType");
                Object poseType = null;
                for (Object enumConst : poseTypeClass.getEnumConstants()) {
                    if (!enumConst.toString().equalsIgnoreCase(poseTypeName)) continue;
                    poseType = enumConst;
                    break;
                }
                if (poseType == null) break block6;
                Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                Field companionInstance = this.previewEntity.getClass().getField("Companion");
                Object companion = companionInstance.get(null);
                Method getPoseTypeAccessor = companionClass.getMethod("getPOSE_TYPE", new Class[0]);
                Object poseTypeAccessor = getPoseTypeAccessor.invoke(companion, new Object[0]);
                if (poseTypeAccessor == null || (entityData = this.findEntityData(this.previewEntity)) == null) break block6;
                for (Method m : entityData.getClass().getMethods()) {
                    Class<?> param0Type;
                    if (m.getParameterCount() != 2 || !(param0Type = m.getParameterTypes()[0]).isAssignableFrom(poseTypeAccessor.getClass())) continue;
                    m.invoke(entityData, poseTypeAccessor, poseType);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void method_25426() {
        MinimonDisplayBlock displayBlock;
        super.method_25426();
        this.panelX = (this.field_22789 - 400) / 2;
        this.panelY = (this.field_22790 - 275) / 2;
        int contentX = this.panelX + 12;
        int y = this.panelY + 40;
        int btnWidth = 76;
        int btnHeight = 16;
        int padding = 3;
        int columns = 3;
        PokemonAnimation[] animations = PokemonAnimation.values();
        for (int i = 0; i < animations.length; ++i) {
            PokemonAnimation anim = animations[i];
            int col = i % columns;
            int row = i / columns;
            int bx = contentX + col * (btnWidth + padding);
            int by = y + row * (btnHeight + padding);
            MinimonsStyledButton button = new MinimonsStyledButton(bx, by, btnWidth, btnHeight, (class_2561)class_2561.method_43471((String)anim.getDisplayName()), btn -> this.selectAnimation(anim));
            button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)anim.getDescription())));
            this.method_37063((class_364)button);
        }
        int animRows = (animations.length + columns - 1) / columns;
        int controlsY = y + animRows * (btnHeight + padding) + 8;
        int halfWidth = 115;
        this.autoRotateButton = new MinimonsStyledButton(contentX, controlsY, halfWidth, 16, (class_2561)class_2561.method_43469((String)"gui.cobblemon_minimons.auto_rotate", (Object[])new Object[]{class_2561.method_43471((String)(this.autoRotate ? "gui.cobblemon_minimons.on" : "gui.cobblemon_minimons.off"))}), btn -> {
            this.autoRotate = !this.autoRotate;
            MinimonClientNetworking.sendAutoRotatePacket(this.blockPos, this.autoRotate, this.blockEntity.getRotation());
            btn.method_25355((class_2561)class_2561.method_43469((String)"gui.cobblemon_minimons.auto_rotate", (Object[])new Object[]{class_2561.method_43471((String)(this.autoRotate ? "gui.cobblemon_minimons.on" : "gui.cobblemon_minimons.off"))}));
        });
        this.autoRotateButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.cobblemon_minimons.auto_rotate.tooltip")));
        this.method_37063((class_364)this.autoRotateButton);
        MinimonsStyledButton hideBlockButton = new MinimonsStyledButton(contentX + halfWidth + 4, controlsY, halfWidth, 16, (class_2561)class_2561.method_43471((String)(this.blockEntity.isHideBlock() ? "screen.cobblemon_minimons.button.hide_block_on" : "screen.cobblemon_minimons.button.hide_block_off")), btn -> {
            boolean newHide = !this.blockEntity.isHideBlock();
            MinimonClientNetworking.sendHideBlockPacket(this.blockPos, newHide);
            btn.method_25355((class_2561)class_2561.method_43471((String)(newHide ? "screen.cobblemon_minimons.button.hide_block_on" : "screen.cobblemon_minimons.button.hide_block_off")));
        });
        hideBlockButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.hide_block")));
        this.method_37063((class_364)hideBlockButton);
        MinimonsStyledButton autoRepeatButton = new MinimonsStyledButton(contentX, controlsY += 20, 78, 16, (class_2561)class_2561.method_43471((String)(this.blockEntity.isAutoRepeat() ? "screen.cobblemon_minimons.button.repeat_on" : "screen.cobblemon_minimons.button.repeat_off")), btn -> {
            boolean newRepeat = !this.blockEntity.isAutoRepeat();
            try {
                this.blockEntity.setAutoRepeat(newRepeat);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MinimonClientNetworking.sendAutoRepeatPacket(this.blockPos, newRepeat);
            btn.method_25355((class_2561)class_2561.method_43471((String)(newRepeat ? "screen.cobblemon_minimons.button.repeat_on" : "screen.cobblemon_minimons.button.repeat_off")));
        });
        autoRepeatButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.auto_repeat")));
        this.method_37063((class_364)autoRepeatButton);
        this.autoRepeatMsBox = new class_342(this.field_22793, contentX + 82, controlsY, 55, 16, (class_2561)class_2561.method_43470((String)"ms"));
        try {
            this.autoRepeatMsBox.method_1852(Integer.toString(this.blockEntity.getAutoRepeatMs()));
        }
        catch (Exception e) {
            this.autoRepeatMsBox.method_1852("3500");
        }
        this.method_37063((class_364)this.autoRepeatMsBox);
        MinimonsStyledButton applyMsButton = new MinimonsStyledButton(contentX + 141, controlsY, 32, 16, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.set"), btn -> {
            try {
                int ms = Integer.parseInt(this.autoRepeatMsBox.method_1882().trim());
                ms = Math.max(100, Math.min(20000, ms));
                try {
                    this.blockEntity.setAutoRepeatMs(ms);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MinimonClientNetworking.sendAutoRepeatMsPacket(this.blockPos, ms);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        applyMsButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.apply_interval")));
        this.method_37063((class_364)applyMsButton);
        MinimonsStyledButton minusButton = new MinimonsStyledButton(contentX, controlsY += 20, 30, 16, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.minus"), btn -> this.adjustScale(-0.05f));
        minusButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.decrease_size")));
        this.method_37063((class_364)minusButton);
        this.scaleLabelButton = new MinimonsStyledButton(contentX + 34, controlsY, 130, 16, (class_2561)class_2561.method_43470((String)this.getScaleDisplayText()), btn -> {});
        this.method_37063((class_364)this.scaleLabelButton);
        MinimonsStyledButton plusButton = new MinimonsStyledButton(contentX + 168, controlsY, 30, 16, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.plus"), btn -> this.adjustScale(0.05f));
        plusButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.increase_size")));
        this.method_37063((class_364)plusButton);
        int clearBtnY = controlsY += 24;
        class_2248 block = this.blockEntity.method_11010().method_26204();
        if (block instanceof MinimonDisplayBlock && (displayBlock = (MinimonDisplayBlock)block).isDyeable()) {
            MinimonsStyledButton clearColorButton = new MinimonsStyledButton(contentX, clearBtnY, halfWidth, 16, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.clear_color"), btn -> MinimonClientNetworking.sendClearColorPacket(this.blockPos));
            clearColorButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.remove_dye")));
            this.method_37063((class_364)clearColorButton);
        }
        MinimonsStyledButton clearModelButton = new MinimonsStyledButton(contentX + halfWidth + 4, clearBtnY, halfWidth, 16, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.clear_model"), btn -> {
            MinimonClientNetworking.sendClearModelPacket(this.blockPos);
            this.method_25419();
        });
        clearModelButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_minimons.clear_model")));
        this.method_37063((class_364)clearModelButton);
        int doneY = this.panelY + 275 - 28;
        MinimonsStyledButton doneButton = new MinimonsStyledButton(contentX, doneY, 237, 20, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.button.done"), btn -> this.method_25419());
        this.method_37063((class_364)doneButton);
    }

    private String getScaleDisplayText() {
        int percent = Math.round(this.currentScale * 100.0f);
        return class_2561.method_43469((String)"screen.cobblemon_minimons.button.size", (Object[])new Object[]{percent}).getString();
    }

    private void adjustScale(float delta) {
        this.currentScale = Math.max(0.05f, Math.min(1.0f, this.currentScale + delta));
        MinimonClientNetworking.sendScalePacket(this.blockPos, this.currentScale);
        if (this.scaleLabelButton != null) {
            this.scaleLabelButton.method_25355((class_2561)class_2561.method_43470((String)this.getScaleDisplayText()));
        }
    }

    private void selectAnimation(PokemonAnimation animation) {
        if (animation.isNamedAnimation()) {
            this.lastNamedAnimationTime = System.currentTimeMillis();
        }
        this.selectedAnimation = animation;
        MinimonClientNetworking.sendAnimationPacket(this.blockPos, animation);
        this.updatePreviewPose();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, MinimonDisplayScreen.color(0, 0, 0, 160));
        this.drawPanel(graphics, this.panelX, this.panelY, 400, 275);
        this.drawHeader(graphics, this.panelX, this.panelY, 400);
        int previewX = this.panelX + 245 + 16;
        int previewY = this.panelY + 40;
        int previewH = 195;
        this.drawPreviewPanel(graphics, previewX, previewY, 135, previewH);
        this.renderPreviewEntity(graphics, previewX, previewY, 135, previewH, mouseX, mouseY, partialTick);
        class_5250 currentAnimLabel = this.selectedAnimation != null ? class_2561.method_43471((String)this.selectedAnimation.getDisplayName()) : class_2561.method_43471((String)"screen.cobblemon_minimons.label.none");
        graphics.method_27534(this.field_22793, (class_2561)currentAnimLabel, previewX + 67, previewY + previewH + 6, ACCENT_COLOR);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void drawPanel(class_332 graphics, int x, int y, int width, int height) {
        graphics.method_25294(x, y, x + width, y + height, PANEL_BG);
        graphics.method_25294(x, y, x + width, y + 2, BORDER_COLOR);
        graphics.method_25294(x, y + height - 2, x + width, y + height, BORDER_COLOR);
        graphics.method_25294(x, y, x + 2, y + height, BORDER_COLOR);
        graphics.method_25294(x + width - 2, y, x + width, y + height, BORDER_COLOR);
        graphics.method_25294(x + 2, y + 2, x + width - 2, y + 3, BORDER_HIGHLIGHT);
        graphics.method_25294(x + 2, y + 2, x + 3, y + height - 2, BORDER_HIGHLIGHT);
    }

    private void drawHeader(class_332 graphics, int x, int y, int width) {
        Object pokemonName;
        graphics.method_25294(x + 2, y + 2, x + width - 2, y + 36, HEADER_BG);
        graphics.method_25294(x + 8, y + 8, x + 10, y + 30, ACCENT_COLOR);
        MinimonData data = this.blockEntity.getMinimonData();
        Object object = pokemonName = data != null && data.isValid() ? data.getSpeciesId() : class_2561.method_43471((String)"screen.cobblemon_minimons.label.unknown").getString();
        if (!((String)pokemonName).isEmpty()) {
            pokemonName = ((String)pokemonName).substring(0, 1).toUpperCase() + ((String)pokemonName).substring(1);
        }
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.label.minimon_display"), x + 16, y + 10, TEXT_PRIMARY, true);
        graphics.method_51433(this.field_22793, (String)pokemonName, x + 16, y + 22, TEXT_SECONDARY, false);
        if (data != null && data.isShiny()) {
            graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.label.shiny_symbol"), x + width - 20, y + 14, ACCENT_SECONDARY, true);
        }
        graphics.method_25294(x + 8, y + 36, x + width - 8, y + 37, BORDER_COLOR);
    }

    private void drawPreviewPanel(class_332 graphics, int x, int y, int width, int height) {
        graphics.method_25294(x, y, x + width, y + height, PREVIEW_BG);
        graphics.method_49601(x, y, width, height, BORDER_COLOR);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.preview"), x + width / 2, y - 12, TEXT_DIM);
    }

    private void renderPreviewEntity(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        long currentTime;
        if (this.previewEntity == null) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.cobblemon_minimons.no_preview"), x + width / 2, y + height / 2, TEXT_DIM);
            return;
        }
        if (!this.previewDragging) {
            this.previewRotation = this.blockEntity.getRotation();
            this.autoRotate = this.blockEntity.isAutoRotating();
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastPreviewTickTime >= 50L) {
            this.lastPreviewTickTime = currentTime;
            try {
                double savedX = this.previewEntity.method_23317();
                double savedY = this.previewEntity.method_23318();
                double savedZ = this.previewEntity.method_23321();
                try {
                    Method setEnablePoseTypeRecalculation = this.previewEntity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                    setEnablePoseTypeRecalculation.invoke((Object)this.previewEntity, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.previewEntity.method_5773();
                ++this.previewEntity.field_6012;
                this.previewEntity.method_5814(savedX, savedY, savedZ);
            }
            catch (Exception savedX) {
                // empty catch block
            }
        }
        try {
            if (this.blockEntity.isAutoRepeat() && this.selectedAnimation != null && this.selectedAnimation.isNamedAnimation()) {
                long interval = this.blockEntity.getAutoRepeatMs();
                if (System.currentTimeMillis() - this.lastNamedAnimationTime >= interval) {
                    this.selectAnimation(this.selectedAnimation);
                }
            }
        }
        catch (Exception interval) {
            // empty catch block
        }
        int centerX = x + width / 2;
        int centerY = y + height / 2 + 40;
        float entityScale = 100.0f * this.currentScale;
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)centerX, (float)centerY, 50.0f);
        poseStack.method_22905(entityScale, -entityScale, entityScale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - this.previewRotation + this.facingRotation));
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        try {
            dispatcher.method_3954(this.previewEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (class_4597)graphics.method_51450(), 0xF000F0);
            graphics.method_51450().method_22993();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dispatcher.method_3948(true);
        poseStack.method_22909();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int previewX = this.panelX + 245 + 16;
        int previewY = this.panelY + 40;
        int previewH = 195;
        if (mouseX >= (double)previewX && mouseX <= (double)(previewX + 135) && mouseY >= (double)previewY && mouseY <= (double)(previewY + previewH)) {
            this.previewDragging = true;
            this.lastMouseX = mouseX;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.previewDragging = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.previewDragging) {
            double deltaX = mouseX - this.lastMouseX;
            this.previewRotation -= (float)deltaX;
            this.lastMouseX = mouseX;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25421() {
        return false;
    }
}

