/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.block.entity;

public enum PokemonAnimation {
    STAND("Stand", "STAND", AnimationType.POSE, "Default standing pose"),
    WALK("Walk", "WALK", AnimationType.POSE, "Walking animation (if available)"),
    SLEEP("Sleep", "SLEEP", AnimationType.POSE, "Sleeping pose (if available)"),
    HOVER("Hover", "HOVER", AnimationType.POSE, "Hovering in place (flying Pokemon)"),
    FLY("Fly", "FLY", AnimationType.POSE, "Flying animation (flying Pokemon)"),
    FLOAT("Float", "FLOAT", AnimationType.POSE, "Floating on water (if available)"),
    SWIM("Swim", "SWIM", AnimationType.POSE, "Swimming animation (if available)"),
    PORTRAIT("Portrait", "PORTRAIT", AnimationType.POSE, "Front-facing portrait pose"),
    PROFILE("Profile", "PROFILE", AnimationType.POSE, "Side profile pose"),
    SHOULDER_LEFT("Shoulder L", "SHOULDER_LEFT", AnimationType.POSE, "Left shoulder pose (small Pokemon)"),
    SHOULDER_RIGHT("Shoulder R", "SHOULDER_RIGHT", AnimationType.POSE, "Right shoulder pose (small Pokemon)"),
    BATTLE_IDLE("Battle", "STAND", AnimationType.BATTLE, "Battle idle stance (if available)"),
    CRY("Cry", "cry", AnimationType.NAMED, "Cry animation (plays once)"),
    PHYSICAL("Physical", "physical", AnimationType.NAMED, "Physical attack animation (plays once)"),
    SPECIAL("Special", "special", AnimationType.NAMED, "Special attack animation (plays once)"),
    STATUS("Status", "status", AnimationType.NAMED, "Status move animation (plays once)");

    private final String displayName;
    private final String animationName;
    private final AnimationType animationType;
    private final String description;

    private PokemonAnimation(String displayName, String animationName, AnimationType animationType, String description) {
        this.displayName = displayName;
        this.animationName = animationName;
        this.animationType = animationType;
        this.description = description;
    }

    public String getDisplayName() {
        return "animation.cobblemon_minimons." + this.name().toLowerCase();
    }

    public String getDescription() {
        return "animation.cobblemon_minimons." + this.name().toLowerCase() + ".desc";
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public boolean isPoseType() {
        return this.animationType == AnimationType.POSE;
    }

    public boolean isBattleAnimation() {
        return this.animationType == AnimationType.BATTLE;
    }

    public boolean isNamedAnimation() {
        return this.animationType == AnimationType.NAMED;
    }

    public String getPoseTypeName() {
        return this.animationName;
    }

    public static PokemonAnimation fromName(String name) {
        for (PokemonAnimation anim : PokemonAnimation.values()) {
            if (!anim.animationName.equalsIgnoreCase(name) && !anim.name().equalsIgnoreCase(name)) continue;
            return anim;
        }
        return STAND;
    }

    public PokemonAnimation next() {
        int nextIndex = (this.ordinal() + 1) % PokemonAnimation.values().length;
        return PokemonAnimation.values()[nextIndex];
    }

    public PokemonAnimation previous() {
        int prevIndex = (this.ordinal() - 1 + PokemonAnimation.values().length) % PokemonAnimation.values().length;
        return PokemonAnimation.values()[prevIndex];
    }

    public static enum AnimationType {
        POSE,
        BATTLE,
        NAMED;

    }
}

