/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.block.entity;

import com.minimons.block.entity.MinimonBlockEntities;
import com.minimons.block.entity.PokemonAnimation;
import com.minimons.data.MinimonData;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MinimonDisplayBlockEntity
extends class_2586 {
    private static final String DATA_KEY = "MinimonData";
    private static final String ROTATION_KEY = "Rotation";
    private static final String ANIMATION_TIME_KEY = "AnimationTime";
    private static final String ANIMATION_KEY = "Animation";
    private static final String AUTO_ROTATE_KEY = "AutoRotate";
    private static final String COLOR_KEY = "DisplayColor";
    private static final String OWNER_KEY = "OwnerUUID";
    private MinimonData minimonData;
    private float rotation = 0.0f;
    private float animationTime = 0.0f;
    private long animationSerial = 0L;
    private boolean shouldRotate = true;
    private PokemonAnimation currentAnimation = PokemonAnimation.STAND;
    private class_1767 displayColor = null;
    private UUID ownerUUID = null;
    private boolean hideBlock = false;
    private boolean autoRepeat = false;
    private int autoRepeatMs = 3500;

    public MinimonDisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(MinimonBlockEntities.MINIMON_DISPLAY, pos, state);
    }

    public void clientTick() {
        this.animationTime += 0.05f;
        if (this.animationTime > 1000.0f) {
            this.animationTime = 0.0f;
        }
        if (this.shouldRotate) {
            this.rotation += 0.5f;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }
    }

    public void rotate() {
        this.rotation += 45.0f;
        if (this.rotation >= 360.0f) {
            this.rotation -= 360.0f;
        }
        this.shouldRotate = false;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public MinimonData getMinimonData() {
        return this.minimonData;
    }

    public void setMinimonData(MinimonData data) {
        MinimonData oldData = this.minimonData;
        this.minimonData = data;
        this.method_5431();
        if (this.field_11863 != null && this.field_11863.method_8608() && oldData != null && data == null) {
            this.clearRendererCache();
        }
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.method_5431();
    }

    public float getAnimationTime() {
        return this.animationTime;
    }

    public PokemonAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(PokemonAnimation animation) {
        this.currentAnimation = animation;
        ++this.animationSerial;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public long getAnimationSerial() {
        return this.animationSerial;
    }

    public void cycleAnimation() {
        this.setAnimation(this.currentAnimation.next());
    }

    public boolean isAutoRotating() {
        return this.shouldRotate;
    }

    public void setAutoRotate(boolean autoRotate) {
        this.shouldRotate = autoRotate;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public float getScale() {
        return this.minimonData != null ? this.minimonData.getScale() : 0.15f;
    }

    public void setScale(float scale) {
        if (this.minimonData != null) {
            this.minimonData.setScale(scale);
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    @Nullable
    public class_1767 getDisplayColor() {
        return this.displayColor;
    }

    public void setDisplayColor(@Nullable class_1767 color) {
        this.displayColor = color;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean isHideBlock() {
        return this.hideBlock;
    }

    public void setHideBlock(boolean hide) {
        this.hideBlock = hide;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean isAutoRepeat() {
        return this.autoRepeat;
    }

    public void setAutoRepeat(boolean repeat) {
        this.autoRepeat = repeat;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public int getAutoRepeatMs() {
        return this.autoRepeatMs;
    }

    public void setAutoRepeatMs(int ms) {
        this.autoRepeatMs = ms;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.ownerUUID = uuid;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean isOwner(class_1657 player) {
        if (this.ownerUUID == null) {
            return true;
        }
        return this.ownerUUID.equals(player.method_5667());
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (this.minimonData != null) {
            class_2487 dataTag = new class_2487();
            this.minimonData.saveToTag(dataTag);
            tag.method_10566(DATA_KEY, (class_2520)dataTag);
        }
        tag.method_10548(ROTATION_KEY, this.rotation);
        tag.method_10548(ANIMATION_TIME_KEY, this.animationTime);
        tag.method_10582(ANIMATION_KEY, this.currentAnimation.name());
        tag.method_10544("AnimationSerial", this.animationSerial);
        tag.method_10556("HideBlock", this.hideBlock);
        tag.method_10556("AutoRepeat", this.autoRepeat);
        tag.method_10569("AutoRepeatMs", this.autoRepeatMs);
        tag.method_10556(AUTO_ROTATE_KEY, this.shouldRotate);
        if (this.displayColor != null) {
            tag.method_10582(COLOR_KEY, this.displayColor.method_7792());
        }
        if (this.ownerUUID != null) {
            tag.method_25927(OWNER_KEY, this.ownerUUID);
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        MinimonData oldData = this.minimonData;
        this.minimonData = tag.method_10545(DATA_KEY) ? MinimonData.fromTag(tag.method_10562(DATA_KEY)) : null;
        if (this.field_11863 != null && this.field_11863.method_8608() && oldData != null && this.minimonData == null) {
            this.clearRendererCache();
        }
        this.rotation = tag.method_10583(ROTATION_KEY);
        this.animationTime = tag.method_10583(ANIMATION_TIME_KEY);
        if (tag.method_10545(ANIMATION_KEY)) {
            this.currentAnimation = PokemonAnimation.fromName(tag.method_10558(ANIMATION_KEY));
        }
        if (tag.method_10545(AUTO_ROTATE_KEY)) {
            this.shouldRotate = tag.method_10577(AUTO_ROTATE_KEY);
        }
        if (tag.method_10545("AnimationSerial")) {
            this.animationSerial = tag.method_10537("AnimationSerial");
        }
        if (tag.method_10545("HideBlock")) {
            this.hideBlock = tag.method_10577("HideBlock");
        }
        if (tag.method_10545("AutoRepeat")) {
            this.autoRepeat = tag.method_10577("AutoRepeat");
        }
        if (tag.method_10545("AutoRepeatMs")) {
            this.autoRepeatMs = tag.method_10550("AutoRepeatMs");
        }
        this.displayColor = tag.method_10545(COLOR_KEY) ? class_1767.method_7793((String)tag.method_10558(COLOR_KEY), null) : null;
        this.ownerUUID = tag.method_25928(OWNER_KEY) ? tag.method_25926(OWNER_KEY) : null;
    }

    private void clearRendererCache() {
        try {
            Class<?> rendererClass = Class.forName("com.minimons.client.render.MinimonDisplayBlockEntityRenderer");
            Method clearMethod = rendererClass.getMethod("clearCacheForPosition", class_2338.class);
            clearMethod.invoke(null, this.field_11867);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = new class_2487();
        this.method_11007(tag, registries);
        return tag;
    }
}

