/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame.client.minigame;

import com.mojang.blaze3d.systems.RenderSystem;
import handyfon.pickaxeminigame.MiningConfig;
import handyfon.pickaxeminigame.MiningGrid;
import handyfon.pickaxeminigame.MiningType;
import handyfon.pickaxeminigame.Pickaxeminigame;
import handyfon.pickaxeminigame.client.MiningMusicHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class MiningMinigameScreen
extends class_437 {
    private static final class_2960 BEDROCK_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/block/bedrock.png");
    private static final class_2960[] DESTROY_STAGES = new class_2960[10];
    private static final int COLOR_GRID_BORDER = -15066598;
    private static final int COLOR_BACKGROUND = -15066598;
    private static final int COLOR_HIT_PREVIEW = 0x40FFFF00;
    private final MiningGrid grid;
    private final MiningType type;
    private final Random random = new Random();
    private final List<Sparkle> sparkles = new ArrayList<Sparkle>();
    private final List<Debris> debrisList = new ArrayList<Debris>();
    private final Map<MiningGrid.HiddenTreasure, Float> popAnimationTimers = new HashMap<MiningGrid.HiddenTreasure, Float>();
    private int currentTileSize = 32;
    private int gridStartX;
    private int gridStartY;
    private int totalPixelWidth;
    private int totalPixelHeight;
    private int hoveredTileX = -1;
    private int hoveredTileY = -1;
    private boolean itemsGiven = false;
    private boolean closedDueToLoss = false;
    private boolean endSoundPlayed = false;
    private float winTimer = 0.0f;
    private boolean winTransitionStarted = false;
    private float shakeIntensity = 0.0f;
    private float shakeOffsetX = 0.0f;
    private float shakeOffsetY = 0.0f;
    private float[][] hitFlash;
    private float[][] tileWobble;
    private float toolAnimationTime = 0.0f;
    private boolean isDigging = false;
    private float globalTime = 0.0f;
    private class_4185 closeButton;
    private boolean specialMusicStarted = false;
    private boolean initSoundsPlayed = false;
    private boolean advancementSpotOpenedSent = false;
    private boolean advancementScreenClearedSent = false;
    private final Set<MiningGrid.HiddenTreasure> rareItemsNotified = new HashSet<MiningGrid.HiddenTreasure>();
    private int screensCleared = 0;

    public MiningMinigameScreen(MiningType type, class_2338 pos) {
        this(type, pos, null, false);
    }

    public MiningMinigameScreen(MiningType type, class_2338 pos, String forcedGridSize, boolean forcedSuperStable) {
        super((class_2561)class_2561.method_43470((String)"Mining Minigame"));
        if (class_310.method_1551().field_1687 != null) {
            MiningConfig.TreasureEntry.setEnchantmentRegistry((class_2378<class_1887>)class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41265));
        }
        this.grid = new MiningGrid(type, pos, forcedGridSize, forcedSuperStable ? Boolean.TRUE : null);
        this.type = type;
        this.hitFlash = new float[this.grid.getHeight()][this.grid.getWidth()];
        this.tileWobble = new float[this.grid.getHeight()][this.grid.getWidth()];
    }

    private void recalcGridGeometry() {
        if (this.field_22789 <= 0 || this.field_22790 <= 0) {
            return;
        }
        int availW = this.field_22789 - 40;
        int availH = this.field_22790 - 140;
        int sizeX = availW / this.grid.getWidth();
        int sizeY = availH / this.grid.getHeight();
        this.currentTileSize = Math.max(8, Math.min(32, Math.min(sizeX, sizeY)));
        this.totalPixelWidth = this.grid.getWidth() * this.currentTileSize;
        this.totalPixelHeight = this.grid.getHeight() * this.currentTileSize;
        this.gridStartX = (this.field_22789 - this.totalPixelWidth) / 2;
        this.gridStartY = 80;
        if (this.hitFlash == null || this.hitFlash.length != this.grid.getHeight() || this.hitFlash[0].length != this.grid.getWidth()) {
            this.hitFlash = new float[this.grid.getHeight()][this.grid.getWidth()];
            this.tileWobble = new float[this.grid.getHeight()][this.grid.getWidth()];
        }
        int buttonY = this.field_22790 - 35;
        if (this.closeButton != null) {
            this.closeButton.method_46421(this.field_22789 / 2 - 50);
            this.closeButton.method_46419(buttonY);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.recalcGridGeometry();
        if (!this.initSoundsPlayed) {
            if (this.grid.getGridSize() == MiningGrid.GridSize.HUGE) {
                this.playSound(class_3417.field_15195, 1.2f);
            } else if (this.grid.getGridSize() == MiningGrid.GridSize.VERY_LARGE) {
                this.playSound(class_3417.field_14709, 1.0f);
            } else if (this.grid.getGridSize() == MiningGrid.GridSize.LARGE) {
                this.playSound(class_3417.field_14627, 1.2f);
            }
            if (this.grid.isSuperStable()) {
                this.playSound(class_3417.field_14703, 1.5f);
            }
            if (this.grid.getGridSize() == MiningGrid.GridSize.HUGE || this.grid.getGridSize() == MiningGrid.GridSize.VERY_LARGE) {
                MiningMusicHandler.getInstance().startMusic();
                this.specialMusicStarted = true;
            }
            this.initSoundsPlayed = true;
            if (!this.advancementSpotOpenedSent) {
                this.advancementSpotOpenedSent = true;
                ClientPlayNetworking.send((class_8710)new Pickaxeminigame.AdvancementPayload(Pickaxeminigame.AdvancementTrigger.SPOT_OPENED, this.grid.getGridSize().name()));
            }
        }
        int buttonY = this.field_22790 - 35;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> {
            this.playSound((class_3414)class_3417.field_15015.comp_349());
            this.method_25419();
        }).method_46434(this.field_22789 / 2 - 50, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
    }

    private void resetStateForNewRound() {
        this.itemsGiven = false;
        this.closedDueToLoss = false;
        this.endSoundPlayed = false;
        this.winTransitionStarted = false;
        this.winTimer = 0.0f;
        this.sparkles.clear();
        this.debrisList.clear();
        this.popAnimationTimers.clear();
        this.hitFlash = new float[this.grid.getHeight()][this.grid.getWidth()];
        this.tileWobble = new float[this.grid.getHeight()][this.grid.getWidth()];
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawTiledBackground(class_332 context) {
        int texSize = 32;
        for (int x = 0; x < this.field_22789; x += texSize) {
            for (int y = 0; y < this.field_22790; y += texSize) {
                context.method_25290(this.type.backgroundTexture, x, y, 0.0f, 0.0f, texSize, texSize, texSize, texSize);
            }
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, -654311424);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.grid.isGameOver() && !this.grid.hasWon() && !this.closedDueToLoss) {
            if (!this.endSoundPlayed) {
                this.playSound(class_3417.field_15081, 0.8f);
                this.endSoundPlayed = true;
            }
            this.closedDueToLoss = true;
            this.giveItemsToPlayer();
            if (this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"The wall collapsed!"), true);
            }
            this.method_25419();
            return;
        }
        this.globalTime += delta;
        this.updateShake(delta);
        this.updateHitFlash(delta);
        this.updateToolAnimation(delta);
        this.updateSparkles(delta);
        this.drawTiledBackground(context);
        this.drawUI(context);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)(this.gridStartX + (int)this.shakeOffsetX), (float)(this.gridStartY + (int)this.shakeOffsetY), 0.0f);
        this.drawGrid(context);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)(this.gridStartX + (int)this.shakeOffsetX), (float)(this.gridStartY + (int)this.shakeOffsetY), 0.0f);
        this.drawGrid(context);
        context.method_51448().method_22909();
        int gridBottom = this.gridStartY + this.totalPixelHeight;
        if (this.grid.isGameOver() && this.grid.hasWon()) {
            if (!this.winTransitionStarted) {
                this.winTransitionStarted = true;
                this.giveItemsToPlayer();
                if (!this.endSoundPlayed) {
                    this.playSound(class_3417.field_15195, 1.0f);
                    this.endSoundPlayed = true;
                }
                ++this.screensCleared;
                ClientPlayNetworking.send((class_8710)new Pickaxeminigame.AdvancementPayload(Pickaxeminigame.AdvancementTrigger.SCREEN_CLEARED));
            }
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Level Cleared!"), this.field_22789 / 2, gridBottom + 10, 65280);
            this.winTimer += delta;
            if (this.winTimer > 40.0f) {
                this.grid.startNextLevel();
                this.recalcGridGeometry();
                this.resetStateForNewRound();
            }
            this.drawCollectedItems(context, gridBottom + 25);
        }
        this.updateHoveredTile(mouseX, mouseY);
        this.drawToolCursor(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawUI(class_332 context) {
        Object titleStr = "Mining Minigame";
        if (this.grid.getGridSize() != MiningGrid.GridSize.NORMAL) {
            titleStr = this.grid.getGridSize().displayName + " Deposit!";
        }
        int titleColor = switch (this.grid.getGridSize()) {
            case MiningGrid.GridSize.LARGE -> 0x55FF55;
            case MiningGrid.GridSize.VERY_LARGE -> 0x55FFFF;
            case MiningGrid.GridSize.HUGE -> 0xFFAA00;
            default -> 0xFFFFFF;
        };
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)titleStr), this.field_22789 / 2, 10, titleColor);
        String toolName = this.grid.getCurrentTool() == MiningGrid.Tool.DIAMOND_PICKAXE ? "Hammer [3x3]" : "Pickaxe [+]";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)toolName), this.field_22789 / 2, 22, 13468991);
        int remaining = this.grid.getTotalTreasureCount() - this.grid.getFoundTreasureCount();
        class_5250 treasureText = class_2561.method_43470((String)("Items remaining: " + remaining));
        context.method_27535(this.field_22793, (class_2561)treasureText, 10, 10, 0xFFCC00);
        if (this.grid.isSuperStable()) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"SUPER STABLE!"), 10, 22, 65535);
        }
        int barW = 200;
        int barH = 10;
        int barX = (this.field_22789 - barW) / 2;
        int barY = 35;
        float pct = (float)this.grid.getStabilityRemaining() / (float)this.grid.getMaxStability();
        int fill = (int)((float)barW * pct);
        int col = this.grid.isSuperStable() ? (pct > 0.5f ? -16711681 : (pct > 0.25f ? -16733526 : -65536)) : (pct > 0.5f ? -16711936 : (pct > 0.25f ? -256 : -65536));
        context.method_25294(barX - 2, barY - 2, barX + barW + 2, barY + barH + 2, -16777216);
        context.method_25294(barX, barY, barX + barW, barY + barH, -12303292);
        if (fill > 0) {
            context.method_25294(barX, barY, barX + fill, barY + barH, col);
        }
        for (int i = 1; i < 10; ++i) {
            int lx = barX + i * barW / 10;
            context.method_25294(lx, barY, lx + 1, barY + barH, Integer.MIN_VALUE);
        }
    }

    private void drawGrid(class_332 context) {
        int ty;
        int tx;
        int x;
        int y;
        int w = this.grid.getWidth();
        int h = this.grid.getHeight();
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                tx = x * this.currentTileSize;
                ty = y * this.currentTileSize;
                if (this.grid.hasBedrock(x, y)) {
                    context.method_25290(BEDROCK_TEXTURE, tx, ty, 0.0f, 0.0f, this.currentTileSize, this.currentTileSize, this.currentTileSize, this.currentTileSize);
                    continue;
                }
                this.drawDarkenedTexture(context, this.type.backgroundTexture, tx, ty, this.currentTileSize, this.currentTileSize, 0.4f);
            }
        }
        this.drawItemsBelow(context);
        this.drawSparkles(context);
        this.drawDebris(context);
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                int sHp;
                int dHp;
                tx = x * this.currentTileSize;
                ty = y * this.currentTileSize;
                float wobble = this.tileWobble[y][x];
                int wobbleOffsetX = 0;
                int wobbleOffsetY = 0;
                if (wobble > 0.0f) {
                    wobbleOffsetX = (int)(Math.sin(wobble * 20.0f) * (double)wobble * 3.0);
                    wobbleOffsetY = (int)(Math.cos(wobble * 25.0f) * (double)wobble * 2.0);
                }
                if ((dHp = this.grid.getDirtHealth(x, y)) > 0) {
                    context.method_25290(this.type.softTexture, tx + wobbleOffsetX, ty + wobbleOffsetY, 0.0f, 0.0f, this.currentTileSize, this.currentTileSize, this.currentTileSize, this.currentTileSize);
                    if (dHp < 2) {
                        this.drawBreakAnimation(context, tx + wobbleOffsetX, ty + wobbleOffsetY, dHp, 2);
                    }
                }
                if ((sHp = this.grid.getStoneHealth(x, y)) > 0) {
                    int mx;
                    this.drawDarkenedTexture(context, this.type.hardTexture, tx + wobbleOffsetX, ty + wobbleOffsetY, this.currentTileSize, this.currentTileSize, sHp > 3 ? 0.2f : 0.0f);
                    int n = mx = sHp > 3 ? 6 : 3;
                    if (sHp < mx) {
                        this.drawBreakAnimation(context, tx + wobbleOffsetX, ty + wobbleOffsetY, sHp, mx);
                    }
                }
                if (this.hitFlash[y][x] > 0.0f) {
                    int a = (int)(this.hitFlash[y][x] * 200.0f);
                    context.method_25294(tx, ty, tx + this.currentTileSize, ty + this.currentTileSize, a << 24 | 0xFFFFFF);
                }
                context.method_49601(tx, ty, this.currentTileSize, this.currentTileSize, -15066598);
            }
        }
        if (this.hoveredTileX >= 0 && this.hoveredTileY >= 0 && !this.grid.isGameOver()) {
            this.drawHitPreview(context);
        }
        context.method_51448().method_22909();
    }

    private void drawItemsBelow(class_332 context) {
        for (MiningGrid.HiddenTreasure tr : this.grid.getTreasures()) {
            boolean fullyRevealed = this.grid.isTreasureFullyRevealed(tr);
            if (!this.isPartiallyExposed(tr)) continue;
            float cx = (float)(tr.x * this.currentTileSize) + (float)(tr.width * this.currentTileSize) / 2.0f;
            float cy = (float)(tr.y * this.currentTileSize) + (float)(tr.height * this.currentTileSize) / 2.0f;
            context.method_51448().method_22903();
            context.method_51448().method_46416(cx, cy, 0.0f);
            float baseScale = (float)this.currentTileSize / 32.0f * (float)Math.min(tr.width, tr.height) * 2.0f;
            float animationScale = 1.0f;
            if (fullyRevealed) {
                float tSincePop;
                if (!this.popAnimationTimers.containsKey(tr)) {
                    this.popAnimationTimers.put(tr, Float.valueOf(this.globalTime));
                    for (int i = 0; i < 8; ++i) {
                        this.sparkles.add(new Sparkle(cx, cy, this.random));
                    }
                    if (this.isRare(tr)) {
                        this.playSound(class_3417.field_14709, 1.0f);
                    }
                    if (this.isVeryRare(tr) && !this.rareItemsNotified.contains(tr)) {
                        this.rareItemsNotified.add(tr);
                        ClientPlayNetworking.send((class_8710)new Pickaxeminigame.AdvancementPayload(Pickaxeminigame.AdvancementTrigger.RARE_ITEM_FOUND));
                    }
                }
                if ((tSincePop = this.globalTime - this.popAnimationTimers.get(tr).floatValue()) < 0.5f) {
                    animationScale = 1.0f + (float)Math.sin((double)tSincePop * Math.PI / 0.5) * 0.3f;
                }
                if (this.isRare(tr) && this.random.nextFloat() < 0.2f) {
                    float ox = (this.random.nextFloat() - 0.5f) * (float)tr.width * (float)this.currentTileSize;
                    float oy = (this.random.nextFloat() - 0.5f) * (float)tr.height * (float)this.currentTileSize;
                    this.sparkles.add(new Sparkle(cx + ox, cy + oy, this.random));
                }
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            }
            context.method_51448().method_22905(baseScale * animationScale, baseScale * animationScale, 1.0f);
            context.method_51427(new class_1799((class_1935)tr.item), -8, -8);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_51448().method_22909();
        }
    }

    private boolean isPartiallyExposed(MiningGrid.HiddenTreasure tr) {
        for (int dy = 0; dy < tr.height; ++dy) {
            for (int dx = 0; dx < tr.width; ++dx) {
                if (this.grid.getStoneHealth(tr.x + dx, tr.y + dy) != 0 || this.grid.getDirtHealth(tr.x + dx, tr.y + dy) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRare(MiningGrid.HiddenTreasure tr) {
        String trId = class_7923.field_41178.method_10221((Object)tr.item).toString();
        for (MiningConfig.TreasureEntry entry : Pickaxeminigame.CONFIG.possibleTreasures) {
            if (!entry.itemId.equals(trId) || entry.rarity < 10) continue;
            return true;
        }
        return false;
    }

    private boolean isVeryRare(MiningGrid.HiddenTreasure tr) {
        String trId = class_7923.field_41178.method_10221((Object)tr.item).toString();
        for (MiningConfig.TreasureEntry entry : Pickaxeminigame.CONFIG.possibleTreasures) {
            if (!entry.itemId.equals(trId) || entry.rarity < 100) continue;
            return true;
        }
        return false;
    }

    private void drawRareGlow(class_332 context, float size) {
        int alpha = (int)((Math.sin((double)this.globalTime * 2.0) * 0.5 + 0.5) * 60.0) + 40;
        int argb = alpha << 24 | 0xFFD700;
        int s = (int)(size * 6.0f);
        context.method_25294(-s, -s, s, s, argb);
    }

    private void drawDarkenedTexture(class_332 context, class_2960 tex, int x, int y, int w, int h, float d) {
        context.method_25290(tex, x, y, 0.0f, 0.0f, w, h, w, h);
        if (d > 0.0f) {
            context.method_25294(x, y, x + w, y + h, (int)(d * 255.0f) << 24);
        }
    }

    private void drawBreakAnimation(class_332 context, int x, int y, int cur, int max) {
        int stage = class_3532.method_15340((int)((int)((1.0f - (float)cur / (float)max) * 10.0f)), (int)0, (int)9);
        RenderSystem.enableBlend();
        context.method_25290(DESTROY_STAGES[stage], x, y, 0.0f, 0.0f, this.currentTileSize, this.currentTileSize, this.currentTileSize, this.currentTileSize);
        RenderSystem.disableBlend();
    }

    private void drawHitPreview(class_332 context) {
        for (int[] off : this.grid.getToolOffsets()) {
            int x = this.hoveredTileX + off[0];
            int y = this.hoveredTileY + off[1];
            if (!this.grid.isValidTile(x, y) || this.grid.getStoneHealth(x, y) <= 0 && this.grid.getDirtHealth(x, y) <= 0) continue;
            context.method_25294(x * this.currentTileSize + 1, y * this.currentTileSize + 1, x * this.currentTileSize + this.currentTileSize - 1, y * this.currentTileSize + this.currentTileSize - 1, 0x40FFFF00);
        }
    }

    private void drawToolCursor(class_332 context, int mx, int my) {
        class_1792 item = this.grid.getCurrentTool() == MiningGrid.Tool.DIAMOND_PICKAXE ? class_1802.field_22024 : class_1802.field_8403;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)mx, (float)my, 300.0f);
        float rot = this.isDigging ? (float)Math.sin(this.toolAnimationTime * 20.0f) * 30.0f - 45.0f : -45.0f;
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(rot));
        context.method_51448().method_22905(1.5f, 1.5f, 1.5f);
        context.method_51427(new class_1799((class_1935)item), -8, -8);
        context.method_51448().method_22909();
    }

    private void drawCollectedItems(class_332 context, int yp) {
        Map<class_1792, Integer> coll = this.grid.getCollectedItems();
        if (coll.isEmpty()) {
            return;
        }
        int sx = this.field_22789 / 2 - coll.size() * 20 / 2;
        int i = 0;
        for (Map.Entry<class_1792, Integer> e : coll.entrySet()) {
            class_1799 stack = new class_1799((class_1935)e.getKey(), e.getValue().intValue());
            context.method_51427(stack, sx + i * 20, yp);
            context.method_51431(this.field_22793, stack, sx + i * 20, yp);
            ++i;
        }
    }

    private void playSound(class_3414 s) {
        this.playSound(s, 1.0f);
    }

    private void playSound(class_3414 s, float p) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)s, (float)p));
    }

    private void updateShake(float delta) {
        if (this.shakeIntensity > 0.0f) {
            this.shakeOffsetX = (this.random.nextFloat() - 0.5f) * 2.0f * this.shakeIntensity;
            this.shakeOffsetY = (this.random.nextFloat() - 0.5f) * 2.0f * this.shakeIntensity;
            this.shakeIntensity -= delta * 25.0f;
        } else {
            this.shakeOffsetX = 0.0f;
            this.shakeOffsetY = 0.0f;
        }
    }

    private void updateHitFlash(float d) {
        if (this.hitFlash == null) {
            return;
        }
        for (int y = 0; y < this.grid.getHeight(); ++y) {
            for (int x = 0; x < this.grid.getWidth(); ++x) {
                if (this.hitFlash[y][x] > 0.0f) {
                    this.hitFlash[y][x] = Math.max(0.0f, this.hitFlash[y][x] - d * 8.0f);
                }
                if (!(this.tileWobble[y][x] > 0.0f)) continue;
                this.tileWobble[y][x] = Math.max(0.0f, this.tileWobble[y][x] - d * 6.0f);
            }
        }
    }

    private void updateToolAnimation(float d) {
        if (this.isDigging) {
            this.toolAnimationTime += d;
            if (this.toolAnimationTime > 0.4f) {
                this.isDigging = false;
                this.toolAnimationTime = 0.0f;
            }
        }
    }

    private void updateSparkles(float d) {
        Iterator<Sparkle> it = this.sparkles.iterator();
        while (it.hasNext()) {
            Sparkle s = it.next();
            s.update(d);
            if (s.isAlive()) continue;
            it.remove();
        }
        Iterator<Debris> debrisIt = this.debrisList.iterator();
        while (debrisIt.hasNext()) {
            Debris debris = debrisIt.next();
            debris.update(d);
            if (debris.isAlive()) continue;
            debrisIt.remove();
        }
    }

    private void drawSparkles(class_332 context) {
        for (Sparkle s : this.sparkles) {
            float ratio = s.life / s.maxLife;
            float twinkle = (float)Math.sin(this.globalTime * 3.5f + s.phase) * 0.4f + 0.6f;
            int alpha = (int)(ratio * twinkle * 255.0f);
            if (alpha < 10) continue;
            int color = alpha << 24 | 0xFFFFFF;
            int x = (int)s.x;
            int y = (int)s.y;
            int sz = (int)s.size;
            context.method_25294(x - sz, y, x + sz + 1, y + 1, color);
            context.method_25294(x, y - sz, x + 1, y + sz + 1, color);
        }
    }

    private void drawDebris(class_332 context) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        for (Debris d : this.debrisList) {
            float ratio = d.life / d.maxLife;
            int alpha = (int)(ratio * 255.0f);
            if (alpha < 10) continue;
            int color = alpha << 24 | d.color;
            int sz = (int)(d.size * (0.5f + ratio * 0.5f) + 1.0f);
            context.method_51448().method_22903();
            context.method_51448().method_46416(d.x, d.y, 0.0f);
            context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(d.rotation));
            context.method_25294(-sz / 2, -sz / 2, sz / 2 + 1, sz / 2 + 1, color);
            context.method_51448().method_22909();
        }
        context.method_51448().method_22909();
    }

    private void spawnDebris(int tileX, int tileY, boolean isHardLayer) {
        float centerX = (float)(tileX * this.currentTileSize) + (float)this.currentTileSize / 2.0f;
        float centerY = (float)(tileY * this.currentTileSize) + (float)this.currentTileSize / 2.0f;
        int count = 1 + this.random.nextInt(3);
        for (int i = 0; i < count; ++i) {
            this.debrisList.add(new Debris(centerX, centerY, this.type, isHardLayer, this.random));
        }
    }

    private void triggerHitFlash(int cx, int cy) {
        for (int[] off : this.grid.getToolOffsets()) {
            int x = cx + off[0];
            int y = cy + off[1];
            if (!this.grid.isValidTile(x, y)) continue;
            this.hitFlash[y][x] = 1.0f;
            this.tileWobble[y][x] = 1.0f;
        }
    }

    private void updateHoveredTile(int mx, int my) {
        int rx = mx - (int)this.shakeOffsetX - this.gridStartX;
        int ry = my - (int)this.shakeOffsetY - this.gridStartY;
        if (rx >= 0 && rx < this.totalPixelWidth && ry >= 0 && ry < this.totalPixelHeight) {
            this.hoveredTileX = rx / this.currentTileSize;
            this.hoveredTileY = ry / this.currentTileSize;
        } else {
            this.hoveredTileX = -1;
            this.hoveredTileY = -1;
        }
    }

    private void giveItemsToPlayer() {
        if (this.itemsGiven) {
            return;
        }
        this.itemsGiven = true;
        List<class_1799> stacks = this.grid.getCollectedItemStacks();
        if (!stacks.isEmpty()) {
            ClientPlayNetworking.send((class_8710)new Pickaxeminigame.RewardPayload(new ArrayList<class_1799>(stacks)));
        }
    }

    public boolean method_25402(double mx, double my, int btn) {
        if (this.hoveredTileX >= 0 && this.hoveredTileY >= 0 && !this.grid.isGameOver()) {
            if (btn == 0) {
                this.triggerHitFlash(this.hoveredTileX, this.hoveredTileY);
                if (this.grid.hitTile(this.hoveredTileX, this.hoveredTileY)) {
                    this.isDigging = true;
                    this.toolAnimationTime = 0.0f;
                    boolean hitBedrock = false;
                    for (int[] off : this.grid.getToolOffsets()) {
                        int tx = this.hoveredTileX + off[0];
                        int ty = this.hoveredTileY + off[1];
                        if (!this.grid.isValidTile(tx, ty) || !this.grid.hasBedrock(tx, ty)) continue;
                        hitBedrock = true;
                        break;
                    }
                    if (hitBedrock) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14785, (float)(1.2f + (this.random.nextFloat() - 0.5f) * 0.2f), (float)0.25f));
                        this.shakeIntensity = 8.0f;
                    } else {
                        this.shakeIntensity = this.grid.getCurrentTool().size == 3 ? 4.0f : 2.0f;
                        boolean isStone = this.grid.lastHitFeedback == MiningGrid.HitFeedback.STONE;
                        for (int[] off : this.grid.getToolOffsets()) {
                            int tx = this.hoveredTileX + off[0];
                            int ty = this.hoveredTileY + off[1];
                            if (!this.grid.isValidTile(tx, ty)) continue;
                            this.spawnDebris(tx, ty, isStone);
                        }
                        if (isStone) {
                            this.playSound(class_3417.field_15026, 1.0f + (this.random.nextFloat() - 0.5f) * 0.2f);
                        } else if (this.grid.lastHitFeedback == MiningGrid.HitFeedback.REVEAL_ITEM) {
                            this.playSound(class_3417.field_26942, 1.5f + (this.random.nextFloat() - 0.5f) * 0.2f);
                        } else {
                            this.playSound(class_3417.field_15211, 0.8f + (this.random.nextFloat() - 0.5f) * 0.2f);
                        }
                    }
                } else {
                    this.playSound(class_3417.field_28975, 0.5f);
                }
                if (this.grid.checkAndCollectTreasures()) {
                    this.playSound(class_3417.field_14627, 1.2f);
                }
                return true;
            }
            if (btn == 1) {
                this.playSound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
                this.grid.cycleTool();
                return true;
            }
        }
        return super.method_25402(mx, my, btn);
    }

    public boolean method_25404(int key, int scan, int mod) {
        if (key == 258) {
            this.grid.cycleTool();
            this.playSound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
            return true;
        }
        if (key == 49) {
            this.grid.setTool(MiningGrid.Tool.STONE_PICKAXE);
            this.playSound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
            return true;
        }
        if (key == 50) {
            this.grid.setTool(MiningGrid.Tool.DIAMOND_PICKAXE);
            this.playSound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
            return true;
        }
        return super.method_25404(key, scan, mod);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        if (this.specialMusicStarted) {
            MiningMusicHandler.getInstance().startFadeOut(15.0f);
        }
        super.method_25419();
    }

    static {
        for (int i = 0; i < 10; ++i) {
            MiningMinigameScreen.DESTROY_STAGES[i] = class_2960.method_60655((String)"minecraft", (String)("textures/block/destroy_stage_" + i + ".png"));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Sparkle {
        float x;
        float y;
        float life;
        float maxLife;
        float vx;
        float vy;
        float size;
        float phase;

        Sparkle(float x, float y, Random random) {
            this.x = x;
            this.y = y;
            this.life = this.maxLife = 1.5f + random.nextFloat() * 1.0f;
            this.vx = (random.nextFloat() - 0.5f) * 3.0f;
            this.vy = (random.nextFloat() - 0.5f) * 3.0f;
            this.size = 0.8f + random.nextFloat() * 0.7f;
            this.phase = random.nextFloat() * 6.28f;
        }

        void update(float d) {
            this.life -= d;
            this.x += this.vx * d;
            this.y += this.vy * d;
            this.vx *= 0.99f;
            this.vy *= 0.99f;
        }

        boolean isAlive() {
            return this.life > 0.0f;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Debris {
        float x;
        float y;
        float life;
        float maxLife;
        float vx;
        float vy;
        float size;
        int color;
        float gravity;
        float rotation;
        float rotationSpeed;
        private static final Map<MiningType, int[][]> TYPE_COLORS = Map.of(MiningType.STONE, new int[][]{{0x8B8B8B, 0x6B6B6B, 0x5A5A5A, 0x7A7A7A}, {9132587, 7029795, 10185533, 8018484}}, MiningType.DIRT, new int[][]{{7029795, 5913114, 8015920, 4861973}, {9136971, 8018490, 10189659, 6965802}}, MiningType.SAND, new int[][]{{13941899, 12889211, 14994587, 11836523}, {15259043, 14403730, 15786165, 13613957}}, MiningType.DEEPSLATE, new int[][]{{0x4A4A4A, 0x3A3A3A, 0x5A5A5A, 0x2A2A2A}, {0x6B6B5B, 0x5B5B4B, 0x7B7B6B, 0x4B4B3B}}, MiningType.NETHERRACK, new int[][]{{7020576, 0x5B1515, 8071722, 4919312}, {3877664, 2824976, 4930352, 0x1B0B00}}, MiningType.END, new int[][]{{14211232, 13158544, 15263920, 0xB8B880}, {0xA080A0, 0x907090, 0xB090B0, 0x806080}});

        Debris(float x, float y, MiningType miningType, boolean isHardLayer, Random random) {
            this.x = x + (random.nextFloat() - 0.5f) * 8.0f;
            this.y = y + (random.nextFloat() - 0.5f) * 8.0f;
            this.life = this.maxLife = 30.0f + random.nextFloat() * 20.0f;
            this.vx = (random.nextFloat() - 0.5f) * 3.0f;
            this.vy = -2.0f - random.nextFloat() * 2.0f;
            this.size = 2.0f + random.nextFloat() * 1.5f;
            this.gravity = 0.15f + random.nextFloat() * 0.05f;
            this.rotation = random.nextFloat() * 360.0f;
            this.rotationSpeed = (random.nextFloat() - 0.5f) * 15.0f;
            int[][] typeColors = TYPE_COLORS.getOrDefault((Object)miningType, TYPE_COLORS.get((Object)MiningType.STONE));
            int[] colors = isHardLayer ? typeColors[0] : typeColors[1];
            this.color = colors[random.nextInt(colors.length)];
        }

        void update(float d) {
            this.life -= d;
            this.x += this.vx;
            this.y += this.vy;
            this.vy += this.gravity;
            this.vx *= 0.98f;
            this.rotation += this.rotationSpeed;
        }

        boolean isAlive() {
            return this.life > 0.0f;
        }
    }
}

