/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame.client;

import handyfon.pickaxeminigame.ModSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class MiningMusicHandler {
    private static MiningMusicHandler instance;
    private MinigameMusicInstance currentMusic;
    private boolean isPlaying = false;
    private float fadeOutTime = 0.0f;
    private float maxFadeOutTime = 0.0f;
    private boolean isFadingOut = false;

    public static MiningMusicHandler getInstance() {
        if (instance == null) {
            instance = new MiningMusicHandler();
        }
        return instance;
    }

    public void startMusic() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_1538().method_4859();
        this.stopImmediately();
        this.currentMusic = new MinigameMusicInstance();
        client.method_1483().method_4873((class_1113)this.currentMusic);
        this.isPlaying = true;
        this.isFadingOut = false;
    }

    public void startFadeOut(float durationSeconds) {
        if (!this.isPlaying || this.currentMusic == null) {
            return;
        }
        this.isFadingOut = true;
        this.fadeOutTime = this.maxFadeOutTime = durationSeconds * 20.0f;
    }

    public void tick(float delta) {
        if (!this.isFadingOut || this.currentMusic == null) {
            return;
        }
        this.fadeOutTime -= delta;
        if (this.fadeOutTime <= 0.0f) {
            this.stopImmediately();
        } else {
            float progress = this.fadeOutTime / this.maxFadeOutTime;
            this.currentMusic.setFadeVolume(progress);
        }
    }

    public void stopImmediately() {
        if (this.currentMusic != null) {
            class_310 client = class_310.method_1551();
            if (client != null) {
                client.method_1483().method_4870((class_1113)this.currentMusic);
            }
            this.currentMusic = null;
        }
        this.isPlaying = false;
        this.isFadingOut = false;
        this.fadeOutTime = 0.0f;
    }

    public boolean isPlaying() {
        return this.isPlaying && !this.isFadingOut;
    }

    public boolean isFadingOut() {
        return this.isFadingOut;
    }

    @Environment(value=EnvType.CLIENT)
    private static class MinigameMusicInstance
    extends class_1102 {
        private float fadeVolume = 1.0f;

        protected MinigameMusicInstance() {
            super(ModSounds.SINNOH_UNDERGROUND, class_3419.field_15253, class_5819.method_43047());
            this.field_5446 = true;
            this.field_5451 = 0;
            this.field_5442 = 0.3f;
            this.field_5441 = 1.0f;
            this.field_18936 = true;
        }

        public void setFadeVolume(float volume) {
            this.fadeVolume = Math.max(0.0f, Math.min(1.0f, volume));
        }

        public float method_4781() {
            return super.method_4781() * this.fadeVolume;
        }

        public boolean method_4785() {
            return true;
        }
    }
}

