/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import handyfon.pickaxeminigame.MiningConfig;
import handyfon.pickaxeminigame.MiningGrid;
import handyfon.pickaxeminigame.MiningType;
import handyfon.pickaxeminigame.ModAdvancements;
import handyfon.pickaxeminigame.ModSounds;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class Pickaxeminigame
implements ModInitializer {
    public static MiningConfig CONFIG;
    private static final Gson GSON;
    private static final Random random;
    private static final int SPAWN_CHECK_INTERVAL = 20;
    public static final Map<class_2338, SpotData> activeSpotData;
    public static final Map<class_2338, Long> activeSpots;

    public void onInitialize() {
        this.loadConfig();
        ModSounds.register();
        PayloadTypeRegistry.playC2S().register(RewardPayload.ID, RewardPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(OpenMinigamePayload.ID, OpenMinigamePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenMinigamePayload.ID, OpenMinigamePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpotUpdatePayload.ID, SpotUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(AdvancementPayload.ID, AdvancementPayload.CODEC);
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 100 != 0) {
                return;
            }
            long now = System.currentTimeMillis();
            activeSpots.entrySet().removeIf(entry -> {
                if (now > (Long)entry.getValue()) {
                    class_2338 pos = (class_2338)entry.getKey();
                    for (class_3218 world : server.method_3738()) {
                        this.sendSpotUpdateToNearby(world, pos, false);
                    }
                    return true;
                }
                return false;
            });
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.field_9236 || world.method_18456().isEmpty()) {
                return;
            }
            long worldTime = world.method_8510();
            for (class_3222 player : world.method_18456()) {
                long playerOffset = Math.abs(player.method_5667().getLeastSignificantBits() % 20L);
                if (worldTime % 20L != playerOffset || !(random.nextFloat() < Pickaxeminigame.CONFIG.spawnChancePerTick * 20.0f)) continue;
                this.spawnSpotNearPlayer(world, player);
            }
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, be) -> {
            if (!world.field_9236 && activeSpots.containsKey(pos)) {
                activeSpots.remove(pos);
                this.sendSpotUpdateToNearby((class_3218)world, pos, false);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(RewardPayload.ID, (payload, context) -> context.server().execute(() -> {
            for (class_1799 stack : payload.stacks()) {
                context.player().method_31548().method_7394(stack);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(AdvancementPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            try {
                AdvancementTrigger trigger = AdvancementTrigger.valueOf(payload.trigger());
                switch (trigger.ordinal()) {
                    case 0: {
                        MiningGrid.GridSize gridSize = MiningGrid.GridSize.NORMAL;
                        try {
                            if (!payload.extraData().isEmpty()) {
                                gridSize = MiningGrid.GridSize.valueOf(payload.extraData());
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        ModAdvancements.onSpotOpened(player, gridSize);
                        break;
                    }
                    case 1: {
                        ModAdvancements.onScreenCleared(player);
                        break;
                    }
                    case 2: {
                        ModAdvancements.onRareItemFound(player);
                        break;
                    }
                    case 3: {
                        ModAdvancements.grant(player, ModAdvancements.ROOT);
                        ModAdvancements.grant(player, ModAdvancements.LARGE_DISCOVERY);
                        break;
                    }
                    case 4: {
                        ModAdvancements.grant(player, ModAdvancements.ROOT);
                        ModAdvancements.grant(player, ModAdvancements.LARGE_DISCOVERY);
                        ModAdvancements.grant(player, ModAdvancements.HUGE_DISCOVERY);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(OpenMinigamePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_2680 state;
            MiningType type;
            class_2338 pos = payload.pos();
            class_3222 player = context.player();
            SpotData data = activeSpotData.get(pos);
            if (data != null) {
                long playerCooldown;
                long now = System.currentTimeMillis();
                if (now < (playerCooldown = data.playerCooldowns.getOrDefault(player.method_5667(), 0L).longValue())) {
                    long remaining = (playerCooldown - now) / 1000L;
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cCooldown: " + remaining + "s")), true);
                    return;
                }
                if (!data.infinite) {
                    activeSpotData.remove(pos);
                    this.sendSpotUpdateToNearby((class_3218)player.method_37908(), pos, false);
                } else if (data.cooldownSeconds > 0) {
                    data.playerCooldowns.put(player.method_5667(), now + (long)data.cooldownSeconds * 1000L);
                }
                ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenMinigamePayload(data.type.name(), pos));
            } else if (activeSpots.containsKey(pos) && (type = MiningType.fromBlockState(state = player.method_37908().method_8320(pos))) != null) {
                activeSpots.remove(pos);
                this.sendSpotUpdateToNearby((class_3218)player.method_37908(), pos, false);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenMinigamePayload(type.name(), pos));
            }
        }));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mining").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"transform").then(class_2170.method_9244((String)"mining_type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (MiningType t : MiningType.values()) {
                builder.suggest(t.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(this::executeTransformCommand)))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"miningsimulation").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
                for (MiningType t : MiningType.values()) {
                    b.suggest(t.name().toLowerCase());
                }
                return b.buildFuture();
            }).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::executeSimulation)))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mining").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"open").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
                for (MiningType t : MiningType.values()) {
                    b.suggest(t.name().toLowerCase());
                }
                return b.buildFuture();
            }).executes(context -> {
                class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
                MiningType type = MiningType.valueOf(StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase());
                ServerPlayNetworking.send((class_3222)target, (class_8710)new OpenMinigamePayload(type.name(), target.method_24515()));
                return 1;
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"gridSize", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
                for (MiningGrid.GridSize gs : MiningGrid.GridSize.values()) {
                    b.suggest(gs.name().toLowerCase());
                }
                return b.buildFuture();
            }).executes(context -> {
                class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
                MiningType type = MiningType.valueOf(StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase());
                String gridSize = StringArgumentType.getString((CommandContext)context, (String)"gridSize").toUpperCase();
                ServerPlayNetworking.send((class_3222)target, (class_8710)new OpenMinigamePayload(type.name(), target.method_24515(), gridSize, false));
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aOpened " + gridSize + " grid for " + target.method_5477().getString())), false);
                return 1;
            })).then(class_2170.method_9244((String)"superStable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
                class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
                MiningType type = MiningType.valueOf(StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase());
                String gridSize = StringArgumentType.getString((CommandContext)context, (String)"gridSize").toUpperCase();
                boolean superStable = BoolArgumentType.getBool((CommandContext)context, (String)"superStable");
                ServerPlayNetworking.send((class_3222)target, (class_8710)new OpenMinigamePayload(type.name(), target.method_24515(), gridSize, superStable));
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aOpened " + gridSize + (superStable ? " SUPER STABLE" : "") + " grid for " + target.method_5477().getString())), false);
                return 1;
            }))))))).then(class_2170.method_9247((String)"transform").then(class_2170.method_9244((String)"mining_type", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"infinite", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"cooldown", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::executeTransformCommandExtended)))))).then(class_2170.method_9247((String)"book").executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                MiningConfig.TreasureEntry.setEnchantmentRegistry((class_2378<class_1887>)((class_2168)context.getSource()).method_9225().method_30349().method_30530(class_7924.field_41265));
                MiningConfig.TreasureEntry bookEntry = new MiningConfig.TreasureEntry("minecraft:enchanted_book", 1, 1, 1, 1, 1, true);
                class_1799 book = bookEntry.createStack();
                player.method_31548().method_7394(book);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aGave random enchanted book"), false);
                return 1;
            })));
        });
    }

    private void spawnSpotNearPlayer(class_3218 world, class_3222 player) {
        class_2338 playerPos = player.method_24515();
        int radius = Pickaxeminigame.CONFIG.spawnRadius;
        long count = activeSpots.keySet().stream().filter(p -> p.method_10262((class_2382)playerPos) < (double)(radius * radius)).count();
        if (count >= (long)Pickaxeminigame.CONFIG.maxSpotsPerPlayer) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            class_2680 state;
            int dz;
            int dy;
            int dx = random.nextInt(radius * 2) - radius;
            class_2338 targetPos = playerPos.method_10069(dx, dy = random.nextInt(Math.min(radius, 10)) - 5, dz = random.nextInt(radius * 2) - radius);
            if (activeSpots.containsKey(targetPos) || MiningType.fromBlockState(state = world.method_8320(targetPos)) == null) continue;
            boolean touchesExposedFace = false;
            for (class_2350 dir : class_2350.values()) {
                class_2680 neighborState = world.method_8320(targetPos.method_10093(dir));
                if (!neighborState.method_26215() && !neighborState.method_26227().method_15771()) continue;
                touchesExposedFace = true;
                break;
            }
            if (!touchesExposedFace) continue;
            activeSpots.put(targetPos, System.currentTimeMillis() + (long)Pickaxeminigame.CONFIG.spotTimeoutSeconds * 1000L);
            this.sendSpotUpdateToNearby(world, targetPos, true);
            break;
        }
    }

    private void sendSpotUpdateToNearby(class_3218 world, class_2338 pos, boolean add) {
        SpotUpdatePayload payload = new SpotUpdatePayload(pos, add);
        for (class_3222 player : world.method_18456()) {
            if (!player.method_24515().method_19771((class_2382)pos, 64.0)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    private int executeTransformCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        MiningType type;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String typeStr = StringArgumentType.getString(context, (String)"mining_type");
        try {
            type = MiningType.valueOf(typeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        class_239 hit = player.method_5745(5.0, 0.0f, false);
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hit).method_17777();
            player.method_37908().method_8501(pos, this.getRepresentativeBlockForType(type).method_9564());
            activeSpots.put(pos, System.currentTimeMillis() + (long)Pickaxeminigame.CONFIG.spotTimeoutSeconds * 1000L);
            this.sendSpotUpdateToNearby((class_3218)player.method_37908(), pos, true);
            return 1;
        }
        return 0;
    }

    private void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "pickaxeminigame.json");
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (MiningConfig)GSON.fromJson((Reader)reader, MiningConfig.class);
            }
            catch (Exception e) {
                CONFIG = MiningConfig.createDefault();
            }
        } else {
            CONFIG = MiningConfig.createDefault();
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class_2248 getRepresentativeBlockForType(MiningType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MiningType.STONE -> class_2246.field_10340;
            case MiningType.DEEPSLATE -> class_2246.field_28888;
            case MiningType.NETHERRACK -> class_2246.field_10515;
            case MiningType.DIRT -> class_2246.field_10253;
            case MiningType.SAND -> class_2246.field_9979;
            case MiningType.END -> class_2246.field_10471;
        };
    }

    private int executeSimulation(CommandContext<class_2168> context) {
        String typeStr = StringArgumentType.getString(context, (String)"type");
        int height = IntegerArgumentType.getInteger(context, (String)"height");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        MiningType type = MiningType.valueOf(typeStr.toUpperCase());
        class_2338 mockPos = new class_2338(0, height, 0);
        HashMap<class_1792, Integer> totalResults = new HashMap<class_1792, Integer>();
        for (int i = 0; i < amount; ++i) {
            MiningGrid grid = new MiningGrid(type, mockPos);
            grid.getTreasures().forEach(t -> totalResults.merge(t.item, t.yieldAmount, Integer::sum));
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76Simulation results for " + amount + " rounds at Y=" + height + ":")), false);
        totalResults.forEach((item, count) -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77- " + item.method_7848().getString() + ": \u00a7e" + count)), false));
        return 1;
    }

    private int executeTransformCommandExtended(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        MiningType type = MiningType.valueOf(StringArgumentType.getString(context, (String)"mining_type").toUpperCase());
        boolean infinite = BoolArgumentType.getBool(context, (String)"infinite");
        int cooldown = IntegerArgumentType.getInteger(context, (String)"cooldown");
        class_239 hit = player.method_5745(5.0, 0.0f, false);
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hit).method_17777();
            player.method_37908().method_8501(pos, this.getRepresentativeBlockForType(type).method_9564());
            activeSpotData.put(pos, new SpotData(type, System.currentTimeMillis() + (long)Pickaxeminigame.CONFIG.spotTimeoutSeconds * 1000L, infinite, cooldown));
            this.sendSpotUpdateToNearby((class_3218)player.method_37908(), pos, true);
            return 1;
        }
        return 0;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        random = new Random();
        activeSpotData = new ConcurrentHashMap<class_2338, SpotData>();
        activeSpots = new ConcurrentHashMap<class_2338, Long>();
    }

    public record RewardPayload(List<class_1799> stacks) implements class_8710
    {
        public static final class_8710.class_9154<RewardPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pickaxeminigame", (String)"reward"));
        public static final class_9139<class_9129, RewardPayload> CODEC = class_9139.method_56434((class_9139)class_1799.field_48349.method_56433(class_9135.method_56363()), RewardPayload::stacks, RewardPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record OpenMinigamePayload(String typeName, class_2338 pos, String forcedGridSize, boolean forcedSuperStable) implements class_8710
    {
        public static final class_8710.class_9154<OpenMinigamePayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pickaxeminigame", (String)"open_screen"));
        public static final class_9139<class_9129, OpenMinigamePayload> CODEC = class_9139.method_56905((class_9139)class_9135.field_48554, OpenMinigamePayload::typeName, (class_9139)class_2338.field_48404, OpenMinigamePayload::pos, (class_9139)class_9135.field_48554, OpenMinigamePayload::forcedGridSize, (class_9139)class_9135.field_48547, OpenMinigamePayload::forcedSuperStable, OpenMinigamePayload::new);

        public OpenMinigamePayload(String typeName, class_2338 pos) {
            this(typeName, pos, "", false);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record SpotUpdatePayload(class_2338 pos, boolean add) implements class_8710
    {
        public static final class_8710.class_9154<SpotUpdatePayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pickaxeminigame", (String)"spot_update"));
        public static final class_9139<class_9129, SpotUpdatePayload> CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, SpotUpdatePayload::pos, (class_9139)class_9135.field_48547, SpotUpdatePayload::add, SpotUpdatePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record AdvancementPayload(String trigger, String extraData) implements class_8710
    {
        public static final class_8710.class_9154<AdvancementPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pickaxeminigame", (String)"advancement"));
        public static final class_9139<class_9129, AdvancementPayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, AdvancementPayload::trigger, (class_9139)class_9135.field_48554, AdvancementPayload::extraData, AdvancementPayload::new);

        public AdvancementPayload(AdvancementTrigger trigger) {
            this(trigger.name(), "");
        }

        public AdvancementPayload(AdvancementTrigger trigger, String extraData) {
            this(trigger.name(), extraData);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public static class SpotData {
        public MiningType type;
        public long expiry;
        public boolean infinite;
        public int cooldownSeconds;
        public Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();

        public SpotData(MiningType type, long expiry, boolean infinite, int cooldown) {
            this.type = type;
            this.expiry = expiry;
            this.infinite = infinite;
            this.cooldownSeconds = cooldown;
        }
    }

    public static enum AdvancementTrigger {
        SPOT_OPENED,
        SCREEN_CLEARED,
        RARE_ITEM_FOUND,
        LARGE_SPOT,
        HUGE_SPOT;

    }
}

