/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame;

import handyfon.pickaxeminigame.MiningGrid;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_167;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8779;

public class ModAdvancements {
    public static final String MOD_ID = "pickaxeminigame";
    public static final class_2960 ROOT = class_2960.method_60655((String)"pickaxeminigame", (String)"root");
    public static final class_2960 FIRST_COMPLETE = class_2960.method_60655((String)"pickaxeminigame", (String)"first_complete");
    public static final class_2960 DOUBLE_CLEAR = class_2960.method_60655((String)"pickaxeminigame", (String)"double_clear");
    public static final class_2960 RARE_DISCOVERY = class_2960.method_60655((String)"pickaxeminigame", (String)"rare_discovery");
    public static final class_2960 DEDICATED_MINER = class_2960.method_60655((String)"pickaxeminigame", (String)"dedicated_miner");
    public static final class_2960 MASTER_MINER = class_2960.method_60655((String)"pickaxeminigame", (String)"master_miner");
    public static final class_2960 LARGE_DISCOVERY = class_2960.method_60655((String)"pickaxeminigame", (String)"large_discovery");
    public static final class_2960 HUGE_DISCOVERY = class_2960.method_60655((String)"pickaxeminigame", (String)"huge_discovery");
    private static final Map<UUID, PlayerMiningStats> playerStats = new ConcurrentHashMap<UUID, PlayerMiningStats>();

    public static PlayerMiningStats getStats(UUID playerId) {
        return playerStats.computeIfAbsent(playerId, k -> new PlayerMiningStats());
    }

    public static void grant(class_3222 player, class_2960 advancementId) {
        if (player == null || player.method_5682() == null) {
            return;
        }
        class_8779 advancementEntry = player.method_5682().method_3851().method_12896(advancementId);
        if (advancementEntry == null) {
            return;
        }
        class_167 progress = player.method_14236().method_12882(advancementEntry);
        if (progress.method_740()) {
            return;
        }
        for (String criterion : progress.method_731()) {
            player.method_14236().method_12878(advancementEntry, criterion);
        }
    }

    public static boolean has(class_3222 player, class_2960 advancementId) {
        if (player == null || player.method_5682() == null) {
            return false;
        }
        class_8779 advancementEntry = player.method_5682().method_3851().method_12896(advancementId);
        if (advancementEntry == null) {
            return false;
        }
        return player.method_14236().method_12882(advancementEntry).method_740();
    }

    public static void onSpotOpened(class_3222 player, MiningGrid.GridSize gridSize) {
        ModAdvancements.grant(player, ROOT);
        if (gridSize == MiningGrid.GridSize.VERY_LARGE) {
            ModAdvancements.grant(player, LARGE_DISCOVERY);
        } else if (gridSize == MiningGrid.GridSize.HUGE) {
            ModAdvancements.grant(player, LARGE_DISCOVERY);
            ModAdvancements.grant(player, HUGE_DISCOVERY);
        }
        ModAdvancements.getStats(player.method_5667()).resetScreensCleared();
    }

    public static void onScreenCleared(class_3222 player) {
        PlayerMiningStats stats = ModAdvancements.getStats(player.method_5667());
        ++stats.screensCleared;
        ++stats.spotsCompleted;
        ModAdvancements.grant(player, FIRST_COMPLETE);
        if (stats.screensCleared >= 2) {
            ModAdvancements.grant(player, DOUBLE_CLEAR);
        }
        if (stats.spotsCompleted >= 50) {
            ModAdvancements.grant(player, DEDICATED_MINER);
        }
        if (stats.spotsCompleted >= 100) {
            ModAdvancements.grant(player, MASTER_MINER);
        }
    }

    public static void onRareItemFound(class_3222 player) {
        ModAdvancements.grant(player, RARE_DISCOVERY);
    }

    public static class PlayerMiningStats {
        public int spotsCompleted = 0;
        public int screensCleared = 0;

        public void resetScreensCleared() {
            this.screensCleared = 0;
        }
    }
}

