/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame;

import handyfon.pickaxeminigame.MiningConfig;
import handyfon.pickaxeminigame.MiningType;
import handyfon.pickaxeminigame.Pickaxeminigame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public class MiningGrid {
    private final float effectiveRarityModifier;
    public static final int STONE_LAYER_HEALTH = 3;
    public static final int DIRT_LAYER_HEALTH = 2;
    public static final int BEDROCK_STABILITY_PENALTY = 2;
    private int width;
    private int height;
    private int[][] stoneHealth;
    private int[][] dirtHealth;
    private class_1792[][] hiddenItems;
    private boolean[][] hasBedrock;
    private final MiningType type;
    private final Set<HiddenTreasure> collectedTreasures = new HashSet<HiddenTreasure>();
    private final List<HiddenTreasure> treasures = new ArrayList<HiddenTreasure>();
    private final List<class_1799> collectedItemStacks = new ArrayList<class_1799>();
    private final Random random = new Random();
    private int stabilityRemaining;
    private int maxStability;
    private boolean gameOver;
    private boolean won;
    private Tool currentTool = Tool.STONE_PICKAXE;
    private GridSize currentGridSize = GridSize.NORMAL;
    private boolean isSuperStable = false;
    private GridSize forcedGridSize = null;
    private Boolean forcedSuperStable = null;
    public HitFeedback lastHitFeedback = HitFeedback.NONE;

    public MiningGrid(MiningType type, class_2338 pos) {
        this(type, pos, null, null);
    }

    public MiningGrid(MiningType type, class_2338 pos, String forcedGridSizeStr, Boolean forcedSuperStable) {
        this.type = type;
        this.effectiveRarityModifier = this.calculateEffectiveModifier(type, pos);
        if (forcedGridSizeStr != null && !forcedGridSizeStr.isEmpty()) {
            try {
                this.forcedGridSize = GridSize.valueOf(forcedGridSizeStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.forcedSuperStable = forcedSuperStable;
        this.initNewGame();
    }

    public void initNewGame() {
        MiningConfig config = Pickaxeminigame.CONFIG;
        if (this.forcedGridSize != null) {
            this.currentGridSize = this.forcedGridSize;
            switch (this.forcedGridSize.ordinal()) {
                case 3: {
                    this.width = 20 + this.random.nextInt(3);
                    this.height = 13 + this.random.nextInt(2);
                    break;
                }
                case 2: {
                    this.width = 17 + this.random.nextInt(3);
                    this.height = 11 + this.random.nextInt(2);
                    break;
                }
                case 1: {
                    this.width = 14 + this.random.nextInt(3);
                    this.height = 9 + this.random.nextInt(2);
                    break;
                }
                default: {
                    this.width = 10 + this.random.nextInt(4);
                    this.height = 6 + this.random.nextInt(3);
                    break;
                }
            }
        } else {
            float sizeRoll = this.random.nextFloat();
            float hugeThreshold = config.hugeGridChance;
            float veryLargeThreshold = hugeThreshold + config.veryLargeGridChance;
            float largeThreshold = veryLargeThreshold + config.largeGridChance;
            if (sizeRoll < hugeThreshold) {
                this.currentGridSize = GridSize.HUGE;
                this.width = 20 + this.random.nextInt(3);
                this.height = 13 + this.random.nextInt(2);
            } else if (sizeRoll < veryLargeThreshold) {
                this.currentGridSize = GridSize.VERY_LARGE;
                this.width = 17 + this.random.nextInt(3);
                this.height = 11 + this.random.nextInt(2);
            } else if (sizeRoll < largeThreshold) {
                this.currentGridSize = GridSize.LARGE;
                this.width = 14 + this.random.nextInt(3);
                this.height = 9 + this.random.nextInt(2);
            } else {
                this.currentGridSize = GridSize.NORMAL;
                this.width = 10 + this.random.nextInt(4);
                this.height = 6 + this.random.nextInt(3);
            }
        }
        this.isSuperStable = this.forcedSuperStable != null ? this.forcedSuperStable : this.random.nextFloat() < config.superStableChance;
        float multiplier = config.stabilityMultiplier;
        int baseStability = 60 + this.random.nextInt(25);
        float sizeMultiplier = (float)(this.width * this.height) / 80.0f;
        baseStability = (int)((float)baseStability * Math.max(1.0f, sizeMultiplier));
        if (this.isSuperStable) {
            baseStability = (int)((float)baseStability * config.superStableBonus);
        }
        this.stabilityRemaining = this.maxStability = (int)((float)baseStability * multiplier);
        this.generateLevel();
    }

    public void startNextLevel() {
        this.stabilityRemaining = Math.min(this.maxStability, this.stabilityRemaining + 45);
        this.generateLevel();
    }

    public int getTotalTreasureCount() {
        return this.treasures.size();
    }

    public int getFoundTreasureCount() {
        return this.collectedTreasures.size();
    }

    private void generateLevel() {
        this.stoneHealth = new int[this.height][this.width];
        this.dirtHealth = new int[this.height][this.width];
        this.hiddenItems = new class_1792[this.height][this.width];
        this.hasBedrock = new boolean[this.height][this.width];
        this.gameOver = false;
        this.won = false;
        this.collectedItemStacks.clear();
        this.collectedTreasures.clear();
        this.treasures.clear();
        float multiLayerChance = 0.2f;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.stoneHealth[y][x] = this.random.nextFloat() < multiLayerChance ? 6 : 3;
            }
        }
        this.generateDirtLayerWithNoise();
        int area = this.width * this.height;
        int baseItems = 2 + this.random.nextInt(Math.max(1, area / 15));
        int targetItems = (int)Math.max(3.0f, (float)baseItems * this.effectiveRarityModifier);
        for (int attempts = 0; this.treasures.size() < targetItems && attempts < 150; ++attempts) {
            this.placeTreasureFromConfig();
        }
        this.placeBedrockBlocks();
    }

    private void generateDirtLayerWithNoise() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.dirtHealth[y][x] = 2;
            }
        }
    }

    private void placeBedrockBlocks() {
        int area = this.width * this.height;
        int bedrockCount = Math.max(2, area / 15 + this.random.nextInt(area / 20 + 1));
        for (int i = 0; i < bedrockCount; ++i) {
            this.placeSingleBedrock();
        }
    }

    private void placeSingleBedrock() {
        for (int attempt = 0; attempt < 50; ++attempt) {
            int x = this.random.nextInt(this.width);
            int y = this.random.nextInt(this.height);
            if (this.hiddenItems[y][x] != null || this.hasBedrock[y][x]) continue;
            this.hasBedrock[y][x] = true;
            return;
        }
    }

    private void placeTreasureFromConfig() {
        List<MiningConfig.TreasureEntry> validEntries = Pickaxeminigame.CONFIG.possibleTreasures.stream().filter(MiningConfig.TreasureEntry::isValid).toList();
        if (validEntries.isEmpty()) {
            return;
        }
        float totalRarityMod = this.effectiveRarityModifier * this.currentGridSize.getRarityBonus();
        double totalWeight = 0.0;
        for (MiningConfig.TreasureEntry e : validEntries) {
            totalWeight += Math.pow(1.0 / (double)e.rarity, 1.0 / (double)totalRarityMod);
        }
        double randomValue = this.random.nextDouble() * totalWeight;
        MiningConfig.TreasureEntry selectedEntry = validEntries.get(0);
        for (MiningConfig.TreasureEntry e : validEntries) {
            if (!((randomValue -= Math.pow(1.0 / (double)e.rarity, 1.0 / (double)totalRarityMod)) <= 0.0)) continue;
            selectedEntry = e;
            break;
        }
        class_1799 itemStack = selectedEntry.createStack();
        class_1792 item = itemStack.method_7909();
        int w = selectedEntry.width;
        int h = selectedEntry.height;
        for (int i = 0; i < 50; ++i) {
            int startY;
            int startX = this.random.nextInt(Math.max(1, this.width - w + 1));
            if (!this.canPlaceTreasure(startX, startY = this.random.nextInt(Math.max(1, this.height - h + 1)), w, h)) continue;
            int amount = selectedEntry.minYield + this.random.nextInt(selectedEntry.maxYield - selectedEntry.minYield + 1);
            HiddenTreasure t = new HiddenTreasure(item, itemStack, startX, startY, w, h, amount);
            this.treasures.add(t);
            for (int dy = 0; dy < h; ++dy) {
                for (int dx = 0; dx < w; ++dx) {
                    this.hiddenItems[startY + dy][startX + dx] = item;
                    this.hasBedrock[startY + dy][startX + dx] = false;
                    this.dirtHealth[startY + dy][startX + dx] = 2;
                }
            }
            return;
        }
    }

    private boolean canPlaceTreasure(int x, int y, int w, int h) {
        if (x + w > this.width || y + h > this.height) {
            return false;
        }
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                if (this.hiddenItems[y + dy][x + dx] == null) continue;
                return false;
            }
        }
        return true;
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public void setTool(Tool tool) {
        this.currentTool = tool;
    }

    public void cycleTool() {
        this.currentTool = Tool.values()[(this.currentTool.ordinal() + 1) % Tool.values().length];
    }

    public int[][] getToolOffsetsWithDamage() {
        if (this.currentTool.size == 1) {
            return new int[][]{{0, 0, 2, 2}, {-1, 0, 1, 1}, {1, 0, 1, 1}, {0, -1, 1, 1}, {0, 1, 1, 1}};
        }
        return new int[][]{{-1, -1, 1, 1}, {0, -1, 1, 1}, {1, -1, 1, 1}, {-1, 0, 1, 1}, {0, 0, 1, 1}, {1, 0, 1, 1}, {-1, 1, 1, 1}, {0, 1, 1, 1}, {1, 1, 1, 1}};
    }

    public int[][] getToolOffsets() {
        int[][] withDamage = this.getToolOffsetsWithDamage();
        int[][] offsets = new int[withDamage.length][2];
        for (int i = 0; i < withDamage.length; ++i) {
            offsets[i][0] = withDamage[i][0];
            offsets[i][1] = withDamage[i][1];
        }
        return offsets;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStoneHealth(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height ? this.stoneHealth[y][x] : 0;
    }

    public int getDirtHealth(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height ? this.dirtHealth[y][x] : 0;
    }

    public boolean hasBedrock(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height && this.hasBedrock[y][x];
    }

    public int getStabilityRemaining() {
        return this.stabilityRemaining;
    }

    public int getMaxStability() {
        return this.maxStability;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public boolean hasWon() {
        return this.won;
    }

    public List<class_1799> getCollectedItemStacks() {
        return Collections.unmodifiableList(this.collectedItemStacks);
    }

    @Deprecated
    public Map<class_1792, Integer> getCollectedItems() {
        HashMap<class_1792, Integer> legacy = new HashMap<class_1792, Integer>();
        for (class_1799 stack : this.collectedItemStacks) {
            legacy.merge(stack.method_7909(), stack.method_7947(), Integer::sum);
        }
        return legacy;
    }

    public List<HiddenTreasure> getTreasures() {
        return this.treasures;
    }

    public boolean isValidTile(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public GridSize getGridSize() {
        return this.currentGridSize;
    }

    public boolean isSuperStable() {
        return this.isSuperStable;
    }

    public boolean hitTile(int cx, int cy) {
        if (!this.isValidTile(cx, cy) || this.gameOver) {
            return false;
        }
        this.lastHitFeedback = HitFeedback.NONE;
        boolean anyHit = false;
        boolean hitBedrock = false;
        for (int[] off : this.getToolOffsetsWithDamage()) {
            int nx = cx + off[0];
            int ny = cy + off[1];
            int stoneDamage = off[2];
            int dirtDamage = off[3];
            if (!this.isValidTile(nx, ny)) continue;
            if (this.hasBedrock[ny][nx] && this.stoneHealth[ny][nx] == 0 && this.dirtHealth[ny][nx] == 0) {
                if (this.lastHitFeedback != HitFeedback.REVEAL_ITEM) {
                    this.lastHitFeedback = HitFeedback.BEDROCK;
                }
                anyHit = true;
                hitBedrock = true;
                continue;
            }
            if (this.stoneHealth[ny][nx] > 0) {
                this.stoneHealth[ny][nx] = Math.max(0, this.stoneHealth[ny][nx] - stoneDamage);
                anyHit = true;
                if (this.stoneHealth[ny][nx] == 0 && this.dirtHealth[ny][nx] == 0 && this.hiddenItems[ny][nx] != null) {
                    this.lastHitFeedback = HitFeedback.REVEAL_ITEM;
                    continue;
                }
                if (this.lastHitFeedback != HitFeedback.NONE && this.lastHitFeedback != HitFeedback.DIRT) continue;
                this.lastHitFeedback = HitFeedback.STONE;
                continue;
            }
            if (this.dirtHealth[ny][nx] <= 0) continue;
            this.dirtHealth[ny][nx] = Math.max(0, this.dirtHealth[ny][nx] - dirtDamage);
            anyHit = true;
            if (this.dirtHealth[ny][nx] == 0 && this.hiddenItems[ny][nx] != null) {
                this.lastHitFeedback = HitFeedback.REVEAL_ITEM;
                continue;
            }
            if (this.lastHitFeedback != HitFeedback.NONE) continue;
            this.lastHitFeedback = HitFeedback.DIRT;
        }
        if (anyHit) {
            this.stabilityRemaining -= this.currentTool.stabilityCost;
        }
        if (hitBedrock) {
            this.stabilityRemaining -= 2;
        }
        if (this.isAllTreasuresRevealed()) {
            this.gameOver = true;
            this.won = true;
        } else if (this.stabilityRemaining <= 0) {
            this.gameOver = true;
            this.won = false;
        }
        return anyHit;
    }

    public boolean checkAndCollectTreasures() {
        boolean newCol = false;
        for (HiddenTreasure t : this.treasures) {
            if (this.collectedTreasures.contains(t) || !this.isTreasureFullyRevealed(t)) continue;
            this.collectedTreasures.add(t);
            class_1799 stack = t.itemStack.method_7972();
            stack.method_7939(t.yieldAmount);
            this.collectedItemStacks.add(stack);
            newCol = true;
        }
        return newCol;
    }

    private boolean isAllTreasuresRevealed() {
        for (HiddenTreasure t : this.treasures) {
            if (this.isTreasureFullyRevealed(t)) continue;
            return false;
        }
        return true;
    }

    public boolean isTreasureFullyRevealed(HiddenTreasure t) {
        for (int dy = 0; dy < t.height; ++dy) {
            for (int dx = 0; dx < t.width; ++dx) {
                if (this.stoneHealth[t.y + dy][t.x + dx] <= 0 && this.dirtHealth[t.y + dy][t.x + dx] <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private float calculateEffectiveModifier(MiningType type, class_2338 pos) {
        float mod = type.rarityModifier;
        if (type == MiningType.STONE || type == MiningType.DEEPSLATE) {
            if (pos.method_10264() < 10) {
                mod += 0.5f;
            } else if (pos.method_10264() > 64) {
                float heightFactor = Math.max(0.0f, (float)(pos.method_10264() - 64) / 128.0f);
                mod -= Math.max(0.3f, heightFactor);
            }
        }
        return mod;
    }

    public static enum Tool {
        STONE_PICKAXE(1, 1),
        DIAMOND_PICKAXE(3, 3);

        public final int size;
        public final int stabilityCost;

        private Tool(int size, int cost) {
            this.size = size;
            this.stabilityCost = cost;
        }
    }

    public static enum GridSize {
        NORMAL(""),
        LARGE("Large"),
        VERY_LARGE("Very Large"),
        HUGE("Huge");

        public final String displayName;

        private GridSize(String displayName) {
            this.displayName = displayName;
        }

        public float getRarityBonus() {
            MiningConfig config = Pickaxeminigame.CONFIG;
            return switch (this.ordinal()) {
                case 3 -> config.hugeGridRarityBonus;
                case 2 -> config.veryLargeGridRarityBonus;
                case 1 -> config.largeGridRarityBonus;
                default -> 1.0f;
            };
        }
    }

    public static enum HitFeedback {
        NONE,
        DIRT,
        STONE,
        BEDROCK,
        REVEAL_ITEM;

    }

    public static class HiddenTreasure {
        public final class_1792 item;
        public final class_1799 itemStack;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final int yieldAmount;

        public HiddenTreasure(class_1792 item, class_1799 itemStack, int x, int y, int width, int height, int yieldAmount) {
            this.item = item;
            this.itemStack = itemStack;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.yieldAmount = yieldAmount;
        }
    }
}

