/*
 * Decompiled with CFR 0.152.
 */
package handyfon.pickaxeminigame;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class MiningConfig {
    public float stabilityMultiplier = 1.0f;
    public int maxSpotsPerPlayer = 2;
    public int spotTimeoutSeconds = 180;
    public int spawnRadius = 30;
    public float spawnChancePerTick = 0.1f;
    public float superStableChance = 0.05f;
    public float superStableBonus = 1.5f;
    public float hugeGridChance = 0.01f;
    public float veryLargeGridChance = 0.05f;
    public float largeGridChance = 0.1f;
    public float hugeGridRarityBonus = 2.0f;
    public float veryLargeGridRarityBonus = 1.6f;
    public float largeGridRarityBonus = 1.3f;
    public List<TreasureEntry> possibleTreasures = new ArrayList<TreasureEntry>();
    public static final Map<String, int[]> CURATED_ENCHANTMENTS = new LinkedHashMap<String, int[]>();

    public static MiningConfig createDefault() {
        String[] fossils;
        String[] plates;
        String[] stones;
        String[] teraTypes;
        String[] sherds;
        String[] templates;
        MiningConfig config = new MiningConfig();
        config.stabilityMultiplier = 1.0f;
        List<TreasureEntry> t = config.possibleTreasures;
        t.add(new TreasureEntry("minecraft:coal", 2, 2, 4, 12, 1));
        t.add(new TreasureEntry("minecraft:raw_iron", 2, 2, 3, 8, 2));
        t.add(new TreasureEntry("minecraft:raw_gold", 2, 2, 2, 6, 4));
        t.add(new TreasureEntry("minecraft:raw_copper", 2, 2, 4, 10, 2));
        t.add(new TreasureEntry("minecraft:redstone", 2, 2, 6, 16, 3));
        t.add(new TreasureEntry("minecraft:lapis_lazuli", 1, 1, 4, 12, 5));
        t.add(new TreasureEntry("minecraft:diamond", 2, 2, 1, 2, 15));
        t.add(new TreasureEntry("minecraft:emerald", 2, 2, 1, 3, 12));
        t.add(new TreasureEntry("minecraft:amethyst_shard", 2, 2, 2, 6, 10));
        t.add(new TreasureEntry("minecraft:ender_pearl", 2, 2, 2, 6, 10));
        t.add(new TreasureEntry("minecraft:quartz", 2, 2, 4, 12, 4));
        t.add(new TreasureEntry("minecraft:elytra", 4, 4, 1, 1, 2000));
        t.add(new TreasureEntry("minecraft:heavy_core", 3, 3, 1, 1, 500));
        t.add(new TreasureEntry("minecraft:trident", 2, 3, 1, 1, 450));
        t.add(new TreasureEntry("minecraft:nether_star", 3, 3, 1, 1, 800));
        t.add(new TreasureEntry("minecraft:ominous_bottle", 1, 2, 1, 1, 100));
        t.add(new TreasureEntry("minecraft:mace", 2, 3, 1, 1, 1000));
        t.add(new TreasureEntry("minecraft:shulker_shell", 2, 2, 1, 2, 120));
        t.add(new TreasureEntry("minecraft:dragon_breath", 1, 2, 1, 3, 150));
        t.add(new TreasureEntry("minecraft:golden_apple", 3, 3, 1, 1, 100));
        t.add(new TreasureEntry("minecraft:golden_carrot", 3, 3, 1, 1, 100));
        t.add(new TreasureEntry("minecraft:enchanted_golden_apple", 3, 3, 1, 1, 600));
        t.add(new TreasureEntry("minecraft:totem_of_undying", 2, 3, 1, 1, 400));
        t.add(new TreasureEntry("minecraft:netherite_scrap", 3, 3, 1, 2, 250));
        t.add(new TreasureEntry("minecraft:ancient_debris", 3, 3, 1, 1, 250));
        t.add(new TreasureEntry("minecraft:wither_skull", 3, 3, 1, 1, 650));
        t.add(new TreasureEntry("minecraft:ghast_tear", 2, 2, 1, 1, 650));
        t.add(new TreasureEntry("minecraft:shulker_box", 3, 3, 1, 1, 400));
        t.add(new TreasureEntry("minecraft:iron_golem_spawn_egg", 3, 3, 1, 3, 500));
        t.add(new TreasureEntry("minecraft:enchanted_book", 2, 2, 1, 1, 80, true));
        t.add(new TreasureEntry("minecraft:enchanted_book", 2, 2, 1, 1, 150, true));
        t.add(new TreasureEntry("minecraft:enchanted_book", 2, 2, 1, 1, 250, true));
        for (String s : templates = new String[]{"netherite_upgrade", "silence", "tide", "ward", "vex", "wild", "wayfinder", "raiser", "shaper", "host"}) {
            String id = "minecraft:" + (String)(s.equals("netherite_upgrade") ? s : s + "_armor_trim") + "_smithing_template";
            int rarity = s.equals("silence") ? 1000 : 350;
            t.add(new TreasureEntry(id, 2, 2, 1, 1, rarity));
        }
        t.add(new TreasureEntry("minecraft:heart_of_the_sea", 2, 2, 1, 1, 300));
        t.add(new TreasureEntry("minecraft:echo_shard", 2, 2, 1, 3, 200));
        t.add(new TreasureEntry("minecraft:music_disc_5", 2, 2, 1, 1, 400));
        t.add(new TreasureEntry("minecraft:music_disc_pigstep", 2, 2, 1, 1, 500));
        t.add(new TreasureEntry("minecraft:sniffer_egg", 2, 2, 1, 1, 700));
        for (String s : sherds = new String[]{"archer", "prize", "arms_up", "skull", "danger", "friend", "heart", "miner", "burn", "snort"}) {
            t.add(new TreasureEntry("minecraft:" + s + "_pottery_sherd", 2, 2, 1, 1, 150));
        }
        t.add(new TreasureEntry("mega_showdown:blank_mega_stone", 2, 2, 1, 1, 60));
        t.add(new TreasureEntry("mega_showdown:key_stone", 1, 2, 1, 1, 300));
        t.add(new TreasureEntry("mega_showdown:blank_z_crystal", 2, 2, 1, 1, 80));
        t.add(new TreasureEntry("mega_showdown:wishing_star", 2, 2, 1, 1, 100));
        for (String type : teraTypes = new String[]{"normal", "fire", "water", "grass", "electric", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            t.add(new TreasureEntry("mega_showdown:" + type + "_tera_shard", 2, 2, 1, 4, 40));
        }
        t.add(new TreasureEntry("mega_showdown:stellar_tera_shard", 2, 2, 1, 3, 200));
        t.add(new TreasureEntry("cobblemon:master_ball", 4, 4, 1, 1, 1500));
        t.add(new TreasureEntry("cobblemon:origin_ball", 4, 4, 1, 1, 2000));
        t.add(new TreasureEntry("cobblemon:cherish_ball", 2, 2, 1, 1, 500));
        t.add(new TreasureEntry("cobblemon:gs_ball", 2, 2, 1, 1, 600));
        for (String s : stones = new String[]{"fire", "water", "thunder", "leaf", "moon", "sun", "shiny", "dusk", "dawn", "ice"}) {
            t.add(new TreasureEntry("cobblemon:" + s + "_stone", 2, 2, 1, 2, 50));
        }
        t.add(new TreasureEntry("cobblemon:relic_crown", 3, 3, 1, 1, 600));
        t.add(new TreasureEntry("cobblemon:relic_statue", 2, 3, 1, 1, 400));
        for (String p : plates = new String[]{"pixie", "draco", "dread", "earth", "fist", "flame", "icicle", "insect", "iron", "meadow", "mind", "sky", "splash", "spooky", "stone", "toxic", "zap"}) {
            t.add(new TreasureEntry("cobblemon:" + p + "_plate", 2, 2, 1, 1, 250));
        }
        for (String f : fossils = new String[]{"helix", "dome", "old_amber", "root", "claw", "skull", "armor", "cover", "plume", "jaw", "sail"}) {
            t.add(new TreasureEntry("cobblemon:" + f + (f.equals("old_amber") ? "" : "_fossil"), 3, 3, 1, 1, 100));
        }
        return config;
    }

    static {
        CURATED_ENCHANTMENTS.put("protection", new int[]{4, 10});
        CURATED_ENCHANTMENTS.put("sharpness", new int[]{5, 10});
        CURATED_ENCHANTMENTS.put("efficiency", new int[]{5, 10});
        CURATED_ENCHANTMENTS.put("unbreaking", new int[]{3, 10});
        CURATED_ENCHANTMENTS.put("power", new int[]{5, 8});
        CURATED_ENCHANTMENTS.put("smite", new int[]{5, 6});
        CURATED_ENCHANTMENTS.put("bane_of_arthropods", new int[]{5, 4});
        CURATED_ENCHANTMENTS.put("fire_aspect", new int[]{2, 7});
        CURATED_ENCHANTMENTS.put("knockback", new int[]{2, 6});
        CURATED_ENCHANTMENTS.put("looting", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("fortune", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("feather_falling", new int[]{4, 6});
        CURATED_ENCHANTMENTS.put("blast_protection", new int[]{4, 5});
        CURATED_ENCHANTMENTS.put("projectile_protection", new int[]{4, 5});
        CURATED_ENCHANTMENTS.put("fire_protection", new int[]{4, 5});
        CURATED_ENCHANTMENTS.put("respiration", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("aqua_affinity", new int[]{1, 5});
        CURATED_ENCHANTMENTS.put("depth_strider", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("frost_walker", new int[]{2, 4});
        CURATED_ENCHANTMENTS.put("thorns", new int[]{3, 4});
        CURATED_ENCHANTMENTS.put("sweeping_edge", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("punch", new int[]{2, 5});
        CURATED_ENCHANTMENTS.put("flame", new int[]{1, 5});
        CURATED_ENCHANTMENTS.put("infinity", new int[]{1, 3});
        CURATED_ENCHANTMENTS.put("luck_of_the_sea", new int[]{3, 4});
        CURATED_ENCHANTMENTS.put("lure", new int[]{3, 4});
        CURATED_ENCHANTMENTS.put("loyalty", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("riptide", new int[]{3, 4});
        CURATED_ENCHANTMENTS.put("channeling", new int[]{1, 3});
        CURATED_ENCHANTMENTS.put("impaling", new int[]{5, 4});
        CURATED_ENCHANTMENTS.put("multishot", new int[]{1, 4});
        CURATED_ENCHANTMENTS.put("quick_charge", new int[]{3, 5});
        CURATED_ENCHANTMENTS.put("piercing", new int[]{4, 5});
        CURATED_ENCHANTMENTS.put("soul_speed", new int[]{3, 3});
        CURATED_ENCHANTMENTS.put("swift_sneak", new int[]{3, 3});
        CURATED_ENCHANTMENTS.put("mending", new int[]{1, 2});
        CURATED_ENCHANTMENTS.put("silk_touch", new int[]{1, 2});
        CURATED_ENCHANTMENTS.put("wind_burst", new int[]{3, 1});
        CURATED_ENCHANTMENTS.put("density", new int[]{5, 1});
        CURATED_ENCHANTMENTS.put("breach", new int[]{4, 1});
    }

    public static class TreasureEntry {
        public String itemId;
        public String nbtData;
        public int width;
        public int height;
        public int minYield;
        public int maxYield;
        public int rarity;
        public boolean randomEnchantment;
        private static final Random RANDOM = new Random();
        private static class_2378<class_1887> enchantmentRegistry = null;

        public TreasureEntry(String itemId, int width, int height, int minYield, int maxYield, int rarity) {
            this(itemId, null, width, height, minYield, maxYield, rarity, false);
        }

        public TreasureEntry(String itemId, String nbtData, int width, int height, int minYield, int maxYield, int rarity) {
            this(itemId, nbtData, width, height, minYield, maxYield, rarity, false);
        }

        public TreasureEntry(String itemId, int width, int height, int minYield, int maxYield, int rarity, boolean randomEnchantment) {
            this(itemId, null, width, height, minYield, maxYield, rarity, randomEnchantment);
        }

        public TreasureEntry(String itemId, String nbtData, int width, int height, int minYield, int maxYield, int rarity, boolean randomEnchantment) {
            this.itemId = itemId;
            this.nbtData = nbtData;
            this.width = width;
            this.height = height;
            this.minYield = minYield;
            this.maxYield = Math.max(minYield, maxYield);
            this.rarity = Math.max(1, rarity);
            this.randomEnchantment = randomEnchantment;
        }

        public static void setEnchantmentRegistry(class_2378<class_1887> registry) {
            enchantmentRegistry = registry;
        }

        public class_1799 createStack() {
            class_2960 id = class_2960.method_60654((String)this.itemId);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1799 stack = new class_1799((class_1935)item);
            if (this.itemId.equals("minecraft:enchanted_book")) {
                if (this.nbtData != null && !this.nbtData.isEmpty() && this.nbtData.contains("StoredEnchantments")) {
                    this.applyEnchantmentFromNbt(stack, this.nbtData);
                } else {
                    this.applyRandomEnchantment(stack);
                }
                return stack;
            }
            if (this.nbtData != null && !this.nbtData.isEmpty()) {
                try {
                    class_2487 nbt = class_2522.method_10718((String)this.nbtData);
                    class_9326 changes = (class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow()).getFirst();
                    stack.method_59692(changes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return stack;
        }

        private void applyEnchantmentFromNbt(class_1799 stack, String nbt) {
            try {
                class_2960 enchantId;
                class_5321 enchantKey;
                Optional enchantmentEntry;
                int idStart = nbt.indexOf("id:\"") + 4;
                int idEnd = nbt.indexOf("\"", idStart);
                String enchantIdStr = nbt.substring(idStart, idEnd);
                int lvlStart = nbt.indexOf("lvl:") + 4;
                int lvlEnd = nbt.indexOf("s", lvlStart);
                if (lvlEnd == -1) {
                    lvlEnd = nbt.indexOf("}", lvlStart);
                }
                int level = Integer.parseInt(nbt.substring(lvlStart, lvlEnd).trim());
                if (enchantmentRegistry != null && (enchantmentEntry = enchantmentRegistry.method_40264(enchantKey = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)(enchantId = class_2960.method_60654((String)enchantIdStr))))).isPresent()) {
                    class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
                    builder.method_57550((class_6880)enchantmentEntry.get(), level);
                    stack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
                }
            }
            catch (Exception e) {
                this.applyRandomEnchantment(stack);
            }
        }

        private void applyRandomEnchantment(class_1799 stack) {
            int totalWeight = 0;
            for (int[] data : CURATED_ENCHANTMENTS.values()) {
                totalWeight += data[1];
            }
            int roll = RANDOM.nextInt(totalWeight);
            String selectedEnchant = "unbreaking";
            int maxLevel = 3;
            for (Map.Entry<String, int[]> entry : CURATED_ENCHANTMENTS.entrySet()) {
                if ((roll -= entry.getValue()[1]) >= 0) continue;
                selectedEnchant = entry.getKey();
                maxLevel = entry.getValue()[0];
                break;
            }
            int level = 1;
            if (maxLevel > 1) {
                int levelRoll = RANDOM.nextInt(100);
                if (levelRoll < 50) {
                    level = 1;
                } else if (levelRoll < 75 && maxLevel >= 2) {
                    level = 2;
                } else if (levelRoll < 90 && maxLevel >= 3) {
                    level = 3;
                } else if (levelRoll < 97 && maxLevel >= 4) {
                    level = 4;
                } else if (maxLevel >= 5) {
                    level = 5;
                }
                level = Math.min(level, maxLevel);
            }
            System.out.println("[Pickaxeminigame] Applying enchantment: " + selectedEnchant + " level " + level);
            System.out.println("[Pickaxeminigame] Registry: " + (String)(enchantmentRegistry != null ? "SET (size=" + enchantmentRegistry.method_10204() + ")" : "NULL"));
            if (enchantmentRegistry != null) {
                class_2960 enchantId = class_2960.method_60655((String)"minecraft", (String)selectedEnchant);
                class_5321 enchantKey = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchantId);
                Optional enchantmentEntry = enchantmentRegistry.method_40264(enchantKey);
                System.out.println("[Pickaxeminigame] Looking up: " + String.valueOf(enchantKey) + " -> found: " + enchantmentEntry.isPresent());
                if (enchantmentEntry.isPresent()) {
                    class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
                    builder.method_57550((class_6880)enchantmentEntry.get(), level);
                    stack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
                    System.out.println("[Pickaxeminigame] Successfully applied enchantment!");
                } else {
                    System.err.println("[Pickaxeminigame] Enchantment not found: " + String.valueOf(enchantId));
                }
            } else {
                System.err.println("[Pickaxeminigame] Enchantment registry not set!");
            }
        }

        public class_1792 getItem() {
            return (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)this.itemId));
        }

        public boolean isValid() {
            class_2960 id = class_2960.method_12829((String)this.itemId);
            if (id == null) {
                return false;
            }
            return class_7923.field_41178.method_10223(id) != class_1802.field_8162;
        }
    }
}

