/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.gui;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cwg.mod.CobblemonWikiGui;
import com.cwg.mod.config.CobblemonWikiGuiLang;
import com.cwg.mod.gui.EvolutionsGui;
import com.cwg.mod.helper.GuiHelper;
import com.cwg.mod.util.CobblemonUtil;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/cwg/mod/gui/PokeWikiGui;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "formData", "Lnet/minecraft/class_3222;", "playerEntity", "Leu/pb4/sgui/api/gui/SimpleGui;", "open", "(Lcom/cobblemon/mod/common/pokemon/FormData;Lnet/minecraft/class_3222;)Leu/pb4/sgui/api/gui/SimpleGui;", "", "step", "Leu/pb4/sgui/api/elements/GuiElementBuilder;", "createRelativeButton", "(Lcom/cobblemon/mod/common/pokemon/FormData;I)Leu/pb4/sgui/api/elements/GuiElementBuilder;", "species", "serverPlayerEntity", "", "Leu/pb4/sgui/api/elements/GuiElement;", "contentMain", "(Lcom/cobblemon/mod/common/pokemon/FormData;Lnet/minecraft/class_3222;)[Leu/pb4/sgui/api/elements/GuiElement;", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "lang", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "getLang", "()Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "redPane", "Leu/pb4/sgui/api/elements/GuiElement;", "CONTENT_SPACE", "[Ljava/lang/Integer;", "MAX_CONTENT", "I", "common"})
public final class PokeWikiGui {
    @NotNull
    public static final PokeWikiGui INSTANCE = new PokeWikiGui();
    @NotNull
    private static final CobblemonWikiGuiLang lang = CobblemonWikiGui.INSTANCE.getLangConfig();
    @NotNull
    private static final GuiElement redPane = GuiHelper.INSTANCE.getRED_PANE();
    @NotNull
    private static final Integer[] CONTENT_SPACE;
    private static final int MAX_CONTENT;

    private PokeWikiGui() {
    }

    @NotNull
    public final CobblemonWikiGuiLang getLang() {
        return lang;
    }

    @NotNull
    public final SimpleGui open(@NotNull FormData formData, @NotNull class_3222 playerEntity) {
        Intrinsics.checkNotNullParameter((Object)formData, (String)"formData");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        GuiElement[] content = this.contentMain(formData, playerEntity);
        if (content.length > MAX_CONTENT) {
            throw new RuntimeException("The content provided exceeds " + MAX_CONTENT + " elements or is invalid.");
        }
        SimpleGui gui = new SimpleGui(class_3917.field_17327, playerEntity, false);
        class_5250 class_52502 = class_2561.method_43470((String)"Cobblemon Wiki");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        gui.setTitle((class_2561)TextKt.red((class_5250)class_52502));
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 0, 0, 8, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.VERTICAL, gui, 0, 1, 3, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 4, 0, 8, redPane);
        gui.setSlot(48, (GuiElementInterface)this.createRelativeButton(formData, -1).build());
        gui.setSlot(49, (GuiElementInterface)GuiHelper.INSTANCE.createPokemonButton(formData).build());
        gui.setSlot(50, (GuiElementInterface)this.createRelativeButton(formData, 1).build());
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.VERTICAL, gui, 8, 1, 3, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 5, 0, 2, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 5, 6, 8, redPane);
        int n = content.length;
        for (int j = 0; j < n; ++j) {
            gui.setSlot(CONTENT_SPACE[j].intValue(), (GuiElementInterface)content[j]);
        }
        n = gui.getSize();
        for (int i = 0; i < n; ++i) {
            if (gui.getSlot(i) != null) continue;
            gui.setSlot(i, (GuiElementInterface)redPane);
        }
        gui.open();
        return gui;
    }

    private final GuiElementBuilder createRelativeButton(FormData formData, int step) {
        FormData relativeForm;
        Species relative;
        Species species = relative = PokemonSpecies.getByPokedexNumber$default((int)(formData.getSpecies().getNationalPokedexNumber() + step), null, (int)2, null);
        FormData formData2 = relativeForm = species != null ? species.getFormByName(formData.getName()) : null;
        if (relative != null && relativeForm != null) {
            GuiElementBuilder guiElementBuilder = GuiHelper.INSTANCE.createPokemonButton(relativeForm).setLore(CollectionsKt.listOf((Object)TextKt.text((String)lang.getPokeInfo()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> PokeWikiGui.createRelativeButton$lambda$0(relativeForm, arg_0, arg_1, arg_2, arg_3));
            Intrinsics.checkNotNullExpressionValue((Object)guiElementBuilder, (String)"setCallback(...)");
            return guiElementBuilder;
        }
        class_1799 class_17992 = redPane.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItemStack(...)");
        return GuiHelper.INSTANCE.createEmptyButton(class_17992);
    }

    private final GuiElement[] contentMain(FormData species, class_3222 serverPlayerEntity) {
        GuiElement[] guiElementArray = new GuiElement[18];
        guiElementArray[0] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.LIGHT_BALL)).setName((class_2561)TextKt.text((String)lang.getType())).setLore(CollectionsKt.toMutableList((Collection)CobblemonUtil.INSTANCE.getTypeToWikiGui(species))).build();
        guiElementArray[1] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.ELECTIRIZER)).setName((class_2561)TextKt.text((String)lang.getEffectiveness())).setLore(CobblemonUtil.INSTANCE.getEffectiveness(species)).build();
        guiElementArray[2] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.POKE_BALL)).setName((class_2561)TextKt.text((String)lang.getCatchrate())).setLore(CobblemonUtil.INSTANCE.getCatchRateToWikiGui(species)).build();
        guiElementArray[3] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.WEAKNESS_POLICY)).setName((class_2561)TextKt.text((String)lang.getBasestats())).setLore(CobblemonUtil.INSTANCE.getBaseStatsToWikiGui(species)).build();
        GuiElementBuilder guiElementBuilder = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)class_1802.field_17535)).setName((class_2561)TextKt.text((String)lang.getSpawnbiome()));
        class_3218 class_32182 = serverPlayerEntity.method_51469();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"serverLevel(...)");
        guiElementArray[4] = guiElementBuilder.setLore(CobblemonUtil.INSTANCE.getSpawnBiomesToWikiGui(species, (class_1937)class_32182)).build();
        guiElementArray[5] = GuiHelper.INSTANCE.createPokemonButton(species).setName((class_2561)TextKt.text((String)lang.getEvolutions())).setLore(CollectionsKt.listOf((Object)TextKt.text((String)lang.getSeeEvolutions()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> PokeWikiGui.contentMain$lambda$0(species, serverPlayerEntity, arg_0, arg_1, arg_2, arg_3)).build();
        guiElementArray[6] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)class_1802.field_8557)).setName((class_2561)class_2561.method_43470((String)lang.getSpawntime())).setLore(CobblemonUtil.INSTANCE.getSpawnTime(species)).build();
        guiElementArray[7] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.ABILITY_CAPSULE)).setName((class_2561)class_2561.method_43470((String)lang.getAbilities())).setLore(CobblemonUtil.INSTANCE.getAbilities(species)).build();
        guiElementArray[8] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.LEVEL_BALL)).setName((class_2561)class_2561.method_43470((String)lang.getMovesbylevel())).setLore(CobblemonUtil.INSTANCE.getMovesByLevelToWikiGui(species)).build();
        guiElementArray[9] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.LIGHT_BALL)).setName((class_2561)class_2561.method_43470((String)lang.getTmMoves())).setLore(CobblemonUtil.INSTANCE.getTmMoves(species)).build();
        guiElementArray[10] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.FRIEND_BALL)).setName((class_2561)class_2561.method_43470((String)lang.getTutorMoves())).setLore(CobblemonUtil.INSTANCE.getTutorMoves(species)).build();
        guiElementArray[11] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.ULTRA_BALL)).setName((class_2561)class_2561.method_43470((String)lang.getEvolutionMoves())).setLore(CobblemonUtil.INSTANCE.getEvolutionMoves(species)).build();
        guiElementArray[12] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.POWER_WEIGHT)).setName((class_2561)class_2561.method_43470((String)lang.getFormChangeMoves())).setLore(CobblemonUtil.INSTANCE.getFormChangeMoves(species)).build();
        guiElementArray[13] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.OVAL_STONE)).setName((class_2561)class_2561.method_43470((String)lang.getEggMoves())).setLore(CobblemonUtil.INSTANCE.getEggMoves(species)).build();
        guiElementArray[14] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.LUCKY_EGG)).setName((class_2561)class_2561.method_43470((String)lang.getEggGroups())).setLore(CobblemonUtil.INSTANCE.getEggGroups(species)).build();
        guiElementArray[15] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.NORMAL_GEM)).setName((class_2561)class_2561.method_43470((String)lang.getForms())).setLore(CobblemonUtil.INSTANCE.getForms(species)).build();
        guiElementArray[16] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)CobblemonItems.AIR_BALLOON)).setName((class_2561)class_2561.method_43470((String)lang.getDynamax())).setLore(CobblemonUtil.INSTANCE.getDynamax(species)).build();
        guiElementArray[17] = GuiHelper.INSTANCE.createEmptyButton(new class_1799((class_1935)class_1802.field_8606)).setName((class_2561)class_2561.method_43470((String)lang.getDrops())).setLore(CobblemonUtil.INSTANCE.getDrops(species)).build();
        GuiElement[] content = guiElementArray;
        return content;
    }

    private static final void createRelativeButton$lambda$0(FormData $relativeForm, int n, ClickType clickType, class_1713 class_17132, SlotGuiInterface gui) {
        PokeWikiGui $this$createRelativeButton_u24lambda_u240_u240 = INSTANCE;
        boolean bl = false;
        gui.close();
        class_3222 class_32222 = gui.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        $this$createRelativeButton_u24lambda_u240_u240.open($relativeForm, class_32222);
    }

    private static final void contentMain$lambda$0(FormData $species, class_3222 $serverPlayerEntity, int n, ClickType clickType, class_1713 class_17132, SlotGuiInterface gui) {
        gui.close();
        EvolutionsGui.open$default(EvolutionsGui.INSTANCE, $species, $serverPlayerEntity, 0, 4, null);
    }

    static {
        Integer[] integerArray = new Integer[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        CONTENT_SPACE = integerArray;
        MAX_CONTENT = CONTENT_SPACE.length;
    }
}

