/*
 * Decompiled with CFR 0.152.
 */
package necro.livelier.pokemon.common.weather;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import necro.livelier.pokemon.common.weather.Weather;
import necro.livelier.pokemon.common.weather.WeatherType;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_8710;

public class WeatherManager {
    private static final Map<class_1923, List<Weather>> WEATHER_MAP = new HashMap<class_1923, List<Weather>>();
    private static final Set<UUID> ACTIVE_SOURCES = new HashSet<UUID>();
    private static int TICK = 0;
    public static BiConsumer<class_3222, class_8710> WEATHER_PACKET;

    public static void addWeather(Weather weather) {
        if (ACTIVE_SOURCES.contains(weather.source.getPokemon().getUuid())) {
            return;
        }
        Set<class_1923> chunks = WeatherManager.getCoveredChunks(weather.region);
        ArrayList<Weather> toRemove = new ArrayList<Weather>();
        ArrayList<Weather> candidates = new ArrayList<Weather>();
        for (class_1923 pos : chunks) {
            List<Weather> list = WEATHER_MAP.get(pos);
            if (list == null) continue;
            candidates.addAll(list);
        }
        for (Weather existingWeather : candidates) {
            if (!existingWeather.intersects(weather)) continue;
            if (existingWeather.weatherType == weather.weatherType) {
                return;
            }
            if (existingWeather.weatherType.getPriority() > weather.weatherType.getPriority()) {
                return;
            }
            toRemove.add(existingWeather);
        }
        toRemove.forEach(WeatherManager::removeWeather);
        for (class_1923 pos : chunks) {
            WEATHER_MAP.computeIfAbsent(pos, k -> new ArrayList()).add(weather);
        }
        ACTIVE_SOURCES.add(weather.source.getPokemon().getUuid());
        weather.onSummon();
    }

    public static void removeWeather(Weather weather) {
        weather.onExit();
        Set<class_1923> coveredChunks = WeatherManager.getCoveredChunks(weather.region);
        for (class_1923 pos : coveredChunks) {
            List<Weather> list = WEATHER_MAP.get(pos);
            if (list == null) continue;
            list.remove(weather);
            ACTIVE_SOURCES.remove(weather.source.getPokemon().getUuid());
            if (!list.isEmpty()) continue;
            WEATHER_MAP.remove(pos);
        }
    }

    public static void removeFromPos(class_2338 blockPos, class_1937 level) {
        List<Weather> weathers = WEATHER_MAP.get(new class_1923(blockPos));
        if (weathers == null || weathers.isEmpty()) {
            return;
        }
        Weather toRemove = null;
        for (Weather weather : weathers) {
            if (weather.level != level || !weather.contains(blockPos)) continue;
            toRemove = weather;
            break;
        }
        if (toRemove != null) {
            WeatherManager.removeWeather(toRemove);
        }
    }

    public static boolean isWeather(class_2338 blockPos, class_1937 level, WeatherType ... weatherTypes) {
        List<Weather> weathers = WEATHER_MAP.get(new class_1923(blockPos));
        if (weathers == null || weathers.isEmpty()) {
            return false;
        }
        Set<WeatherType> typeSet = Set.of(weatherTypes);
        for (Weather weather : weathers) {
            if (weather.level != level || !typeSet.contains((Object)weather.weatherType) || !weather.contains(blockPos)) continue;
            return true;
        }
        return false;
    }

    public static void tick() {
        if (++TICK < 20) {
            return;
        }
        TICK = 0;
        HashSet<Weather> uniqueWeathers = new HashSet<Weather>();
        for (List<Weather> list : WEATHER_MAP.values()) {
            uniqueWeathers.addAll(list);
        }
        for (Weather weather : uniqueWeathers) {
            if (weather.tick()) continue;
            WeatherManager.removeWeather(weather);
        }
    }

    private static Set<class_1923> getCoveredChunks(class_238 region) {
        int minChunkX = class_3532.method_15357((double)region.field_1323) >> 4;
        int minChunkZ = class_3532.method_15357((double)region.field_1321) >> 4;
        int maxChunkX = class_3532.method_15357((double)region.field_1320) >> 4;
        int maxChunkZ = class_3532.method_15357((double)region.field_1324) >> 4;
        HashSet<class_1923> chunks = new HashSet<class_1923>();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunks.add(new class_1923(cx, cz));
            }
        }
        return chunks;
    }
}

