/*
 * Decompiled with CFR 0.152.
 */
package necro.livelier.pokemon.common.weather;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.HashSet;
import java.util.Set;
import necro.livelier.pokemon.common.network.SetWeatherPacket;
import necro.livelier.pokemon.common.weather.WeatherManager;
import necro.livelier.pokemon.common.weather.WeatherType;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4051;

public abstract class Weather {
    protected final PokemonEntity source;
    protected final class_238 region;
    protected final class_2338 origin;
    protected final int radius;
    protected final class_1937 level;
    protected int tick;
    private final boolean doTick;
    protected final WeatherType weatherType;
    protected Set<class_1657> players;

    public Weather(PokemonEntity source, class_2338 blockPos, class_1937 level, int radius, int duration, WeatherType weatherType) {
        this.source = source;
        this.region = new class_238(blockPos).method_1009((double)radius, (double)level.method_31600(), (double)radius);
        this.origin = blockPos;
        this.radius = radius;
        this.level = level;
        this.tick = duration;
        this.doTick = duration != -1;
        this.weatherType = weatherType;
        this.players = new HashSet<class_1657>();
    }

    public Weather(PokemonEntity source, class_243 vec3, class_1937 level, int radius, int duration, WeatherType weatherType) {
        this(source, new class_2338((int)vec3.method_10216(), (int)vec3.method_10214(), (int)vec3.method_10215()), level, radius, duration, weatherType);
    }

    public Weather(PokemonEntity source, int x, int y, int z, class_1937 level, int radius, int duration, WeatherType weatherType) {
        this(source, new class_2338(x, y, z), level, radius, duration, weatherType);
    }

    public boolean intersects(Weather weather) {
        return this.level == weather.level && this.region.method_994(weather.region);
    }

    public boolean contains(class_2338 blockPos) {
        return this.region.method_1008((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
    }

    public void onSummon() {
        this.checkPlayers();
    }

    public void onExit() {
        this.players.forEach(this::onPlayerExit);
    }

    protected void doWeather() {
    }

    protected void onPlayerEnter(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            WeatherManager.WEATHER_PACKET.accept(serverPlayer, new SetWeatherPacket(this.weatherType));
        }
    }

    protected void onPlayerTick(class_1657 player) {
    }

    protected void onPlayerExit(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            WeatherManager.WEATHER_PACKET.accept(serverPlayer, new SetWeatherPacket(WeatherType.NONE));
        }
    }

    private void checkPlayers() {
        HashSet<class_1657> current = new HashSet<class_1657>();
        for (class_1657 player : this.level.method_18464(class_4051.method_36626().method_36627(), null, this.region)) {
            if (!this.level.method_8311(player.method_24515())) continue;
            current.add(player);
        }
        for (class_1657 player : current) {
            if (this.players.contains(player)) continue;
            this.onPlayerEnter(player);
        }
        for (class_1657 player : this.players) {
            if (current.contains(player)) continue;
            this.onPlayerExit(player);
        }
        this.players.clear();
        this.players.addAll(current);
    }

    public boolean tick() {
        if (!this.doTick && this.source.method_31481()) {
            return false;
        }
        if (this.doTick && --this.tick <= 0) {
            return false;
        }
        this.doWeather();
        this.checkPlayers();
        this.players.forEach(this::onPlayerTick);
        return true;
    }

    public int getTick() {
        return this.tick;
    }
}

