/*
 * Decompiled with CFR 0.152.
 */
package necro.livelier.pokemon.common.helpers;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Unit;
import necro.livelier.pokemon.common.LivelierPokemon;
import necro.livelier.pokemon.common.config.AbilityConfig;
import necro.livelier.pokemon.common.events.BallFetchEvent;
import necro.livelier.pokemon.common.goals.BlockProjectileGoal;
import necro.livelier.pokemon.common.goals.CropGrowthGoal;
import necro.livelier.pokemon.common.goals.DamageRevengeGoal;
import necro.livelier.pokemon.common.goals.EffectRevengeGoal;
import necro.livelier.pokemon.common.goals.EntityEffectGoal;
import necro.livelier.pokemon.common.goals.FieldEffectGoal;
import necro.livelier.pokemon.common.goals.FlameBodyGoal;
import necro.livelier.pokemon.common.goals.FleeRainGoal;
import necro.livelier.pokemon.common.goals.IlluminateGoal;
import necro.livelier.pokemon.common.goals.KecleonGoal;
import necro.livelier.pokemon.common.goals.MagnetPullGoal;
import necro.livelier.pokemon.common.goals.OwnerCleanseGoal;
import necro.livelier.pokemon.common.goals.OwnerEffectGoal;
import necro.livelier.pokemon.common.goals.PressureGoal;
import necro.livelier.pokemon.common.goals.PurifyVillagerGoal;
import necro.livelier.pokemon.common.goals.RandomTeleportGoal;
import necro.livelier.pokemon.common.goals.RemoveWeatherGoal;
import necro.livelier.pokemon.common.goals.RestrictRainGoal;
import necro.livelier.pokemon.common.goals.SelfEffectGoal;
import necro.livelier.pokemon.common.goals.VoltorbExplosionGoal;
import necro.livelier.pokemon.common.registries.EffectRegistry;
import necro.livelier.pokemon.common.registries.EventRegistry;
import necro.livelier.pokemon.common.registries.ParticleRegistry;
import necro.livelier.pokemon.common.weather.WeatherManager;
import necro.livelier.pokemon.common.weather.weathers.HarshSun;
import necro.livelier.pokemon.common.weather.weathers.HeavyRain;
import necro.livelier.pokemon.common.weather.weathers.Rain;
import necro.livelier.pokemon.common.weather.weathers.Sandstorm;
import necro.livelier.pokemon.common.weather.weathers.Snow;
import necro.livelier.pokemon.common.weather.weathers.StrongWind;
import necro.livelier.pokemon.common.weather.weathers.Sun;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_2394;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.apache.logging.log4j.util.TriConsumer;

public class SpawnHelper {
    private static final Map<String, Consumer<PokemonEntity>> ON_SEND = new HashMap<String, Consumer<PokemonEntity>>();
    private static final Map<String, Consumer<PokemonEntity>> ON_SPAWN = new HashMap<String, Consumer<PokemonEntity>>();
    private static final TriConsumer<PokemonEntity, Integer, class_1352> goalHelper = (pokemonEntity, priority, goal) -> pokemonEntity.field_6201.method_6277(priority.intValue(), goal);

    public static void init() {
        Consumer<PokemonEntity> cons;
        SpawnHelper.registerEvents();
        AbilityConfig config = LivelierPokemon.getAbilityConfig();
        if (config.AIR_LOCK) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new RemoveWeatherGoal((PokemonEntity)pokemonEntity));
            ON_SEND.putIfAbsent("airlock", cons);
            ON_SPAWN.putIfAbsent("airlock", cons);
        }
        if (config.BEADS_OF_RUIN) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EntityEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5911, false));
            ON_SEND.putIfAbsent("beadsofruin", cons);
            ON_SPAWN.putIfAbsent("beadsofruin", cons);
        }
        if (config.CLOUD_NINE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new RemoveWeatherGoal((PokemonEntity)pokemonEntity));
            ON_SEND.putIfAbsent("cloudnine", cons);
            ON_SPAWN.putIfAbsent("cloudnine", cons);
        }
        if (config.CURSED_BODY) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5901, config.cursed_body_duration, config.cursed_body_trigger_chance));
            ON_SEND.putIfAbsent("cursedbody", cons);
            ON_SPAWN.putIfAbsent("cursedbody", cons);
        }
        if (config.DARK_AURA) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.dark_aura_radius, null, entity -> SpawnHelper.isType(entity, "dark")));
            ON_SEND.putIfAbsent("darkaura", cons);
            ON_SPAWN.putIfAbsent("darkaura", cons);
        }
        if (config.DAUNTLESS_SHIELD) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5907, 240, 0));
            ON_SEND.putIfAbsent("dauntlessshield", cons);
            ON_SPAWN.putIfAbsent("dauntlessshield", cons);
        }
        if (config.DELTA_STREAM) {
            cons = pokemonEntity -> {
                StrongWind weather = new StrongWind((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.delta_stream_radius, config.delta_stream_duration_seconds);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("deltastream", cons);
            ON_SPAWN.putIfAbsent("deltastream", cons);
        }
        if (config.DESOLATE_LAND) {
            cons = pokemonEntity -> {
                int duration = config.desolate_land_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.HEAT_ROCK)) {
                    duration *= 2;
                }
                HarshSun weather = new HarshSun((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.desolate_land_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("desolateland", cons);
            ON_SPAWN.putIfAbsent("desolateland", cons);
        }
        if (config.DISGUISE) {
            cons = pokemonEntity -> pokemonEntity.method_6092(new class_1293(class_1294.field_5898, -1, 0));
            ON_SEND.putIfAbsent("disguise", cons);
            ON_SPAWN.putIfAbsent("disguise", cons);
        }
        if (config.DRIZZLE) {
            cons = pokemonEntity -> {
                int duration = config.drizzle_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.DAMP_ROCK)) {
                    duration *= 2;
                }
                Rain weather = new Rain((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.drizzle_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("drizzle", cons);
            ON_SPAWN.putIfAbsent("drizzle", cons);
        }
        if (config.DROUGHT) {
            cons = pokemonEntity -> {
                int duration = config.drought_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.HEAT_ROCK)) {
                    duration *= 2;
                }
                Sun weather = new Sun((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.drought_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("drought", cons);
            ON_SPAWN.putIfAbsent("drought", cons);
        }
        if (config.EFFECT_SPORE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5899, config.effect_spore_duration, config.effect_spore_trigger_chance));
            ON_SEND.putIfAbsent("effectspore", cons);
            ON_SPAWN.putIfAbsent("effectspore", cons);
        }
        if (config.ELECTRIC_SURGE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.electric_surge_radius, (class_2394)(config.electric_surge_show_terrain ? ParticleRegistry.ELECTRIC_TERRAIN : null), entity -> SpawnHelper.isType(entity, "electric")));
            ON_SEND.putIfAbsent("electricsurge", cons);
            ON_SPAWN.putIfAbsent("electricsurge", cons);
        }
        if (config.FAIRY_AURA) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.fairy_aura_radius, null, entity -> SpawnHelper.isType(entity, "fairy")));
            ON_SEND.putIfAbsent("fairyaura", cons);
            ON_SPAWN.putIfAbsent("fairyaura", cons);
        }
        if (config.FLAME_BODY) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FlameBodyGoal((PokemonEntity)pokemonEntity, (float)config.flame_body_trigger_chance, config.flame_body_duration));
            ON_SEND.putIfAbsent("flamebody", cons);
            ON_SPAWN.putIfAbsent("flamebody", cons);
        }
        if (config.FRIEND_GUARD) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5907, config.friend_guard_friendship_threshold));
            ON_SEND.putIfAbsent("friendguard", cons);
        }
        if (config.GOOEY) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5909, config.gooey_duration, config.gooey_trigger_chance));
            ON_SEND.putIfAbsent("gooey", cons);
            ON_SPAWN.putIfAbsent("gooey", cons);
        }
        if (config.GRASSY_SURGE) {
            cons = pokemonEntity -> {
                goalHelper.accept(pokemonEntity, (Object)3, (Object)new CropGrowthGoal((PokemonEntity)pokemonEntity, config.grassy_surge_radius));
                goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.grassy_surge_radius, (class_2394)(config.grassy_surge_show_terrain ? ParticleRegistry.GRASSY_TERRAIN : null), entity -> SpawnHelper.isType(entity, "grass")));
            };
            ON_SEND.putIfAbsent("grassysurge", cons);
            ON_SPAWN.putIfAbsent("grassysurge", cons);
        }
        if (config.HADRON_ENGINE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.hadron_engine_radius, (class_2394)(config.hadron_engine_show_terrain ? ParticleRegistry.ELECTRIC_TERRAIN : null), entity -> SpawnHelper.isType(entity, "electric")));
            ON_SEND.putIfAbsent("hadronengine", cons);
            ON_SPAWN.putIfAbsent("hadronengine", cons);
        }
        if (config.HEALER) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerCleanseGoal((PokemonEntity)pokemonEntity));
            ON_SEND.putIfAbsent("healer", cons);
        }
        if (config.HEATPROOF) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5918, 240, 0));
            ON_SEND.putIfAbsent("heatproof", cons);
            ON_SPAWN.putIfAbsent("heatproof", cons);
        }
        if (config.HUGE_POWER) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, 240, 0));
            ON_SEND.putIfAbsent("hugepower", cons);
            ON_SPAWN.putIfAbsent("hugepower", cons);
        }
        if (config.ICE_FACE) {
            cons = pokemonEntity -> pokemonEntity.method_6092(new class_1293(class_1294.field_5898, -1, 0));
            ON_SEND.putIfAbsent("iceface", cons);
            ON_SPAWN.putIfAbsent("iceface", cons);
        }
        if (config.ILLUMINATE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new IlluminateGoal((PokemonEntity)pokemonEntity, config.illuminate_radius));
            ON_SEND.putIfAbsent("illuminate", cons);
        }
        if (config.INTREPID_SWORD) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, 240, 0));
            ON_SEND.putIfAbsent("intrepidsword", cons);
            ON_SPAWN.putIfAbsent("intrepidsword", cons);
        }
        if (config.IRON_BARBS) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new DamageRevengeGoal((PokemonEntity)pokemonEntity, config.iron_barbs_damage));
            ON_SEND.putIfAbsent("ironbarbs", cons);
            ON_SPAWN.putIfAbsent("ironbarbs", cons);
        }
        if (config.MAGNET_PULL) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new MagnetPullGoal((PokemonEntity)pokemonEntity, config.magnet_pull_range));
            ON_SEND.putIfAbsent("magnetpull", cons);
        }
        if (config.MISTY_SURGE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5911, config.misty_surge_radius, (class_2394)(config.misty_surge_show_terrain ? ParticleRegistry.MISTY_TERRAIN : null), entity -> SpawnHelper.isType(entity, "dragon")));
            ON_SEND.putIfAbsent("mistysurge", cons);
            ON_SPAWN.putIfAbsent("mistysurge", cons);
        }
        if (config.ORICHALCUM_PULSE) {
            cons = pokemonEntity -> {
                int duration = config.orichalcum_pulse_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.HEAT_ROCK)) {
                    duration *= 2;
                }
                Sun weather = new Sun((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.orichalcum_pulse_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("orichalcumpulse", cons);
            ON_SPAWN.putIfAbsent("orichalcumpulse", cons);
        }
        if (config.PASTEL_VEIL) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerCleanseGoal((PokemonEntity)pokemonEntity));
            ON_SEND.putIfAbsent("pastelveil", cons);
        }
        if (config.PERISH_BODY) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5920, config.perish_body_duration, config.perish_body_trigger_chance));
            ON_SEND.putIfAbsent("perishbody", cons);
            ON_SPAWN.putIfAbsent("perishbody", cons);
        }
        if (config.POISON_POINT) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5899, config.poison_point_duration, config.poison_point_trigger_chance));
            ON_SEND.putIfAbsent("poisonpoint", cons);
            ON_SPAWN.putIfAbsent("poisonpoint", cons);
        }
        if (config.POWER_SPOT) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.power_spot_friendship_threshold));
            ON_SEND.putIfAbsent("powerspot", cons);
        }
        if (config.PRESSURE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new PressureGoal((PokemonEntity)pokemonEntity, config.pressure_durability_loss));
            ON_SEND.putIfAbsent("pressure", cons);
            ON_SPAWN.putIfAbsent("pressure", cons);
        }
        if (config.PRIMORDIAL_SEA) {
            cons = pokemonEntity -> {
                int duration = config.primordial_sea_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.DAMP_ROCK)) {
                    duration *= 2;
                }
                HeavyRain weather = new HeavyRain((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.primordial_sea_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("primordialsea", cons);
            ON_SPAWN.putIfAbsent("primordialsea", cons);
        }
        if (config.PSYCHIC_SURGE) {
            cons = pokemonEntity -> {
                goalHelper.accept(pokemonEntity, (Object)3, (Object)new FieldEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, config.psychic_surge_radius, (class_2394)(config.psychic_surge_show_terrain ? ParticleRegistry.PSYCHIC_TERRAIN : null), entity -> SpawnHelper.isType(entity, "psychic")));
                goalHelper.accept(pokemonEntity, (Object)3, (Object)new BlockProjectileGoal((PokemonEntity)pokemonEntity, config.psychic_surge_block_radius));
            };
            ON_SEND.putIfAbsent("psychicsurge", cons);
            ON_SPAWN.putIfAbsent("psychicsurge", cons);
        }
        if (config.PURE_POWER) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5910, 240, 0));
            ON_SEND.putIfAbsent("purepower", cons);
            ON_SPAWN.putIfAbsent("purepower", cons);
        }
        if (config.ROUGH_SKIN) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new DamageRevengeGoal((PokemonEntity)pokemonEntity, config.rough_skin_damage));
            ON_SEND.putIfAbsent("roughskin", cons);
            ON_SPAWN.putIfAbsent("roughskin", cons);
        }
        if (config.SAND_SPIT) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5919, config.sand_spit_duration, config.sand_spit_trigger_chance));
            ON_SEND.putIfAbsent("sandspit", cons);
            ON_SPAWN.putIfAbsent("sandspit", cons);
        }
        if (config.SAND_STREAM) {
            cons = pokemonEntity -> {
                int duration = config.sand_stream_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.SMOOTH_ROCK)) {
                    duration *= 2;
                }
                Sandstorm weather = new Sandstorm((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.sand_stream_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("sandstream", cons);
            ON_SPAWN.putIfAbsent("sandstream", cons);
        }
        if (config.SEED_SOWER) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new CropGrowthGoal((PokemonEntity)pokemonEntity, config.seed_sower_radius));
            ON_SEND.putIfAbsent("seedsower", cons);
            ON_SPAWN.putIfAbsent("seedsower", cons);
        }
        if (config.SNOW_WARNING) {
            cons = pokemonEntity -> {
                int duration = config.snow_warning_duration_seconds;
                if (duration > 0 && pokemonEntity.getPokemon().heldItem().method_31574((class_1792)CobblemonItems.ICY_ROCK)) {
                    duration *= 2;
                }
                Snow weather = new Snow((PokemonEntity)pokemonEntity, pokemonEntity.method_24515(), pokemonEntity.method_37908(), config.snow_warning_radius, duration);
                WeatherManager.addWeather(weather);
            };
            ON_SEND.putIfAbsent("snowwarning", cons);
            ON_SPAWN.putIfAbsent("snowwarning", cons);
        }
        if (config.STATIC) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, EffectRegistry.PARALYSIS, config.static_duration, config.static_trigger_chance));
            ON_SEND.putIfAbsent("static", cons);
            ON_SPAWN.putIfAbsent("static", cons);
        }
        if (config.SLOW_START) {
            cons = pokemonEntity -> {
                pokemonEntity.method_6092(new class_1293(class_1294.field_5909, config.slow_start_duration, 1));
                pokemonEntity.method_6092(new class_1293(class_1294.field_5911, config.slow_start_duration, 1));
            };
            ON_SEND.putIfAbsent("slowstart", cons);
            ON_SPAWN.putIfAbsent("slowstart", cons);
        }
        if (config.SPEED_BOOST) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5904, 240, 0));
            ON_SEND.putIfAbsent("speedboost", cons);
            ON_SPAWN.putIfAbsent("speedboost", cons);
        }
        if (config.SWEET_VEIL) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerCleanseGoal((PokemonEntity)pokemonEntity));
            ON_SEND.putIfAbsent("sweetveil", cons);
        }
        if (config.SWIFT_SWIM) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new SelfEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5900, 240, 0));
            ON_SEND.putIfAbsent("swiftswim", cons);
            ON_SPAWN.putIfAbsent("swiftswim", cons);
        }
        if (config.SERENE_GRACE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5926, config.serene_grace_friendship_threshold));
            ON_SEND.putIfAbsent("serenegrace", cons);
        }
        if (config.SWORD_OF_RUIN) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EntityEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5911, false));
            ON_SEND.putIfAbsent("swordofruin", cons);
            ON_SPAWN.putIfAbsent("swordofruin", cons);
        }
        if (config.TABLET_OF_RUIN) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EntityEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5911, false));
            ON_SEND.putIfAbsent("tabletofruin", cons);
            ON_SPAWN.putIfAbsent("tabletofruin", cons);
        }
        if (config.TANGLING_HAIR) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5909, config.tangling_hair_duration, config.tangling_hair_trigger_chance));
            ON_SEND.putIfAbsent("tanglinghair", cons);
            ON_SPAWN.putIfAbsent("tanglinghair", cons);
        }
        if (config.TOXIC_DEBRIS) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EffectRevengeGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5899, config.toxic_debris_duration, config.toxic_debris_trigger_chance));
            ON_SEND.putIfAbsent("toxicdebris", cons);
            ON_SPAWN.putIfAbsent("toxicdebris", cons);
        }
        if (config.VESSEL_OF_RUIN) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new EntityEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5911, false));
            ON_SEND.putIfAbsent("vesselofruin", cons);
            ON_SPAWN.putIfAbsent("vesselofruin", cons);
        }
        if (config.VICTORY_STAR) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new OwnerEffectGoal((PokemonEntity)pokemonEntity, (class_6880<class_1291>)class_1294.field_5917, config.victory_star_friendship_threshold));
            ON_SEND.putIfAbsent("victorystar", cons);
        }
        if (config.WONDER_GUARD) {
            cons = pokemonEntity -> {
                if (pokemonEntity.method_29504()) {
                    return;
                }
                class_1324 attribute = pokemonEntity.method_5996(class_5134.field_23716);
                if (attribute == null) {
                    return;
                }
                attribute.method_6192(1.0);
                pokemonEntity.method_6033(1.0f);
            };
            ON_SEND.putIfAbsent("wonderguard", cons);
            ON_SPAWN.putIfAbsent("wonderguard", cons);
        }
        if (config.ABRA) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new RandomTeleportGoal((PokemonEntity)pokemonEntity));
            ON_SPAWN.putIfAbsent("Abra", cons);
        }
        if (config.KECLEON) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new KecleonGoal((PokemonEntity)pokemonEntity, config.kecleon_duration));
            ON_SEND.putIfAbsent("Kecleon", cons);
            ON_SPAWN.putIfAbsent("Kecleon", cons);
        }
        if (config.SUICUNE) {
            cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new PurifyVillagerGoal((PokemonEntity)pokemonEntity, config.suicune_purify_radius));
            ON_SEND.putIfAbsent("Suicune", cons);
            ON_SPAWN.putIfAbsent("Suicune", cons);
        }
        if (config.VOLTORB) {
            Consumer<PokemonEntity> voltorb_cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new VoltorbExplosionGoal((PokemonEntity)pokemonEntity, config.voltorb_affects_environment, config.voltorb_explosion_radius));
            Consumer<PokemonEntity> electrode_cons = pokemonEntity -> goalHelper.accept(pokemonEntity, (Object)3, (Object)new VoltorbExplosionGoal((PokemonEntity)pokemonEntity, config.voltorb_affects_environment, config.electrode_explosion_radius));
            ON_SPAWN.putIfAbsent("Voltorb", voltorb_cons);
            ON_SPAWN.putIfAbsent("Electrode", electrode_cons);
        }
        if (config.AVOID_RAIN) {
            cons = pokemonEntity -> {
                goalHelper.accept(pokemonEntity, (Object)3, (Object)new FleeRainGoal((PokemonEntity)pokemonEntity, pokemonEntity.method_6029()));
                goalHelper.accept(pokemonEntity, (Object)2, (Object)new RestrictRainGoal((PokemonEntity)pokemonEntity));
            };
            ON_SPAWN.putIfAbsent("fire", cons);
            ON_SPAWN.putIfAbsent("Sudowoodo", cons);
            ON_SPAWN.putIfAbsent("Bonsly", cons);
        }
    }

    private static void registerEvents() {
        CobblemonEvents.POKEMON_SENT_POST.subscribe(Priority.NORMAL, event -> {
            try {
                SpawnHelper.onSend(event.getPokemon());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, event -> {
            try {
                SpawnHelper.onSpawn((PokemonEntity)event.getEntity());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_ENTITY_LOAD.subscribe(Priority.NORMAL, event -> {
            try {
                if (event.getPokemonEntity().getPokemon().getOwnerEntity() == null) {
                    SpawnHelper.onSpawn(event.getPokemonEntity());
                } else {
                    SpawnHelper.onSend(event.getPokemonEntity());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return Unit.INSTANCE;
        });
        EventRegistry.PASTURE_SENT.subscribe(Priority.NORMAL, event -> {
            try {
                SpawnHelper.onSend(event.pokemon);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return Unit.INSTANCE;
        });
        if (LivelierPokemon.getAbilityConfig().BALL_FETCH) {
            CobblemonEvents.POKE_BALL_CAPTURE_CALCULATED.subscribe(Priority.NORMAL, event -> {
                BallFetchEvent.onPokeballCaptureCalculated(event);
                return Unit.INSTANCE;
            });
        }
    }

    public static boolean hasAbility(Pokemon pokemon, String ability) {
        return pokemon.getAbility().getName().equals(ability);
    }

    public static boolean hasAbility(PokemonEntity pokemonEntity, String ability) {
        return SpawnHelper.hasAbility(pokemonEntity.getPokemon(), ability);
    }

    public static boolean isSpecies(Pokemon pokemon, String species) {
        return pokemon.getSpecies().getName().equals(species);
    }

    public static boolean isSpecies(PokemonEntity pokemonEntity, String species) {
        return SpawnHelper.isSpecies(pokemonEntity.getPokemon(), species);
    }

    public static boolean isType(Pokemon pokemon, String type) {
        for (ElementalType elementalType : pokemon.getTypes()) {
            if (!elementalType.getName().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isType(PokemonEntity pokemonEntity, String type) {
        return SpawnHelper.isType(pokemonEntity.getPokemon(), type);
    }

    public static List<String> getAttributes(Pokemon pokemon) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(pokemon.getSpecies().getName());
        attributes.add(pokemon.getAbility().getName());
        pokemon.getTypes().forEach(type -> attributes.add(type.getName()));
        return attributes;
    }

    public static void onSpawn(PokemonEntity pokemonEntity) {
        List<String> attributes = SpawnHelper.getAttributes(pokemonEntity.getPokemon());
        for (String attribute : attributes) {
            Consumer addGoal = ON_SPAWN.getOrDefault(attribute, null);
            if (addGoal == null) continue;
            addGoal.accept(pokemonEntity);
        }
    }

    public static void onSend(PokemonEntity pokemonEntity) {
        List<String> attributes = SpawnHelper.getAttributes(pokemonEntity.getPokemon());
        for (String attribute : attributes) {
            Consumer addGoal = ON_SEND.getOrDefault(attribute, null);
            if (addGoal == null) continue;
            addGoal.accept(pokemonEntity);
        }
    }

    public static void onSend(Pokemon pokemon) {
        List<String> attributes = SpawnHelper.getAttributes(pokemon);
        for (String attribute : attributes) {
            Consumer addGoal = ON_SEND.getOrDefault(attribute, null);
            if (addGoal == null) continue;
            addGoal.accept(pokemon.getEntity());
        }
    }
}

