/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneClusterConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneUtils;

public class PointedRedstoneClusterFeature
extends class_3031<PointedRedstoneClusterConfiguration> {
    public PointedRedstoneClusterFeature(Codec<PointedRedstoneClusterConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<PointedRedstoneClusterConfiguration> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        PointedRedstoneClusterConfiguration redstoneClusterConfiguration = (PointedRedstoneClusterConfiguration)context.method_33656();
        class_5819 random = context.method_33654();
        if (!PointedRedstoneUtils.isEmptyOrWater((class_1936)level, pos)) {
            return false;
        }
        int i = redstoneClusterConfiguration.height.method_35008(random);
        float f = redstoneClusterConfiguration.wetness.method_33920(random);
        float f1 = redstoneClusterConfiguration.density.method_33920(random);
        int j = redstoneClusterConfiguration.radius.method_35008(random);
        int k = redstoneClusterConfiguration.radius.method_35008(random);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, redstoneClusterConfiguration);
                class_2338 blockpos1 = pos.method_10069(l, 0, i1);
                this.placeColumn(level, random, blockpos1, l, i1, f, d0, i, f1, redstoneClusterConfiguration);
            }
        }
        return true;
    }

    private void placeColumn(class_5281 level, class_5819 random, class_2338 pos, int i4, int i5, float v, double v1, int i6, float v2, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        Optional optional = class_5721.method_32982((class_3746)level, (class_2338)pos, (int)redstoneClusterConfiguration.floorToCeilingSearchRange, PointedRedstoneUtils::isEmptyOrWater, PointedRedstoneUtils::isNeitherEmptyNorWater);
        if (optional.isPresent()) {
            OptionalInt optionalInt = ((class_5721)optional.get()).method_32985();
            OptionalInt optionalInt1 = ((class_5721)optional.get()).method_32987();
            if (optionalInt.isPresent() || optionalInt1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                class_5721 column;
                boolean flag;
                boolean bl = flag = random.method_43057() < v;
                if (flag && optionalInt1.isPresent() && this.canPlacePool(level, pos.method_33096(optionalInt1.getAsInt()))) {
                    int i = optionalInt1.getAsInt();
                    column = ((class_5721)optional.get()).method_32983(OptionalInt.of(i - 1));
                    level.method_8652(pos.method_33096(i), class_2246.field_10382.method_9564(), 2);
                } else {
                    column = (class_5721)optional.get();
                }
                OptionalInt optionalint2 = column.method_32987();
                boolean bl2 = flag1 = random.method_43058() < v1;
                if (optionalInt.isPresent() && flag1 && !this.isLava((class_4538)level, pos.method_33096(optionalInt.getAsInt()))) {
                    int k = redstoneClusterConfiguration.redstoneBlockLayerThickness.method_35008(random);
                    this.replaceBlocksWithRedstoneBlocks(level, pos.method_33096(optionalInt.getAsInt()), k, class_2350.field_11036);
                    int l = optionalint2.isPresent() ? Math.min(i6, optionalInt.getAsInt() - optionalint2.getAsInt()) : i6;
                    j = this.getRedstoneHeight(random, i4, i5, v2, l, redstoneClusterConfiguration);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = random.method_43058() < v1;
                if (optionalint2.isPresent() && flag2 && !this.isLava((class_4538)level, pos.method_33096(optionalint2.getAsInt()))) {
                    int i1 = redstoneClusterConfiguration.redstoneBlockLayerThickness.method_35008(random);
                    this.replaceBlocksWithRedstoneBlocks(level, pos.method_33096(optionalint2.getAsInt()), i1, class_2350.field_11033);
                    i3 = optionalInt.isPresent() ? Math.max(0, j + class_3532.method_32751((class_5819)random, (int)(-redstoneClusterConfiguration.maxStalagmiteStalactiteHeightDiff), (int)redstoneClusterConfiguration.maxStalagmiteStalactiteHeightDiff)) : this.getRedstoneHeight(random, i4, i5, v2, i6, redstoneClusterConfiguration);
                } else {
                    i3 = 0;
                }
                if (optionalInt.isPresent() && optionalint2.isPresent() && optionalInt.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalInt.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = class_3532.method_32751((class_5819)random, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = random.method_43056() && j3 > 0 && j1 > 0 && column.method_33385().isPresent() && j3 + j1 == column.method_33385().getAsInt();
                if (optionalInt.isPresent()) {
                    PointedRedstoneUtils.growPointedRedstone((class_1936)level, pos.method_33096(optionalInt.getAsInt() - 1), class_2350.field_11033, j3, flag3);
                }
                if (optionalint2.isPresent()) {
                    PointedRedstoneUtils.growPointedRedstone((class_1936)level, pos.method_33096(optionalint2.getAsInt() + 1), class_2350.field_11036, j1, flag3);
                }
            }
        }
    }

    private boolean isLava(class_4538 level, class_2338 pos) {
        return level.method_8320(pos).method_27852(class_2246.field_10164);
    }

    private int getRedstoneHeight(class_5819 random, int i1, int i2, float v, int i3, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        if (random.method_43057() > v) {
            return 0;
        }
        int i = Math.abs(i1) + Math.abs(i2);
        float f = (float)class_3532.method_32854((double)i, (double)0.0, (double)redstoneClusterConfiguration.maxDistanceFromCenterAffectingHeightBias, (double)((double)i3 / 2.0), (double)0.0);
        return (int)PointedRedstoneClusterFeature.randomBetweenBiased(random, 0.0f, i3, f, redstoneClusterConfiguration.heightDeviation);
    }

    private boolean canPlacePool(class_5281 level, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos);
        if (!(blockstate.method_27852(class_2246.field_10328) || blockstate.method_27852(RuBlocks.RAW_REDSTONE_BLOCK.get()) || blockstate.method_27852(RuBlocks.POINTED_REDSTONE.get()))) {
            if (level.method_8320(pos.method_10084()).method_26227().method_15767(class_3486.field_15517)) {
                return false;
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (this.canBeAdjacentToWater((class_1936)level, pos.method_10093(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((class_1936)level, pos.method_10074());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(class_1936 level, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos);
        return blockstate.method_26164(class_3481.field_25806) || blockstate.method_26227().method_15767(class_3486.field_15517);
    }

    private void replaceBlocksWithRedstoneBlocks(class_5281 level, class_2338 pos, int i1, class_2350 direction) {
        class_2338.class_2339 blockpos$mutableblockpos = pos.method_25503();
        for (int i = 0; i < i1; ++i) {
            if (!PointedRedstoneUtils.placeRedstoneBlockIfPossible((class_1936)level, (class_2338)blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.method_10098(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int i1, int i2, int i3, int i4, PointedRedstoneClusterConfiguration redstoneClusterConfiguration) {
        int i = i1 - Math.abs(i3);
        int j = i2 - Math.abs(i4);
        int k = Math.min(i, j);
        return class_3532.method_37958((float)k, (float)0.0f, (float)redstoneClusterConfiguration.maxDistanceFromEdgeAffectingChanceOfRedstoneColumn, (float)redstoneClusterConfiguration.chanceOfRedstoneColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float randomBetweenBiased(class_5819 random, float v, float v1, float v2, float v3) {
        return class_5861.method_33903((class_5819)random, (float)v2, (float)v3, (float)v, (float)v1);
    }
}

