/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.feature.configuration.LargePointedRedstoneConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneUtils;
import org.jetbrains.annotations.Nullable;

public class LargePointedRedstoneFeature
extends class_3031<LargePointedRedstoneConfiguration> {
    public LargePointedRedstoneFeature(Codec<LargePointedRedstoneConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<LargePointedRedstoneConfiguration> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        LargePointedRedstoneConfiguration largeRedstoneConfiguration = (LargePointedRedstoneConfiguration)context.method_33656();
        class_5819 random = context.method_33654();
        if (!PointedRedstoneUtils.isEmptyOrWater((class_1936)level, pos)) {
            return false;
        }
        Optional optional = class_5721.method_32982((class_3746)level, (class_2338)pos, (int)largeRedstoneConfiguration.floorToCeilingSearchRange, PointedRedstoneUtils::isEmptyOrWater, PointedRedstoneUtils::isRedstoneBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof class_5721.class_5723) {
            class_5721.class_5723 columnRange = (class_5721.class_5723)optional.get();
            if (columnRange.method_32992() < 4) {
                return false;
            }
            int i = (int)((float)columnRange.method_32992() * largeRedstoneConfiguration.maxColumnRadiusToCaveHeightRatio);
            int j = class_3532.method_15340((int)i, (int)largeRedstoneConfiguration.columnRadius.method_35009(), (int)largeRedstoneConfiguration.columnRadius.method_35011());
            int k = class_3532.method_32751((class_5819)random, (int)largeRedstoneConfiguration.columnRadius.method_35009(), (int)j);
            LargeRedstone largeRedstone = LargePointedRedstoneFeature.makeRedstone(pos.method_33096(columnRange.method_32990() - 1), false, random, k, largeRedstoneConfiguration.stalactiteBluntness, largeRedstoneConfiguration.heightScale);
            LargeRedstone largeRedstone1 = LargePointedRedstoneFeature.makeRedstone(pos.method_33096(columnRange.method_32991() + 1), true, random, k, largeRedstoneConfiguration.stalagmiteBluntness, largeRedstoneConfiguration.heightScale);
            WindOffsetter windOffsetter = largeRedstone.isSuitableForWind(largeRedstoneConfiguration) && largeRedstone1.isSuitableForWind(largeRedstoneConfiguration) ? new WindOffsetter(pos.method_10264(), random, largeRedstoneConfiguration.windSpeed) : WindOffsetter.noWind();
            boolean flag = largeRedstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            boolean flag1 = largeRedstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            if (flag) {
                largeRedstone.placeBlocks(level, random, windOffsetter);
            }
            if (flag1) {
                largeRedstone1.placeBlocks(level, random, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeRedstone makeRedstone(class_2338 pos, boolean pointingUp, class_5819 random, int radius, class_5863 bluntness, class_5863 scale) {
        return new LargeRedstone(pos, pointingUp, radius, bluntness.method_33920(random), scale.method_33920(random));
    }

    static final class LargeRedstone {
        private class_2338 root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeRedstone(class_2338 pos, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = pos;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(class_5281 level, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                class_2338.class_2339 pos = this.root.method_25503();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (level.method_8320((class_2338)pos).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (PointedRedstoneUtils.isCircleMostlyEmbeddedInStone(level, windOffsetter.offset((class_2338)pos), this.radius)) {
                        this.root = pos;
                        return true;
                    }
                    pos.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float v) {
            return (int)PointedRedstoneUtils.getRedstoneHeight(v, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(class_5281 level, class_5819 random, WindOffsetter windOffsetter) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = class_3532.method_15355((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)random.method_43057() < 0.2) {
                        k = (int)((float)k * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 pos = this.root.method_10069(i, 0, j).method_25503();
                    boolean flag = false;
                    int l = this.pointingUp ? level.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && pos.method_10264() < l; ++i1) {
                        class_2338 blockpos = windOffsetter.offset((class_2338)pos);
                        if (PointedRedstoneUtils.isEmptyOrWaterOrLava((class_1936)level, blockpos)) {
                            flag = true;
                            class_2248 block = RuBlocks.RAW_REDSTONE_BLOCK.get();
                            level.method_8652(blockpos, block.method_9564(), 2);
                        } else if (flag && level.method_8320(blockpos).method_26164(class_3481.field_25806)) continue block1;
                        pos.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargePointedRedstoneConfiguration largeRedstoneConfiguration) {
            return this.radius >= largeRedstoneConfiguration.minRadiusForWind && this.bluntness >= (double)largeRedstoneConfiguration.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final class_243 windSpeed;

        WindOffsetter(int originY, class_5819 random, class_5863 floatProvider) {
            this.originY = originY;
            float f = floatProvider.method_33920(random);
            float f1 = class_3532.method_32750((class_5819)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new class_243((double)(class_3532.method_15362((float)f1) * f), 0.0, (double)(class_3532.method_15374((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        class_2338 offset(class_2338 pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int i = this.originY - pos.method_10264();
            class_243 vec3 = this.windSpeed.method_1021((double)i);
            return pos.method_10069(class_3532.method_15357((double)vec3.field_1352), 0, class_3532.method_15357((double)vec3.field_1350));
        }
    }
}

