/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.block.set;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2766;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7707;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.entity.custom.RuBoat;
import net.regions_unexplored.item.items.RuBoatItem;
import net.regions_unexplored.registry.BlockRegistry;
import net.regions_unexplored.registry.ItemRegistry;

public class WoodSet {
    public final boolean fireproof;
    protected Supplier<class_2248> log;
    protected Supplier<class_2248> wood;
    protected Supplier<class_2248> strippedLog;
    protected Supplier<class_2248> strippedWood;
    protected Supplier<class_2248> planks;
    protected Supplier<class_2248> stairs;
    protected Supplier<class_2248> slab;
    protected Supplier<class_2248> fence;
    protected Supplier<class_2248> fenceGate;
    protected Supplier<class_2248> door;
    protected Supplier<class_2248> trapdoor;
    protected Supplier<class_2248> pressurePlate;
    protected Supplier<class_2248> button;
    protected Supplier<class_2248> sign;
    protected Supplier<class_2248> wallSign;
    protected Supplier<class_2248> hangingSign;
    protected Supplier<class_2248> wallHangingSign;
    protected Supplier<class_1792> itemSign;
    protected Supplier<class_1792> itemHangingSign;
    protected Supplier<class_1792> itemBoat;
    protected Supplier<class_1792> itemChestBoat;

    public WoodSet(boolean fireproof) {
        this.fireproof = fireproof;
    }

    public static WoodSet simple(String name, class_4719 woodType, class_2498 sound, class_3620 colour, boolean fireproof) {
        return WoodSet.simple(name, woodType, sound, colour, colour, fireproof);
    }

    public static WoodSet simple(String name, class_4719 woodType, class_2498 sound, class_3620 plankColour, class_3620 logColour, boolean fireproof) {
        WoodSet set = new WoodSet(fireproof);
        set.log = BlockRegistry.registerDefaultBlock(name + "_log", () -> BlockRegistry.log(plankColour, logColour, sound, fireproof));
        set.wood = BlockRegistry.registerDefaultBlock(name + "_wood", () -> BlockRegistry.log(plankColour, logColour, sound, fireproof));
        set.strippedLog = BlockRegistry.registerDefaultBlock("stripped_" + name + "_log", () -> BlockRegistry.wood(plankColour, sound, fireproof));
        set.strippedWood = BlockRegistry.registerDefaultBlock("stripped_" + name + "_wood", () -> BlockRegistry.wood(plankColour, sound, fireproof));
        set.planks = BlockRegistry.registerDefaultBlock(name + "_planks", () -> BlockRegistry.planks(plankColour, sound, fireproof));
        set.stairs = BlockRegistry.registerDefaultBlock(name + "_stairs", () -> BlockRegistry.stairs(plankColour, sound, fireproof));
        set.slab = BlockRegistry.registerDefaultBlock(name + "_slab", () -> BlockRegistry.slab(plankColour, sound, fireproof));
        set.fence = BlockRegistry.registerDefaultBlock(name + "_fence", () -> BlockRegistry.fence(plankColour, sound, fireproof));
        set.fenceGate = BlockRegistry.registerDefaultBlock(name + "_fence_gate", () -> BlockRegistry.fenceGate(plankColour, woodType, sound, fireproof));
        set.door = BlockRegistry.registerDefaultBlock(name + "_door", () -> BlockRegistry.door(plankColour, sound, woodType.comp_1300(), fireproof));
        set.trapdoor = BlockRegistry.registerDefaultBlock(name + "_trapdoor", () -> BlockRegistry.trapdoor(plankColour, sound, woodType.comp_1300(), fireproof));
        set.pressurePlate = BlockRegistry.registerDefaultBlock(name + "_pressure_plate", () -> BlockRegistry.pressurePlate(plankColour, sound, woodType.comp_1300(), fireproof));
        set.button = BlockRegistry.registerDefaultBlock(name + "_button", () -> BlockRegistry.button(sound, woodType.comp_1300()));
        set.sign = BlockRegistry.registerDefaultBlockNoItem(name + "_sign", () -> BlockRegistry.sign(sound, woodType, fireproof));
        set.wallSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_sign", () -> BlockRegistry.wallSign(sound, set.sign.get(), woodType, fireproof));
        set.hangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_hanging_sign", () -> BlockRegistry.hangingSign(plankColour, sound, woodType, fireproof));
        set.wallHangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_hanging_sign", () -> BlockRegistry.wallHangingSign(plankColour, sound, set.hangingSign.get(), woodType, fireproof));
        set.itemSign = ItemRegistry.registerItem(name + "_sign", () -> new class_1822(new class_1792.class_1793().method_7889(16), set.sign.get(), set.wallSign.get()));
        set.itemHangingSign = ItemRegistry.registerItem(name + "_hanging_sign", () -> new class_7707(set.hangingSign.get(), set.wallHangingSign.get(), new class_1792.class_1793().method_7889(16)));
        if (!name.equals("cobalt")) {
            set.itemBoat = ItemRegistry.registerItem(name + "_boat", () -> new RuBoatItem(false, RuBoat.ModelType.byName(name), new class_1792.class_1793().method_7889(1)));
            set.itemChestBoat = ItemRegistry.registerItem(name + "_chest_boat", () -> new RuBoatItem(true, RuBoat.ModelType.byName(name), new class_1792.class_1793().method_7889(1)));
        }
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public static WoodSet bioshroom(String name, class_4719 woodType, class_2498 sound, class_3620 colour, boolean fireproof) {
        WoodSet set = new WoodSet(fireproof);
        set.log = BlockRegistry.registerDefaultBlock(name + "_stem", () -> BlockRegistry.log(colour, colour, sound, fireproof));
        set.wood = BlockRegistry.registerDefaultBlock(name + "_hyphae", () -> BlockRegistry.log(colour, colour, sound, fireproof));
        set.strippedLog = BlockRegistry.registerDefaultBlock("stripped_" + name + "_stem", () -> BlockRegistry.wood(colour, sound, fireproof));
        set.strippedWood = BlockRegistry.registerDefaultBlock("stripped_" + name + "_hyphae", () -> BlockRegistry.wood(colour, sound, fireproof));
        set.planks = BlockRegistry.registerDefaultBlock(name + "_planks", () -> BlockRegistry.planks(colour, sound, fireproof));
        set.stairs = BlockRegistry.registerDefaultBlock(name + "_stairs", () -> BlockRegistry.stairs(colour, sound, fireproof));
        set.slab = BlockRegistry.registerDefaultBlock(name + "_slab", () -> BlockRegistry.slab(colour, sound, fireproof));
        set.fence = BlockRegistry.registerDefaultBlock(name + "_fence", () -> BlockRegistry.fence(colour, sound, fireproof));
        set.fenceGate = BlockRegistry.registerDefaultBlock(name + "_fence_gate", () -> BlockRegistry.fenceGate(colour, woodType, sound, fireproof));
        set.door = BlockRegistry.registerDefaultBlock(name + "_door", () -> BlockRegistry.door(colour, sound, woodType.comp_1300(), fireproof));
        set.trapdoor = BlockRegistry.registerDefaultBlock(name + "_trapdoor", () -> BlockRegistry.trapdoor(colour, sound, woodType.comp_1300(), fireproof));
        set.pressurePlate = BlockRegistry.registerDefaultBlock(name + "_pressure_plate", () -> BlockRegistry.pressurePlate(colour, sound, woodType.comp_1300(), fireproof));
        set.button = BlockRegistry.registerDefaultBlock(name + "_button", () -> BlockRegistry.button(sound, woodType.comp_1300()));
        set.sign = BlockRegistry.registerDefaultBlockNoItem(name + "_sign", () -> BlockRegistry.sign(sound, woodType, fireproof));
        set.wallSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_sign", () -> BlockRegistry.wallSign(sound, set.sign.get(), woodType, fireproof));
        set.hangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_hanging_sign", () -> BlockRegistry.hangingSign(colour, sound, woodType, fireproof));
        set.wallHangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_hanging_sign", () -> BlockRegistry.wallHangingSign(colour, sound, set.hangingSign.get(), woodType, fireproof));
        set.itemSign = ItemRegistry.registerItem(name + "_sign", () -> new class_1822(new class_1792.class_1793().method_7889(16), set.sign.get(), set.wallSign.get()));
        set.itemHangingSign = ItemRegistry.registerItem(name + "_hanging_sign", () -> new class_7707(set.hangingSign.get(), set.wallHangingSign.get(), new class_1792.class_1793().method_7889(16)));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public static WoodSet alpha() {
        WoodSet set = new WoodSet(false);
        set.log = BlockRegistry.registerDefaultBlock("alpha_log", () -> new class_2248(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9632(2.0f).method_50013().method_9626(class_2498.field_11547)));
        set.planks = BlockRegistry.registerDefaultBlock("alpha_planks", () -> BlockRegistry.planks(class_3620.field_15996, class_2498.field_11547, false));
        set.stairs = BlockRegistry.registerDefaultBlock("alpha_stairs", () -> BlockRegistry.stairs(class_3620.field_15996, class_2498.field_11547, false));
        set.slab = BlockRegistry.registerDefaultBlock("alpha_slab", () -> new class_2482(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9632(1.5f).method_9626(class_2498.field_11544).method_29292()));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public static WoodSet silverBirch() {
        WoodSet set = new WoodSet(false);
        set.log = BlockRegistry.registerDefaultBlock("silver_birch_log", () -> BlockRegistry.aspenLogBlock(class_3620.field_15986, class_3620.field_16025, class_2498.field_40314));
        set.wood = BlockRegistry.registerDefaultBlock("silver_birch_wood", () -> BlockRegistry.log(class_3620.field_16025, class_3620.field_16025, class_2498.field_40314, false));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public static WoodSet ashen() {
        WoodSet set = new WoodSet(true);
        set.log = BlockRegistry.registerDefaultBlock("ashen_log", () -> BlockRegistry.log(class_3620.field_15993, class_3620.field_15978, class_2498.field_40315, true));
        set.wood = BlockRegistry.registerDefaultBlock("ashen_wood", () -> BlockRegistry.log(class_3620.field_15993, class_3620.field_15993, class_2498.field_40315, true));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public static WoodSet pine(String name, class_4719 woodType, class_2498 sound, class_3620 colour, boolean fireproof) {
        WoodSet set = new WoodSet(fireproof);
        set.log = BlockRegistry.registerDefaultBlock(name + "_log", () -> BlockRegistry.pineLog(colour, colour, sound));
        set.wood = BlockRegistry.registerDefaultBlock(name + "_wood", () -> BlockRegistry.log(colour, colour, sound, fireproof));
        set.strippedLog = BlockRegistry.registerDefaultBlock("stripped_" + name + "_log", () -> BlockRegistry.wood(colour, sound, fireproof));
        set.strippedWood = BlockRegistry.registerDefaultBlock("stripped_" + name + "_wood", () -> BlockRegistry.wood(colour, sound, fireproof));
        set.planks = BlockRegistry.registerDefaultBlock(name + "_planks", () -> BlockRegistry.planks(colour, sound, fireproof));
        set.stairs = BlockRegistry.registerDefaultBlock(name + "_stairs", () -> BlockRegistry.stairs(colour, sound, fireproof));
        set.slab = BlockRegistry.registerDefaultBlock(name + "_slab", () -> BlockRegistry.slab(colour, sound, fireproof));
        set.fence = BlockRegistry.registerDefaultBlock(name + "_fence", () -> BlockRegistry.fence(colour, sound, fireproof));
        set.fenceGate = BlockRegistry.registerDefaultBlock(name + "_fence_gate", () -> BlockRegistry.fenceGate(colour, woodType, sound, fireproof));
        set.door = BlockRegistry.registerDefaultBlock(name + "_door", () -> BlockRegistry.door(colour, sound, woodType.comp_1300(), fireproof));
        set.trapdoor = BlockRegistry.registerDefaultBlock(name + "_trapdoor", () -> BlockRegistry.trapdoor(colour, sound, woodType.comp_1300(), fireproof));
        set.pressurePlate = BlockRegistry.registerDefaultBlock(name + "_pressure_plate", () -> BlockRegistry.pressurePlate(colour, sound, woodType.comp_1300(), fireproof));
        set.button = BlockRegistry.registerDefaultBlock(name + "_button", () -> BlockRegistry.button(sound, woodType.comp_1300()));
        set.sign = BlockRegistry.registerDefaultBlockNoItem(name + "_sign", () -> BlockRegistry.sign(sound, woodType, fireproof));
        set.wallSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_sign", () -> BlockRegistry.wallSign(sound, set.sign.get(), woodType, fireproof));
        set.hangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_hanging_sign", () -> BlockRegistry.hangingSign(colour, sound, woodType, fireproof));
        set.wallHangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_hanging_sign", () -> BlockRegistry.wallHangingSign(colour, sound, set.hangingSign.get(), woodType, fireproof));
        set.itemSign = ItemRegistry.registerItem(name + "_sign", () -> new class_1822(new class_1792.class_1793().method_7889(16), set.sign.get(), set.wallSign.get()));
        set.itemHangingSign = ItemRegistry.registerItem(name + "_hanging_sign", () -> new class_7707(set.hangingSign.get(), set.wallHangingSign.get(), new class_1792.class_1793().method_7889(16)));
        set.itemBoat = ItemRegistry.registerItem(name + "_boat", () -> new RuBoatItem(false, RuBoat.ModelType.byName(name), new class_1792.class_1793().method_7889(1)));
        set.itemChestBoat = ItemRegistry.registerItem(name + "_chest_boat", () -> new RuBoatItem(true, RuBoat.ModelType.byName(name), new class_1792.class_1793().method_7889(1)));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public class_2248 getLog() {
        return this.log != null ? this.log.get() : null;
    }

    public class_2248 getWood() {
        return this.wood != null ? this.wood.get() : null;
    }

    public class_2248 getStrippedLog() {
        return this.strippedLog != null ? this.strippedLog.get() : null;
    }

    public class_2248 getStrippedWood() {
        return this.strippedWood != null ? this.strippedWood.get() : null;
    }

    public class_2248 getPlanks() {
        return this.planks != null ? this.planks.get() : null;
    }

    public class_2248 getStairs() {
        return this.stairs != null ? this.stairs.get() : null;
    }

    public class_2248 getSlab() {
        return this.slab != null ? this.slab.get() : null;
    }

    public class_2248 getFence() {
        return this.fence != null ? this.fence.get() : null;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate != null ? this.fenceGate.get() : null;
    }

    public class_2248 getDoor() {
        return this.door != null ? this.door.get() : null;
    }

    public class_2248 getTrapdoor() {
        return this.trapdoor != null ? this.trapdoor.get() : null;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate != null ? this.pressurePlate.get() : null;
    }

    public class_2248 getButton() {
        return this.button != null ? this.button.get() : null;
    }

    public class_2248 getSign() {
        return this.sign != null ? this.sign.get() : null;
    }

    public class_2248 getWallSign() {
        return this.wallSign != null ? this.wallSign.get() : null;
    }

    public class_2248 getHangingSign() {
        return this.hangingSign != null ? this.hangingSign.get() : null;
    }

    public class_2248 getWallHangingSign() {
        return this.wallHangingSign != null ? this.wallHangingSign.get() : null;
    }

    public class_1792 getBoat() {
        return this.itemBoat != null ? this.itemBoat.get() : null;
    }

    public class_1792 getChestBoat() {
        return this.itemChestBoat != null ? this.itemChestBoat.get() : null;
    }

    public List<class_1792> getAllBlocks() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        this.addItemToList(WoodSet::getLog, items);
        this.addItemToList(WoodSet::getWood, items);
        this.addItemToList(WoodSet::getStrippedLog, items);
        this.addItemToList(WoodSet::getStrippedWood, items);
        this.addItemToList(WoodSet::getPlanks, items);
        this.addItemToList(WoodSet::getStairs, items);
        this.addItemToList(WoodSet::getSlab, items);
        this.addItemToList(WoodSet::getFence, items);
        this.addItemToList(WoodSet::getFenceGate, items);
        this.addItemToList(WoodSet::getDoor, items);
        this.addItemToList(WoodSet::getTrapdoor, items);
        this.addItemToList(WoodSet::getPressurePlate, items);
        this.addItemToList(WoodSet::getButton, items);
        this.addItemToList(WoodSet::getSign, items);
        this.addItemToList(WoodSet::getHangingSign, items);
        return items;
    }

    public List<class_1792> getBuildingBlocksTabItems() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        this.addItemToList(WoodSet::getLog, items);
        this.addItemToList(WoodSet::getWood, items);
        this.addItemToList(WoodSet::getStrippedLog, items);
        this.addItemToList(WoodSet::getStrippedWood, items);
        this.addItemToList(WoodSet::getPlanks, items);
        this.addItemToList(WoodSet::getStairs, items);
        this.addItemToList(WoodSet::getSlab, items);
        this.addItemToList(WoodSet::getFence, items);
        this.addItemToList(WoodSet::getFenceGate, items);
        this.addItemToList(WoodSet::getDoor, items);
        this.addItemToList(WoodSet::getTrapdoor, items);
        this.addItemToList(WoodSet::getPressurePlate, items);
        this.addItemToList(WoodSet::getButton, items);
        return items;
    }

    public List<class_1792> getFunctionalBlocksTabItems() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        this.addItemToList(WoodSet::getSign, items);
        this.addItemToList(WoodSet::getHangingSign, items);
        return items;
    }

    public List<class_1792> getToolsAndUtilitiesTabItems() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        this.addItemToList(WoodSet::getBoat, items);
        this.addItemToList(WoodSet::getChestBoat, items);
        return items;
    }

    protected <T extends WoodSet> void addItemToList(Function<T, class_1935> getter, ArrayList<class_1792> items) {
        if (getter.apply(this) != null) {
            items.add(getter.apply(this).method_8389());
        }
    }
}

