/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.block.set;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2397;
import net.minecraft.class_2473;
import net.minecraft.class_2498;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_8813;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.block.sapling.RuTreeGrowers;
import net.regions_unexplored.registry.BlockRegistry;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.plant.sapling.RuNetherSaplingBlock;
import net.regions_unexplored.world.level.block.plant.tall.AshenShrubBlock;
import net.regions_unexplored.world.level.block.plant.tall.ShrubBlock;

public class NaturalSet {
    private static final class_4970.class_2251 BRANCH_PROPERTIES = class_4970.class_2251.method_9637().method_22488().method_9626(class_2498.field_37638).method_9629(1.0f, 1.5f).method_9624();
    private static final class_4970.class_2251 SHRUB_PROPERTIES = class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9634().method_9618().method_9626(class_2498.field_28694).method_49229(class_4970.class_2250.field_10657);
    public final boolean fireproof;
    protected Supplier<class_2248> branch;
    protected Supplier<class_2248> shrub;
    protected Supplier<class_2248> leaves;
    protected Supplier<class_2248> sapling;
    protected Supplier<class_2248> pottedSapling;

    public NaturalSet(boolean fireproof) {
        this.fireproof = fireproof;
    }

    public static NaturalSet vanilla(String name) {
        NaturalSet set = new NaturalSet(false);
        set.branch = BlockRegistry.registerDefaultBlock(name + "_branch", () -> new BranchBlock(BRANCH_PROPERTIES, BranchBlock.BranchType.BRANCH));
        set.shrub = BlockRegistry.registerDefaultBlock(name + "_shrub", () -> new ShrubBlock(SHRUB_PROPERTIES));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet full(String name, class_8813 grower) {
        return NaturalSet.full(name, class_3620.field_16004, BranchBlock.BranchType.BRANCH, false, (class_4970.class_2251 properties) -> new class_2473(grower, properties));
    }

    public static NaturalSet full(String name, class_3620 leavesColour, BranchBlock.BranchType branchType, boolean fireproof, class_8813 grower) {
        return NaturalSet.full(name, leavesColour, branchType, fireproof, (class_4970.class_2251 properties) -> new class_2473(grower, properties));
    }

    public static NaturalSet full(String name, class_3620 leavesColour, BranchBlock.BranchType branchType, boolean fireproof, Function<class_4970.class_2251, class_2248> saplingFactory) {
        return NaturalSet.full(name, branchType, fireproof, () -> BlockRegistry.leaves(leavesColour, fireproof, class_2397::new), saplingFactory);
    }

    public static <T extends class_2397> NaturalSet full(String name, BranchBlock.BranchType branchType, boolean fireproof, Supplier<class_2248> leavesFactory, Function<class_4970.class_2251, class_2248> saplingFactory) {
        NaturalSet set = new NaturalSet(fireproof);
        set.branch = BlockRegistry.registerDefaultBlock(name + "_" + branchType.method_15434(), () -> new BranchBlock(BRANCH_PROPERTIES, branchType));
        set.shrub = BlockRegistry.registerDefaultBlock(name + "_shrub", () -> new ShrubBlock(SHRUB_PROPERTIES));
        set.leaves = BlockRegistry.registerDefaultBlock(name + "_leaves", leavesFactory);
        set.sapling = BlockRegistry.registerDefaultBlock(name + "_sapling", () -> (class_2248)saplingFactory.apply(class_4970.class_2251.method_9630((class_4970)class_2246.field_10394)));
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_" + name + "_sapling", () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet fullWithoutBranch(String name, class_3620 leavesColour, boolean fireproof, class_8813 grower) {
        return NaturalSet.fullWithoutBranch(name, leavesColour, fireproof, (class_4970.class_2251 properties) -> new class_2473(grower, properties));
    }

    public static NaturalSet fullWithoutBranch(String name, class_3620 leavesColour, boolean fireproof, Function<class_4970.class_2251, class_2248> saplingFactory) {
        return NaturalSet.fullWithoutBranch(name, fireproof, () -> BlockRegistry.leaves(leavesColour, fireproof, class_2397::new), saplingFactory);
    }

    public static NaturalSet fullWithoutBranch(String name, boolean fireproof, Supplier<class_2248> leavesFactory, Function<class_4970.class_2251, class_2248> saplingFactory) {
        NaturalSet set = new NaturalSet(fireproof);
        set.shrub = BlockRegistry.registerDefaultBlock(name + "_shrub", () -> new ShrubBlock(SHRUB_PROPERTIES));
        set.leaves = BlockRegistry.registerDefaultBlock(name + "_leaves", leavesFactory);
        set.sapling = BlockRegistry.registerDefaultBlock(name + "_sapling", () -> (class_2248)saplingFactory.apply(class_4970.class_2251.method_9630((class_4970)class_2246.field_10394)));
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_" + name + "_sapling", () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet leavesAndSaplings(String name, Function<class_4970.class_2251, class_2248> leavesFactory, class_8813 grower) {
        NaturalSet set = new NaturalSet(false);
        set.leaves = BlockRegistry.registerDefaultBlock(name + "_leaves", () -> BlockRegistry.leaves(class_3620.field_16004, false, leavesFactory));
        set.sapling = BlockRegistry.registerDefaultBlock(name + "_sapling", () -> new class_2473(grower, class_4970.class_2251.method_9630((class_4970)class_2246.field_10394)));
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_" + name + "_sapling", () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet onlySapling(String name, Supplier<class_2248> saplingFactory) {
        NaturalSet set = new NaturalSet(false);
        set.sapling = BlockRegistry.registerDefaultBlock(name, saplingFactory);
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_" + name, () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet ashen() {
        NaturalSet set = new NaturalSet(false);
        set.shrub = BlockRegistry.registerDefaultBlock("ashen_shrub", () -> new AshenShrubBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_9618().method_9626(class_2498.field_28700).method_49229(class_4970.class_2250.field_10657).method_26247((bs, br, bp) -> true).method_26249((bs, br, bp) -> true)));
        set.leaves = BlockRegistry.registerDefaultBlock("ashen_leaves", () -> BlockRegistry.leaves(class_3620.field_15993));
        set.sapling = BlockRegistry.registerDefaultBlock("ashen_sapling", () -> new class_2473(RuTreeGrowers.ASHEN, class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9634().method_9618().method_9626(class_2498.field_11535).method_9640()));
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_ashen_sapling", () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public static NaturalSet cobalt() {
        NaturalSet set = new NaturalSet(false);
        set.sapling = BlockRegistry.registerDefaultBlock("cobalt_sapling", () -> new RuNetherSaplingBlock(RuTreeGrowers.COBALT, class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9634().method_9618().method_9626(class_2498.field_22147).method_9640()));
        set.leaves = BlockRegistry.registerDefaultBlock("cobalt_webbing", () -> BlockRegistry.leaves(class_3620.field_15984, true, class_2397::new));
        set.pottedSapling = BlockRegistry.registerDefaultBlockNoItem("potted_cobalt_sapling", () -> new class_2362(set.sapling.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10468)));
        RuBlocks.NATURAL_SETS.add(set);
        return set;
    }

    public class_2248 getBranch() {
        return this.branch != null ? this.branch.get() : null;
    }

    public class_2248 getShrub() {
        return this.shrub != null ? this.shrub.get() : null;
    }

    public class_2248 getLeaves() {
        return this.leaves != null ? this.leaves.get() : null;
    }

    public class_2248 getSapling() {
        return this.sapling != null ? this.sapling.get() : null;
    }

    public class_2248 getPottedSapling() {
        return this.pottedSapling != null ? this.pottedSapling.get() : null;
    }
}

