/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.block.set;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_7707;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.block.set.WoodSet;
import net.regions_unexplored.registry.BlockRegistry;
import net.regions_unexplored.registry.ItemRegistry;
import net.regions_unexplored.world.level.block.wood.MagmaLogBlock;

public class BrimwoodWoodSet
extends WoodSet {
    protected Supplier<class_2248> logMagma;

    public BrimwoodWoodSet(boolean fireproof) {
        super(fireproof);
    }

    public static BrimwoodWoodSet brimwood(String name, class_4719 woodType, class_2498 sound, class_3620 plankColour, class_3620 logColour, boolean fireproof) {
        BrimwoodWoodSet set = new BrimwoodWoodSet(fireproof);
        set.log = BlockRegistry.registerDefaultBlock(name + "_log", () -> BlockRegistry.log(plankColour, logColour, sound, fireproof));
        set.logMagma = BlockRegistry.registerDefaultBlock(name + "_log_magma", () -> BlockRegistry.block(2.0f, 2.0f, plankColour, sound, fireproof, MagmaLogBlock::new));
        set.wood = BlockRegistry.registerDefaultBlock(name + "_wood", () -> BlockRegistry.log(plankColour, logColour, sound, fireproof));
        set.strippedLog = BlockRegistry.registerDefaultBlock("stripped_" + name + "_log", () -> BlockRegistry.wood(plankColour, sound, fireproof));
        set.strippedWood = BlockRegistry.registerDefaultBlock("stripped_" + name + "_wood", () -> BlockRegistry.wood(plankColour, sound, fireproof));
        set.planks = BlockRegistry.registerDefaultBlock(name + "_planks", () -> BlockRegistry.planks(plankColour, sound, fireproof));
        set.stairs = BlockRegistry.registerDefaultBlock(name + "_stairs", () -> BlockRegistry.stairs(plankColour, sound, fireproof));
        set.slab = BlockRegistry.registerDefaultBlock(name + "_slab", () -> BlockRegistry.slab(plankColour, sound, fireproof));
        set.fence = BlockRegistry.registerDefaultBlock(name + "_fence", () -> BlockRegistry.fence(plankColour, sound, fireproof));
        set.fenceGate = BlockRegistry.registerDefaultBlock(name + "_fence_gate", () -> BlockRegistry.fenceGate(plankColour, woodType, sound, fireproof));
        set.door = BlockRegistry.registerDefaultBlock(name + "_door", () -> BlockRegistry.door(plankColour, sound, woodType.comp_1300(), fireproof));
        set.trapdoor = BlockRegistry.registerDefaultBlock(name + "_trapdoor", () -> BlockRegistry.trapdoor(plankColour, sound, woodType.comp_1300(), fireproof));
        set.pressurePlate = BlockRegistry.registerDefaultBlock(name + "_pressure_plate", () -> BlockRegistry.pressurePlate(plankColour, sound, woodType.comp_1300(), fireproof));
        set.button = BlockRegistry.registerDefaultBlock(name + "_button", () -> BlockRegistry.button(sound, woodType.comp_1300()));
        set.sign = BlockRegistry.registerDefaultBlockNoItem(name + "_sign", () -> BlockRegistry.sign(sound, woodType, fireproof));
        set.wallSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_sign", () -> BlockRegistry.wallSign(sound, (class_2248)set.sign.get(), woodType, fireproof));
        set.hangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_hanging_sign", () -> BlockRegistry.hangingSign(plankColour, sound, woodType, fireproof));
        set.wallHangingSign = BlockRegistry.registerDefaultBlockNoItem(name + "_wall_hanging_sign", () -> BlockRegistry.wallHangingSign(plankColour, sound, (class_2248)set.hangingSign.get(), woodType, fireproof));
        set.itemSign = ItemRegistry.registerItem(name + "_sign", () -> new class_1822(new class_1792.class_1793().method_7889(16), (class_2248)set.sign.get(), (class_2248)set.wallSign.get()));
        set.itemHangingSign = ItemRegistry.registerItem(name + "_hanging_sign", () -> new class_7707((class_2248)set.hangingSign.get(), (class_2248)set.wallHangingSign.get(), new class_1792.class_1793().method_7889(16)));
        RuBlocks.WOOD_SETS.add(set);
        return set;
    }

    public class_2248 getLogMagma() {
        return this.logMagma != null ? this.logMagma.get() : null;
    }

    @Override
    public List<class_1792> getBuildingBlocksTabItems() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        this.addItemToList(WoodSet::getLog, items);
        this.addItemToList(BrimwoodWoodSet::getLogMagma, items);
        this.addItemToList(WoodSet::getWood, items);
        this.addItemToList(WoodSet::getStrippedLog, items);
        this.addItemToList(WoodSet::getStrippedWood, items);
        this.addItemToList(WoodSet::getPlanks, items);
        this.addItemToList(WoodSet::getStairs, items);
        this.addItemToList(WoodSet::getSlab, items);
        this.addItemToList(WoodSet::getFence, items);
        this.addItemToList(WoodSet::getFenceGate, items);
        this.addItemToList(WoodSet::getDoor, items);
        this.addItemToList(WoodSet::getTrapdoor, items);
        this.addItemToList(WoodSet::getPressurePlate, items);
        this.addItemToList(WoodSet::getButton, items);
        return items;
    }
}

