/*
 * Decompiled with CFR 0.152.
 */
package com.example.cobblemonsidemod.network;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.example.cobblemonsidemod.ArreglandoCobblemon;
import com.example.cobblemonsidemod.managers.EvolutionDecisionManager;
import com.example.cobblemonsidemod.managers.PendingMovesManager;
import com.example.cobblemonsidemod.network.packet.ClientboundEvolutionPromptPacket;
import com.example.cobblemonsidemod.network.packet.ClientboundMoveSelectionPacket;
import com.example.cobblemonsidemod.network.packet.ServerboundEvolutionCompletePacket;
import com.example.cobblemonsidemod.network.packet.ServerboundEvolutionDecisionPacket;
import com.example.cobblemonsidemod.network.packet.ServerboundMoveSelectionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J-\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ'\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/example/cobblemonsidemod/network/NetworkHandler;", "", "<init>", "()V", "", "register", "Lnet/minecraft/class_3222;", "player", "Ljava/util/UUID;", "pokemonId", "", "selectedIndex", "", "newMoveName", "handleServerMoveSelectionPublic", "(Lnet/minecraft/class_3222;Ljava/util/UUID;ILjava/lang/String;)V", "handleServerMoveSelection", "Lcom/cobblemon/mod/common/api/moves/MoveSet;", "moveSet", "sendNextMoveIfExists", "(Lnet/minecraft/class_3222;Ljava/util/UUID;Lcom/cobblemon/mod/common/api/moves/MoveSet;)V", "Lcom/example/cobblemonsidemod/network/packet/ClientboundEvolutionPromptPacket;", "packet", "sendEvoPrompt", "(Lnet/minecraft/class_3222;Lcom/example/cobblemonsidemod/network/packet/ClientboundEvolutionPromptPacket;)V", "Lcom/example/cobblemonsidemod/network/packet/ClientboundMoveSelectionPacket;", "sendMoveSelection", "(Lnet/minecraft/class_3222;Lcom/example/cobblemonsidemod/network/packet/ClientboundMoveSelectionPacket;)V", "DONT_LEARN_INDEX", "I", "arreglandocobblemon"})
@SourceDebugExtension(value={"SMAP\nNetworkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkHandler.kt\ncom/example/cobblemonsidemod/network/NetworkHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1563#3:178\n1634#3,3:179\n*S KotlinDebug\n*F\n+ 1 NetworkHandler.kt\ncom/example/cobblemonsidemod/network/NetworkHandler\n*L\n131#1:178\n131#1:179,3\n*E\n"})
public final class NetworkHandler {
    @NotNull
    public static final NetworkHandler INSTANCE = new NetworkHandler();
    private static final int DONT_LEARN_INDEX = -1;

    private NetworkHandler() {
    }

    public final void register() {
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] NetworkHandler.register() called");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ServerboundEvolutionDecisionPacket.Companion.getTYPE(), ServerboundEvolutionDecisionPacket.Companion.getCODEC(), NetworkHandler::register$lambda$0);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ServerboundEvolutionCompletePacket.Companion.getTYPE(), ServerboundEvolutionCompletePacket.Companion.getCODEC(), NetworkHandler::register$lambda$1);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ServerboundMoveSelectionPacket.Companion.getTYPE(), ServerboundMoveSelectionPacket.Companion.getCODEC(), NetworkHandler::register$lambda$2);
    }

    public final void handleServerMoveSelectionPublic(@NotNull class_3222 player, @NotNull UUID pokemonId, int selectedIndex, @NotNull String newMoveName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)newMoveName, (String)"newMoveName");
        try {
            Object v0;
            block8: {
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                Iterable iterable = (Iterable)party;
                for (Object t : iterable) {
                    Pokemon it = (Pokemon)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)pokemonId)) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            Pokemon pokemon = v0;
            if (pokemon == null) {
                return;
            }
            Pokemon pokemon2 = pokemon;
            MoveSet moveSet = pokemon2.getMoveSet();
            if (PendingMovesManager.hasPendingMoves(pokemonId)) {
                String processedMove = PendingMovesManager.getNextPendingMove(pokemonId);
                ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] Processed pending move: " + processedMove + " for " + pokemon2.getSpecies().getName());
            }
            if (selectedIndex == -1) {
                ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] Player chose NOT to learn " + newMoveName);
                this.sendNextMoveIfExists(player, pokemonId, moveSet);
                return;
            }
            List moves = moveSet.getMoves();
            if (!(0 <= selectedIndex ? selectedIndex < ((Collection)moves).size() : false)) {
                return;
            }
            MoveTemplate moveTemplate = Moves.getByName((String)newMoveName);
            if (moveTemplate == null) {
                return;
            }
            MoveTemplate template = moveTemplate;
            moveSet.setMove(selectedIndex, template.create());
            this.sendNextMoveIfExists(player, pokemonId, moveSet);
        }
        catch (Exception e) {
            ArreglandoCobblemon.INSTANCE.getLOGGER().error("Error handling move selection", (Throwable)e);
        }
    }

    private final void handleServerMoveSelection(class_3222 player, UUID pokemonId, int selectedIndex, String newMoveName) {
        this.handleServerMoveSelectionPublic(player, pokemonId, selectedIndex, newMoveName);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendNextMoveIfExists(class_3222 player, UUID pokemonId, MoveSet moveSet) {
        Object v1;
        List moveNames;
        String nextMove;
        block4: {
            Pokemon it;
            void $this$mapTo$iv$iv;
            String string = PendingMovesManager.peekNextPendingMove(pokemonId);
            if (string == null) {
                return;
            }
            nextMove = string;
            Iterable $this$map$iv = moveSet.getMoves();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Move move = (Move)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            moveNames = (List)destination$iv$iv;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable iterable2 = (Iterable)party;
            for (Object t : iterable2) {
                it = (Pokemon)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)pokemonId)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        Pokemon pokemon = v1;
        if (pokemon == null) {
            return;
        }
        Pokemon pokemon2 = pokemon;
        String speciesName = pokemon2.getSpecies().getName();
        ClientboundMoveSelectionPacket packet = new ClientboundMoveSelectionPacket(pokemonId, speciesName, moveNames, nextMove);
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)packet);
    }

    public final void sendEvoPrompt(@NotNull class_3222 player, @NotNull ClientboundEvolutionPromptPacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] NetworkHandler.sendEvoPrompt: Sending to " + player.method_5477().getString() + " - " + packet.getPokemonName() + " -> " + packet.getEvolutionName());
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)packet);
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] NetworkHandler.sendEvoPrompt: sendToPlayer called successfully");
        }
        catch (Exception e) {
            ArreglandoCobblemon.INSTANCE.getLOGGER().error("[DEBUG] NetworkHandler.sendEvoPrompt: ERROR", (Throwable)e);
        }
    }

    public final void sendMoveSelection(@NotNull class_3222 player, @NotNull ClientboundMoveSelectionPacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] NetworkHandler.sendMoveSelection: Sending to " + player.method_5477().getString() + " for " + packet.getPokemonSpecies() + " new move " + packet.getNewMove());
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)packet);
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] NetworkHandler.sendMoveSelection: sendToPlayer called successfully");
        }
        catch (Exception e) {
            ArreglandoCobblemon.INSTANCE.getLOGGER().error("[DEBUG] NetworkHandler.sendMoveSelection: ERROR", (Throwable)e);
        }
    }

    private static final void register$lambda$0(ServerboundEvolutionDecisionPacket packet, NetworkManager.PacketContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        context.queue(() -> NetworkHandler.register$lambda$0$0(context, packet));
    }

    private static final void register$lambda$0$0(NetworkManager.PacketContext $context, ServerboundEvolutionDecisionPacket $packet) {
        class_1657 class_16572 = $context.getPlayer();
        Intrinsics.checkNotNull((Object)class_16572, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        EvolutionDecisionManager.executeHandler((class_3222)class_16572, $packet.getPokemonId(), $packet.getAccept());
    }

    private static final void register$lambda$1(ServerboundEvolutionCompletePacket packet, NetworkManager.PacketContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        context.queue(() -> NetworkHandler.register$lambda$1$0(packet, context));
    }

    private static final void register$lambda$1$0(ServerboundEvolutionCompletePacket $packet, NetworkManager.PacketContext $context) {
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("[DEBUG] Received Evolution Complete Confirmation for " + $packet.getPokemonId());
        class_1657 class_16572 = $context.getPlayer();
        Intrinsics.checkNotNull((Object)class_16572, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        class_3222 player = (class_3222)class_16572;
        EvolutionDecisionManager.PendingEvolution pending = EvolutionDecisionManager.getPendingEvolution($packet.getPokemonId());
        if (pending != null) {
            EvolutionDecisionManager.executeHandler(player, $packet.getPokemonId(), true);
        }
    }

    private static final void register$lambda$2(ServerboundMoveSelectionPacket packet, NetworkManager.PacketContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        context.queue(() -> NetworkHandler.register$lambda$2$0(context, packet));
    }

    private static final void register$lambda$2$0(NetworkManager.PacketContext $context, ServerboundMoveSelectionPacket $packet) {
        class_1657 class_16572 = $context.getPlayer();
        Intrinsics.checkNotNull((Object)class_16572, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        INSTANCE.handleServerMoveSelection((class_3222)class_16572, $packet.getPokemonId(), $packet.getSelectedIndex(), $packet.getNewMoveName());
    }
}

