/*
 * Decompiled with CFR 0.152.
 */
package com.example.cobblemonsidemod.client;

import com.example.cobblemonsidemod.ArreglandoCobblemon;
import com.example.cobblemonsidemod.client.gui.EvolutionConfirmationScreen;
import com.example.cobblemonsidemod.client.gui.MoveSelectionScreen;
import com.example.cobblemonsidemod.network.packet.ClientboundEvolutionPromptPacket;
import com.example.cobblemonsidemod.network.packet.ClientboundMoveSelectionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\u0003\u00a8\u0006\r"}, d2={"Lcom/example/cobblemonsidemod/client/ArreglandoCobblemonClient;", "", "<init>", "()V", "Lcom/example/cobblemonsidemod/network/packet/ClientboundEvolutionPromptPacket;", "packet", "", "handleEvolutionPrompt", "(Lcom/example/cobblemonsidemod/network/packet/ClientboundEvolutionPromptPacket;)V", "Lcom/example/cobblemonsidemod/network/packet/ClientboundMoveSelectionPacket;", "handleMoveSelection", "(Lcom/example/cobblemonsidemod/network/packet/ClientboundMoveSelectionPacket;)V", "init", "arreglandocobblemon"})
public final class ArreglandoCobblemonClient {
    @NotNull
    public static final ArreglandoCobblemonClient INSTANCE = new ArreglandoCobblemonClient();

    private ArreglandoCobblemonClient() {
    }

    public final void handleEvolutionPrompt(@NotNull ClientboundEvolutionPromptPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("Client received Evolution Prompt packet for " + packet.getPokemonName() + " -> " + packet.getEvolutionName());
        UUID pokemonId = packet.getPokemonId();
        String pokemonName = packet.getPokemonName();
        String evolutionName = packet.getEvolutionName();
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("Attempting to open EvolutionConfirmationScreen on main thread with pokemonId: " + pokemonId + ", pokemonName: " + pokemonName + ", evolutionName: " + evolutionName);
        try {
            class_310.method_1551().method_1507((class_437)new EvolutionConfirmationScreen(pokemonId, pokemonName, evolutionName));
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("Successfully requested EvolutionConfirmationScreen to open.");
        }
        catch (Exception e) {
            ArreglandoCobblemon.INSTANCE.getLOGGER().error("Error opening EvolutionConfirmationScreen", (Throwable)e);
        }
    }

    public final void handleMoveSelection(@NotNull ClientboundMoveSelectionPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("Client received Move Selection packet for " + packet.getNewMove() + " (Pokemon: " + packet.getPokemonSpecies() + ")");
        UUID pokemonId = packet.getPokemonId();
        String pokemonSpecies = packet.getPokemonSpecies();
        List<String> currentMoves = packet.getCurrentMoves();
        String newMove = packet.getNewMove();
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("Attempting to open MoveSelectionScreen on main thread with pokemonId: " + pokemonId + ", pokemonSpecies: " + pokemonSpecies + ", currentMoves: " + currentMoves + ", newMove: " + newMove);
        try {
            class_310.method_1551().method_1507((class_437)new MoveSelectionScreen(pokemonId, pokemonSpecies, currentMoves, newMove));
            ArreglandoCobblemon.INSTANCE.getLOGGER().info("Successfully requested MoveSelectionScreen to open.");
        }
        catch (Exception e) {
            ArreglandoCobblemon.INSTANCE.getLOGGER().error("Error opening MoveSelectionScreen", (Throwable)e);
        }
    }

    public final void init() {
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("Initializing ArreglandoCobblemonClient");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, ClientboundEvolutionPromptPacket.Companion.getTYPE(), ClientboundEvolutionPromptPacket.Companion.getCODEC(), ArreglandoCobblemonClient::init$lambda$0);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, ClientboundMoveSelectionPacket.Companion.getTYPE(), ClientboundMoveSelectionPacket.Companion.getCODEC(), ArreglandoCobblemonClient::init$lambda$1);
        ArreglandoCobblemon.INSTANCE.getLOGGER().info("=== ARREGLANDO COBBLEMON CLIENT INITIALIZED ===");
    }

    private static final void init$lambda$0(ClientboundEvolutionPromptPacket packet, NetworkManager.PacketContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        context.queue(() -> ArreglandoCobblemonClient.init$lambda$0$0(packet));
    }

    private static final void init$lambda$0$0(ClientboundEvolutionPromptPacket $packet) {
        INSTANCE.handleEvolutionPrompt($packet);
    }

    private static final void init$lambda$1(ClientboundMoveSelectionPacket packet, NetworkManager.PacketContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        context.queue(() -> ArreglandoCobblemonClient.init$lambda$1$0(packet));
    }

    private static final void init$lambda$1$0(ClientboundMoveSelectionPacket $packet) {
        INSTANCE.handleMoveSelection($packet);
    }
}

