/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.gachamachine.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hisroyalty.gachamachine.GachaMachine;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class DatapackConfigData {
    private static final Codec<Map<String, Integer>> CONFIG_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT);
    private static final Map<String, Integer> gachaMachineCurrencyLimits = new HashMap<String, Integer>();
    private static final Map<String, Integer> gachaMachineCooldowns = new HashMap<String, Integer>();
    private static final Map<String, Integer> gachaMachineUsesBeforeCooldowns = new HashMap<String, Integer>();
    private static final int DEFAULT_COOLDOWN = 0;
    private static final int DEFAULT_USES_BEFORE_COOLDOWN = 1;
    private static boolean pickupOnDispense = false;

    public static void reload(class_3300 resourceManager) {
        gachaMachineCurrencyLimits.clear();
        gachaMachineCooldowns.clear();
        gachaMachineUsesBeforeCooldowns.clear();
        pickupOnDispense = false;
        Map resources = resourceManager.method_14488("config", path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            if (!id.method_12832().equals("config/server_config.json")) continue;
            try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                JsonElement json;
                JsonElement forCodec = json = JsonParser.parseReader((Reader)reader);
                if (json.isJsonObject()) {
                    JsonObject obj = json.getAsJsonObject();
                    if (obj.has("pickup") && obj.get("pickup").isJsonPrimitive()) {
                        try {
                            pickupOnDispense = obj.get("pickup").getAsBoolean();
                        }
                        catch (Exception ignored) {
                            pickupOnDispense = false;
                        }
                    }
                    if (obj.has("cooldowns") && obj.get("cooldowns").isJsonObject()) {
                        JsonObject cooldownsJson = obj.getAsJsonObject("cooldowns");
                        DataResult cooldownResult = CONFIG_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)cooldownsJson);
                        cooldownResult.resultOrPartial(System.err::println).ifPresentOrElse(gachaMachineCooldowns::putAll, () -> GachaMachine.LOGGER.warn("Failed to load cooldowns for gacha machines: {}", (Object)id));
                    }
                    if (obj.has("usesBeforeCooldown") && obj.get("usesBeforeCooldown").isJsonObject()) {
                        JsonObject usesJson = obj.getAsJsonObject("usesBeforeCooldown");
                        DataResult usesResult = CONFIG_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)usesJson);
                        usesResult.resultOrPartial(System.err::println).ifPresentOrElse(gachaMachineUsesBeforeCooldowns::putAll, () -> GachaMachine.LOGGER.warn("Failed to load usesBeforeCooldown for gacha machines: {}", (Object)id));
                    }
                    JsonObject limitsObj = obj.deepCopy();
                    limitsObj.remove("pickup");
                    limitsObj.remove("cooldowns");
                    limitsObj.remove("usesBeforeCooldown");
                    forCodec = limitsObj;
                }
                DataResult result = CONFIG_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)forCodec);
                result.resultOrPartial(System.err::println).ifPresentOrElse(gachaMachineCurrencyLimits::putAll, () -> GachaMachine.LOGGER.warn("Failed to load config for gacha machine: {}", (Object)id));
                GachaMachine.LOGGER.info("Loaded config for gacha machine: {} (pickup={})", (Object)id, (Object)pickupOnDispense);
            }
            catch (Exception e) {
                GachaMachine.LOGGER.error("Failed to load config for gacha machine: {}", (Object)id, (Object)e);
            }
        }
    }

    public static int getMaxCurrency(String machineId) {
        return gachaMachineCurrencyLimits.getOrDefault(machineId, 5);
    }

    public static int getCooldown(String machineId) {
        return gachaMachineCooldowns.getOrDefault(machineId, 0);
    }

    public static int getUsesBeforeCooldown(String machineId) {
        return gachaMachineUsesBeforeCooldowns.getOrDefault(machineId, 1);
    }

    public static boolean shouldPickupOnDispense() {
        return pickupOnDispense;
    }
}

