/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.gachamachine.block;

import com.hisroyalty.gachamachine.GachaMachine;
import com.hisroyalty.gachamachine.GachaMachineRegistries;
import com.hisroyalty.gachamachine.block.GachaMachineBlockEntity;
import com.hisroyalty.gachamachine.config.DatapackConfigData;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GachaMachineBlock
extends class_2237
implements class_3954 {
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    private final class_6862<class_1792> currencyTag;
    private final String loot;
    private final int configProperty;
    private final Supplier<class_2591<GachaMachineBlockEntity>> blockEntityTypeSupplier;

    public GachaMachineBlock(class_4970.class_2251 properties, class_6862<class_1792> currencyTag, String loot, int configProperty, Supplier<class_2591<GachaMachineBlockEntity>> blockEntityTypeSupplier) {
        super(properties);
        this.currencyTag = currencyTag;
        this.loot = loot;
        this.configProperty = configProperty;
        this.blockEntityTypeSupplier = blockEntityTypeSupplier;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{HALF});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(HALF, (Comparable)class_2756.field_12607);
    }

    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return;
        }
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(pos = GachaMachineBlock.getLowerPos(state, pos));
            if (blockEntity instanceof GachaMachineBlockEntity) {
                level.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, level, pos, newState, movedByPiston);
        }
    }

    private static String machineKey(int index) {
        return "gacha_machine_" + index;
    }

    public static int deserializeCooldown(int index) {
        return DatapackConfigData.getCooldown(GachaMachineBlock.machineKey(index)) * 20;
    }

    public static int deserializeUsesBeforeCooldown(int index) {
        return DatapackConfigData.getUsesBeforeCooldown(GachaMachineBlock.machineKey(index));
    }

    public static int deserializeLevel(int index) {
        return DatapackConfigData.getMaxCurrency(GachaMachineBlock.machineKey(index));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.field_9236) {
            return null;
        }
        if (state.method_11654(HALF) != class_2756.field_12607) {
            return null;
        }
        return (w, pos, st, be) -> {
            if (be instanceof GachaMachineBlockEntity) {
                GachaMachineBlockEntity g = (GachaMachineBlockEntity)be;
                GachaMachineBlockEntity.tick(w, pos, st, g);
            }
        };
    }

    public boolean isValidCurrency(class_1799 stack) {
        return stack.method_31573(this.currencyTag);
    }

    public class_6862<class_1792> getCurrencyTag() {
        return this.currencyTag;
    }

    protected boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return level.method_8320(pos.method_10084()).method_45474();
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return Collections.emptyList();
        }
        return super.method_9560(state, builder);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (!level.method_8608()) {
            level.method_8652(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        }
        super.method_9567(level, pos, state, placer, stack);
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            boolean valid = true;
            class_2756 half = (class_2756)state.method_11654(HALF);
            if (!(half != class_2756.field_12607 || direction != class_2350.field_11036 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12609)) {
                valid = false;
            }
            if (!(half != class_2756.field_12609 || direction != class_2350.field_11033 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12607)) {
                valid = false;
            }
            if (!valid) {
                return class_2246.field_10124.method_9564();
            }
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    private boolean isValidItem(class_1799 stack, class_1937 level) {
        if (level.field_9236) {
            return false;
        }
        return stack.method_31573(this.currencyTag);
    }

    public boolean processCurrencyInsertion(class_3218 level, class_2338 pos, class_1799 currencyStack, @Nullable class_1657 player, GachaMachineBlockEntity be) {
        int maxLevel;
        class_2680 state = level.method_8320(pos);
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
            state = level.method_8320(pos);
        }
        if (be == null) {
            return false;
        }
        if (be.getCooldown() > 0) {
            if (player != null) {
                int secondsLeft = (be.getCooldown() + 19) / 20;
                class_5250 message = class_2561.method_43469((String)"message.gacha_machine.cooldown", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(secondsLeft)).method_27692(class_124.field_1061)}).method_27692(class_124.field_1061);
                player.method_7353((class_2561)message, true);
            }
            return false;
        }
        if (!this.isValidItem(currencyStack, (class_1937)level)) {
            if (player != null) {
                class_5250 message;
                StringBuilder itemNames = new StringBuilder();
                Iterable currencyItems = level.method_30349().method_30530(class_7924.field_41197).method_40286(this.currencyTag);
                boolean hasItems = false;
                for (class_6880 holder : currencyItems) {
                    class_1792 item = (class_1792)holder.comp_349();
                    String itemName = item.method_7848().getString();
                    if (hasItems) {
                        itemNames.append(", ");
                    }
                    itemNames.append(itemName);
                    hasItems = true;
                }
                if (!hasItems) {
                    itemNames.append("No valid currencies");
                }
                player.method_7353((class_2561)message, (message = class_2561.method_43469((String)"message.gacha_machine.invalid_currency", (Object[])new Object[]{class_2561.method_43470((String)itemNames.toString()).method_27692(class_124.field_1061)}).method_27692(class_124.field_1061)).getString().length() <= 128);
            }
            return false;
        }
        int currentLevel = be.getGachaLevel();
        if (currentLevel < (maxLevel = GachaMachineBlock.deserializeLevel(this.configProperty)) - 1) {
            be.setGachaLevel(currentLevel + 1);
            if (player != null && !level.method_8608()) {
                class_5250 text = class_2561.method_43470((String)"[").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(currentLevel + 1))).method_10852((class_2561)class_2561.method_43470((String)"/")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(maxLevel))).method_10852((class_2561)class_2561.method_43470((String)"]"));
                player.method_7353((class_2561)text, true);
            }
            if (player == null) {
                class_1799 s = be.method_5438(0);
                if (!s.method_7960()) {
                    s.method_7934(1);
                    be.method_5447(0, s);
                }
            } else if (!player.method_7337()) {
                currencyStack.method_7934(1);
            }
            level.method_8396(null, pos, class_3417.field_24064, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (!level.method_8608()) {
            List<class_1799> capsules = this.getOutput(player, level, pos);
            if (capsules.isEmpty() && player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.gacha_machine.dud").method_27692(class_124.field_1061), true);
            }
            if (player == null) {
                class_1799 s = be.method_5438(0);
                if (!s.method_7960()) {
                    s.method_7934(1);
                    be.method_5447(0, s);
                }
            } else if (!player.method_7337()) {
                currencyStack.method_7934(1);
            }
            class_2350 facing = state.method_28498(FACING) ? (class_2350)state.method_11654(FACING) : class_2350.field_11043;
            for (class_1799 capsule : capsules) {
                class_1542 itemEntity;
                class_243 spawnPos;
                if (capsule.method_7947() > 1) {
                    Random random = new Random();
                    int messageIndex = random.nextInt(4) + 1;
                    class_5250 message = class_2561.method_43469((String)("message.gacha_machine.multiple_rewards_" + messageIndex), (Object[])new Object[]{class_2561.method_43470((String)capsule.method_7909().method_7864(capsule).getString())}).method_27692(class_124.field_1065);
                    if (player != null) {
                        player.method_7353((class_2561)message, false);
                    }
                }
                boolean insertedBelow = false;
                class_2338 belowPos = pos.method_10074();
                class_2586 belowEntity = level.method_8321(belowPos);
                if (belowEntity instanceof class_1278) {
                    int[] slots;
                    class_1278 sidedBelow = (class_1278)belowEntity;
                    for (int slot : slots = sidedBelow.method_5494(class_2350.field_11036)) {
                        if (!sidedBelow.method_5492(slot, capsule, class_2350.field_11036)) continue;
                        class_1799 existing = sidedBelow.method_5438(slot);
                        int max = Math.min(existing.method_7914(), sidedBelow.method_5444());
                        if (existing.method_7960()) {
                            sidedBelow.method_5447(slot, capsule.method_7972());
                            insertedBelow = true;
                            break;
                        }
                        if (!class_1799.method_31577((class_1799)existing, (class_1799)capsule) || existing.method_7947() + capsule.method_7947() > max) continue;
                        existing.method_7933(capsule.method_7947());
                        sidedBelow.method_5447(slot, existing);
                        insertedBelow = true;
                        break;
                    }
                    if (insertedBelow) {
                        continue;
                    }
                } else if (belowEntity instanceof class_1263) {
                    class_1263 invBelow = (class_1263)belowEntity;
                    for (int i = 0; i < invBelow.method_5439(); ++i) {
                        class_1799 existing = invBelow.method_5438(i);
                        if (existing.method_7960()) {
                            invBelow.method_5447(i, capsule.method_7972());
                            insertedBelow = true;
                            break;
                        }
                        if (!class_1799.method_31577((class_1799)existing, (class_1799)capsule) || existing.method_7947() + capsule.method_7947() > existing.method_7914()) continue;
                        existing.method_7933(capsule.method_7947());
                        invBelow.method_5447(i, existing);
                        insertedBelow = true;
                        break;
                    }
                    if (insertedBelow) continue;
                }
                if (player != null) {
                    if (DatapackConfigData.shouldPickupOnDispense()) {
                        class_1799 remainder = capsule.method_7972();
                        player.method_31548().method_7394(remainder);
                        if (remainder.method_7960()) continue;
                        spawnPos = pos.method_10093(facing).method_46558();
                        itemEntity = new class_1542((class_1937)level, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, remainder);
                        itemEntity.method_6988();
                        level.method_8649((class_1297)itemEntity);
                        continue;
                    }
                    class_243 spawnPos2 = pos.method_10093(facing).method_46558();
                    class_1542 itemEntity2 = new class_1542((class_1937)level, spawnPos2.field_1352, spawnPos2.field_1351, spawnPos2.field_1350, capsule.method_7972());
                    itemEntity2.method_6988();
                    level.method_8649((class_1297)itemEntity2);
                    continue;
                }
                class_1799 outExisting = be.method_5438(1);
                if (outExisting.method_7960()) {
                    be.method_5447(1, capsule.method_7972());
                } else if (class_1799.method_31577((class_1799)outExisting, (class_1799)capsule)) {
                    outExisting.method_7933(capsule.method_7947());
                    be.method_5447(1, outExisting);
                }
                spawnPos = pos.method_10093(facing).method_46558();
                itemEntity = new class_1542((class_1937)level, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, capsule.method_7972());
                itemEntity.method_6982(0);
                level.method_8649((class_1297)itemEntity);
            }
            be.setGachaLevel(0);
            int configuredUses = GachaMachineBlock.deserializeUsesBeforeCooldown(this.configProperty);
            if (be.getUsesBeforeCooldownRemaining() == -1) {
                be.setUsesBeforeCooldownRemaining(configuredUses);
            }
            int remaining = be.getUsesBeforeCooldownRemaining();
            if (configuredUses <= 1) {
                cooldownTicks = GachaMachineBlock.deserializeCooldown(this.configProperty);
                if (cooldownTicks > 0) {
                    be.setCooldown(cooldownTicks);
                }
                be.setUsesBeforeCooldownRemaining(configuredUses);
            } else if (remaining > 1) {
                be.setUsesBeforeCooldownRemaining(remaining - 1);
            } else {
                cooldownTicks = GachaMachineBlock.deserializeCooldown(this.configProperty);
                if (cooldownTicks > 0) {
                    be.setCooldown(cooldownTicks);
                }
                be.setUsesBeforeCooldownRemaining(configuredUses);
            }
            level.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
            GachaMachine.onMachineDispense(level, pos);
        }
        return true;
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos = GachaMachineBlock.getLowerPos(state, pos));
        if (class_25862 instanceof GachaMachineBlockEntity) {
            GachaMachineBlockEntity g = (GachaMachineBlockEntity)class_25862;
            return g.getGachaLevel();
        }
        return 0;
    }

    public List<class_1799> getOutput(@Nullable class_1657 player, class_3218 serverLevel, class_2338 origin) {
        class_1657 entity = player != null ? player : GachaMachineRegistries.getFakePlayer(serverLevel);
        class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)origin.method_46558()).method_51874(class_181.field_1226, (Object)entity);
        class_8567 parameters = builder.method_51875(GachaMachineRegistries.GACHA_MACHINE_LOOT_CONTEXT);
        class_2960 lootTableId = GachaMachine.id(this.loot);
        class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId));
        if (lootTable == class_52.field_948) {
            GachaMachine.LOGGER.error("Loot table not found: {}", (Object)lootTableId);
            return List.of();
        }
        ObjectArrayList generatedLoot = lootTable.method_51878(parameters);
        if (generatedLoot == null || generatedLoot.isEmpty()) {
            return List.of();
        }
        return generatedLoot;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return state.method_11654(HALF) == class_2756.field_12607 ? new GachaMachineBlockEntity(this.blockEntityTypeSupplier.get(), pos, state) : null;
    }

    public static class_2338 getLowerPos(class_2680 state, class_2338 pos) {
        return state.method_11654(HALF) == class_2756.field_12609 ? pos.method_10074() : pos;
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!(level.field_9236 || !player.method_7337() && player.method_7305(state))) {
            GachaMachineBlock.onBreakInCreative(level, pos, state, player);
        }
        return super.method_9576(level, pos, state, player);
    }

    protected static void onBreakInCreative(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (half == class_2756.field_12609 && (blockState = level.method_8320(blockPos = pos.method_10074())).method_27852(state.method_26204()) && blockState.method_11654(HALF) == class_2756.field_12607) {
            class_2680 newState = blockState.method_26227().method_39360((class_3611)class_3612.field_15910) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
            level.method_8652(blockPos, newState, 35);
            level.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos = GachaMachineBlock.getLowerPos(state, pos));
        if (!(class_25862 instanceof GachaMachineBlockEntity)) {
            return class_9062.field_47731;
        }
        GachaMachineBlockEntity be = (GachaMachineBlockEntity)class_25862;
        if (!level.field_9236 && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            boolean success = this.processCurrencyInsertion(serverLevel, pos, stack, player, be);
            return success ? class_9062.field_47728 : class_9062.field_47733;
        }
        return class_9062.field_47728;
    }

    @NotNull
    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        class_1278 inv;
        class_2586 be;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
        }
        return (be = world.method_8321(pos)) instanceof class_1278 ? (inv = (class_1278)be) : null;
    }

    public String getLootKey() {
        return this.loot;
    }
}

