/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.gachamachine.block;

import com.hisroyalty.gachamachine.block.GachaMachineBlock;
import com.hisroyalty.gachamachine.block.GachaMachineBlockEntity;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GachaMachineAnimatedBlockEntity
extends GachaMachineBlockEntity
implements GeoBlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(GachaMachineAnimatedBlockEntity.class);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GachaMachineAnimatedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 0, state -> {
            class_2248 block = this.method_11010().method_26204();
            String anim = this.getIdleAnimationForBlock(block);
            if (anim == null || anim.isEmpty()) {
                LOGGER.warn("GachaMachineAnimatedBlockEntity at {} has no valid idle animation; skipping.", (Object)this.method_11016());
                return PlayState.STOP;
            }
            try {
                state.setAnimation(RawAnimation.begin().thenLoop(anim));
                return PlayState.CONTINUE;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set idle animation '{}' for gacha machine at {}. Animation will be skipped.", new Object[]{anim, this.method_11016(), e});
                return PlayState.STOP;
            }
        }), new AnimationController((GeoAnimatable)this, "dispense_controller", 0, state -> PlayState.STOP).triggerableAnim("dispense", this.buildDispenseAnimation())});
    }

    private String getIdleAnimationForBlock(class_2248 block) {
        if (!(block instanceof GachaMachineBlock)) {
            return null;
        }
        GachaMachineBlock gacha = (GachaMachineBlock)block;
        String loot = gacha.getLootKey();
        if (loot == null || loot.isEmpty()) {
            return null;
        }
        return "animation." + loot + ".idle";
    }

    private String getDispenseAnimationForBlock(class_2248 block) {
        if (!(block instanceof GachaMachineBlock)) {
            return null;
        }
        GachaMachineBlock gacha = (GachaMachineBlock)block;
        String loot = gacha.getLootKey();
        if (loot == null || loot.isEmpty()) {
            return null;
        }
        return "animation." + loot + ".dispense";
    }

    private String resolveDispenseAnimationName() {
        return this.getDispenseAnimationForBlock(this.method_11010().method_26204());
    }

    private RawAnimation buildDispenseAnimation() {
        String animName = this.resolveDispenseAnimationName();
        return animName == null || animName.isEmpty() ? RawAnimation.begin() : RawAnimation.begin().thenPlay(animName);
    }

    public void playDispenseAnimation() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        String animation = this.resolveDispenseAnimationName();
        if (animation == null || animation.isEmpty()) {
            LOGGER.warn("No dispense animation resolved for gacha machine at {}.", (Object)this.method_11016());
            return;
        }
        this.triggerAnim("dispense_controller", "dispense");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

