/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.spawner;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.AlphaGenerator;
import dev.cudzer.cobblemonalphas.entity.HerdMember;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaDespawner;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.ISpawnLocation;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.RandomSpawnAroundPlayer;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.BlockBlacklist;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.HeightBounds;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.ISpawnCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class AlphaSpawner {
    private static final AlphaSpawner instance = new AlphaSpawner();
    private static final Random RNG = new Random();
    private int spawnCountdown;
    private ISpawnLocation spawnLocationSelector;
    private List<ISpawnCondition> spawnConditions;
    private static final int HERD_SIZE = 4;
    private MinecraftServer server;

    public static AlphaSpawner getInstance() {
        return instance;
    }

    public void init() {
        this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        this.spawnLocationSelector = new RandomSpawnAroundPlayer(ModConfig.minimumSpawnDistance, ModConfig.maximumSpawnDistance);
        this.spawnConditions = List.of(new BlockBlacklist(List.of(class_2246.field_10164, class_2246.field_10036, class_2246.field_10029)), new HeightBounds(-50, 200));
        AlphaDespawner.getInstance().setMinimumDespawnDistance(ModConfig.minimumSpawnDistance);
        AlphaDespawner.getInstance().setSpawnIntervalTicks(ModConfig.ticksBetweenSpawns);
        AlphaJsonDataManager.populateBiomeData(this.server.method_3847(class_1937.field_25179));
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (this.spawnCountdown > 0) {
            --this.spawnCountdown;
        } else {
            this.attemptSpawn();
            this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        }
    }

    private void attemptSpawn() {
        Map<class_2960, Alpha> alphaMap;
        class_2382 spawnLocation;
        class_1937 spawnLevel;
        List players = this.server.method_3760().method_14571();
        if (players.size() < ModConfig.requiredPlayerAmount) {
            return;
        }
        if (RNG.nextDouble() > (double)(ModConfig.alphaSpawnChance + 0.02f * (float)(this.server.method_3788() - ModConfig.requiredPlayerAmount))) {
            return;
        }
        int attemptedSpawns = 0;
        while (true) {
            boolean underground;
            Optional biomeKey;
            if (++attemptedSpawns > ModConfig.spawnAttempts) {
                CobblemonAlphasMod.LOGGER.info("Maximum spawn attempts reached. Skipping this alpha spawn");
                return;
            }
            Optional chosenPlayerOpt = players.stream().skip((int)((double)players.size() * RNG.nextDouble())).findFirst();
            if (!chosenPlayerOpt.isPresent()) continue;
            class_3222 chosenPlayer = (class_3222)chosenPlayerOpt.get();
            spawnLevel = chosenPlayer.method_37908();
            class_1937 chosenPlayerSpawnLevel = chosenPlayer.method_37908();
            spawnLocation = this.spawnLocationSelector.getSpawnLocation(chosenPlayer.method_37908(), chosenPlayer.method_19538());
            if (spawnLocation == null) continue;
            class_2338 finalSpawnPos = new class_2338(spawnLocation.method_10263(), spawnLocation.method_10264(), spawnLocation.method_10260());
            if (this.spawnConditions.stream().anyMatch(condition -> !condition.isSafe(chosenPlayerSpawnLevel, finalSpawnPos)) || (biomeKey = chosenPlayerSpawnLevel.method_23753(finalSpawnPos).method_40230()).isEmpty()) continue;
            boolean bl = underground = !spawnLevel.method_8311(finalSpawnPos);
            alphaMap = AlphaJsonDataManager.getRandomAlphaForBiome(spawnLevel, (class_5321<class_1959>)((class_5321)biomeKey.get()), underground);
            if (alphaMap != null && !alphaMap.isEmpty()) break;
        }
        Alpha chosenAlpha = alphaMap.values().iterator().next();
        class_2382 spawnPos = spawnLocation;
        this.spawnAlphaEntity(chosenAlpha, spawnLevel, spawnPos, ModConfig.doHerdSpawning);
        Object announcement = ModConfig.spawnAnnouncementMessage;
        if (ModConfig.showCoordinatesInAnnouncement) {
            announcement = (String)announcement + " (" + spawnPos.method_10263() + ", " + spawnPos.method_10264() + ", " + spawnPos.method_10260() + ")";
        }
        this.server.method_3760().method_43514((class_2561)class_2561.method_43470((String)announcement), false);
    }

    public void spawnAlphaEntity(Alpha alpha, class_1937 level, class_2382 spawnPosition, boolean doHerdSpawning) {
        if (!level.method_8608()) {
            PokemonEntity alphaEntity = AlphaGenerator.generate(alpha, level, spawnPosition);
            if (alphaEntity != null) {
                level.method_8500(new class_2338(spawnPosition));
                level.method_8649((class_1297)alphaEntity);
                if (doHerdSpawning) {
                    this.spawnHerdPokemon(alphaEntity, alpha.getHerdMembers(), level, spawnPosition);
                }
            } else {
                CobblemonAlphasMod.LOGGER.error("An alpha spawn was attempted but the entity creation failed...");
            }
        }
    }

    private void spawnHerdPokemon(PokemonEntity alphaEntity, List<HerdMember> herdMembers, class_1937 spawnLevel, class_2382 spawnPos) {
        String alphaString = alphaEntity.getPokemon().getSpecies().getName();
        if (herdMembers.size() <= 0) {
            CobblemonAlphasMod.LOGGER.warn(String.format("Herd members for %s is empty. Skipping herd spawning for this alpha", alphaString));
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            HerdMember herdMember = herdMembers.get(RNG.nextInt(herdMembers.size()));
            Pokemon herdMemberPokemon = new Pokemon();
            Species herdMemberSpecies = PokemonSpecies.getByName((String)herdMember.getSpecies());
            if (herdMemberSpecies == null) {
                CobblemonAlphasMod.LOGGER.warn(String.format("Incorrect species defined for herd member of %s. %s is not a valid pokemon species", alphaString, herdMember.getSpecies()));
                return;
            }
            herdMemberPokemon.setSpecies(herdMemberSpecies);
            herdMemberPokemon.setLevel(herdMember.getLevelFromRange());
            herdMemberPokemon.initializeMoveset(true);
            herdMemberPokemon.getPersistentData().method_25927("ALPHA_ID", alphaEntity.method_5667());
            if (RNG.nextDouble() < 1.0 / (double)ModConfig.shinyOdds) {
                herdMemberPokemon.setShiny(true);
            }
            PokemonEntity herdEntity = new PokemonEntity(spawnLevel, herdMemberPokemon, CobblemonEntities.POKEMON);
            herdEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
            herdEntity.method_5814((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
            spawnLevel.method_8500(new class_2338(spawnPos));
            spawnLevel.method_8649((class_1297)herdEntity);
        }
    }
}

