/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaDespawner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5455;

public class AlphaGenerator {
    private static final Random RNG = new Random();
    private static final String[] statNames = new String[]{"HP", "ATTACK", "DEFENCE", "SPECIAL_ATTACK", "SPECIAL_DEFENCE", "SPEED"};

    public static PokemonEntity generate(Alpha chosenAlpha, class_1937 spawnLevel, class_2382 spawnPos) {
        PokemonEntity alphaEntity;
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(Objects.requireNonNull(PokemonSpecies.getByName((String)chosenAlpha.getSpecies())));
        pokemon.setLevel(chosenAlpha.getLevelFromRange());
        pokemon.initializeMoveset(true);
        float baseSize = (float)ModConfig.alphaSizeMultiplier;
        pokemon = pokemon.clone(true, (class_5455)class_5455.field_40585);
        pokemon.setScaleModifier((float)ModConfig.alphaSizeMultiplier);
        pokemon.getAspects().add("alpha");
        pokemon.getPersistentData().method_10556("IS_ALPHA", true);
        pokemon.setScaleModifier(baseSize);
        IVs ivs = pokemon.getIvs();
        pokemon.setIvs$common(AlphaGenerator.maximizeRandomIVs(ivs, ModConfig.maximumBestIVs));
        pokemon.setAbility$common(AlphaGenerator.doHiddenAbilityCheck(pokemon));
        if (RNG.nextDouble() < 1.0 / (double)ModConfig.shinyOdds) {
            pokemon.setShiny(true);
        }
        if ((alphaEntity = (PokemonEntity)CobblemonEntities.POKEMON.method_5883(spawnLevel)) != null) {
            alphaEntity.setPokemon(pokemon);
            alphaEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
            alphaEntity.method_5814((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
            spawnLevel.method_8500(new class_2338(spawnPos));
            return alphaEntity;
        }
        return null;
    }

    private static Ability doHiddenAbilityCheck(Pokemon pokemon) {
        AbilityPool abilities = pokemon.getSpecies().getAbilities();
        ArrayList<AbilityTemplate> hiddenAbilities = new ArrayList<AbilityTemplate>();
        for (PotentialAbility potentialAbility : abilities) {
            if (potentialAbility.getPriority() != Priority.LOW) continue;
            hiddenAbilities.add(potentialAbility.getTemplate());
        }
        if (!hiddenAbilities.isEmpty() && Math.random() >= 0.6) {
            int selection = new Random().nextInt(hiddenAbilities.size());
            return new Ability((AbilityTemplate)hiddenAbilities.get(selection), false, Priority.NORMAL);
        }
        return pokemon.getAbility();
    }

    public static IVs maximizeRandomIVs(IVs ivs, int numIvs) {
        ArrayList<String> chosenStats = new ArrayList<String>(List.of(statNames));
        for (int i = 1; i <= numIvs; ++i) {
            int ivIndex = new Random().nextInt(chosenStats.size());
            String statName = (String)chosenStats.get(ivIndex);
            Stats stat = Stats.valueOf((String)statName);
            ivs.set((Stat)stat, 31);
            chosenStats.remove(statName);
        }
        return ivs;
    }
}

