/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class AlphaJsonDataManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    protected static Map<class_2960, Alpha> data = new HashMap<class_2960, Alpha>();
    protected static List<class_2960> resourceLocationList = new ArrayList<class_2960>();
    protected static Map<class_5321<class_1959>, Map<class_2960, Alpha>> biomeData = new HashMap<class_5321<class_1959>, Map<class_2960, Alpha>>();
    protected static Map<class_5321<class_1959>, List<class_2960>> resourceLocationMap = new HashMap<class_5321<class_1959>, List<class_2960>>();
    protected static List<class_2960> undergroundSpawnResourceLocationList = new ArrayList<class_2960>();
    protected static Map<class_2960, Alpha> undergroundSpawnsMap = new HashMap<class_2960, Alpha>();
    protected static Map<class_5321<class_1959>, List<class_2960>> undergroundResourceLocationMap = new HashMap<class_5321<class_1959>, List<class_2960>>();
    protected static Map<class_5321<class_1959>, Map<class_2960, Alpha>> undergroundBiomeData = new HashMap<class_5321<class_1959>, Map<class_2960, Alpha>>();

    public AlphaJsonDataManager() {
        super(GSON, CobblemonAlphasMod.cobblemonAlphasResource("alphas").method_12832());
    }

    public static Map<class_2960, Alpha> getRandomAlphaForBiome(class_1937 level, class_5321<class_1959> biome, boolean undergroundSpawn) {
        if (!undergroundSpawn) {
            HashMap<class_2960, Alpha> map = new HashMap<class_2960, Alpha>();
            class_2960 rl = AlphaJsonDataManager.getRandomResourceLocationForBiome(level, biome);
            Map<class_2960, Alpha> alphaMap = biomeData.getOrDefault(biome, new HashMap());
            Alpha alpha = alphaMap.getOrDefault(rl, null);
            if (alpha == null) {
                alphaMap = AlphaJsonDataManager.getRandomAlpha(level);
                if (alphaMap == null) {
                    CobblemonAlphasMod.LOGGER.error("Something went wrong when trying to choose an alpha to spawn!");
                    return Map.of();
                }
                rl = (class_2960)alphaMap.keySet().stream().toList().getFirst();
                alpha = alphaMap.values().stream().toList().getFirst();
            }
            map.put(rl, alpha);
            return map;
        }
        HashMap<class_2960, Alpha> map = new HashMap<class_2960, Alpha>();
        class_2960 rl = AlphaJsonDataManager.getRandomUndergroundResourceLocationForBiome(level, biome);
        Map<class_2960, Alpha> alphaMap = undergroundBiomeData.getOrDefault(biome, new HashMap());
        Alpha alpha = alphaMap.getOrDefault(rl, null);
        if (alpha == null) {
            alphaMap = AlphaJsonDataManager.getRandomUndergroundAlpha(level);
            rl = (class_2960)alphaMap.keySet().stream().toList().getFirst();
            alpha = alphaMap.values().stream().toList().getFirst();
        }
        map.put(rl, alpha);
        return map;
    }

    private static class_2960 getRandomResourceLocationForBiome(class_1937 level, class_5321<class_1959> biome) {
        List resourceLocations = resourceLocationMap.getOrDefault(biome, Collections.emptyList());
        if (resourceLocations.isEmpty()) {
            return AlphaJsonDataManager.getRandomResourceLocation(level);
        }
        return (class_2960)resourceLocations.get(level.field_9229.method_43048(resourceLocations.size()));
    }

    private static class_2960 getRandomUndergroundResourceLocationForBiome(class_1937 level, class_5321<class_1959> biome) {
        List resourceLocations = undergroundResourceLocationMap.getOrDefault(biome, Collections.emptyList());
        if (resourceLocations.isEmpty()) {
            return AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
        }
        return (class_2960)resourceLocations.get(level.field_9229.method_43048(resourceLocations.size()));
    }

    public static Map<class_2960, Alpha> getRandomAlpha(class_1937 level) {
        HashMap<class_2960, Alpha> map = new HashMap<class_2960, Alpha>();
        class_2960 rl = AlphaJsonDataManager.getRandomResourceLocation(level);
        if (rl == null) {
            return null;
        }
        Alpha alpha = data.get(rl);
        map.put(rl, alpha);
        return map;
    }

    public static Alpha getAlphaById(class_2960 id) {
        return data.get(id);
    }

    public static Map<class_2960, Alpha> getRandomUndergroundAlpha(class_1937 level) {
        HashMap<class_2960, Alpha> map = new HashMap<class_2960, Alpha>();
        class_2960 rl = AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
        Alpha alpha = undergroundSpawnsMap.get(rl);
        map.put(rl, alpha);
        return map;
    }

    public static Alpha getRandomAlphaObj(class_1937 level) {
        class_2960 rl = AlphaJsonDataManager.getRandomResourceLocation(level);
        if (rl == null) {
            rl = AlphaJsonDataManager.getRandomUndergroundResourceLocation(level);
            return undergroundSpawnsMap.get(rl);
        }
        return data.get(rl);
    }

    public static Alpha getAlphaObj(class_1937 level, String alphaName) {
        for (Alpha alpha : data.values()) {
            if (!alpha.getSpecies().equalsIgnoreCase(alphaName)) continue;
            return alpha;
        }
        for (Alpha alpha : undergroundSpawnsMap.values()) {
            if (!alpha.getSpecies().equalsIgnoreCase(alphaName)) continue;
            return alpha;
        }
        return null;
    }

    private static class_2960 getRandomResourceLocation(class_1937 level) {
        if (!resourceLocationList.isEmpty()) {
            return resourceLocationList.get(level.field_9229.method_43048(resourceLocationList.size()));
        }
        return null;
    }

    private static class_2960 getRandomUndergroundResourceLocation(class_1937 level) {
        return undergroundSpawnResourceLocationList.get(level.field_9229.method_43048(undergroundSpawnResourceLocationList.size()));
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profilerFiller) {
        CobblemonAlphasMod.LOGGER.info("Loading alpha definitions...");
        HashMap<class_2960, Alpha> newMap = new HashMap<class_2960, Alpha>();
        ArrayList<class_2960> newResourceLocationList = new ArrayList<class_2960>();
        HashMap resourceLocationBiomeMap = new HashMap();
        HashMap<class_2960, Alpha> newUndergroundMap = new HashMap<class_2960, Alpha>();
        ArrayList<class_2960> newUndergroundResourceLocationList = new ArrayList<class_2960>();
        HashMap undergroundLocationBiomeMap = new HashMap();
        data.clear();
        biomeData.clear();
        resourceLocationList.clear();
        undergroundSpawnsMap.clear();
        undergroundSpawnResourceLocationList.clear();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement element = entry.getValue();
            Alpha.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(result -> {
                Alpha alpha = (Alpha)result.getFirst();
                alpha.setJsonLocation(key);
                if (alpha.canSpawnUnderground()) {
                    newUndergroundMap.put(key, alpha);
                    newUndergroundResourceLocationList.add(key);
                } else {
                    newMap.put(key, alpha);
                    newResourceLocationList.add(key);
                }
                List<class_2960> spawnBiome = alpha.getSpawnBiome();
                spawnBiome.forEach(biome -> {
                    class_5321 biomeResourceKey = null;
                    try {
                        biomeResourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome);
                    }
                    catch (Exception e) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in %s due to %s", biome, key, e));
                    }
                    if (biomeResourceKey == null) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in %s", biome, key));
                    }
                    List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                    resourceLocations.add(key);
                    resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                });
            }).ifError(partial -> CobblemonAlphasMod.LOGGER.error(String.format("Failed to parse data json for %s due to %s", key, partial.message())));
        }
        resourceLocationList = newResourceLocationList;
        data = newMap;
        undergroundSpawnsMap = newUndergroundMap;
        undergroundSpawnResourceLocationList = newUndergroundResourceLocationList;
        CobblemonAlphasMod.LOGGER.info(String.format("Loaded %s alpha definitions.", data.size() + undergroundSpawnsMap.size()));
    }

    public static void populateBiomeData(class_3218 level) {
        AlphaJsonDataManager.applySurfaceBiomeAlphas((class_1937)level);
        AlphaJsonDataManager.applyUndergroundBiomeAlphas((class_1937)level);
    }

    public static Map<class_2960, Alpha> getAlphaData() {
        Map<class_2960, Alpha> newData = data;
        newData.putAll(undergroundSpawnsMap);
        return newData;
    }

    private static void applySurfaceBiomeAlphas(class_1937 level) {
        HashMap<class_5321, Map> newBiomeData = new HashMap<class_5321, Map>();
        HashMap<class_5321, List> resourceLocationBiomeMap = new HashMap<class_5321, List>();
        for (Alpha alpha : data.values()) {
            if (alpha.canSpawnUnderground()) continue;
            List<class_2960> tagsResourceLocation = alpha.getSpawnBiomeTags();
            List<class_2960> biomesResourceLocation = alpha.getSpawnBiome();
            for (class_2960 tag : tagsResourceLocation) {
                class_6862 biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tag);
                level.method_30349().method_33310(class_7924.field_41236).ifPresent(reg -> {
                    Iterable biomeHolder = reg.method_40286(biomeTagKey);
                    for (class_6880 biome : biomeHolder) {
                        class_5321 biomeResourceKey = (class_5321)biome.method_40230().get();
                        Map mapToPut = newBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                        mapToPut.put(alpha.getJsonLocation(), alpha);
                        newBiomeData.put(biomeResourceKey, mapToPut);
                        List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                        resourceLocations.add(alpha.getJsonLocation());
                        resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                    }
                    if (!biomeHolder.iterator().hasNext()) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Tag for %s does not have any biomes!", biomeTagKey));
                        CobblemonAlphasMod.LOGGER.error(String.format("Alpha for %s might not have any biomes assigned!", alpha.getJsonLocation()));
                    }
                });
            }
            for (class_2960 biome : biomesResourceLocation) {
                class_5321 biomeResourceKey = null;
                try {
                    biomeResourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome);
                }
                catch (Exception e) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s due to %s", biome, alpha.getJsonLocation(), e));
                }
                if (biomeResourceKey == null) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s, skipping...", biome, alpha.getJsonLocation()));
                    continue;
                }
                List resourceLocations = resourceLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                resourceLocations.add(alpha.getJsonLocation());
                resourceLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                Map mapToPut = newBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                mapToPut.put(alpha.getJsonLocation(), alpha);
                newBiomeData.put(biomeResourceKey, mapToPut);
            }
        }
        biomeData.putAll(newBiomeData);
        resourceLocationMap.putAll(resourceLocationBiomeMap);
        newBiomeData.clear();
    }

    private static void applyUndergroundBiomeAlphas(class_1937 level) {
        HashMap<class_5321, Map> newUndergroundBiomeData = new HashMap<class_5321, Map>();
        HashMap<class_5321, List> undergroundLocationBiomeMap = new HashMap<class_5321, List>();
        for (Alpha alpha : undergroundSpawnsMap.values()) {
            if (!alpha.canSpawnUnderground()) continue;
            List<class_2960> tagsResourceLocation = alpha.getSpawnBiomeTags();
            List<class_2960> biomesResourceLocation = alpha.getSpawnBiome();
            for (class_2960 tag : tagsResourceLocation) {
                class_6862 biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tag);
                level.method_30349().method_33310(class_7924.field_41236).ifPresent(reg -> {
                    Iterable biomeHolder = reg.method_40286(biomeTagKey);
                    for (class_6880 biome : biomeHolder) {
                        class_5321 biomeResourceKey = (class_5321)biome.method_40230().get();
                        Map mapToPut = newUndergroundBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                        mapToPut.put(alpha.getJsonLocation(), alpha);
                        newUndergroundBiomeData.put(biomeResourceKey, mapToPut);
                        List resourceLocations = undergroundLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                        resourceLocations.add(alpha.getJsonLocation());
                        undergroundLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                    }
                    if (!biomeHolder.iterator().hasNext()) {
                        CobblemonAlphasMod.LOGGER.error(String.format("Tag for %s does not have any biomes!", biomeTagKey));
                        CobblemonAlphasMod.LOGGER.error(String.format("Alpha for %s might not have any biomes assigned!", alpha.getJsonLocation()));
                    }
                });
            }
            for (class_2960 biome : biomesResourceLocation) {
                class_5321 biomeResourceKey = null;
                try {
                    biomeResourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome);
                }
                catch (Exception e) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s due to %s", biome, alpha.getJsonLocation(), e));
                }
                if (biomeResourceKey == null) {
                    CobblemonAlphasMod.LOGGER.error(String.format("Could not find biome %s in alpha for %s, skipping...", biome, alpha.getJsonLocation()));
                    continue;
                }
                List resourceLocations = undergroundLocationBiomeMap.getOrDefault(biomeResourceKey, new ArrayList());
                resourceLocations.add(alpha.getJsonLocation());
                undergroundLocationBiomeMap.put(biomeResourceKey, resourceLocations);
                Map mapToPut = newUndergroundBiomeData.computeIfAbsent(biomeResourceKey, k -> new HashMap());
                mapToPut.put(alpha.getJsonLocation(), alpha);
                newUndergroundBiomeData.put(biomeResourceKey, mapToPut);
            }
        }
        undergroundBiomeData.putAll(newUndergroundBiomeData);
        undergroundResourceLocationMap.putAll(undergroundLocationBiomeMap);
        newUndergroundBiomeData.clear();
    }
}

