/*
 * Decompiled with CFR 0.152.
 */
package party.extras.network;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import party.extras.network.LearnsetResponsePacket;

public class LearnsetServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PartyExtras");

    public static LearnsetResponsePacket handleRequest(class_3222 player, UUID pokemonUuid) {
        LOGGER.info("[PartyExtras] Received learnset request for Pokemon UUID: {}", (Object)pokemonUuid);
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            LOGGER.info("[PartyExtras] Got party: {}", (Object)party);
            Pokemon pokemon = null;
            Method getMethod = party.getClass().getMethod("get", Integer.TYPE);
            for (int i = 0; i < 6; ++i) {
                Object p = getMethod.invoke((Object)party, i);
                if (!(p instanceof Pokemon)) continue;
                Pokemon poke = (Pokemon)p;
                LOGGER.info("[PartyExtras] Slot {}: {} (UUID: {})", new Object[]{i, poke.getSpecies().getName(), poke.getUuid()});
                if (!poke.getUuid().equals(pokemonUuid)) continue;
                pokemon = poke;
                break;
            }
            if (pokemon == null) {
                LOGGER.warn("[PartyExtras] Pokemon not found in party!");
                return new LearnsetResponsePacket(pokemonUuid, List.of(), List.of(), List.of());
            }
            LOGGER.info("[PartyExtras] Found Pokemon: {}", (Object)pokemon.getSpecies().getName());
            Learnset learnset = pokemon.getForm().getMoves();
            ArrayList<String> eggMoves = new ArrayList<String>();
            ArrayList<String> tmMoves = new ArrayList<String>();
            ArrayList<String> tutorMoves = new ArrayList<String>();
            for (MoveTemplate move : learnset.getEggMoves()) {
                eggMoves.add(move.getName());
            }
            for (MoveTemplate move : learnset.getTmMoves()) {
                tmMoves.add(move.getName());
            }
            for (MoveTemplate move : learnset.getTutorMoves()) {
                tutorMoves.add(move.getName());
            }
            LOGGER.info("[PartyExtras] Sending response - Egg: {}, TM: {}, Tutor: {}", new Object[]{eggMoves.size(), tmMoves.size(), tutorMoves.size()});
            return new LearnsetResponsePacket(pokemonUuid, eggMoves, tmMoves, tutorMoves);
        }
        catch (Exception e) {
            LOGGER.error("[PartyExtras] Error handling learnset request", (Throwable)e);
            return new LearnsetResponsePacket(pokemonUuid, List.of(), List.of(), List.of());
        }
    }
}

