/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.extras.cobblemon.client.gui.PokemonWeaknessHelper;

@Mixin(value={Summary.class}, remap=false)
public abstract class SummaryWeaknessIconsMixin
extends class_437 {
    @Shadow
    protected Pokemon selectedPokemon;
    @Unique
    private static final int BASE_WIDTH = 331;
    @Unique
    private static final int BASE_HEIGHT = 161;
    @Unique
    private static final class_2960 TYPES_SMALL = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");

    protected SummaryWeaknessIconsMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")}, remap=true)
    private void renderWeaknessIcons(class_332 graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        block8: {
            if (this.selectedPokemon == null) {
                return;
            }
            try {
                int count;
                int baseX = (this.field_22789 - 331) / 2;
                int baseY = (this.field_22790 - 161) / 2;
                PokemonWeaknessHelper.WeaknessResult weaknesses = PokemonWeaknessHelper.getWeaknessesCategorized(this.selectedPokemon);
                if (weaknesses.x2Weaknesses.isEmpty() && weaknesses.x4Weaknesses.isEmpty()) {
                    return;
                }
                int startX = baseX + 6;
                int startY = baseY + 150;
                int maxX = baseX + 70;
                class_327 font = class_310.method_1551().field_1772;
                int iconSpacing = 10;
                int currentX = startX;
                if (!weaknesses.x4Weaknesses.isEmpty()) {
                    graphics.method_51433(font, "\u00a74x4:", currentX, startY, 0xFFFFFF, true);
                    currentX += font.method_1727("x4:") + 1;
                    count = 0;
                    for (ElementalType type : weaknesses.x4Weaknesses) {
                        if (count >= 3 || currentX > maxX) break;
                        this.renderSmallTypeIcon(graphics, currentX, startY - 1, type);
                        currentX += iconSpacing;
                        ++count;
                    }
                    currentX += 2;
                }
                if (weaknesses.x2Weaknesses.isEmpty() || currentX >= maxX) break block8;
                graphics.method_51433(font, "\u00a7cx2:", currentX, startY, 0xFFFFFF, true);
                currentX += font.method_1727("x2:") + 1;
                count = 0;
                for (ElementalType type : weaknesses.x2Weaknesses) {
                    if (currentX <= maxX) {
                        this.renderSmallTypeIcon(graphics, currentX, startY - 1, type);
                        currentX += iconSpacing;
                        ++count;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Unique
    private void renderSmallTypeIcon(class_332 graphics, int x, int y, ElementalType type) {
        try {
            int diameter = 18;
            float scale = 0.5f;
            int textureXOffset = diameter * type.getTextureXMultiplier();
            class_4587 pose = graphics.method_51448();
            pose.method_22903();
            pose.method_22905(scale, scale, 1.0f);
            float scaledX = (float)x / scale;
            float scaledY = (float)y / scale;
            graphics.method_25290(TYPES_SMALL, (int)scaledX, (int)scaledY, (float)textureXOffset, 0.0f, diameter, diameter, diameter * 18, diameter);
            pose.method_22909();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

