/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.extras.cobblemon.client.LearnsetLoader;
import party.extras.cobblemon.client.tooltip.AbilityTooltipBuilder;
import party.extras.cobblemon.client.tooltip.DexTooltipBuilder;
import party.extras.cobblemon.client.tooltip.NatureTooltipBuilder;
import party.extras.cobblemon.client.tooltip.TooltipRenderer;
import party.extras.cobblemon.client.tooltip.TypeTooltipBuilder;

@Mixin(value={Summary.class}, remap=false, priority=1100)
public abstract class SummaryUIMixin
extends class_437 {
    @Shadow
    protected Pokemon selectedPokemon;
    @Shadow
    private int mainScreenIndex;
    @Unique
    private List<class_2561> pendingTooltip = null;
    @Unique
    private int tooltipX = 0;
    @Unique
    private int tooltipY = 0;
    @Unique
    private int pendingTooltipBorderColor = -1;
    private static final int BASE_WIDTH = 331;
    private static final int BASE_HEIGHT = 161;
    private static final int TYPE_ICON_SIZE = 18;
    private static final int TYPE_ICON_PRIMARY_X = 30;
    private static final int TYPE_ICON_Y = 123;
    private static final int TYPE_ICON_SPACING = 20;
    private static final int TERA_ICON_X = 58;
    private static final int TERA_ICON_Y = 84;
    private static final int TERA_ICON_WIDTH = 16;
    private static final int TERA_ICON_HEIGHT = 15;
    private static final int TYPE_HOVER_SIZE = 18;
    private static final int TYPE_HOVER_X_OFFSET = -5;
    private static final int TYPE_HOVER_Y_OFFSET = -2;
    private static final int TYPE_HOVER_SECONDARY_X_OFFSET = -7;
    private static final int TYPE_HOVER_SECONDARY_GAP = 2;
    private static final int PORTRAIT_STAT_LEFT_X = 6;
    private static final int PORTRAIT_STAT_RIGHT_X = 66;
    private static final int PORTRAIT_STAT_START_Y = 44;
    private static final int PORTRAIT_STAT_LINE_HEIGHT = 7;
    private static final float PORTRAIT_STAT_SCALE = 0.45f;
    private static final String[] STAT_KEYS = new String[]{"hp", "atk", "def", "spa", "spd", "spe"};
    private static final int[] BASE_STAT_COLORS = new int[]{-13382605, -3394765, -26317, -13395457, -5609729, -13261};
    private static final class_2960 MEGA_ICON = class_2960.method_60655((String)"cobblemon_party_extras", (String)"textures/gui/mega_icon.png");
    private static final int MEGA_ICON_SIZE = 10;
    private static final int MEGA_ICON_TEXTURE_SIZE = 16;
    private static final int MEGA_ICON_X = 6;
    private static final int MEGA_ICON_Y = 88;
    private static final int INFO_TAB = 0;

    protected SummaryUIMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")}, remap=true)
    private void onRender(class_332 graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.selectedPokemon == null) {
            return;
        }
        int baseX = (this.field_22789 - 331) / 2;
        int baseY = (this.field_22790 - 161) / 2;
        this.renderPortraitStats(graphics, baseX, baseY);
        this.renderMegaIcon(graphics, baseX, baseY);
        this.collectTooltipData(mouseX, mouseY);
        if (this.pendingTooltip != null && !this.pendingTooltip.isEmpty()) {
            class_4587 pose = graphics.method_51448();
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, 2000.0f);
            TooltipRenderer.renderStyledTooltip(graphics, this.field_22793, this.pendingTooltip, this.tooltipX, this.tooltipY, this.pendingTooltipBorderColor);
            pose.method_22909();
            this.pendingTooltip = null;
        }
    }

    private void collectTooltipData(int mouseX, int mouseY) {
        block21: {
            try {
                ElementalType teraType;
                ElementalType type;
                List<class_2561> tooltip2;
                int baseX = (this.field_22789 - 331) / 2;
                int baseY = (this.field_22790 - 161) / 2;
                if (this.mainScreenIndex == 0) {
                    if (this.isHoveringDexArea(mouseX, mouseY, baseX, baseY)) {
                        try {
                            tooltip2 = DexTooltipBuilder.buildDexTooltip(this.selectedPokemon);
                            if (!tooltip2.isEmpty()) {
                                this.pendingTooltip = tooltip2;
                                this.tooltipX = mouseX + 10;
                                this.tooltipY = mouseY;
                                this.pendingTooltipBorderColor = this.selectedPokemon.getPrimaryType().getHue() | 0xFF000000;
                                return;
                            }
                        }
                        catch (Exception tooltip2) {
                            // empty catch block
                        }
                    }
                    if (this.isHoveringAbilityArea(mouseX, mouseY, baseX, baseY)) {
                        try {
                            tooltip2 = AbilityTooltipBuilder.buildAbilityTooltip(this.selectedPokemon);
                            if (!tooltip2.isEmpty()) {
                                this.pendingTooltip = tooltip2;
                                this.tooltipX = mouseX + 10;
                                this.tooltipY = mouseY;
                                boolean isHidden = this.isCurrentAbilityHidden();
                                this.pendingTooltipBorderColor = isHidden ? -2258689 : -11162881;
                                return;
                            }
                        }
                        catch (Exception tooltip3) {
                            // empty catch block
                        }
                    }
                    if (this.isHoveringNatureArea(mouseX, mouseY, baseX, baseY)) {
                        try {
                            tooltip2 = NatureTooltipBuilder.buildNatureTooltip(this.selectedPokemon);
                            if (!tooltip2.isEmpty()) {
                                this.pendingTooltip = tooltip2;
                                this.tooltipX = mouseX + 10;
                                this.tooltipY = mouseY;
                                this.pendingTooltipBorderColor = -256;
                                return;
                            }
                        }
                        catch (Exception tooltip4) {
                            // empty catch block
                        }
                    }
                }
                if (this.isHoveringPrimaryTypeIcon(mouseX, mouseY, baseX, baseY) && (type = this.getPrimaryType()) != null) {
                    int iconX = baseX + 30;
                    int iconY = baseY + 123;
                    this.showTypeTooltip(type, iconX, iconY);
                    this.pendingTooltipBorderColor = type.getHue() | 0xFF000000;
                    return;
                }
                if (this.isHoveringSecondaryTypeIcon(mouseX, mouseY, baseX, baseY) && (type = this.getSecondaryType()) != null) {
                    int iconX = baseX + 30;
                    int iconY = baseY + 123;
                    this.showTypeTooltip(type, iconX, iconY);
                    this.pendingTooltipBorderColor = type.getHue() | 0xFF000000;
                    return;
                }
                if (this.isHoveringTeraTypeIcon(mouseX, mouseY, baseX, baseY) && (teraType = this.getTeraType()) != null) {
                    this.pendingTooltip = List.of(class_2561.method_43470((String)("Tera: " + this.getTypeDisplayName(teraType))));
                    this.tooltipX = baseX + 58 + 16 + 8;
                    this.tooltipY = baseY + 84 + 4;
                    this.pendingTooltipBorderColor = teraType.getHue() | 0xFF000000;
                    return;
                }
                if (this.mainScreenIndex != 0 || !this.isHoveringTypeArea(mouseX, mouseY, baseX, baseY)) break block21;
                try {
                    tooltip2 = TypeTooltipBuilder.buildTypeTooltip(this.selectedPokemon);
                    if (!tooltip2.isEmpty()) {
                        this.pendingTooltip = tooltip2;
                        this.tooltipX = mouseX + 10;
                        this.tooltipY = mouseY;
                        this.pendingTooltipBorderColor = -11141121;
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void renderPortraitStats(class_332 graphics, int baseX, int baseY) {
        int[] baseStats = this.getBaseStats();
        int[] ivs = this.getIvs();
        int startY = baseY + 44;
        int leftX = baseX + 6;
        int rightX = baseX + 66;
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 5000.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        pose.method_22905(0.45f, 0.45f, 1.0f);
        int scaledLeftX = Math.round((float)leftX / 0.45f);
        int scaledRightX = Math.round((float)rightX / 0.45f);
        int scaledStartY = Math.round((float)startY / 0.45f);
        for (int i = 0; i < STAT_KEYS.length; ++i) {
            int width;
            int color;
            int y = scaledStartY + Math.round((float)(i * 7) / 0.45f);
            String baseText = this.formatStatValue(baseStats[i]);
            String ivText = this.formatStatValue(ivs[i]);
            if (!baseText.isEmpty()) {
                color = BASE_STAT_COLORS[i % BASE_STAT_COLORS.length];
                width = this.field_22793.method_1727(baseText);
                Objects.requireNonNull(this.field_22793);
                graphics.method_25294(scaledLeftX - 1, y - 1, scaledLeftX + width + 1, y + 9 - 1, 0x66000000);
                graphics.method_51433(this.field_22793, baseText, scaledLeftX, y, color, true);
            }
            if (ivText.isEmpty()) continue;
            color = this.getIvColor(ivs[i]);
            width = this.field_22793.method_1727(ivText);
            Objects.requireNonNull(this.field_22793);
            graphics.method_25294(scaledRightX - 1, y - 1, scaledRightX + width + 1, y + 9 - 1, 0x66000000);
            graphics.method_51433(this.field_22793, ivText, scaledRightX, y, color, true);
        }
        pose.method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    private void renderMegaIcon(class_332 graphics, int baseX, int baseY) {
        if (this.selectedPokemon == null || !this.canMegaEvolve(this.selectedPokemon)) {
            return;
        }
        int iconX = baseX + 6;
        int iconY = baseY + 88;
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 10000.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        pose.method_46416((float)iconX, (float)iconY, 0.0f);
        pose.method_22905(0.625f, 0.625f, 1.0f);
        graphics.method_25290(MEGA_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        pose.method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    private boolean canMegaEvolve(Pokemon pokemon) {
        if (pokemon == null || pokemon.getSpecies() == null) {
            return false;
        }
        try {
            List forms = pokemon.getSpecies().getForms();
            for (FormData form : forms) {
                String formName = form.getName().toLowerCase();
                if (!formName.contains("mega")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getIvColor(int value) {
        float localT;
        int end;
        int start;
        if (value < 0) {
            return -1;
        }
        int clamped = Math.min(31, Math.max(0, value));
        float t = (float)clamped / 31.0f;
        if (t <= 0.5f) {
            start = -3394765;
            end = -13261;
            localT = t / 0.5f;
        } else {
            start = -13261;
            end = -13382605;
            localT = (t - 0.5f) / 0.5f;
        }
        return this.lerpColor(start, end, localT);
    }

    private int lerpColor(int start, int end, float t) {
        int a = this.lerpChannel(start >> 24 & 0xFF, end >> 24 & 0xFF, t);
        int r = this.lerpChannel(start >> 16 & 0xFF, end >> 16 & 0xFF, t);
        int g = this.lerpChannel(start >> 8 & 0xFF, end >> 8 & 0xFF, t);
        int b = this.lerpChannel(start & 0xFF, end & 0xFF, t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int lerpChannel(int start, int end, float t) {
        return Math.round((float)start + (float)(end - start) * t);
    }

    private String formatStatValue(int value) {
        return value >= 0 ? Integer.toString(value) : "";
    }

    private int[] getBaseStats() {
        int[] values = this.createEmptyStats();
        if (this.selectedPokemon == null) {
            return values;
        }
        try {
            Species species = this.selectedPokemon.getSpecies();
            if (species == null) {
                return values;
            }
            Object stats = this.invokeNoArg(species, "getBaseStats");
            if (stats == null) {
                stats = this.invokeNoArg(species, "getStats");
            }
            if (stats == null) {
                stats = this.getFieldValue(species, "baseStats");
            }
            if (stats == null) {
                stats = this.getFieldValue(species, "stats");
            }
            this.fillStats(values, stats);
        }
        catch (Exception species) {
            // empty catch block
        }
        try {
            LearnsetLoader.CachedSpeciesData data = LearnsetLoader.getSpeciesData(this.selectedPokemon);
            if (data != null && data.baseStats != null && !data.baseStats.isEmpty()) {
                this.fillMissingStats(values, data.baseStats);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return values;
    }

    private int[] getIvs() {
        int[] values = this.createEmptyStats();
        if (this.selectedPokemon == null) {
            return values;
        }
        try {
            Object ivs = this.invokeNoArg(this.selectedPokemon, "getIvs");
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIVs");
            }
            if (ivs == null) {
                ivs = this.getFieldValue(this.selectedPokemon, "ivs");
            }
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIvStore");
            }
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIVStore");
            }
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIvValues");
            }
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIVValues");
            }
            if (ivs == null) {
                ivs = this.invokeNoArg(this.selectedPokemon, "getIndividualValues");
            }
            if (ivs == null) {
                ivs = this.getFieldValue(this.selectedPokemon, "ivStore");
            }
            if (ivs == null) {
                ivs = this.getFieldValue(this.selectedPokemon, "ivValues");
            }
            if (ivs == null) {
                ivs = this.getFieldValue(this.selectedPokemon, "individualValues");
            }
            this.fillStats(values, ivs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return values;
    }

    private int[] createEmptyStats() {
        int[] values = new int[STAT_KEYS.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = -1;
        }
        return values;
    }

    private void fillStats(int[] target, Object stats) {
        if (stats == null) {
            return;
        }
        for (int i = 0; i < STAT_KEYS.length; ++i) {
            Integer value = this.readStatValue(stats, STAT_KEYS[i]);
            if (value == null) continue;
            target[i] = value;
        }
    }

    private void fillMissingStats(int[] target, Object stats) {
        if (stats == null || target == null) {
            return;
        }
        for (int i = 0; i < STAT_KEYS.length; ++i) {
            Integer value;
            if (target[i] >= 0 || (value = this.readStatValue(stats, STAT_KEYS[i])) == null) continue;
            target[i] = value;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Integer readStatValue(Object stats, String key) {
        void var7_20;
        void var7_18;
        void var7_15;
        if (stats == null || key == null) {
            return null;
        }
        Integer effectiveValue = this.readEffectiveIv(stats, key);
        if (effectiveValue != null) {
            return effectiveValue;
        }
        Integer statValue = this.readStatByCobblemonStat(stats, key);
        if (statValue != null) {
            return statValue;
        }
        if (stats instanceof Map) {
            Map map = (Map)stats;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null || !key.equalsIgnoreCase(entry.getKey().toString())) continue;
                return this.extractInt(entry.getValue());
            }
        }
        String string = key;
        int n = -1;
        switch (string.hashCode()) {
            case 3336: {
                if (!string.equals("hp")) break;
                boolean bl = false;
                break;
            }
            case 96920: {
                if (!string.equals("atk")) break;
                boolean bl = true;
                break;
            }
            case 99333: {
                if (!string.equals("def")) break;
                int n2 = 2;
                break;
            }
            case 114084: {
                if (!string.equals("spa")) break;
                int n3 = 3;
                break;
            }
            case 114087: {
                if (!string.equals("spd")) break;
                int n4 = 4;
                break;
            }
            case 114088: {
                if (!string.equals("spe")) break;
                int n5 = 5;
            }
        }
        String methodSuffix = switch (var7_15) {
            case 0 -> "Hp";
            case 1 -> "Atk";
            case 2 -> "Def";
            case 3 -> "SpAtk";
            case 4 -> "SpDef";
            case 5 -> "Spe";
            default -> key;
        };
        Integer viaMethod = this.tryStatMethod(stats, methodSuffix, key);
        if (viaMethod != null) {
            return viaMethod;
        }
        Object object = this.getFieldValue(stats, key);
        if (object == null && methodSuffix != null) {
            Object object2 = this.getFieldValue(stats, methodSuffix);
        }
        if (var7_18 == null) {
            Object object3 = this.getFieldValue(stats, this.getAltFieldKey(key));
        }
        return this.extractInt(var7_20);
    }

    private Integer tryStatMethod(Object stats, String methodSuffix, String key) {
        ArrayList<CallSite> methodNames = new ArrayList<CallSite>();
        if (methodSuffix != null) {
            methodNames.add((CallSite)((Object)("get" + methodSuffix)));
            methodNames.add((CallSite)((Object)("get" + methodSuffix.toUpperCase())));
        }
        methodNames.add((CallSite)((Object)("get" + key)));
        methodNames.add((CallSite)((Object)("get" + key.toUpperCase())));
        String altKey = this.getAltMethodKey(key);
        if (altKey != null) {
            methodNames.add((CallSite)((Object)("get" + altKey)));
            methodNames.add((CallSite)((Object)("get" + altKey.toUpperCase())));
        }
        for (String string : methodNames) {
            Object value = this.invokeNoArg(stats, string);
            Integer intValue = this.extractInt(value);
            if (intValue == null) continue;
            return intValue;
        }
        Object value = this.invokeSingleArg(stats, "get", key);
        Integer n = this.extractInt(value);
        if (n != null) {
            return n;
        }
        value = this.invokeSingleArg(stats, "getStat", key);
        Integer n2 = this.extractInt(value);
        if (n2 != null) {
            return n2;
        }
        value = this.invokeSingleArg(stats, "getValue", key);
        return this.extractInt(value);
    }

    private Integer readStatByCobblemonStat(Object stats, String key) {
        try {
            Stats stat = Stats.Companion.getStat(key);
            Object value = this.invokeSingleArg(stats, "getOrDefault", Stat.class, stat);
            Integer intValue = this.extractInt(value);
            if (intValue != null) {
                return intValue;
            }
            value = this.invokeSingleArg(stats, "get", Stat.class, stat);
            return this.extractInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer readEffectiveIv(Object stats, String key) {
        try {
            Stats stat = Stats.Companion.getStat(key);
            Object value = this.invokeSingleArg(stats, "getEffectiveBattleIV", Stat.class, stat);
            Integer intValue = this.extractInt(value);
            if (intValue != null) {
                return intValue;
            }
            value = this.invokeSingleArg(stats, "getEffectiveIV", Stat.class, stat);
            intValue = this.extractInt(value);
            if (intValue != null) {
                return intValue;
            }
            value = this.invokeSingleArg(stats, "getEffective", Stat.class, stat);
            return this.extractInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getAltMethodKey(String key) {
        if (key == null) {
            return null;
        }
        return switch (key) {
            case "atk" -> "Attack";
            case "def" -> "Defense";
            case "spa" -> "SpecialAttack";
            case "spd" -> "SpecialDefense";
            case "spe" -> "Speed";
            default -> null;
        };
    }

    private String getAltFieldKey(String key) {
        if (key == null) {
            return null;
        }
        return switch (key) {
            case "atk" -> "attack";
            case "def" -> "defense";
            case "spa" -> "specialAttack";
            case "spd" -> "specialDefense";
            case "spe" -> "speed";
            default -> null;
        };
    }

    private Object invokeNoArg(Object target, String methodName) {
        if (target == null || methodName == null) {
            return null;
        }
        try {
            return target.getClass().getMethod(methodName, new Class[0]).invoke(target, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object invokeSingleArg(Object target, String methodName, String arg) {
        if (target == null || methodName == null) {
            return null;
        }
        try {
            return target.getClass().getMethod(methodName, String.class).invoke(target, arg);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object invokeSingleArg(Object target, String methodName, Class<?> paramType, Object arg) {
        if (target == null || methodName == null || paramType == null) {
            return null;
        }
        try {
            return target.getClass().getMethod(methodName, paramType).invoke(target, arg);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getFieldValue(Object target, String fieldName) {
        if (target == null || fieldName == null) {
            return null;
        }
        try {
            Field field = target.getClass().getField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer toInt(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return null;
    }

    private Integer extractInt(Object value) {
        Integer direct = this.toInt(value);
        if (direct != null) {
            return direct;
        }
        if (value == null) {
            return null;
        }
        List<String> methodNames = List.of("getValue", "getEffectiveValue", "getEffective", "getFinalValue", "getModifiedValue", "getActualValue", "getRaisedValue", "getHyperTrainedValue", "getMaxValue", "getMaxedValue");
        for (String methodName : methodNames) {
            Object methodValue = this.invokeNoArg(value, methodName);
            Integer intValue = this.toInt(methodValue);
            if (intValue == null) continue;
            return intValue;
        }
        return null;
    }

    private boolean isHoveringAbilityArea(int mouseX, int mouseY, int baseX, int baseY) {
        int abilityX = baseX + 77 + 8;
        int abilityY = baseY + 12 + 75;
        int abilityWidth = 118;
        int abilityHeight = 15;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, abilityX, abilityY, abilityWidth, abilityHeight);
    }

    private boolean isHoveringNatureArea(int mouseX, int mouseY, int baseX, int baseY) {
        int natureX = baseX + 77 + 8;
        int natureY = baseY + 12 + 60;
        int natureWidth = 118;
        int natureHeight = 15;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, natureX, natureY, natureWidth, natureHeight);
    }

    private boolean isHoveringTypeArea(int mouseX, int mouseY, int baseX, int baseY) {
        int typeX = baseX + 77 + 8;
        int typeY = baseY + 12 + 30;
        int typeWidth = 118;
        int typeHeight = 15;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, typeX, typeY, typeWidth, typeHeight);
    }

    private boolean isHoveringPrimaryTypeIcon(int mouseX, int mouseY, int baseX, int baseY) {
        int typeX = baseX + 30 + -5;
        int typeY = baseY + 123 + -2;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, typeX, typeY, 18, 18);
    }

    private boolean isHoveringSecondaryTypeIcon(int mouseX, int mouseY, int baseX, int baseY) {
        if (this.getSecondaryType() == null) {
            return false;
        }
        int typeX = baseX + 30 + 20 + -5 + -7 + 2;
        int typeY = baseY + 123 + -2;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, typeX, typeY, 18, 18);
    }

    private boolean isHoveringTeraTypeIcon(int mouseX, int mouseY, int baseX, int baseY) {
        int typeX = baseX + 58;
        int typeY = baseY + 84;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, typeX, typeY, 16, 15);
    }

    private void showTypeTooltip(ElementalType type, int iconX, int iconY) {
        this.pendingTooltip = List.of(class_2561.method_43470((String)this.getTypeDisplayName(type)));
        this.tooltipX = iconX + 18 + 10;
        this.tooltipY = iconY + 4;
    }

    private ElementalType getPrimaryType() {
        try {
            return this.selectedPokemon != null ? this.selectedPokemon.getPrimaryType() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ElementalType getSecondaryType() {
        try {
            return this.selectedPokemon != null ? this.selectedPokemon.getSecondaryType() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ElementalType getTeraType() {
        if (this.selectedPokemon == null) {
            return null;
        }
        try {
            Method method = this.selectedPokemon.getClass().getMethod("getTeraType", new Class[0]);
            Object result = method.invoke((Object)this.selectedPokemon, new Object[0]);
            if (result instanceof ElementalType) {
                ElementalType type = (ElementalType)result;
                return type;
            }
            if (result != null) {
                String showdownIdValue;
                ElementalType mapped;
                Method getType = result.getClass().getMethod("getType", new Class[0]);
                Object typeResult = getType.invoke(result, new Object[0]);
                if (typeResult instanceof ElementalType) {
                    ElementalType type = (ElementalType)typeResult;
                    return type;
                }
                Method showdownIdMethod = result.getClass().getMethod("showdownId", new Class[0]);
                Object idResult = showdownIdMethod.invoke(result, new Object[0]);
                if (idResult instanceof String && (mapped = this.getTypeFromName(showdownIdValue = (String)idResult)) != null) {
                    return mapped;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getTypeDisplayName(ElementalType type) {
        try {
            return type.getDisplayName().getString();
        }
        catch (Exception e) {
            return type.getName();
        }
    }

    private ElementalType getTypeFromName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return switch (typeName.toLowerCase()) {
            case "normal" -> ElementalTypes.INSTANCE.getNORMAL();
            case "fire" -> ElementalTypes.INSTANCE.getFIRE();
            case "water" -> ElementalTypes.INSTANCE.getWATER();
            case "electric" -> ElementalTypes.INSTANCE.getELECTRIC();
            case "grass" -> ElementalTypes.INSTANCE.getGRASS();
            case "ice" -> ElementalTypes.INSTANCE.getICE();
            case "fighting" -> ElementalTypes.INSTANCE.getFIGHTING();
            case "poison" -> ElementalTypes.INSTANCE.getPOISON();
            case "ground" -> ElementalTypes.INSTANCE.getGROUND();
            case "flying" -> ElementalTypes.INSTANCE.getFLYING();
            case "psychic" -> ElementalTypes.INSTANCE.getPSYCHIC();
            case "bug" -> ElementalTypes.INSTANCE.getBUG();
            case "rock" -> ElementalTypes.INSTANCE.getROCK();
            case "ghost" -> ElementalTypes.INSTANCE.getGHOST();
            case "dragon" -> ElementalTypes.INSTANCE.getDRAGON();
            case "dark" -> ElementalTypes.INSTANCE.getDARK();
            case "steel" -> ElementalTypes.INSTANCE.getSTEEL();
            case "fairy" -> ElementalTypes.INSTANCE.getFAIRY();
            default -> null;
        };
    }

    private boolean isHoveringDexArea(int mouseX, int mouseY, int baseX, int baseY) {
        int dexX = baseX + 77 + 8;
        int dexY = baseY + 12 + 15;
        int dexWidth = 118;
        int dexHeight = 15;
        return TooltipRenderer.isMouseOver(mouseX, mouseY, dexX, dexY, dexWidth, dexHeight);
    }

    private boolean isCurrentAbilityHidden() {
        try {
            if (this.selectedPokemon == null || this.selectedPokemon.getAbility() == null) {
                return false;
            }
            String currentAbilityName = this.selectedPokemon.getAbility().getTemplate().getName();
            AbilityPool abilityPool = this.selectedPokemon.getForm().getAbilities();
            Method getMappingMethod = abilityPool.getClass().getMethod("getMapping", new Class[0]);
            Map mapping = (Map)getMappingMethod.invoke((Object)abilityPool, new Object[0]);
            for (Map.Entry entry : mapping.entrySet()) {
                for (PotentialAbility potential : (List)entry.getValue()) {
                    if (!potential.getTemplate().getName().equals(currentAbilityName)) continue;
                    return potential instanceof HiddenAbility;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

