/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.extras.cobblemon.client.gui.TeamAnalyzerScreen;

@Mixin(value={Summary.class}, remap=false)
public abstract class SummaryTeamAnalyzerMixin
extends class_437 {
    @Shadow
    protected Pokemon selectedPokemon;
    private static final int BASE_WIDTH = 331;
    private static final int BASE_HEIGHT = 161;
    @Unique
    private int buttonX;
    @Unique
    private int buttonY;
    @Unique
    private static final int BUTTON_WIDTH = 70;
    @Unique
    private static final int BUTTON_HEIGHT = 12;
    @Unique
    private boolean buttonHovered = false;

    protected SummaryTeamAnalyzerMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        int baseX = (this.field_22789 - 331) / 2;
        int baseY = (this.field_22790 - 161) / 2;
        this.buttonX = baseX + 216 + 7;
        this.buttonY = baseY + 140;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")}, remap=true)
    private void onRenderPost(class_332 graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        int baseX = (this.field_22789 - 331) / 2;
        int baseY = (this.field_22790 - 161) / 2;
        this.buttonX = baseX + 215;
        this.buttonY = baseY + 139;
        this.buttonHovered = mouseX >= this.buttonX && mouseX <= this.buttonX + 70 && mouseY >= this.buttonY && mouseY <= this.buttonY + 12;
        int bgColor = this.buttonHovered ? -583833942 : -870169464;
        graphics.method_25294(this.buttonX, this.buttonY, this.buttonX + 70, this.buttonY + 12, bgColor);
        int borderColor = this.buttonHovered ? -10048769 : -12285748;
        graphics.method_25294(this.buttonX, this.buttonY, this.buttonX + 70, this.buttonY + 1, borderColor);
        graphics.method_25294(this.buttonX, this.buttonY + 12 - 1, this.buttonX + 70, this.buttonY + 12, borderColor);
        graphics.method_25294(this.buttonX, this.buttonY, this.buttonX + 1, this.buttonY + 12, borderColor);
        graphics.method_25294(this.buttonX + 70 - 1, this.buttonY, this.buttonX + 70, this.buttonY + 12, borderColor);
        String text = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.button").getString();
        int textWidth = this.field_22793.method_1727(text);
        int textX = this.buttonX + (70 - textWidth) / 2;
        int textY = this.buttonY + 2;
        int textColor = this.buttonHovered ? 0xFFFFFF : 0xDDDDDD;
        graphics.method_51433(this.field_22793, text, textX, textY, textColor, true);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.buttonHovered) {
            this.openTeamAnalyzer();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Unique
    private void openTeamAnalyzer() {
        try {
            List<Pokemon> partyList = this.getPartyList();
            if (partyList != null && !partyList.isEmpty()) {
                class_310.method_1551().method_1507((class_437)new TeamAnalyzerScreen(this, partyList));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private List<Pokemon> getPartyList() {
        try {
            Field partyField = Summary.class.getDeclaredField("party");
            partyField.setAccessible(true);
            ArrayList party = (ArrayList)partyField.get((Object)this);
            ArrayList<Pokemon> validPokemon = new ArrayList<Pokemon>();
            for (Pokemon p : party) {
                if (p == null) continue;
                validPokemon.add(p);
            }
            return validPokemon;
        }
        catch (Exception e) {
            if (this.selectedPokemon != null) {
                ArrayList<Pokemon> fallback = new ArrayList<Pokemon>();
                fallback.add(this.selectedPokemon);
                return fallback;
            }
            return new ArrayList<Pokemon>();
        }
    }
}

