/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MoveSwapScreen;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.extras.client.MoveSwapFilterAccess;
import party.extras.cobblemon.client.LearnsetLoader;
import party.extras.cobblemon.client.MoveSwapCategoryTracker;
import party.extras.compat.RandomizerCompat;
import party.extras.config.PartyExtrasConfig;

@Mixin(value={MoveSwapScreen.class}, remap=false)
public abstract class SummaryMoveSwapMixin
implements MoveSwapFilterAccess {
    @Unique
    private int partyExtras$addCount = 0;
    @Unique
    private boolean partyExtras$initialized = false;
    @Unique
    private boolean partyExtras$reorganizing = false;
    @Unique
    private List<MoveSwapScreen.MoveSlot> partyExtras$originalEntries = new ArrayList<MoveSwapScreen.MoveSlot>();
    @Unique
    private List<MoveSwapScreen.MoveSlot> partyExtras$baseEntries = new ArrayList<MoveSwapScreen.MoveSlot>();
    @Unique
    private final Comparator<MoveSwapScreen.MoveSlot> partyExtras$typeSort = Comparator.comparing(this::getMoveTypeKey).thenComparing(this::getMoveNameKey);

    @Inject(method={"addEntry"}, at={@At(value="HEAD")}, require=0)
    private void onAddEntry(MoveSwapScreen.MoveSlot entry, CallbackInfoReturnable<Integer> cir) {
        if (this.partyExtras$reorganizing) {
            return;
        }
        if (this.partyExtras$originalEntries == null) {
            this.partyExtras$originalEntries = new ArrayList<MoveSwapScreen.MoveSlot>();
        }
        if (this.partyExtras$baseEntries == null) {
            this.partyExtras$baseEntries = new ArrayList<MoveSwapScreen.MoveSlot>();
        }
        if (!this.partyExtras$initialized) {
            this.partyExtras$originalEntries.add(entry);
            ++this.partyExtras$addCount;
        }
    }

    @Inject(method={"addEntry"}, at={@At(value="RETURN")}, require=0)
    private void onAddEntryReturn(MoveSwapScreen.MoveSlot entry, CallbackInfoReturnable<Integer> cir) {
        if (this.partyExtras$reorganizing) {
            return;
        }
        if (!this.partyExtras$initialized && this.partyExtras$addCount > 0) {
            MoveTemplate template = this.getMoveTemplate(entry);
            if (template == null) {
                this.partyExtras$initialized = true;
                this.reorganizeEntries();
                return;
            }
            try {
                MoveSwapScreen swapScreen = (MoveSwapScreen)this;
                if (this.isAddMoveMode(swapScreen)) {
                    Pokemon pokemon;
                    Object movesWidget = this.getMovesWidget(swapScreen);
                    Pokemon pokemon2 = pokemon = movesWidget != null ? this.getPokemonFromMovesWidget(movesWidget) : null;
                    if (pokemon != null) {
                        int expected = 0;
                        for (MoveTemplate ignored : pokemon.getRelearnableMoves()) {
                            ++expected;
                        }
                        if (expected > 0 && this.partyExtras$addCount >= expected) {
                            this.partyExtras$initialized = true;
                            this.reorganizeEntries();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Unique
    private void reorganizeEntries() {
        try {
            this.partyExtras$reorganizing = true;
            MoveSwapScreen swapScreen = (MoveSwapScreen)this;
            Object movesWidget = this.getMovesWidget(swapScreen);
            if (movesWidget == null) {
                this.partyExtras$reorganizing = false;
                return;
            }
            Pokemon pokemon = this.getPokemonFromMovesWidget(movesWidget);
            if (pokemon == null) {
                this.partyExtras$reorganizing = false;
                return;
            }
            if (this.partyExtras$baseEntries.isEmpty() && !this.partyExtras$originalEntries.isEmpty()) {
                this.partyExtras$baseEntries = new ArrayList<MoveSwapScreen.MoveSlot>(this.partyExtras$originalEntries);
            }
            ArrayList<MoveSwapScreen.MoveSlot> entriesCopy = new ArrayList<MoveSwapScreen.MoveSlot>(this.partyExtras$baseEntries.isEmpty() ? this.partyExtras$originalEntries : this.partyExtras$baseEntries);
            MoveSwapCategoryTracker.clear();
            MoveSwapCategoryTracker.setActive(true);
            this.clearEntries(swapScreen);
            this.populateCategorizedMoves(swapScreen, entriesCopy, pokemon);
            this.partyExtras$reorganizing = false;
        }
        catch (Exception e) {
            this.partyExtras$reorganizing = false;
        }
    }

    @Override
    public void partyExtras$refreshEntries() {
        if (!this.partyExtras$initialized || this.partyExtras$reorganizing) {
            return;
        }
        this.reorganizeEntries();
    }

    @Unique
    private Object getMovesWidget(MoveSwapScreen swapScreen) {
        try {
            Field field = MoveSwapScreen.class.getDeclaredField("movesWidget");
            field.setAccessible(true);
            return field.get(swapScreen);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private boolean isAddMoveMode(MoveSwapScreen swapScreen) {
        try {
            Field field = MoveSwapScreen.class.getDeclaredField("replacedMove");
            field.setAccessible(true);
            return field.get(swapScreen) == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Unique
    private Pokemon getPokemonFromMovesWidget(Object movesWidget) {
        try {
            Field summaryField = movesWidget.getClass().getDeclaredField("summary");
            summaryField.setAccessible(true);
            Object summary = summaryField.get(movesWidget);
            Field pokemonField = summary.getClass().getDeclaredField("selectedPokemon");
            pokemonField.setAccessible(true);
            return (Pokemon)pokemonField.get(summary);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private void clearEntries(MoveSwapScreen swapScreen) {
        try {
            for (Class<?> clazz = swapScreen.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    List list;
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object value = field.get(swapScreen);
                    if (!(value instanceof List) || (list = (List)value).isEmpty() || !(list.get(0) instanceof MoveSwapScreen.MoveSlot)) continue;
                    list.clear();
                }
            }
            try {
                Method clearMethod = this.findMethod(swapScreen.getClass(), "clearEntries");
                if (clearMethod != null) {
                    clearMethod.setAccessible(true);
                    clearMethod.invoke((Object)swapScreen, new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private Method findMethod(Class<?> clazz, String name) {
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.getParameterCount() != 0) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Unique
    private void addEntryDirect(MoveSwapScreen swapScreen, MoveSwapScreen.MoveSlot slot) {
        try {
            swapScreen.addEntry(slot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void refreshOriginalEntriesFromScreen() {
        try {
            MoveSwapScreen swapScreen = (MoveSwapScreen)this;
            ArrayList<MoveSwapScreen.MoveSlot> collected = new ArrayList<MoveSwapScreen.MoveSlot>();
            HashSet<String> seenMoves = new HashSet<String>();
            boolean hasForgetSlot = false;
            for (Class<?> clazz = swapScreen.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    List list;
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object value = field.get(swapScreen);
                    if (!(value instanceof List) || (list = (List)value).isEmpty()) continue;
                    for (Object entryObj : list) {
                        String moveName;
                        MoveSwapScreen.MoveSlot slot;
                        if (!(entryObj instanceof MoveSwapScreen.MoveSlot) || MoveSwapCategoryTracker.isSeparatorSlot(slot = (MoveSwapScreen.MoveSlot)entryObj)) continue;
                        MoveTemplate template = this.getMoveTemplate(slot);
                        if (template == null) {
                            if (hasForgetSlot) continue;
                            collected.add(slot);
                            hasForgetSlot = true;
                            continue;
                        }
                        if (MoveSwapCategoryTracker.isDisabledMove(template) || !seenMoves.add(moveName = template.getName().toLowerCase())) continue;
                        collected.add(slot);
                    }
                }
            }
            if (!collected.isEmpty()) {
                this.partyExtras$originalEntries = collected;
                if (this.partyExtras$baseEntries.isEmpty()) {
                    this.partyExtras$baseEntries = new ArrayList<MoveSwapScreen.MoveSlot>(collected);
                }
                this.partyExtras$addCount = collected.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private void populateCategorizedMoves(MoveSwapScreen swapScreen, List<MoveSwapScreen.MoveSlot> originalEntries, Pokemon pokemon) {
        Learnset learnset = pokemon.getForm().getMoves();
        LearnsetLoader.CachedSpeciesData cachedLearnset = LearnsetLoader.getLearnset(pokemon);
        if (learnset == null) {
            for (MoveSwapScreen.MoveSlot slot : originalEntries) {
                this.addEntryDirect(swapScreen, slot);
            }
            return;
        }
        int currentLevel = pokemon.getLevel();
        HashMap<String, MoveSwapScreen.MoveSlot> moveSlotMap = new HashMap<String, MoveSwapScreen.MoveSlot>();
        MoveSwapScreen.MoveSlot forgetSlot = null;
        ArrayList<MoveSwapScreen.MoveSlot> filteredEntries = new ArrayList<MoveSwapScreen.MoveSlot>();
        for (MoveSwapScreen.MoveSlot slot : originalEntries) {
            MoveTemplate template = this.getMoveTemplate(slot);
            if (template == null) {
                forgetSlot = slot;
                continue;
            }
            String moveName = template.getName().toLowerCase();
            moveSlotMap.put(moveName, slot);
            filteredEntries.add(slot);
        }
        filteredEntries.sort(this.partyExtras$typeSort);
        HashSet<Object> addedMoves = new HashSet<Object>();
        int entryIndex = 0;
        if (forgetSlot != null) {
            this.addEntryDirect(swapScreen, forgetSlot);
            ++entryIndex;
        }
        for (MoveSwapScreen.MoveSlot slot : filteredEntries) {
            MoveTemplate template = this.getMoveTemplate(slot);
            if (template == null) continue;
            this.addEntryDirect(swapScreen, slot);
            addedMoves.add(template.getName().toLowerCase());
            ++entryIndex;
        }
        ArrayList<MoveSwapScreen.MoveSlot> futureLevelUpSlots = new ArrayList<MoveSwapScreen.MoveSlot>();
        Map levelUpMoves = learnset.getLevelUpMoves();
        if (PartyExtrasConfig.get().showLevelUpMoves && !levelUpMoves.isEmpty()) {
            ArrayList sortedLevels = new ArrayList(levelUpMoves.keySet());
            Collections.sort(sortedLevels);
            for (Integer n : sortedLevels) {
                if (n <= currentLevel) continue;
                for (MoveTemplate moveTemplate : (List)levelUpMoves.get(n)) {
                    MoveSwapScreen.MoveSlot futureSlot;
                    void var19_55;
                    try {
                        String string = RandomizerCompat.getRandomizedMoveName(pokemon, moveTemplate.getName()).toLowerCase();
                    }
                    catch (Exception e) {
                        String string = moveTemplate.getName().toLowerCase();
                    }
                    if (addedMoves.contains(var19_55) || (futureSlot = this.createMoveSlot(swapScreen, moveTemplate, pokemon)) == null) continue;
                    addedMoves.add(var19_55);
                    futureLevelUpSlots.add(futureSlot);
                    MoveSwapCategoryTracker.markAsDisabledByName((String)var19_55, n);
                }
            }
        }
        if (!futureLevelUpSlots.isEmpty()) {
            MoveSwapScreen.MoveSlot separator = this.createSeparatorSlot(swapScreen, pokemon);
            if (separator != null) {
                MoveSwapCategoryTracker.addSeparator(entryIndex, "Level-Up Moves", 0xFFFF55);
                MoveSwapCategoryTracker.markAsSeparatorSlot(separator);
                this.addEntryDirect(swapScreen, separator);
                ++entryIndex;
            }
            for (MoveSwapScreen.MoveSlot moveSlot : futureLevelUpSlots) {
                this.addEntryDirect(swapScreen, moveSlot);
                ++entryIndex;
            }
        }
        ArrayList<MoveSwapScreen.MoveSlot> eggSlots = new ArrayList<MoveSwapScreen.MoveSlot>();
        if (PartyExtrasConfig.get().showEggMoves) {
            List<Object> eggMoveList = cachedLearnset != null && !cachedLearnset.eggMoves.isEmpty() ? cachedLearnset.eggMoves : new ArrayList(learnset.getEggMoves());
            for (MoveTemplate moveTemplate : eggMoveList) {
                MoveSwapScreen.MoveSlot moveSlot;
                void var18_47;
                try {
                    String string = RandomizerCompat.getRandomizedMoveName(pokemon, moveTemplate.getName()).toLowerCase();
                }
                catch (Exception exception) {
                    String string = moveTemplate.getName().toLowerCase();
                }
                if (addedMoves.contains(var18_47) || (moveSlot = this.createMoveSlot(swapScreen, moveTemplate, pokemon)) == null) continue;
                addedMoves.add(var18_47);
                eggSlots.add(moveSlot);
                MoveSwapCategoryTracker.markAsDisabledByName((String)var18_47, 0);
            }
        }
        eggSlots.sort(this.partyExtras$typeSort);
        if (!eggSlots.isEmpty()) {
            MoveSwapScreen.MoveSlot separator = this.createSeparatorSlot(swapScreen, pokemon);
            if (separator != null) {
                MoveSwapCategoryTracker.addSeparator(entryIndex, "Egg Moves", 0xFF55FF);
                MoveSwapCategoryTracker.markAsSeparatorSlot(separator);
                this.addEntryDirect(swapScreen, separator);
                ++entryIndex;
            }
            for (MoveSwapScreen.MoveSlot moveSlot : eggSlots) {
                this.addEntryDirect(swapScreen, moveSlot);
                ++entryIndex;
            }
        }
        ArrayList<MoveSwapScreen.MoveSlot> tmSlots = new ArrayList<MoveSwapScreen.MoveSlot>();
        if (PartyExtrasConfig.get().showTMMoves) {
            List<Object> list = cachedLearnset != null && !cachedLearnset.tmMoves.isEmpty() ? cachedLearnset.tmMoves : new ArrayList(learnset.getTmMoves());
            for (MoveTemplate moveTemplate : list) {
                MoveSwapScreen.MoveSlot tmSlot;
                void var19_64;
                try {
                    String string = RandomizerCompat.getRandomizedMoveName(pokemon, moveTemplate.getName()).toLowerCase();
                }
                catch (Exception e) {
                    String string = moveTemplate.getName().toLowerCase();
                }
                if (addedMoves.contains(var19_64) || (tmSlot = this.createMoveSlot(swapScreen, moveTemplate, pokemon)) == null) continue;
                addedMoves.add(var19_64);
                tmSlots.add(tmSlot);
                MoveSwapCategoryTracker.markAsDisabledByName((String)var19_64, 0);
            }
        }
        tmSlots.sort(this.partyExtras$typeSort);
        if (!tmSlots.isEmpty()) {
            MoveSwapScreen.MoveSlot moveSlot = this.createSeparatorSlot(swapScreen, pokemon);
            if (moveSlot != null) {
                MoveSwapCategoryTracker.addSeparator(entryIndex, "TM Moves", 0x55FFFF);
                MoveSwapCategoryTracker.markAsSeparatorSlot(moveSlot);
                this.addEntryDirect(swapScreen, moveSlot);
                ++entryIndex;
            }
            for (MoveSwapScreen.MoveSlot moveSlot2 : tmSlots) {
                this.addEntryDirect(swapScreen, moveSlot2);
                ++entryIndex;
            }
        }
        ArrayList<MoveSwapScreen.MoveSlot> arrayList = new ArrayList<MoveSwapScreen.MoveSlot>();
        if (PartyExtrasConfig.get().showTMMoves) {
            List<Object> list = cachedLearnset != null && !cachedLearnset.tutorMoves.isEmpty() ? cachedLearnset.tutorMoves : new ArrayList(learnset.getTutorMoves());
            for (MoveTemplate moveTemplate : list) {
                MoveSwapScreen.MoveSlot tutorSlot;
                String displayMoveName;
                try {
                    String displayMoveName3 = RandomizerCompat.getRandomizedMoveName(pokemon, moveTemplate.getName()).toLowerCase();
                }
                catch (Exception e) {
                    displayMoveName = moveTemplate.getName().toLowerCase();
                }
                if (addedMoves.contains(displayMoveName) || (tutorSlot = this.createMoveSlot(swapScreen, moveTemplate, pokemon)) == null) continue;
                addedMoves.add(displayMoveName);
                arrayList.add(tutorSlot);
                MoveSwapCategoryTracker.markAsDisabledByName(displayMoveName, 0);
            }
        }
        arrayList.sort(this.partyExtras$typeSort);
        if (!arrayList.isEmpty()) {
            MoveSwapScreen.MoveSlot moveSlot = this.createSeparatorSlot(swapScreen, pokemon);
            if (moveSlot != null) {
                MoveSwapCategoryTracker.addSeparator(entryIndex, "Tutor Moves", 0x55FF55);
                MoveSwapCategoryTracker.markAsSeparatorSlot(moveSlot);
                this.addEntryDirect(swapScreen, moveSlot);
                ++entryIndex;
            }
            for (MoveSwapScreen.MoveSlot moveSlot3 : arrayList) {
                this.addEntryDirect(swapScreen, moveSlot3);
                ++entryIndex;
            }
        }
    }

    @Unique
    private MoveSwapScreen.MoveSlot createSeparatorSlot(MoveSwapScreen swapScreen, Pokemon pokemon) {
        try {
            Class<MoveSwapScreen.MoveSlot> slotClass = MoveSwapScreen.MoveSlot.class;
            Constructor constructor = slotClass.getDeclaredConstructor(MoveSwapScreen.class, MoveTemplate.class, Integer.TYPE, Pokemon.class);
            constructor.setAccessible(true);
            return (MoveSwapScreen.MoveSlot)constructor.newInstance(swapScreen, null, 0, pokemon);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private MoveSwapScreen.MoveSlot createMoveSlot(MoveSwapScreen swapScreen, MoveTemplate template, Pokemon pokemon) {
        try {
            MoveTemplate displayTemplate = template;
            try {
                displayTemplate = RandomizerCompat.getRandomizedMoveTemplate(pokemon, template);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<MoveSwapScreen.MoveSlot> slotClass = MoveSwapScreen.MoveSlot.class;
            Constructor constructor = slotClass.getDeclaredConstructor(MoveSwapScreen.class, MoveTemplate.class, Integer.TYPE, Pokemon.class);
            constructor.setAccessible(true);
            MoveSwapScreen.MoveSlot slot = (MoveSwapScreen.MoveSlot)constructor.newInstance(swapScreen, displayTemplate, 0, pokemon);
            return slot;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private MoveTemplate getMoveTemplate(MoveSwapScreen.MoveSlot slot) {
        try {
            Field field = MoveSwapScreen.MoveSlot.class.getDeclaredField("move");
            field.setAccessible(true);
            return (MoveTemplate)field.get(slot);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private String getMoveTypeKey(MoveSwapScreen.MoveSlot slot) {
        MoveTemplate template = this.getMoveTemplate(slot);
        if (template == null || template.getElementalType() == null) {
            return "zzzz";
        }
        String typeName = template.getElementalType().getName();
        return typeName == null ? "zzzz" : typeName.toLowerCase();
    }

    @Unique
    private String getMoveNameKey(MoveSwapScreen.MoveSlot slot) {
        MoveTemplate template = this.getMoveTemplate(slot);
        if (template == null || template.getName() == null) {
            return "zzzz";
        }
        return template.getName().toLowerCase();
    }
}

