/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.PartyOverlay;
import com.cobblemon.mod.common.client.storage.ClientStorageManager;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.extras.config.PartyExtrasConfig;

@Mixin(value={PartyOverlay.class}, remap=false)
public class PartyOverlayMixin {
    @Unique
    private static final class_2960 TYPES_SMALL = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
    @Unique
    private static final int TYPE_ICON_SIZE = 18;
    @Unique
    private static final float SCALE = 0.3f;
    @Unique
    private static final int SLOT_HEIGHT = 30;
    @Unique
    private static final int SLOT_SPACING = 4;

    @Inject(method={"render"}, at={@At(value="TAIL")}, remap=true)
    private void renderTypeIcons(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (!PartyExtrasConfig.get().showPartyTypeIcons) {
            return;
        }
        try {
            class_310 minecraft = class_310.method_1551();
            ClientStorageManager storage = CobblemonClient.INSTANCE.getStorage();
            Field partyField = storage.getClass().getDeclaredField("party");
            partyField.setAccessible(true);
            Object party = partyField.get(storage);
            if (party == null) {
                return;
            }
            Method getSlotsMethod = party.getClass().getMethod("getSlots", new Class[0]);
            List slots = (List)getSlotsMethod.invoke(party, new Object[0]);
            if (slots == null || slots.stream().noneMatch(p -> p != null)) {
                return;
            }
            Method getSelectedSlotMethod = storage.getClass().getMethod("getSelectedSlot", new Class[0]);
            int selectedSlot = (Integer)getSelectedSlotMethod.invoke((Object)storage, new Object[0]);
            int totalHeight = slots.size() * 30;
            int midY = minecraft.method_22683().method_4502() / 2;
            int startY = midY - totalHeight / 2 - 10;
            int panelX = 0;
            for (int index = 0; index < slots.size(); ++index) {
                Pokemon pokemon = (Pokemon)slots.get(index);
                if (pokemon == null) continue;
                int selectedOffsetX = selectedSlot == index ? 6 : 0;
                int indexOffsetY = 34 * index;
                int indexY = startY + indexOffsetY;
                ElementalType primaryType = pokemon.getPrimaryType();
                Object secondaryType = pokemon.getSecondaryType();
                String[] randomizedTypes = this.cobblemon_party_extras$getRandomizedTypes(pokemon);
                if (randomizedTypes != null) {
                    ElementalType randSecondary;
                    ElementalType randPrimary = ElementalTypes.INSTANCE.get(randomizedTypes[0]);
                    if (randPrimary != null) {
                        primaryType = randPrimary;
                    }
                    secondaryType = randomizedTypes.length > 1 && randomizedTypes[1] != null ? (randSecondary = ElementalTypes.INSTANCE.get(randomizedTypes[1])) : null;
                }
                int typeX = panelX + selectedOffsetX + 2;
                int typeY = indexY + 6;
                this.cobblemon_party_extras$renderTypeIcon(context, typeX, typeY, primaryType);
                if (secondaryType == null) continue;
                this.cobblemon_party_extras$renderTypeIcon(context, typeX + 10, typeY, (ElementalType)secondaryType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void cobblemon_party_extras$renderTypeIcon(class_332 context, int x, int y, ElementalType type) {
        try {
            int uOffset = 18 * type.getTextureXMultiplier();
            class_4587 pose = context.method_51448();
            pose.method_22903();
            pose.method_22905(0.3f, 0.3f, 1.0f);
            float scaledX = (float)x / 0.3f;
            float scaledY = (float)y / 0.3f;
            context.method_25290(TYPES_SMALL, (int)scaledX, (int)scaledY, (float)uOffset, 0.0f, 18, 18, 324, 18);
            pose.method_22909();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private String[] cobblemon_party_extras$getRandomizedTypes(Pokemon pokemon) {
        try {
            Class<?> randomizerClientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
            Method isRunActive = randomizerClientClass.getMethod("isRunActive", new Class[0]);
            Method isRandomTypes = randomizerClientClass.getMethod("isRandomTypes", new Class[0]);
            boolean runActive = (Boolean)isRunActive.invoke(null, new Object[0]);
            boolean randomTypes = (Boolean)isRandomTypes.invoke(null, new Object[0]);
            if (!runActive || !randomTypes) {
                return null;
            }
            Method getTypesForSpecies = randomizerClientClass.getMethod("getTypesForSpecies", String.class);
            String speciesName = pokemon.getSpecies().getName();
            return (String[])getTypesForSpecies.invoke(null, speciesName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

